/* TitledSeparatorMenuItem.c generated by valac 0.56.17, the Vala compiler
 * generated from TitledSeparatorMenuItem.vala, do not modify */

/**/
/*  Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>*/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/*  Copyright (C) 2013 Rico Tzschichholz*/
/**/
/*  This library is free software; you can redistribute it and/or*/
/*  modify it under the terms of the GNU Lesser General Public*/
/*  License as published by the Free Software Foundation; either*/
/*  version 2.1 of the License, or (at your option) any later version.*/
/**/
/*  This library is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU*/
/*  Lesser General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU Lesser General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/
/*  Authored by Michal Hruby <michal.mhr@gmail.com>*/
/*  Modified by Robert Dyer, Rico Tzschichholz*/
/**/

#include "plank.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <pango/pangocairo.h>
#include <atk/atk.h>
#include "gtk-compat.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_TITLED_SEPARATOR_MENU_ITEM_0_PROPERTY,
	PLANK_TITLED_SEPARATOR_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* plank_titled_separator_menu_item_properties[PLANK_TITLED_SEPARATOR_MENU_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

struct _PlankTitledSeparatorMenuItemPrivate {
	gboolean draw_line;
	gchar* text;
};

static gint PlankTitledSeparatorMenuItem_private_offset;
static gpointer plank_titled_separator_menu_item_parent_class = NULL;

static gboolean plank_titled_separator_menu_item_real_draw (GtkWidget* base,
                                                     cairo_t* cr);
static void plank_titled_separator_menu_item_finalize (GObject * obj);
static GType plank_titled_separator_menu_item_get_type_once (void);

static inline gpointer
plank_titled_separator_menu_item_get_instance_private (PlankTitledSeparatorMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, PlankTitledSeparatorMenuItem_private_offset);
}

PlankTitledSeparatorMenuItem*
plank_titled_separator_menu_item_construct (GType object_type,
                                            const gchar* text)
{
	PlankTitledSeparatorMenuItem * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (text != NULL, NULL);
	self = (PlankTitledSeparatorMenuItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->priv->text);
	self->priv->text = _tmp0_;
	return self;
}

PlankTitledSeparatorMenuItem*
plank_titled_separator_menu_item_new (const gchar* text)
{
	return plank_titled_separator_menu_item_construct (PLANK_TYPE_TITLED_SEPARATOR_MENU_ITEM, text);
}

PlankTitledSeparatorMenuItem*
plank_titled_separator_menu_item_construct_no_line (GType object_type,
                                                    const gchar* text)
{
	PlankTitledSeparatorMenuItem * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	self = (PlankTitledSeparatorMenuItem*) plank_titled_separator_menu_item_construct (object_type, text);
	self->priv->draw_line = FALSE;
	return self;
}

PlankTitledSeparatorMenuItem*
plank_titled_separator_menu_item_new_no_line (const gchar* text)
{
	return plank_titled_separator_menu_item_construct_no_line (PLANK_TYPE_TITLED_SEPARATOR_MENU_ITEM, text);
}

static gboolean
plank_titled_separator_menu_item_real_draw (GtkWidget* base,
                                            cairo_t* cr)
{
	PlankTitledSeparatorMenuItem * self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStateFlags state = 0U;
	GtkStyleContext* _tmp1_;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint border_width = 0;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp2_;
	GtkBorder _tmp3_ = {0};
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	PangoFontDescription* font_desc = NULL;
	GtkStyle* _tmp18_;
	GtkStyle* _tmp19_;
	PangoFontDescription* _tmp20_;
	PangoLayout* layout = NULL;
	PangoContext* _tmp21_;
	PangoContext* _tmp22_;
	PangoLayout* _tmp23_;
	PangoLayout* _tmp24_;
	GtkBorder _tmp25_;
	GtkBorder _tmp26_;
	const gchar* _tmp27_;
	PangoRectangle logical_rect = {0};
	PangoRectangle _tmp28_ = {0};
	GtkStyleContext* _tmp29_;
	PangoRectangle _tmp30_;
	GtkBorder _tmp31_;
	GtkBorder _tmp32_;
	GtkStyleContext* _tmp33_;
	PangoRectangle _tmp34_;
	GtkBorder _tmp35_;
	GtkBorder _tmp36_;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp37_;
	GdkRGBA _tmp38_ = {0};
	GdkRGBA _tmp39_;
	GdkRGBA _tmp40_;
	GdkRGBA _tmp41_;
	GdkRGBA _tmp42_;
	GtkBorder _tmp43_;
	PangoRectangle _tmp44_;
	gboolean result;
	self = (PlankTitledSeparatorMenuItem*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	context = _tmp0_;
	_tmp1_ = context;
	state = gtk_style_context_get_state (_tmp1_);
	border_width = (gint) gtk_container_get_border_width ((GtkContainer*) self);
	x = border_width;
	y = border_width;
	w = gtk_widget_get_allocated_width ((GtkWidget*) self) - (2 * border_width);
	h = gtk_widget_get_allocated_height ((GtkWidget*) self) - (2 * border_width);
	_tmp2_ = context;
	gtk_style_context_get_padding (_tmp2_, state, &_tmp3_);
	padding = _tmp3_;
	_tmp4_ = context;
	gtk_render_background (_tmp4_, cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	_tmp5_ = context;
	gtk_render_frame (_tmp5_, cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	if (self->priv->draw_line) {
		gboolean wide_separators = FALSE;
		gint separator_height = 0;
		gboolean _tmp6_ = FALSE;
		gint _tmp7_ = 0;
		gtk_widget_style_get ((GtkWidget*) self, "wide-separators", &_tmp6_, "separator-height", &_tmp7_, NULL);
		wide_separators = _tmp6_;
		separator_height = _tmp7_;
		if (wide_separators) {
			GtkStyleContext* _tmp8_;
			GtkBorder _tmp9_;
			GtkBorder _tmp10_;
			GtkBorder _tmp11_;
			GtkBorder _tmp12_;
			_tmp8_ = context;
			_tmp9_ = padding;
			_tmp10_ = padding;
			_tmp11_ = padding;
			_tmp12_ = padding;
			gtk_render_frame (_tmp8_, cr, (gdouble) (x + _tmp9_.left), (gdouble) (y + _tmp10_.top), (gdouble) ((w - _tmp11_.left) - _tmp12_.right), (gdouble) separator_height);
		} else {
			GtkStyleContext* _tmp13_;
			GtkBorder _tmp14_;
			GtkBorder _tmp15_;
			GtkBorder _tmp16_;
			GtkBorder _tmp17_;
			_tmp13_ = context;
			_tmp14_ = padding;
			_tmp15_ = padding;
			_tmp16_ = padding;
			_tmp17_ = padding;
			gtk_render_line (_tmp13_, cr, (gdouble) (x + _tmp14_.left), (gdouble) (y + _tmp15_.top), (gdouble) (((x + w) - _tmp16_.right) - 1), (gdouble) (y + _tmp17_.top));
		}
	}
	_tmp18_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->font_desc;
	font_desc = _tmp20_;
	pango_font_description_set_absolute_size (font_desc, (gdouble) ((gint) ((h * PANGO_SCALE) * PANGO_SCALE_LARGE)));
	pango_font_description_set_weight (font_desc, PANGO_WEIGHT_BOLD);
	_tmp21_ = gdk_pango_context_get ();
	_tmp22_ = _tmp21_;
	_tmp23_ = pango_layout_new (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp22_);
	layout = _tmp24_;
	pango_layout_set_font_description (layout, font_desc);
	_tmp25_ = padding;
	_tmp26_ = padding;
	pango_layout_set_width (layout, (gint) (((w - _tmp25_.left) - _tmp26_.right) * PANGO_SCALE));
	_tmp27_ = self->priv->text;
	pango_layout_set_text (layout, _tmp27_, -1);
	pango_layout_get_pixel_extents (layout, NULL, &_tmp28_);
	logical_rect = _tmp28_;
	_tmp29_ = context;
	_tmp30_ = logical_rect;
	_tmp31_ = padding;
	_tmp32_ = padding;
	gtk_render_background (_tmp29_, cr, (gdouble) 0, (gdouble) y, (gdouble) (((x + _tmp30_.width) + _tmp31_.left) + _tmp32_.right), (gdouble) h);
	_tmp33_ = context;
	_tmp34_ = logical_rect;
	_tmp35_ = padding;
	_tmp36_ = padding;
	gtk_render_frame (_tmp33_, cr, (gdouble) 0, (gdouble) y, (gdouble) (((x + _tmp34_.width) + _tmp35_.left) + _tmp36_.right), (gdouble) h);
	_tmp37_ = context;
	gtk_style_context_get_color (_tmp37_, state, &_tmp38_);
	color = _tmp38_;
	_tmp39_ = color;
	_tmp40_ = color;
	_tmp41_ = color;
	_tmp42_ = color;
	cairo_set_source_rgba (cr, _tmp39_.red, _tmp40_.green, _tmp41_.blue, _tmp42_.alpha);
	_tmp43_ = padding;
	_tmp44_ = logical_rect;
	cairo_move_to (cr, (gdouble) (x + _tmp43_.left), (gdouble) (y + ((h - _tmp44_.height) / 2)));
	pango_cairo_show_layout (cr, layout);
	result = GDK_EVENT_STOP;
	_g_object_unref0 (layout);
	return result;
}

static void
plank_titled_separator_menu_item_class_init (PlankTitledSeparatorMenuItemClass * klass,
                                             gpointer klass_data)
{
	GTypeClass* _tmp0_;
	GObjectClass* _tmp1_;
	plank_titled_separator_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankTitledSeparatorMenuItem_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) plank_titled_separator_menu_item_real_draw;
	G_OBJECT_CLASS (klass)->finalize = plank_titled_separator_menu_item_finalize;
	gtk_widget_class_set_accessible_role (GTK_WIDGET_CLASS (klass), ATK_ROLE_SEPARATOR);
	_tmp0_ = g_type_class_ref (PLANK_TYPE_TITLED_SEPARATOR_MENU_ITEM);
	_tmp1_ = (GObjectClass*) _tmp0_;
	plank_compat_gtk_widget_class_set_css_name (_tmp1_, "menuitem");
	_g_type_class_unref0 (_tmp1_);
}

static void
plank_titled_separator_menu_item_instance_init (PlankTitledSeparatorMenuItem * self,
                                                gpointer klass)
{
	self->priv = plank_titled_separator_menu_item_get_instance_private (self);
	self->priv->draw_line = TRUE;
}

static void
plank_titled_separator_menu_item_finalize (GObject * obj)
{
	PlankTitledSeparatorMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_TITLED_SEPARATOR_MENU_ITEM, PlankTitledSeparatorMenuItem);
	_g_free0 (self->priv->text);
	G_OBJECT_CLASS (plank_titled_separator_menu_item_parent_class)->finalize (obj);
}

/**
 * A {@link Gtk.SeparatorMenuItem} with a title on it.
 * The separator can be drawn with or without a line.
 */
static GType
plank_titled_separator_menu_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankTitledSeparatorMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_titled_separator_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankTitledSeparatorMenuItem), 0, (GInstanceInitFunc) plank_titled_separator_menu_item_instance_init, NULL };
	GType plank_titled_separator_menu_item_type_id;
	plank_titled_separator_menu_item_type_id = g_type_register_static (gtk_separator_menu_item_get_type (), "PlankTitledSeparatorMenuItem", &g_define_type_info, 0);
	PlankTitledSeparatorMenuItem_private_offset = g_type_add_instance_private (plank_titled_separator_menu_item_type_id, sizeof (PlankTitledSeparatorMenuItemPrivate));
	return plank_titled_separator_menu_item_type_id;
}

GType
plank_titled_separator_menu_item_get_type (void)
{
	static volatile gsize plank_titled_separator_menu_item_type_id__once = 0;
	if (g_once_init_enter (&plank_titled_separator_menu_item_type_id__once)) {
		GType plank_titled_separator_menu_item_type_id;
		plank_titled_separator_menu_item_type_id = plank_titled_separator_menu_item_get_type_once ();
		g_once_init_leave (&plank_titled_separator_menu_item_type_id__once, plank_titled_separator_menu_item_type_id);
	}
	return plank_titled_separator_menu_item_type_id__once;
}

