
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_smb_acl.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject smb_acl_user_Type;
static PyTypeObject smb_acl_group_Type;
static PyTypeObject smb_acl_entry_info_Type;
static PyTypeObject smb_acl_entry_Type;
static PyTypeObject smb_acl_t_Type;
static PyTypeObject smb_acl_wrapper_Type;

static PyTypeObject *BaseObject_Type;

static PyObject *py_smb_acl_user_get_uid(PyObject *obj, void *closure)
{
	struct smb_acl_user *object = pytalloc_get_ptr(obj);
	PyObject *py_uid;
	py_uid = PyLong_FromUnsignedLongLong(object->uid);
	return py_uid;
}

static int py_smb_acl_user_set_uid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_user *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->uid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->uid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smb_acl_user_getsetters[] = {
	{
		.name = discard_const_p(char, "uid"),
		.get = py_smb_acl_user_get_uid,
		.set = py_smb_acl_user_set_uid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uid_t")
	},
	{ .name = NULL }
};

static PyObject *py_smb_acl_user_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb_acl_user, type);
}


static PyTypeObject smb_acl_user_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb_acl.user",
	.tp_getset = py_smb_acl_user_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_acl_user_new,
};


static PyObject *py_smb_acl_group_get_gid(PyObject *obj, void *closure)
{
	struct smb_acl_group *object = pytalloc_get_ptr(obj);
	PyObject *py_gid;
	py_gid = PyLong_FromUnsignedLongLong(object->gid);
	return py_gid;
}

static int py_smb_acl_group_set_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_group *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smb_acl_group_getsetters[] = {
	{
		.name = discard_const_p(char, "gid"),
		.get = py_smb_acl_group_get_gid,
		.set = py_smb_acl_group_set_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type gid_t")
	},
	{ .name = NULL }
};

static PyObject *py_smb_acl_group_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb_acl_group, type);
}


static PyTypeObject smb_acl_group_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb_acl.group",
	.tp_getset = py_smb_acl_group_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_acl_group_new,
};

static PyObject *py_import_smb_acl_entry_info(TALLOC_CTX *mem_ctx, int level, union smb_acl_entry_info *in)
{
	PyObject *ret;

	switch (level) {
		case SMB_ACL_USER:
			ret = pytalloc_reference_ex(&smb_acl_user_Type, mem_ctx, &in->user);
			return ret;

		case SMB_ACL_USER_OBJ:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case SMB_ACL_GROUP:
			ret = pytalloc_reference_ex(&smb_acl_group_Type, mem_ctx, &in->group);
			return ret;

		case SMB_ACL_GROUP_OBJ:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case SMB_ACL_OTHER:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case SMB_ACL_MASK:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smb_acl_entry_info *py_export_smb_acl_entry_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smb_acl_entry_info *ret = talloc_zero(mem_ctx, union smb_acl_entry_info);
	switch (level) {
		case SMB_ACL_USER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->user");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&smb_acl_user_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->user = *(struct smb_acl_user *)pytalloc_get_ptr(in);
			break;

		case SMB_ACL_USER_OBJ:
			break;

		case SMB_ACL_GROUP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->group");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&smb_acl_group_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->group = *(struct smb_acl_group *)pytalloc_get_ptr(in);
			break;

		case SMB_ACL_GROUP_OBJ:
			break;

		case SMB_ACL_OTHER:
			break;

		case SMB_ACL_MASK:
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_smb_acl_entry_info_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smb_acl_entry_info *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smb_acl_entry_info *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smb_acl_entry_info!");
		return NULL;
	}

	return py_import_smb_acl_entry_info(mem_ctx, level, in);
}

static PyObject *py_smb_acl_entry_info_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smb_acl_entry_info *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smb_acl_entry_info(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smb_acl_entry_info_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smb_acl_entry_info_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smb_acl_entry_info_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smb_acl_entry_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smb_acl_entry_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb_acl.entry_info",
	.tp_getset = NULL,
	.tp_methods = py_smb_acl_entry_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_acl_entry_info_new,
};


static PyObject *py_smb_acl_entry_get_a_type(PyObject *obj, void *closure)
{
	struct smb_acl_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_a_type;
	py_a_type = PyLong_FromLong((uint16_t)(object->a_type));
	return py_a_type;
}

static int py_smb_acl_entry_set_a_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->a_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->a_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->a_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_acl_entry_get_info(PyObject *obj, void *closure)
{
	struct smb_acl_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smb_acl_entry_info_Type, pytalloc_get_mem_ctx(obj), object->a_type, &object->info, "union smb_acl_entry_info");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smb_acl_entry_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	{
		union smb_acl_entry_info *info_switch_0;
		info_switch_0 = (union smb_acl_entry_info *)pyrpc_export_union(&smb_acl_entry_info_Type, pytalloc_get_mem_ctx(py_obj), object->a_type, value, "union smb_acl_entry_info");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->info = *info_switch_0;
	}
	return 0;
}

static PyObject *py_smb_acl_entry_get_a_perm(PyObject *obj, void *closure)
{
	struct smb_acl_entry *object = pytalloc_get_ptr(obj);
	PyObject *py_a_perm;
	py_a_perm = PyLong_FromUnsignedLongLong((uint32_t)(object->a_perm));
	return py_a_perm;
}

static int py_smb_acl_entry_set_a_perm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_entry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->a_perm");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->a_perm));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->a_perm = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smb_acl_entry_getsetters[] = {
	{
		.name = discard_const_p(char, "a_type"),
		.get = py_smb_acl_entry_get_a_type,
		.set = py_smb_acl_entry_set_a_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb_acl_tag_t")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_smb_acl_entry_get_info,
		.set = py_smb_acl_entry_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb_acl_entry_info")
	},
	{
		.name = discard_const_p(char, "a_perm"),
		.get = py_smb_acl_entry_get_a_perm,
		.set = py_smb_acl_entry_set_a_perm,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_smb_acl_entry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb_acl_entry, type);
}


static PyTypeObject smb_acl_entry_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb_acl.entry",
	.tp_getset = py_smb_acl_entry_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_acl_entry_new,
};


static PyObject *py_smb_acl_t_get_count(PyObject *obj, void *closure)
{
	struct smb_acl_t *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromLong(object->count);
	return py_count;
}

static int py_smb_acl_t_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->count));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_acl_t_get_next(PyObject *obj, void *closure)
{
	struct smb_acl_t *object = pytalloc_get_ptr(obj);
	PyObject *py_next;
	py_next = PyLong_FromLong(object->next);
	return py_next;
}

static int py_smb_acl_t_set_next(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->next");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->next));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->next = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_acl_t_get_acl(PyObject *obj, void *closure)
{
	struct smb_acl_t *object = pytalloc_get_ptr(obj);
	PyObject *py_acl;
	py_acl = PyList_New(object->count);
	if (py_acl == NULL) {
		return NULL;
	}
	{
		int acl_cntr_0;
		for (acl_cntr_0 = 0; acl_cntr_0 < (object->count); acl_cntr_0++) {
			PyObject *py_acl_0;
			py_acl_0 = pytalloc_reference_ex(&smb_acl_entry_Type, object->acl, &(object->acl)[acl_cntr_0]);
			PyList_SetItem(py_acl, acl_cntr_0, py_acl_0);
		}
	}
	return py_acl;
}

static int py_smb_acl_t_set_acl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acl");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int acl_cntr_0;
		object->acl = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->acl, PyList_GET_SIZE(value));
		if (!object->acl) { return -1; }
		talloc_set_name_const(object->acl, "ARRAY: object->acl");
		for (acl_cntr_0 = 0; acl_cntr_0 < PyList_GET_SIZE(value); acl_cntr_0++) {
			if (PyList_GET_ITEM(value, acl_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->acl)[acl_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&smb_acl_entry_Type, PyList_GET_ITEM(value, acl_cntr_0), return -1;);
			if (talloc_reference(object->acl, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, acl_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->acl)[acl_cntr_0] = *(struct smb_acl_entry *)pytalloc_get_ptr(PyList_GET_ITEM(value, acl_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_smb_acl_t_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_smb_acl_t_get_count,
		.set = py_smb_acl_t_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "next"),
		.get = py_smb_acl_t_get_next,
		.set = py_smb_acl_t_set_next,
		.doc = discard_const_p(char, "PIDL-generated element of base type int32")
	},
	{
		.name = discard_const_p(char, "acl"),
		.get = py_smb_acl_t_get_acl,
		.set = py_smb_acl_t_set_acl,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb_acl_entry")
	},
	{ .name = NULL }
};

static PyObject *py_smb_acl_t_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb_acl_t, type);
}


static PyTypeObject smb_acl_t_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb_acl.t",
	.tp_getset = py_smb_acl_t_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_acl_t_new,
};


static PyObject *py_smb_acl_wrapper_get_access_acl(PyObject *obj, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(obj);
	PyObject *py_access_acl;
	if (object->access_acl == NULL) {
		Py_RETURN_NONE;
	}
	if (object->access_acl == NULL) {
		py_access_acl = Py_None;
		Py_INCREF(py_access_acl);
	} else {
		py_access_acl = pytalloc_reference_ex(&smb_acl_t_Type, object->access_acl, object->access_acl);
	}
	return py_access_acl;
}

static int py_smb_acl_wrapper_set_access_acl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->access_acl));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->access_acl");
		return -1;
	}
	if (value == Py_None) {
		object->access_acl = NULL;
	} else {
		object->access_acl = NULL;
		PY_CHECK_TYPE(&smb_acl_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->access_acl = (struct smb_acl_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smb_acl_wrapper_get_default_acl(PyObject *obj, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(obj);
	PyObject *py_default_acl;
	if (object->default_acl == NULL) {
		Py_RETURN_NONE;
	}
	if (object->default_acl == NULL) {
		py_default_acl = Py_None;
		Py_INCREF(py_default_acl);
	} else {
		py_default_acl = pytalloc_reference_ex(&smb_acl_t_Type, object->default_acl, object->default_acl);
	}
	return py_default_acl;
}

static int py_smb_acl_wrapper_set_default_acl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->default_acl));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->default_acl");
		return -1;
	}
	if (value == Py_None) {
		object->default_acl = NULL;
	} else {
		object->default_acl = NULL;
		PY_CHECK_TYPE(&smb_acl_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->default_acl = (struct smb_acl_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_smb_acl_wrapper_get_owner(PyObject *obj, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(obj);
	PyObject *py_owner;
	py_owner = PyLong_FromUnsignedLongLong(object->owner);
	return py_owner;
}

static int py_smb_acl_wrapper_set_owner(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->owner");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->owner));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->owner = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_acl_wrapper_get_group(PyObject *obj, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(obj);
	PyObject *py_group;
	py_group = PyLong_FromUnsignedLongLong(object->group);
	return py_group;
}

static int py_smb_acl_wrapper_set_group(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->group");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->group));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->group = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smb_acl_wrapper_get_mode(PyObject *obj, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(obj);
	PyObject *py_mode;
	py_mode = PyLong_FromUnsignedLongLong((uint32_t)(object->mode));
	return py_mode;
}

static int py_smb_acl_wrapper_set_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smb_acl_wrapper *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->mode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->mode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->mode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smb_acl_wrapper_getsetters[] = {
	{
		.name = discard_const_p(char, "access_acl"),
		.get = py_smb_acl_wrapper_get_access_acl,
		.set = py_smb_acl_wrapper_set_access_acl,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb_acl_t")
	},
	{
		.name = discard_const_p(char, "default_acl"),
		.get = py_smb_acl_wrapper_get_default_acl,
		.set = py_smb_acl_wrapper_set_default_acl,
		.doc = discard_const_p(char, "PIDL-generated element of base type smb_acl_t")
	},
	{
		.name = discard_const_p(char, "owner"),
		.get = py_smb_acl_wrapper_get_owner,
		.set = py_smb_acl_wrapper_set_owner,
		.doc = discard_const_p(char, "PIDL-generated element of base type uid_t")
	},
	{
		.name = discard_const_p(char, "group"),
		.get = py_smb_acl_wrapper_get_group,
		.set = py_smb_acl_wrapper_set_group,
		.doc = discard_const_p(char, "PIDL-generated element of base type gid_t")
	},
	{
		.name = discard_const_p(char, "mode"),
		.get = py_smb_acl_wrapper_get_mode,
		.set = py_smb_acl_wrapper_set_mode,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_smb_acl_wrapper_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smb_acl_wrapper, type);
}


static PyTypeObject smb_acl_wrapper_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "smb_acl.wrapper",
	.tp_getset = py_smb_acl_wrapper_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smb_acl_wrapper_new,
};

static PyMethodDef smb_acl_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "smb_acl",
	.m_doc = "smb_acl DCE/RPC",
	.m_size = -1,
	.m_methods = smb_acl_methods,
};
MODULE_INIT_FUNC(smb_acl)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	smb_acl_user_Type.tp_base = BaseObject_Type;
	smb_acl_user_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb_acl_group_Type.tp_base = BaseObject_Type;
	smb_acl_group_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb_acl_entry_info_Type.tp_base = BaseObject_Type;
	smb_acl_entry_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb_acl_entry_Type.tp_base = BaseObject_Type;
	smb_acl_entry_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb_acl_t_Type.tp_base = BaseObject_Type;
	smb_acl_t_Type.tp_basicsize = pytalloc_BaseObject_size();

	smb_acl_wrapper_Type.tp_base = BaseObject_Type;
	smb_acl_wrapper_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&smb_acl_user_Type) < 0)
		goto out;
	if (PyType_Ready(&smb_acl_group_Type) < 0)
		goto out;
	if (PyType_Ready(&smb_acl_entry_info_Type) < 0)
		goto out;
	if (PyType_Ready(&smb_acl_entry_Type) < 0)
		goto out;
	if (PyType_Ready(&smb_acl_t_Type) < 0)
		goto out;
	if (PyType_Ready(&smb_acl_wrapper_Type) < 0)
		goto out;
#ifdef PY_USER_PATCH
	PY_USER_PATCH(&smb_acl_user_Type);
#endif
#ifdef PY_GROUP_PATCH
	PY_GROUP_PATCH(&smb_acl_group_Type);
#endif
#ifdef PY_ENTRY_INFO_PATCH
	PY_ENTRY_INFO_PATCH(&smb_acl_entry_info_Type);
#endif
#ifdef PY_ENTRY_PATCH
	PY_ENTRY_PATCH(&smb_acl_entry_Type);
#endif
#ifdef PY_T_PATCH
	PY_T_PATCH(&smb_acl_t_Type);
#endif
#ifdef PY_WRAPPER_PATCH
	PY_WRAPPER_PATCH(&smb_acl_wrapper_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "SMB_ACL_READ", PyLong_FromUnsignedLongLong(4));
	PyModule_AddObject(m, "SMB_ACL_WRITE", PyLong_FromUnsignedLongLong(2));
	PyModule_AddObject(m, "SMB_ACL_EXECUTE", PyLong_FromUnsignedLongLong(1));
	PyModule_AddObject(m, "SMB_ACL_FIRST_ENTRY", PyLong_FromUnsignedLongLong(0));
	PyModule_AddObject(m, "SMB_ACL_NEXT_ENTRY", PyLong_FromUnsignedLongLong(1));
	PyModule_AddObject(m, "SMB_ACL_TYPE_ACCESS", PyLong_FromUnsignedLongLong(0));
	PyModule_AddObject(m, "SMB_ACL_TYPE_DEFAULT", PyLong_FromUnsignedLongLong(1));
	PyModule_AddObject(m, "SMB_ACL_TAG_INVALID", PyLong_FromLong((uint16_t)(SMB_ACL_TAG_INVALID)));
	PyModule_AddObject(m, "SMB_ACL_USER", PyLong_FromLong((uint16_t)(SMB_ACL_USER)));
	PyModule_AddObject(m, "SMB_ACL_USER_OBJ", PyLong_FromLong((uint16_t)(SMB_ACL_USER_OBJ)));
	PyModule_AddObject(m, "SMB_ACL_GROUP", PyLong_FromLong((uint16_t)(SMB_ACL_GROUP)));
	PyModule_AddObject(m, "SMB_ACL_GROUP_OBJ", PyLong_FromLong((uint16_t)(SMB_ACL_GROUP_OBJ)));
	PyModule_AddObject(m, "SMB_ACL_OTHER", PyLong_FromLong((uint16_t)(SMB_ACL_OTHER)));
	PyModule_AddObject(m, "SMB_ACL_MASK", PyLong_FromLong((uint16_t)(SMB_ACL_MASK)));
	Py_INCREF((PyObject *)(void *)&smb_acl_user_Type);
	PyModule_AddObject(m, "user", (PyObject *)(void *)&smb_acl_user_Type);
	Py_INCREF((PyObject *)(void *)&smb_acl_group_Type);
	PyModule_AddObject(m, "group", (PyObject *)(void *)&smb_acl_group_Type);
	Py_INCREF((PyObject *)(void *)&smb_acl_entry_info_Type);
	PyModule_AddObject(m, "entry_info", (PyObject *)(void *)&smb_acl_entry_info_Type);
	Py_INCREF((PyObject *)(void *)&smb_acl_entry_Type);
	PyModule_AddObject(m, "entry", (PyObject *)(void *)&smb_acl_entry_Type);
	Py_INCREF((PyObject *)(void *)&smb_acl_t_Type);
	PyModule_AddObject(m, "t", (PyObject *)(void *)&smb_acl_t_Type);
	Py_INCREF((PyObject *)(void *)&smb_acl_wrapper_Type);
	PyModule_AddObject(m, "wrapper", (PyObject *)(void *)&smb_acl_wrapper_Type);
#ifdef PY_MOD_SMB_ACL_PATCH
	PY_MOD_SMB_ACL_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	return m;

}
