/* FaceDetect.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FaceDetect.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#define FACE_DETECT_DBUS_NAME "org.gnome.Shotwell.Faces1"
#define FACE_DETECT_DBUS_PATH "/org/gnome/shotwell/faces"
#define FACE_DETECT_ERROR_MESSAGE "Unable to connect to facedetect service"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FACE_RECT (face_rect_get_type ())
typedef struct _FaceRect FaceRect;

#define TYPE_FACE_DETECT_INTERFACE (face_detect_interface_get_type ())
#define FACE_DETECT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_DETECT_INTERFACE, FaceDetectInterface))
#define IS_FACE_DETECT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_DETECT_INTERFACE))
#define FACE_DETECT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FACE_DETECT_INTERFACE, FaceDetectInterfaceIface))

typedef struct _FaceDetectInterface FaceDetectInterface;
typedef struct _FaceDetectInterfaceIface FaceDetectInterfaceIface;

#define TYPE_FACE_DETECT_INTERFACE_PROXY (face_detect_interface_proxy_get_type ())
typedef GDBusProxy FaceDetectInterfaceProxy;
typedef GDBusProxyClass FaceDetectInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_FACE_DETECT (face_detect_get_type ())
#define FACE_DETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_DETECT, FaceDetect))
#define FACE_DETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_DETECT, FaceDetectClass))
#define IS_FACE_DETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_DETECT))
#define IS_FACE_DETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_DETECT))
#define FACE_DETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_DETECT, FaceDetectClass))

typedef struct _FaceDetect FaceDetect;
typedef struct _FaceDetectClass FaceDetectClass;
typedef struct _FaceDetectPrivate FaceDetectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecFaceDetect ParamSpecFaceDetect;

struct _FaceRect {
	gdouble x;
	gdouble y;
	gdouble width;
	gdouble height;
	gdouble* vec;
	gint vec_length1;
};

struct _FaceDetectInterfaceIface {
	GTypeInterface parent_iface;
	FaceRect* (*detect_faces) (FaceDetectInterface* self, const gchar* inputName, const gchar* cascadeName, gdouble scale, gboolean infer, gint* result_length1, GError** error);
	gboolean (*load_net) (FaceDetectInterface* self, const gchar* netFile, GError** error);
	void (*terminate) (FaceDetectInterface* self, GError** error);
};

struct _FaceDetect {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FaceDetectPrivate * priv;
};

struct _FaceDetectClass {
	GTypeClass parent_class;
	void (*finalize) (FaceDetect *self);
};

struct _ParamSpecFaceDetect {
	GParamSpec parent_instance;
};

static gpointer face_detect_parent_class = NULL;
VALA_EXTERN gboolean face_detect_connected;
gboolean face_detect_connected = FALSE;
VALA_EXTERN gchar* face_detect_net_file;
gchar* face_detect_net_file = NULL;
VALA_EXTERN FaceDetectInterface* face_detect_face_detect_proxy;
FaceDetectInterface* face_detect_face_detect_proxy = NULL;

VALA_EXTERN GType face_rect_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceRect* face_rect_dup (const FaceRect* self);
VALA_EXTERN void face_rect_free (FaceRect* self);
VALA_EXTERN void face_rect_copy (const FaceRect* self,
                     FaceRect* dest);
VALA_EXTERN void face_rect_destroy (FaceRect* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FaceRect, face_rect_destroy)
static gdouble* _vala_array_dup41 (gdouble* self,
                            gssize length);
VALA_EXTERN GType face_detect_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint face_detect_interface_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType face_detect_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceDetectInterface, g_object_unref)
VALA_EXTERN FaceRect* face_detect_interface_detect_faces (FaceDetectInterface* self,
                                              const gchar* inputName,
                                              const gchar* cascadeName,
                                              gdouble scale,
                                              gboolean infer,
                                              gint* result_length1,
                                              GError** error);
VALA_EXTERN gboolean face_detect_interface_load_net (FaceDetectInterface* self,
                                         const gchar* netFile,
                                         GError** error);
VALA_EXTERN void face_detect_interface_terminate (FaceDetectInterface* self,
                                      GError** error);
static GType face_detect_interface_get_type_once (void);
static void face_detect_interface_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static FaceRect* face_detect_interface_proxy_detect_faces (FaceDetectInterface* self,
                                                    const gchar* inputName,
                                                    const gchar* cascadeName,
                                                    gdouble scale,
                                                    gboolean infer,
                                                    gint* result_length1,
                                                    GError** error);
static gboolean face_detect_interface_proxy_load_net (FaceDetectInterface* self,
                                               const gchar* netFile,
                                               GError** error);
static void face_detect_interface_proxy_terminate (FaceDetectInterface* self,
                                            GError** error);
static void face_detect_interface_proxy_face_detect_interface_interface_init (FaceDetectInterfaceIface* iface);
static void _vala_FaceRect_array_free (FaceRect * array,
                                gssize array_length);
static void _dbus_face_detect_interface_detect_faces (FaceDetectInterface* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_face_detect_interface_load_net (FaceDetectInterface* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_face_detect_interface_terminate (FaceDetectInterface* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void face_detect_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* face_detect_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean face_detect_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _face_detect_interface_unregister_object (gpointer user_data);
VALA_EXTERN gpointer face_detect_ref (gpointer instance);
VALA_EXTERN void face_detect_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_face_detect (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_face_detect (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_face_detect (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_face_detect (const GValue* value);
VALA_EXTERN GType face_detect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceDetect, face_detect_unref)
VALA_EXTERN void face_detect_create_face_detect_proxy (GDBusConnection* connection,
                                           const gchar* bus_name,
                                           const gchar* owner);
VALA_EXTERN void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
VALA_EXTERN void face_detect_interface_gone (GDBusConnection* connection,
                                 const gchar* bus_name);
VALA_EXTERN void face_detect_init (const gchar* net_file);
static void _face_detect_create_face_detect_proxy_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                        const gchar* name,
                                                                        const gchar* name_owner,
                                                                        gpointer self);
static void _face_detect_interface_gone_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self);
VALA_EXTERN FaceDetect* face_detect_new (void);
VALA_EXTERN FaceDetect* face_detect_construct (GType object_type);
static void face_detect_finalize (FaceDetect * obj);
static GType face_detect_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _face_detect_interface_dbus_arg_info_detect_faces_inputName = {-1, "inputName", "s", NULL};
static const GDBusArgInfo _face_detect_interface_dbus_arg_info_detect_faces_cascadeName = {-1, "cascadeName", "s", NULL};
static const GDBusArgInfo _face_detect_interface_dbus_arg_info_detect_faces_scale = {-1, "scale", "d", NULL};
static const GDBusArgInfo _face_detect_interface_dbus_arg_info_detect_faces_infer = {-1, "infer", "b", NULL};
static const GDBusArgInfo _face_detect_interface_dbus_arg_info_detect_faces_result = {-1, "result", "a(ddddad)", NULL};
static const GDBusArgInfo * const _face_detect_interface_dbus_arg_info_detect_faces_in[] = {&_face_detect_interface_dbus_arg_info_detect_faces_inputName, &_face_detect_interface_dbus_arg_info_detect_faces_cascadeName, &_face_detect_interface_dbus_arg_info_detect_faces_scale, &_face_detect_interface_dbus_arg_info_detect_faces_infer, NULL};
static const GDBusArgInfo * const _face_detect_interface_dbus_arg_info_detect_faces_out[] = {&_face_detect_interface_dbus_arg_info_detect_faces_result, NULL};
static const GDBusMethodInfo _face_detect_interface_dbus_method_info_detect_faces = {-1, "DetectFaces", (GDBusArgInfo **) (&_face_detect_interface_dbus_arg_info_detect_faces_in), (GDBusArgInfo **) (&_face_detect_interface_dbus_arg_info_detect_faces_out), NULL};
static const GDBusArgInfo _face_detect_interface_dbus_arg_info_load_net_netFile = {-1, "netFile", "s", NULL};
static const GDBusArgInfo _face_detect_interface_dbus_arg_info_load_net_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _face_detect_interface_dbus_arg_info_load_net_in[] = {&_face_detect_interface_dbus_arg_info_load_net_netFile, NULL};
static const GDBusArgInfo * const _face_detect_interface_dbus_arg_info_load_net_out[] = {&_face_detect_interface_dbus_arg_info_load_net_result, NULL};
static const GDBusMethodInfo _face_detect_interface_dbus_method_info_load_net = {-1, "LoadNet", (GDBusArgInfo **) (&_face_detect_interface_dbus_arg_info_load_net_in), (GDBusArgInfo **) (&_face_detect_interface_dbus_arg_info_load_net_out), NULL};
static const GDBusArgInfo * const _face_detect_interface_dbus_arg_info_terminate_in[] = {NULL};
static const GDBusArgInfo * const _face_detect_interface_dbus_arg_info_terminate_out[] = {NULL};
static const GDBusMethodInfo _face_detect_interface_dbus_method_info_terminate = {-1, "Terminate", (GDBusArgInfo **) (&_face_detect_interface_dbus_arg_info_terminate_in), (GDBusArgInfo **) (&_face_detect_interface_dbus_arg_info_terminate_out), NULL};
static const GDBusMethodInfo * const _face_detect_interface_dbus_method_info[] = {&_face_detect_interface_dbus_method_info_detect_faces, &_face_detect_interface_dbus_method_info_load_net, &_face_detect_interface_dbus_method_info_terminate, NULL};
static const GDBusSignalInfo * const _face_detect_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _face_detect_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _face_detect_interface_dbus_interface_info = {-1, "org.gnome.Shotwell.Faces1", (GDBusMethodInfo **) (&_face_detect_interface_dbus_method_info), (GDBusSignalInfo **) (&_face_detect_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_face_detect_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _face_detect_interface_dbus_interface_vtable = {face_detect_interface_dbus_interface_method_call, face_detect_interface_dbus_interface_get_property, face_detect_interface_dbus_interface_set_property};

static gdouble*
_vala_array_dup41 (gdouble* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

void
face_rect_copy (const FaceRect* self,
                FaceRect* dest)
{
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
	(*dest).width = (*self).width;
	(*dest).height = (*self).height;
	_tmp0_ = (*self).vec;
	_tmp0__length1 = (*self).vec_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup41 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).vec = (g_free ((*dest).vec), NULL);
	(*dest).vec = _tmp1_;
	(*dest).vec_length1 = _tmp1__length1;
}

void
face_rect_destroy (FaceRect* self)
{
	(*self).vec = (g_free ((*self).vec), NULL);
}

FaceRect*
face_rect_dup (const FaceRect* self)
{
	FaceRect* dup;
	dup = g_new0 (FaceRect, 1);
	face_rect_copy (self, dup);
	return dup;
}

void
face_rect_free (FaceRect* self)
{
	face_rect_destroy (self);
	g_free (self);
}

static GType
face_rect_get_type_once (void)
{
	GType face_rect_type_id;
	face_rect_type_id = g_boxed_type_register_static ("FaceRect", (GBoxedCopyFunc) face_rect_dup, (GBoxedFreeFunc) face_rect_free);
	return face_rect_type_id;
}

GType
face_rect_get_type (void)
{
	static volatile gsize face_rect_type_id__once = 0;
	if (g_once_init_enter (&face_rect_type_id__once)) {
		GType face_rect_type_id;
		face_rect_type_id = face_rect_get_type_once ();
		g_once_init_leave (&face_rect_type_id__once, face_rect_type_id);
	}
	return face_rect_type_id__once;
}

FaceRect*
face_detect_interface_detect_faces (FaceDetectInterface* self,
                                    const gchar* inputName,
                                    const gchar* cascadeName,
                                    gdouble scale,
                                    gboolean infer,
                                    gint* result_length1,
                                    GError** error)
{
	FaceDetectInterfaceIface* _iface_;
	g_return_val_if_fail (IS_FACE_DETECT_INTERFACE (self), NULL);
	_iface_ = FACE_DETECT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->detect_faces) {
		return _iface_->detect_faces (self, inputName, cascadeName, scale, infer, result_length1, error);
	}
	return NULL;
}

gboolean
face_detect_interface_load_net (FaceDetectInterface* self,
                                const gchar* netFile,
                                GError** error)
{
	FaceDetectInterfaceIface* _iface_;
	g_return_val_if_fail (IS_FACE_DETECT_INTERFACE (self), FALSE);
	_iface_ = FACE_DETECT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->load_net) {
		return _iface_->load_net (self, netFile, error);
	}
	return FALSE;
}

void
face_detect_interface_terminate (FaceDetectInterface* self,
                                 GError** error)
{
	FaceDetectInterfaceIface* _iface_;
	g_return_if_fail (IS_FACE_DETECT_INTERFACE (self));
	_iface_ = FACE_DETECT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->terminate) {
		_iface_->terminate (self, error);
	}
}

static void
face_detect_interface_default_init (FaceDetectInterfaceIface * iface,
                                    gpointer iface_data)
{
}

static GType
face_detect_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceDetectInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_detect_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType face_detect_interface_type_id;
	face_detect_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "FaceDetectInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (face_detect_interface_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (face_detect_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) face_detect_interface_proxy_get_type);
	g_type_set_qdata (face_detect_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.Shotwell.Faces1");
	g_type_set_qdata (face_detect_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_face_detect_interface_dbus_interface_info));
	g_type_set_qdata (face_detect_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) face_detect_interface_register_object);
	return face_detect_interface_type_id;
}

GType
face_detect_interface_get_type (void)
{
	static volatile gsize face_detect_interface_type_id__once = 0;
	if (g_once_init_enter (&face_detect_interface_type_id__once)) {
		GType face_detect_interface_type_id;
		face_detect_interface_type_id = face_detect_interface_get_type_once ();
		g_once_init_leave (&face_detect_interface_type_id__once, face_detect_interface_type_id);
	}
	return face_detect_interface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (FaceDetectInterfaceProxy, face_detect_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_FACE_DETECT_INTERFACE, face_detect_interface_proxy_face_detect_interface_interface_init) )
static void
face_detect_interface_proxy_class_init (FaceDetectInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = face_detect_interface_proxy_g_signal;
}

static void
face_detect_interface_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
}

static void
face_detect_interface_proxy_init (FaceDetectInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_face_detect_interface_dbus_interface_info));
}

static FaceRect*
face_detect_interface_proxy_detect_faces (FaceDetectInterface* self,
                                          const gchar* inputName,
                                          const gchar* cascadeName,
                                          gdouble scale,
                                          gboolean infer,
                                          gint* result_length1,
                                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	FaceRect* _result = NULL;
	gint _result_length1;
	GVariant* _tmp26_;
	FaceRect* _tmp27_;
	gint _tmp27__length;
	gint _tmp27__size;
	gint _tmp27__length1;
	GVariantIter _tmp28_;
	GVariant* _tmp29_;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Shotwell.Faces1", "DetectFaces");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (inputName));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (cascadeName));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (scale));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (infer));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp26_ = g_variant_iter_next_value (&_reply_iter);
	_tmp27_ = g_new (FaceRect, 5);
	_tmp27__length = 0;
	_tmp27__size = 4;
	_tmp27__length1 = 0;
	g_variant_iter_init (&_tmp28_, _tmp26_);
	for (; (_tmp29_ = g_variant_iter_next_value (&_tmp28_)) != NULL; _tmp27__length1++) {
		FaceRect _tmp30_;
		GVariantIter _tmp31_;
		GVariant* _tmp32_;
		GVariant* _tmp33_;
		GVariant* _tmp34_;
		GVariant* _tmp35_;
		GVariant* _tmp36_;
		gdouble* _tmp37_;
		gint _tmp37__length;
		gint _tmp37__size;
		gint _tmp37__length1;
		GVariantIter _tmp38_;
		GVariant* _tmp39_;
		if (_tmp27__size == _tmp27__length) {
			_tmp27__size = 2 * _tmp27__size;
			_tmp27_ = g_renew (FaceRect, _tmp27_, _tmp27__size + 1);
		}
		g_variant_iter_init (&_tmp31_, _tmp29_);
		_tmp32_ = g_variant_iter_next_value (&_tmp31_);
		_tmp30_.x = g_variant_get_double (_tmp32_);
		g_variant_unref (_tmp32_);
		_tmp33_ = g_variant_iter_next_value (&_tmp31_);
		_tmp30_.y = g_variant_get_double (_tmp33_);
		g_variant_unref (_tmp33_);
		_tmp34_ = g_variant_iter_next_value (&_tmp31_);
		_tmp30_.width = g_variant_get_double (_tmp34_);
		g_variant_unref (_tmp34_);
		_tmp35_ = g_variant_iter_next_value (&_tmp31_);
		_tmp30_.height = g_variant_get_double (_tmp35_);
		g_variant_unref (_tmp35_);
		_tmp36_ = g_variant_iter_next_value (&_tmp31_);
		_tmp37_ = g_new (gdouble, 5);
		_tmp37__length = 0;
		_tmp37__size = 4;
		_tmp37__length1 = 0;
		g_variant_iter_init (&_tmp38_, _tmp36_);
		for (; (_tmp39_ = g_variant_iter_next_value (&_tmp38_)) != NULL; _tmp37__length1++) {
			if (_tmp37__size == _tmp37__length) {
				_tmp37__size = 2 * _tmp37__size;
				_tmp37_ = g_renew (gdouble, _tmp37_, _tmp37__size + 1);
			}
			_tmp37_[_tmp37__length++] = g_variant_get_double (_tmp39_);
			g_variant_unref (_tmp39_);
		}
		_tmp30_.vec_length1 = _tmp37__length1;
		_tmp30_.vec = _tmp37_;
		g_variant_unref (_tmp36_);
		_tmp27_[_tmp27__length++] = _tmp30_;
		g_variant_unref (_tmp29_);
	}
	_result_length1 = _tmp27__length1;
	_result = _tmp27_;
	g_variant_unref (_tmp26_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gboolean
face_detect_interface_proxy_load_net (FaceDetectInterface* self,
                                      const gchar* netFile,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp42_;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Shotwell.Faces1", "LoadNet");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (netFile));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp40_ = FALSE;
		return _tmp40_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp41_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp41_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp42_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp42_);
	g_variant_unref (_tmp42_);
	g_object_unref (_reply_message);
	return _result;
}

static void
face_detect_interface_proxy_terminate (FaceDetectInterface* self,
                                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.Shotwell.Faces1", "Terminate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
face_detect_interface_proxy_face_detect_interface_interface_init (FaceDetectInterfaceIface* iface)
{
	iface->detect_faces = face_detect_interface_proxy_detect_faces;
	iface->load_net = face_detect_interface_proxy_load_net;
	iface->terminate = face_detect_interface_proxy_terminate;
}

static void
_vala_FaceRect_array_free (FaceRect * array,
                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			face_rect_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_face_detect_interface_detect_faces (FaceDetectInterface* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* inputName = NULL;
	GVariant* _tmp43_;
	gchar* cascadeName = NULL;
	GVariant* _tmp44_;
	gdouble scale = 0.0;
	GVariant* _tmp45_;
	gboolean infer = FALSE;
	GVariant* _tmp46_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	FaceRect* result;
	gint result_length1 = 0;
	FaceRect* _tmp47_;
	GVariantBuilder _tmp48_;
	gint _tmp49_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp43_ = g_variant_iter_next_value (&_arguments_iter);
	inputName = g_variant_dup_string (_tmp43_, NULL);
	g_variant_unref (_tmp43_);
	_tmp44_ = g_variant_iter_next_value (&_arguments_iter);
	cascadeName = g_variant_dup_string (_tmp44_, NULL);
	g_variant_unref (_tmp44_);
	_tmp45_ = g_variant_iter_next_value (&_arguments_iter);
	scale = g_variant_get_double (_tmp45_);
	g_variant_unref (_tmp45_);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	infer = g_variant_get_boolean (_tmp46_);
	g_variant_unref (_tmp46_);
	result = face_detect_interface_detect_faces (self, inputName, cascadeName, scale, infer, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp47_ = result;
	g_variant_builder_init (&_tmp48_, G_VARIANT_TYPE ("a(ddddad)"));
	for (_tmp49_ = 0; _tmp49_ < result_length1; _tmp49_++) {
		GVariantBuilder _tmp50_;
		gdouble* _tmp51_;
		GVariantBuilder _tmp52_;
		gint _tmp53_;
		g_variant_builder_init (&_tmp50_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp50_, g_variant_new_double ((*_tmp47_).x));
		g_variant_builder_add_value (&_tmp50_, g_variant_new_double ((*_tmp47_).y));
		g_variant_builder_add_value (&_tmp50_, g_variant_new_double ((*_tmp47_).width));
		g_variant_builder_add_value (&_tmp50_, g_variant_new_double ((*_tmp47_).height));
		_tmp51_ = (*_tmp47_).vec;
		g_variant_builder_init (&_tmp52_, G_VARIANT_TYPE ("ad"));
		for (_tmp53_ = 0; _tmp53_ < (*_tmp47_).vec_length1; _tmp53_++) {
			g_variant_builder_add_value (&_tmp52_, g_variant_new_double (*_tmp51_));
			_tmp51_++;
		}
		g_variant_builder_add_value (&_tmp50_, g_variant_builder_end (&_tmp52_));
		g_variant_builder_add_value (&_tmp48_, g_variant_builder_end (&_tmp50_));
		_tmp47_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp48_));
	result = (_vala_FaceRect_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (inputName);
	_g_free0 (cascadeName);
	;
}

static void
_dbus_face_detect_interface_load_net (FaceDetectInterface* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* netFile = NULL;
	GVariant* _tmp54_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp54_ = g_variant_iter_next_value (&_arguments_iter);
	netFile = g_variant_dup_string (_tmp54_, NULL);
	g_variant_unref (_tmp54_);
	result = face_detect_interface_load_net (self, netFile, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (netFile);
	;
}

static void
_dbus_face_detect_interface_terminate (FaceDetectInterface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	face_detect_interface_terminate (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
face_detect_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "DetectFaces") == 0) {
		_dbus_face_detect_interface_detect_faces (object, parameters, invocation);
	} else if (strcmp (method_name, "LoadNet") == 0) {
		_dbus_face_detect_interface_load_net (object, parameters, invocation);
	} else if (strcmp (method_name, "Terminate") == 0) {
		_dbus_face_detect_interface_terminate (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
face_detect_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
face_detect_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
face_detect_interface_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_face_detect_interface_dbus_interface_info), &_face_detect_interface_dbus_interface_vtable, data, _face_detect_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_face_detect_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
face_detect_create_face_detect_proxy (GDBusConnection* connection,
                                      const gchar* bus_name,
                                      const gchar* owner)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (connection, g_dbus_connection_get_type ()));
	g_return_if_fail (bus_name != NULL);
	g_return_if_fail (owner != NULL);
	if (g_strcmp0 (bus_name, FACE_DETECT_DBUS_NAME) == 0) {
		g_message ("FaceDetect.vala:61: Dbus name %s available", bus_name);
		{
			FaceDetectInterface* _tmp0_ = NULL;
			FaceDetectInterface* _tmp1_;
			FaceDetectInterface* _tmp2_;
			FaceDetectInterface* _tmp3_;
			const gchar* _tmp4_;
			_tmp1_ = (FaceDetectInterface*) g_initable_new (TYPE_FACE_DETECT_INTERFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", FACE_DETECT_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", FACE_DETECT_DBUS_PATH, "g-interface-name", "org.gnome.Shotwell.Faces1", NULL);
			_tmp0_ = (FaceDetectInterface*) _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				if (_inner_error0_->domain == G_DBUS_ERROR) {
					goto __catch0_g_dbus_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (face_detect_face_detect_proxy);
			face_detect_face_detect_proxy = _tmp2_;
			_tmp3_ = face_detect_face_detect_proxy;
			_tmp4_ = face_detect_net_file;
			face_detect_interface_load_net (_tmp3_, _tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp0_);
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				if (_inner_error0_->domain == G_DBUS_ERROR) {
					goto __catch0_g_dbus_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			face_detect_connected = TRUE;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			g_clear_error (&_inner_error0_);
			app_window_error_message (FACE_DETECT_ERROR_MESSAGE, NULL);
		}
		goto __finally0;
		__catch0_g_dbus_error:
		{
			g_clear_error (&_inner_error0_);
			app_window_error_message (FACE_DETECT_ERROR_MESSAGE, NULL);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
face_detect_interface_gone (GDBusConnection* connection,
                            const gchar* bus_name)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (connection, g_dbus_connection_get_type ()));
	g_return_if_fail (bus_name != NULL);
	g_message ("FaceDetect.vala:77: Dbus name %s gone", bus_name);
	face_detect_connected = FALSE;
	_g_object_unref0 (face_detect_face_detect_proxy);
	face_detect_face_detect_proxy = NULL;
}

static void
_face_detect_create_face_detect_proxy_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   const gchar* name_owner,
                                                                   gpointer self)
{
	face_detect_create_face_detect_proxy (connection, name, name_owner);
}

static void
_face_detect_interface_gone_gbus_name_vanished_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         gpointer self)
{
	face_detect_interface_gone (connection, name);
}

void
face_detect_init (const gchar* net_file)
{
	gchar* _tmp0_;
	g_return_if_fail (net_file != NULL);
	_tmp0_ = g_strdup (net_file);
	_g_free0 (face_detect_net_file);
	face_detect_net_file = _tmp0_;
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, FACE_DETECT_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) g_cclosure_new ((GCallback) _face_detect_create_face_detect_proxy_gbus_name_appeared_callback, NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) _face_detect_interface_gone_gbus_name_vanished_callback, NULL, (GClosureNotify) NULL));
}

FaceDetect*
face_detect_construct (GType object_type)
{
	FaceDetect* self = NULL;
	self = (FaceDetect*) g_type_create_instance (object_type);
	return self;
}

FaceDetect*
face_detect_new (void)
{
	return face_detect_construct (TYPE_FACE_DETECT);
}

static void
value_face_detect_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_face_detect_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		face_detect_unref (value->data[0].v_pointer);
	}
}

static void
value_face_detect_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = face_detect_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_face_detect_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_face_detect_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FaceDetect * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = face_detect_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_face_detect_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	FaceDetect ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = face_detect_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_face_detect (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecFaceDetect* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FACE_DETECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_face_detect (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_DETECT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_face_detect (GValue* value,
                       gpointer v_object)
{
	FaceDetect * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_DETECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FACE_DETECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		face_detect_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		face_detect_unref (old);
	}
}

void
value_take_face_detect (GValue* value,
                        gpointer v_object)
{
	FaceDetect * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_DETECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FACE_DETECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		face_detect_unref (old);
	}
}

static void
face_detect_class_init (FaceDetectClass * klass,
                        gpointer klass_data)
{
	face_detect_parent_class = g_type_class_peek_parent (klass);
	((FaceDetectClass *) klass)->finalize = face_detect_finalize;
}

static void
face_detect_instance_init (FaceDetect * self,
                           gpointer klass)
{
	self->ref_count = 1;
}

static void
face_detect_finalize (FaceDetect * obj)
{
	FaceDetect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_DETECT, FaceDetect);
	g_signal_handlers_destroy (self);
}

static GType
face_detect_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_face_detect_init, value_face_detect_free_value, value_face_detect_copy_value, value_face_detect_peek_pointer, "p", value_face_detect_collect_value, "p", value_face_detect_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FaceDetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_detect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceDetect), 0, (GInstanceInitFunc) face_detect_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType face_detect_type_id;
	face_detect_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FaceDetect", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return face_detect_type_id;
}

GType
face_detect_get_type (void)
{
	static volatile gsize face_detect_type_id__once = 0;
	if (g_once_init_enter (&face_detect_type_id__once)) {
		GType face_detect_type_id;
		face_detect_type_id = face_detect_get_type_once ();
		g_once_init_leave (&face_detect_type_id__once, face_detect_type_id);
	}
	return face_detect_type_id__once;
}

gpointer
face_detect_ref (gpointer instance)
{
	FaceDetect * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
face_detect_unref (gpointer instance)
{
	FaceDetect * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FACE_DETECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

