/* HistoryManager.c generated by valac 0.56.18, the Vala compiler
 * generated from HistoryManager.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#define SPICE_SERVICES_HISTORY_MANAGER_MAX_SIZE ((guint) 50)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SPICE_HISTORY_ACTION_TYPE_ITEM_MOVED,
	SPICE_HISTORY_ACTION_TYPE_SLIDE_CHANGED,
	SPICE_HISTORY_ACTION_TYPE_ITEM_CHANGED,
	SPICE_HISTORY_ACTION_TYPE_CANVAS_CHANGED,
	SPICE_HISTORY_ACTION_TYPE_ITEM_DEPTH
} SpiceHistoryActionType;

#define SPICE_TYPE_HISTORY_ACTION_TYPE (spice_history_action_type_get_type ())

#define SPICE_SERVICES_TYPE_HISTORY_MANAGER (spice_services_history_manager_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager))
#define SPICE_SERVICES_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))
#define SPICE_SERVICES_IS_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_IS_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_HISTORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))

typedef struct _SpiceServicesHistoryManager SpiceServicesHistoryManager;
typedef struct _SpiceServicesHistoryManagerClass SpiceServicesHistoryManagerClass;
typedef struct _SpiceServicesHistoryManagerPrivate SpiceServicesHistoryManagerPrivate;

#define SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION (spice_services_history_manager_history_action_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))

typedef struct _SpiceServicesHistoryManagerHistoryAction SpiceServicesHistoryManagerHistoryAction;
typedef struct _SpiceServicesHistoryManagerHistoryActionClass SpiceServicesHistoryManagerHistoryActionClass;
enum  {
	SPICE_SERVICES_HISTORY_MANAGER_0_PROPERTY,
	SPICE_SERVICES_HISTORY_MANAGER_NUM_PROPERTIES
};
static GParamSpec* spice_services_history_manager_properties[SPICE_SERVICES_HISTORY_MANAGER_NUM_PROPERTIES];

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SpiceServicesHistoryManagerHistoryActionPrivate SpiceServicesHistoryManagerHistoryActionPrivate;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
enum  {
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_0_PROPERTY,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_TYPE,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DUP_FUNC,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DESTROY_FUNC,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_TYPE,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DUP_FUNC,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DESTROY_FUNC,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_HISTORY_TYPE_PROPERTY,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_ITEM_PROPERTY,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PARENT_PROPERTY,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PROPERTY_PROPERTY,
	SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_NUM_PROPERTIES
};
static GParamSpec* spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SPICE_SERVICES_HISTORY_MANAGER_ACTION_CALLED_SIGNAL,
	SPICE_SERVICES_HISTORY_MANAGER_UNDO_CHANGED_SIGNAL,
	SPICE_SERVICES_HISTORY_MANAGER_REDO_CHANGED_SIGNAL,
	SPICE_SERVICES_HISTORY_MANAGER_NUM_SIGNALS
};
static guint spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_NUM_SIGNALS] = {0};

struct _SpiceServicesHistoryManager {
	GObject parent_instance;
	SpiceServicesHistoryManagerPrivate * priv;
};

struct _SpiceServicesHistoryManagerClass {
	GObjectClass parent_class;
};

struct _SpiceServicesHistoryManagerPrivate {
	GQueue* undo_history;
	GQueue* redo_history;
};

struct _SpiceServicesHistoryManagerHistoryAction {
	GObject parent_instance;
	SpiceServicesHistoryManagerHistoryActionPrivate * priv;
};

struct _SpiceServicesHistoryManagerHistoryActionClass {
	GObjectClass parent_class;
};

struct _SpiceServicesHistoryManagerHistoryActionPrivate {
	GType i_type;
	GBoxedCopyFunc i_dup_func;
	GDestroyNotify i_destroy_func;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GValue value;
	SpiceHistoryActionType _history_type;
	gconstpointer _item;
	SpiceCanvas* _parent;
	gchar* _property;
};

static gint SpiceServicesHistoryManager_private_offset;
static gpointer spice_services_history_manager_parent_class = NULL;
static gint SpiceServicesHistoryManagerHistoryAction_private_offset;
static gpointer spice_services_history_manager_history_action_parent_class = NULL;

VALA_EXTERN GType spice_history_action_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType spice_services_history_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManager, g_object_unref)
VALA_EXTERN GType spice_services_history_manager_history_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManagerHistoryAction, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
VALA_EXTERN SpiceServicesHistoryManager* spice_services_history_manager_new (void);
VALA_EXTERN SpiceServicesHistoryManager* spice_services_history_manager_construct (GType object_type);
VALA_EXTERN void spice_services_history_manager_add_undoable_action (SpiceServicesHistoryManager* self,
                                                         SpiceServicesHistoryManagerHistoryAction* action,
                                                         gboolean force_add);
VALA_EXTERN const gchar* spice_services_history_manager_history_action_get_property (SpiceServicesHistoryManagerHistoryAction* self);
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN gconstpointer spice_services_history_manager_history_action_get_item (SpiceServicesHistoryManagerHistoryAction* self);
static void spice_services_history_manager_send_signals (SpiceServicesHistoryManager* self);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_undo (SpiceServicesHistoryManager* self);
VALA_EXTERN void spice_services_history_manager_history_action_action (SpiceServicesHistoryManagerHistoryAction* self);
VALA_EXTERN SpiceHistoryActionType spice_services_history_manager_history_action_get_history_type (SpiceServicesHistoryManagerHistoryAction* self);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_redo (SpiceServicesHistoryManager* self);
VALA_EXTERN void spice_services_history_manager_clear_history (SpiceServicesHistoryManager* self);
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_depth_changed (GType i_type,
                                                                                                           GBoxedCopyFunc i_dup_func,
                                                                                                           GDestroyNotify i_destroy_func,
                                                                                                           GType t_type,
                                                                                                           GBoxedCopyFunc t_dup_func,
                                                                                                           GDestroyNotify t_destroy_func,
                                                                                                           gconstpointer item,
                                                                                                           SpiceCanvas* canvas,
                                                                                                           gboolean moved_up);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_depth_changed (GType object_type,
                                                                                                                 GType i_type,
                                                                                                                 GBoxedCopyFunc i_dup_func,
                                                                                                                 GDestroyNotify i_destroy_func,
                                                                                                                 GType t_type,
                                                                                                                 GBoxedCopyFunc t_dup_func,
                                                                                                                 GDestroyNotify t_destroy_func,
                                                                                                                 gconstpointer item,
                                                                                                                 SpiceCanvas* canvas,
                                                                                                                 gboolean moved_up);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_item_moved (GType i_type,
                                                                                                        GBoxedCopyFunc i_dup_func,
                                                                                                        GDestroyNotify i_destroy_func,
                                                                                                        GType t_type,
                                                                                                        GBoxedCopyFunc t_dup_func,
                                                                                                        GDestroyNotify t_destroy_func,
                                                                                                        gconstpointer item);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_item_moved (GType object_type,
                                                                                                              GType i_type,
                                                                                                              GBoxedCopyFunc i_dup_func,
                                                                                                              GDestroyNotify i_destroy_func,
                                                                                                              GType t_type,
                                                                                                              GBoxedCopyFunc t_dup_func,
                                                                                                              GDestroyNotify t_destroy_func,
                                                                                                              gconstpointer item);
static void spice_services_history_manager_history_action_get_item_property (SpiceServicesHistoryManagerHistoryAction* self);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_item_changed (GType i_type,
                                                                                                          GBoxedCopyFunc i_dup_func,
                                                                                                          GDestroyNotify i_destroy_func,
                                                                                                          GType t_type,
                                                                                                          GBoxedCopyFunc t_dup_func,
                                                                                                          GDestroyNotify t_destroy_func,
                                                                                                          gconstpointer item,
                                                                                                          const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_item_changed (GType object_type,
                                                                                                                GType i_type,
                                                                                                                GBoxedCopyFunc i_dup_func,
                                                                                                                GDestroyNotify i_destroy_func,
                                                                                                                GType t_type,
                                                                                                                GBoxedCopyFunc t_dup_func,
                                                                                                                GDestroyNotify t_destroy_func,
                                                                                                                gconstpointer item,
                                                                                                                const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_slide_changed (GType i_type,
                                                                                                           GBoxedCopyFunc i_dup_func,
                                                                                                           GDestroyNotify i_destroy_func,
                                                                                                           GType t_type,
                                                                                                           GBoxedCopyFunc t_dup_func,
                                                                                                           GDestroyNotify t_destroy_func,
                                                                                                           gconstpointer item,
                                                                                                           const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_slide_changed (GType object_type,
                                                                                                                 GType i_type,
                                                                                                                 GBoxedCopyFunc i_dup_func,
                                                                                                                 GDestroyNotify i_destroy_func,
                                                                                                                 GType t_type,
                                                                                                                 GBoxedCopyFunc t_dup_func,
                                                                                                                 GDestroyNotify t_destroy_func,
                                                                                                                 gconstpointer item,
                                                                                                                 const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_canvas_changed (GType i_type,
                                                                                                            GBoxedCopyFunc i_dup_func,
                                                                                                            GDestroyNotify i_destroy_func,
                                                                                                            GType t_type,
                                                                                                            GBoxedCopyFunc t_dup_func,
                                                                                                            GDestroyNotify t_destroy_func,
                                                                                                            gconstpointer item,
                                                                                                            const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_canvas_changed (GType object_type,
                                                                                                                  GType i_type,
                                                                                                                  GBoxedCopyFunc i_dup_func,
                                                                                                                  GDestroyNotify i_destroy_func,
                                                                                                                  GType t_type,
                                                                                                                  GBoxedCopyFunc t_dup_func,
                                                                                                                  GDestroyNotify t_destroy_func,
                                                                                                                  gconstpointer item,
                                                                                                                  const gchar* property);
VALA_EXTERN void spice_canvas_item_style (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_style (SpiceCanvas* self);
static SpiceCanvas* spice_services_history_manager_history_action_get_parent (SpiceServicesHistoryManagerHistoryAction* self);
VALA_EXTERN void spice_canvas_move_down (SpiceCanvas* self,
                             SpiceCanvasItem* item_,
                             gboolean add_undo_action);
VALA_EXTERN void spice_canvas_move_up (SpiceCanvas* self,
                           SpiceCanvasItem* item_,
                           gboolean add_undo_action);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new (GType i_type,
                                                                                             GBoxedCopyFunc i_dup_func,
                                                                                             GDestroyNotify i_destroy_func,
                                                                                             GType t_type,
                                                                                             GBoxedCopyFunc t_dup_func,
                                                                                             GDestroyNotify t_destroy_func);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct (GType object_type,
                                                                                                   GType i_type,
                                                                                                   GBoxedCopyFunc i_dup_func,
                                                                                                   GDestroyNotify i_destroy_func,
                                                                                                   GType t_type,
                                                                                                   GBoxedCopyFunc t_dup_func,
                                                                                                   GDestroyNotify t_destroy_func);
VALA_EXTERN void spice_services_history_manager_history_action_set_history_type (SpiceServicesHistoryManagerHistoryAction* self,
                                                                     SpiceHistoryActionType value);
VALA_EXTERN void spice_services_history_manager_history_action_set_item (SpiceServicesHistoryManagerHistoryAction* self,
                                                             gconstpointer value);
VALA_EXTERN void spice_services_history_manager_history_action_set_parent (SpiceServicesHistoryManagerHistoryAction* self,
                                                               SpiceCanvas* value);
VALA_EXTERN void spice_services_history_manager_history_action_set_property (SpiceServicesHistoryManagerHistoryAction* self,
                                                                 const gchar* value);
static void spice_services_history_manager_history_action_finalize (GObject * obj);
static GType spice_services_history_manager_history_action_get_type_once (void);
static void _vala_spice_services_history_manager_history_action_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec);
static void _vala_spice_services_history_manager_history_action_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec);
static void spice_services_history_manager_finalize (GObject * obj);
static GType spice_services_history_manager_get_type_once (void);

static GType
spice_history_action_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SPICE_HISTORY_ACTION_TYPE_ITEM_MOVED, "SPICE_HISTORY_ACTION_TYPE_ITEM_MOVED", "item-moved"}, {SPICE_HISTORY_ACTION_TYPE_SLIDE_CHANGED, "SPICE_HISTORY_ACTION_TYPE_SLIDE_CHANGED", "slide-changed"}, {SPICE_HISTORY_ACTION_TYPE_ITEM_CHANGED, "SPICE_HISTORY_ACTION_TYPE_ITEM_CHANGED", "item-changed"}, {SPICE_HISTORY_ACTION_TYPE_CANVAS_CHANGED, "SPICE_HISTORY_ACTION_TYPE_CANVAS_CHANGED", "canvas-changed"}, {SPICE_HISTORY_ACTION_TYPE_ITEM_DEPTH, "SPICE_HISTORY_ACTION_TYPE_ITEM_DEPTH", "item-depth"}, {0, NULL, NULL}};
	GType spice_history_action_type_type_id;
	spice_history_action_type_type_id = g_enum_register_static ("SpiceHistoryActionType", values);
	return spice_history_action_type_type_id;
}

GType
spice_history_action_type_get_type (void)
{
	static volatile gsize spice_history_action_type_type_id__once = 0;
	if (g_once_init_enter (&spice_history_action_type_type_id__once)) {
		GType spice_history_action_type_type_id;
		spice_history_action_type_type_id = spice_history_action_type_get_type_once ();
		g_once_init_leave (&spice_history_action_type_type_id__once, spice_history_action_type_type_id);
	}
	return spice_history_action_type_type_id__once;
}

static inline gpointer
spice_services_history_manager_get_instance_private (SpiceServicesHistoryManager* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceServicesHistoryManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
#line 102 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 359 "HistoryManager.c"
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
#line 102 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 367 "HistoryManager.c"
}

SpiceServicesHistoryManager*
spice_services_history_manager_construct (GType object_type)
{
	SpiceServicesHistoryManager * self = NULL;
	GQueue* _tmp0_;
	GQueue* _tmp1_;
#line 105 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = (SpiceServicesHistoryManager*) g_object_new (object_type, NULL);
#line 106 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = g_queue_new ();
#line 106 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	(self->priv->undo_history == NULL) ? NULL : (self->priv->undo_history = (_g_queue_free__g_object_unref0_ (self->priv->undo_history), NULL));
#line 106 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->undo_history = _tmp0_;
#line 107 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp1_ = g_queue_new ();
#line 107 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	(self->priv->redo_history == NULL) ? NULL : (self->priv->redo_history = (_g_queue_free__g_object_unref0_ (self->priv->redo_history), NULL));
#line 107 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->redo_history = _tmp1_;
#line 105 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self;
#line 392 "HistoryManager.c"
}

SpiceServicesHistoryManager*
spice_services_history_manager_new (void)
{
#line 105 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return spice_services_history_manager_construct (SPICE_SERVICES_TYPE_HISTORY_MANAGER);
#line 400 "HistoryManager.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 113 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self ? g_object_ref (self) : NULL;
#line 408 "HistoryManager.c"
}

void
spice_services_history_manager_add_undoable_action (SpiceServicesHistoryManager* self,
                                                    SpiceServicesHistoryManagerHistoryAction* action,
                                                    gboolean force_add)
{
	GQueue* _tmp0_;
	SpiceServicesHistoryManagerHistoryAction* last_action = NULL;
	GQueue* _tmp1_;
	gconstpointer _tmp2_;
	SpiceServicesHistoryManagerHistoryAction* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GQueue* _tmp20_;
#line 110 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 110 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (action != NULL);
#line 111 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->redo_history;
#line 111 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_queue_clear (_tmp0_);
#line 113 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp1_ = self->priv->undo_history;
#line 113 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp2_ = g_queue_peek_head (_tmp1_);
#line 113 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp3_ = _g_object_ref0 ((SpiceServicesHistoryManagerHistoryAction*) _tmp2_);
#line 113 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	last_action = _tmp3_;
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (force_add) {
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp6_ = TRUE;
#line 445 "HistoryManager.c"
	} else {
		SpiceServicesHistoryManagerHistoryAction* _tmp7_;
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp7_ = last_action;
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp6_ = _tmp7_ == NULL;
#line 452 "HistoryManager.c"
	}
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (_tmp6_) {
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp5_ = TRUE;
#line 458 "HistoryManager.c"
	} else {
		SpiceServicesHistoryManagerHistoryAction* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
#line 116 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp8_ = last_action;
#line 116 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp9_ = spice_services_history_manager_history_action_get_property (_tmp8_);
#line 116 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp10_ = _tmp9_;
#line 116 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp11_ = spice_services_history_manager_history_action_get_property (action);
#line 116 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp12_ = _tmp11_;
#line 116 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp5_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
#line 477 "HistoryManager.c"
	}
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (_tmp5_) {
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp4_ = TRUE;
#line 483 "HistoryManager.c"
	} else {
		SpiceServicesHistoryManagerHistoryAction* _tmp13_;
		gconstpointer _tmp14_;
		gconstpointer _tmp15_;
		gconstpointer _tmp16_;
		gconstpointer _tmp17_;
#line 117 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp13_ = last_action;
#line 117 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp14_ = spice_services_history_manager_history_action_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction));
#line 117 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp15_ = _tmp14_;
#line 117 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp16_ = spice_services_history_manager_history_action_get_item (G_TYPE_CHECK_INSTANCE_CAST (action, SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction));
#line 117 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp17_ = _tmp16_;
#line 117 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp4_ = ((SpiceCanvasItem*) _tmp15_) != ((SpiceCanvasItem*) _tmp17_);
#line 502 "HistoryManager.c"
	}
#line 115 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (_tmp4_) {
#line 506 "HistoryManager.c"
		GQueue* _tmp18_;
		SpiceServicesHistoryManagerHistoryAction* _tmp19_;
#line 118 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp18_ = self->priv->undo_history;
#line 118 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp19_ = _g_object_ref0 (action);
#line 118 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_queue_push_head (_tmp18_, _tmp19_);
#line 515 "HistoryManager.c"
	}
#line 121 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp20_ = self->priv->undo_history;
#line 121 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (g_queue_get_length (_tmp20_) > SPICE_SERVICES_HISTORY_MANAGER_MAX_SIZE) {
#line 521 "HistoryManager.c"
		GQueue* _tmp21_;
		gpointer _tmp22_;
		SpiceServicesHistoryManagerHistoryAction* _tmp23_;
#line 122 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp21_ = self->priv->undo_history;
#line 122 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp22_ = g_queue_pop_tail (_tmp21_);
#line 122 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp23_ = (SpiceServicesHistoryManagerHistoryAction*) _tmp22_;
#line 122 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_g_object_unref0 (_tmp23_);
#line 533 "HistoryManager.c"
	}
#line 125 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_send_signals (self);
#line 110 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_g_object_unref0 (last_action);
#line 539 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_undo (SpiceServicesHistoryManager* self)
{
	GQueue* _tmp0_;
	SpiceServicesHistoryManagerHistoryAction* item = NULL;
	GQueue* _tmp1_;
	gpointer _tmp2_;
	SpiceServicesHistoryManagerHistoryAction* _tmp3_;
	SpiceServicesHistoryManagerHistoryAction* _tmp4_;
	SpiceHistoryActionType _tmp5_;
	SpiceHistoryActionType _tmp6_;
	GQueue* _tmp10_;
	SpiceServicesHistoryManagerHistoryAction* _tmp11_;
	SpiceServicesHistoryManagerHistoryAction* _tmp12_;
	SpiceServicesHistoryManagerHistoryAction* result;
#line 128 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 129 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->undo_history;
#line 129 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (g_queue_is_empty (_tmp0_)) {
#line 130 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		result = NULL;
#line 130 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		return result;
#line 567 "HistoryManager.c"
	}
#line 133 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp1_ = self->priv->undo_history;
#line 133 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp2_ = g_queue_pop_head (_tmp1_);
#line 133 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	item = (SpiceServicesHistoryManagerHistoryAction*) _tmp2_;
#line 134 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp3_ = item;
#line 134 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_history_action_action (_tmp3_);
#line 136 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp4_ = item;
#line 136 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp5_ = spice_services_history_manager_history_action_get_history_type (_tmp4_);
#line 136 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp6_ = _tmp5_;
#line 136 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (_tmp6_ != SPICE_HISTORY_ACTION_TYPE_CANVAS_CHANGED) {
#line 587 "HistoryManager.c"
		SpiceServicesHistoryManagerHistoryAction* _tmp7_;
		gconstpointer _tmp8_;
		gconstpointer _tmp9_;
#line 137 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp7_ = item;
#line 137 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp8_ = spice_services_history_manager_history_action_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction));
#line 137 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp9_ = _tmp8_;
#line 137 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_signal_emit (self, spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_ACTION_CALLED_SIGNAL], 0, (SpiceCanvasItem*) _tmp9_);
#line 599 "HistoryManager.c"
	} else {
#line 139 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_signal_emit (self, spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_ACTION_CALLED_SIGNAL], 0, NULL);
#line 603 "HistoryManager.c"
	}
#line 142 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp10_ = self->priv->redo_history;
#line 142 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp11_ = item;
#line 142 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 142 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_queue_push_head (_tmp10_, _tmp12_);
#line 143 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_send_signals (self);
#line 145 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	result = item;
#line 145 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return result;
#line 619 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_redo (SpiceServicesHistoryManager* self)
{
	GQueue* _tmp0_;
	SpiceServicesHistoryManagerHistoryAction* item = NULL;
	GQueue* _tmp1_;
	gpointer _tmp2_;
	SpiceServicesHistoryManagerHistoryAction* _tmp3_;
	SpiceServicesHistoryManagerHistoryAction* _tmp4_;
	SpiceHistoryActionType _tmp5_;
	SpiceHistoryActionType _tmp6_;
	GQueue* _tmp10_;
	SpiceServicesHistoryManagerHistoryAction* _tmp11_;
	SpiceServicesHistoryManagerHistoryAction* _tmp12_;
	SpiceServicesHistoryManagerHistoryAction* result;
#line 148 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->redo_history;
#line 149 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (g_queue_is_empty (_tmp0_)) {
#line 150 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		result = NULL;
#line 150 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		return result;
#line 647 "HistoryManager.c"
	}
#line 153 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp1_ = self->priv->redo_history;
#line 153 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp2_ = g_queue_pop_head (_tmp1_);
#line 153 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	item = (SpiceServicesHistoryManagerHistoryAction*) _tmp2_;
#line 154 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp3_ = item;
#line 154 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_history_action_action (_tmp3_);
#line 156 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp4_ = item;
#line 156 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp5_ = spice_services_history_manager_history_action_get_history_type (_tmp4_);
#line 156 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp6_ = _tmp5_;
#line 156 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (_tmp6_ != SPICE_HISTORY_ACTION_TYPE_CANVAS_CHANGED) {
#line 667 "HistoryManager.c"
		SpiceServicesHistoryManagerHistoryAction* _tmp7_;
		gconstpointer _tmp8_;
		gconstpointer _tmp9_;
#line 157 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp7_ = item;
#line 157 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp8_ = spice_services_history_manager_history_action_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction));
#line 157 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp9_ = _tmp8_;
#line 157 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_signal_emit (self, spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_ACTION_CALLED_SIGNAL], 0, (SpiceCanvasItem*) _tmp9_);
#line 679 "HistoryManager.c"
	} else {
#line 159 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_signal_emit (self, spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_ACTION_CALLED_SIGNAL], 0, NULL);
#line 683 "HistoryManager.c"
	}
#line 162 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp10_ = self->priv->undo_history;
#line 162 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp11_ = item;
#line 162 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 162 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_queue_push_head (_tmp10_, _tmp12_);
#line 163 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_send_signals (self);
#line 165 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	result = item;
#line 165 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return result;
#line 699 "HistoryManager.c"
}

static void
spice_services_history_manager_send_signals (SpiceServicesHistoryManager* self)
{
	GQueue* _tmp0_;
	GQueue* _tmp1_;
#line 168 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 169 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->undo_history;
#line 169 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_signal_emit (self, spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_UNDO_CHANGED_SIGNAL], 0, g_queue_is_empty (_tmp0_));
#line 170 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp1_ = self->priv->redo_history;
#line 170 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_signal_emit (self, spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_REDO_CHANGED_SIGNAL], 0, g_queue_is_empty (_tmp1_));
#line 717 "HistoryManager.c"
}

void
spice_services_history_manager_clear_history (SpiceServicesHistoryManager* self)
{
	GQueue* _tmp0_;
	GQueue* _tmp1_;
#line 173 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 174 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->undo_history;
#line 174 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_queue_clear (_tmp0_);
#line 175 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp1_ = self->priv->redo_history;
#line 175 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_queue_clear (_tmp1_);
#line 735 "HistoryManager.c"
}

static inline gpointer
spice_services_history_manager_history_action_get_instance_private (SpiceServicesHistoryManagerHistoryAction* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceServicesHistoryManagerHistoryAction_private_offset);
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_construct_depth_changed (GType object_type,
                                                                       GType i_type,
                                                                       GBoxedCopyFunc i_dup_func,
                                                                       GDestroyNotify i_destroy_func,
                                                                       GType t_type,
                                                                       GBoxedCopyFunc t_dup_func,
                                                                       GDestroyNotify t_destroy_func,
                                                                       gconstpointer item,
                                                                       SpiceCanvas* canvas,
                                                                       gboolean moved_up)
{
	SpiceServicesHistoryManagerHistoryAction * self = NULL;
	GValue _tmp0_ = {0};
#line 47 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (canvas != NULL, NULL);
#line 48 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = (SpiceServicesHistoryManagerHistoryAction*) g_object_new (object_type, "i-type", i_type, "i-dup-func", i_dup_func, "i-destroy-func", i_destroy_func, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, "item", item, "history-type", SPICE_HISTORY_ACTION_TYPE_ITEM_DEPTH, "property", "depth", "parent", canvas, NULL);
#line 48 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_type = i_type;
#line 48 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_dup_func = i_dup_func;
#line 48 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_destroy_func = i_destroy_func;
#line 48 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_type = t_type;
#line 48 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_dup_func = t_dup_func;
#line 48 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_destroy_func = t_destroy_func;
#line 49 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_value_init (&_tmp0_, G_TYPE_BOOLEAN);
#line 49 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_value_set_boolean (&_tmp0_, moved_up);
#line 49 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_IS_VALUE (&self->priv->value) ? (g_value_unset (&self->priv->value), NULL) : NULL;
#line 49 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->value = _tmp0_;
#line 47 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self;
#line 784 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_new_depth_changed (GType i_type,
                                                                 GBoxedCopyFunc i_dup_func,
                                                                 GDestroyNotify i_destroy_func,
                                                                 GType t_type,
                                                                 GBoxedCopyFunc t_dup_func,
                                                                 GDestroyNotify t_destroy_func,
                                                                 gconstpointer item,
                                                                 SpiceCanvas* canvas,
                                                                 gboolean moved_up)
{
#line 47 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return spice_services_history_manager_history_action_construct_depth_changed (SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, i_type, i_dup_func, i_destroy_func, t_type, t_dup_func, t_destroy_func, item, canvas, moved_up);
#line 800 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_construct_item_moved (GType object_type,
                                                                    GType i_type,
                                                                    GBoxedCopyFunc i_dup_func,
                                                                    GDestroyNotify i_destroy_func,
                                                                    GType t_type,
                                                                    GBoxedCopyFunc t_dup_func,
                                                                    GDestroyNotify t_destroy_func,
                                                                    gconstpointer item)
{
	SpiceServicesHistoryManagerHistoryAction * self = NULL;
#line 53 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = (SpiceServicesHistoryManagerHistoryAction*) g_object_new (object_type, "i-type", i_type, "i-dup-func", i_dup_func, "i-destroy-func", i_destroy_func, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, "item", item, "history-type", SPICE_HISTORY_ACTION_TYPE_ITEM_MOVED, "property", "rectangle", NULL);
#line 53 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_type = i_type;
#line 53 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_dup_func = i_dup_func;
#line 53 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_destroy_func = i_destroy_func;
#line 53 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_type = t_type;
#line 53 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_dup_func = t_dup_func;
#line 53 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_destroy_func = t_destroy_func;
#line 54 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_history_action_get_item_property (self);
#line 52 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self;
#line 832 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_new_item_moved (GType i_type,
                                                              GBoxedCopyFunc i_dup_func,
                                                              GDestroyNotify i_destroy_func,
                                                              GType t_type,
                                                              GBoxedCopyFunc t_dup_func,
                                                              GDestroyNotify t_destroy_func,
                                                              gconstpointer item)
{
#line 52 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return spice_services_history_manager_history_action_construct_item_moved (SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, i_type, i_dup_func, i_destroy_func, t_type, t_dup_func, t_destroy_func, item);
#line 846 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_construct_item_changed (GType object_type,
                                                                      GType i_type,
                                                                      GBoxedCopyFunc i_dup_func,
                                                                      GDestroyNotify i_destroy_func,
                                                                      GType t_type,
                                                                      GBoxedCopyFunc t_dup_func,
                                                                      GDestroyNotify t_destroy_func,
                                                                      gconstpointer item,
                                                                      const gchar* property)
{
	SpiceServicesHistoryManagerHistoryAction * self = NULL;
#line 57 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (property != NULL, NULL);
#line 58 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = (SpiceServicesHistoryManagerHistoryAction*) g_object_new (object_type, "i-type", i_type, "i-dup-func", i_dup_func, "i-destroy-func", i_destroy_func, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, "item", item, "history-type", SPICE_HISTORY_ACTION_TYPE_ITEM_CHANGED, "property", property, NULL);
#line 58 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_type = i_type;
#line 58 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_dup_func = i_dup_func;
#line 58 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_destroy_func = i_destroy_func;
#line 58 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_type = t_type;
#line 58 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_dup_func = t_dup_func;
#line 58 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_destroy_func = t_destroy_func;
#line 59 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_history_action_get_item_property (self);
#line 57 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self;
#line 881 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_new_item_changed (GType i_type,
                                                                GBoxedCopyFunc i_dup_func,
                                                                GDestroyNotify i_destroy_func,
                                                                GType t_type,
                                                                GBoxedCopyFunc t_dup_func,
                                                                GDestroyNotify t_destroy_func,
                                                                gconstpointer item,
                                                                const gchar* property)
{
#line 57 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return spice_services_history_manager_history_action_construct_item_changed (SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, i_type, i_dup_func, i_destroy_func, t_type, t_dup_func, t_destroy_func, item, property);
#line 896 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_construct_slide_changed (GType object_type,
                                                                       GType i_type,
                                                                       GBoxedCopyFunc i_dup_func,
                                                                       GDestroyNotify i_destroy_func,
                                                                       GType t_type,
                                                                       GBoxedCopyFunc t_dup_func,
                                                                       GDestroyNotify t_destroy_func,
                                                                       gconstpointer item,
                                                                       const gchar* property)
{
	SpiceServicesHistoryManagerHistoryAction * self = NULL;
#line 62 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (property != NULL, NULL);
#line 63 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = (SpiceServicesHistoryManagerHistoryAction*) g_object_new (object_type, "i-type", i_type, "i-dup-func", i_dup_func, "i-destroy-func", i_destroy_func, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, "item", item, "history-type", SPICE_HISTORY_ACTION_TYPE_SLIDE_CHANGED, "property", property, NULL);
#line 63 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_type = i_type;
#line 63 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_dup_func = i_dup_func;
#line 63 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_destroy_func = i_destroy_func;
#line 63 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_type = t_type;
#line 63 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_dup_func = t_dup_func;
#line 63 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_destroy_func = t_destroy_func;
#line 64 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_history_action_get_item_property (self);
#line 62 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self;
#line 931 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_new_slide_changed (GType i_type,
                                                                 GBoxedCopyFunc i_dup_func,
                                                                 GDestroyNotify i_destroy_func,
                                                                 GType t_type,
                                                                 GBoxedCopyFunc t_dup_func,
                                                                 GDestroyNotify t_destroy_func,
                                                                 gconstpointer item,
                                                                 const gchar* property)
{
#line 62 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return spice_services_history_manager_history_action_construct_slide_changed (SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, i_type, i_dup_func, i_destroy_func, t_type, t_dup_func, t_destroy_func, item, property);
#line 946 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_construct_canvas_changed (GType object_type,
                                                                        GType i_type,
                                                                        GBoxedCopyFunc i_dup_func,
                                                                        GDestroyNotify i_destroy_func,
                                                                        GType t_type,
                                                                        GBoxedCopyFunc t_dup_func,
                                                                        GDestroyNotify t_destroy_func,
                                                                        gconstpointer item,
                                                                        const gchar* property)
{
	SpiceServicesHistoryManagerHistoryAction * self = NULL;
#line 67 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (property != NULL, NULL);
#line 68 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = (SpiceServicesHistoryManagerHistoryAction*) g_object_new (object_type, "i-type", i_type, "i-dup-func", i_dup_func, "i-destroy-func", i_destroy_func, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, "item", item, "history-type", SPICE_HISTORY_ACTION_TYPE_CANVAS_CHANGED, "property", property, NULL);
#line 68 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_type = i_type;
#line 68 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_dup_func = i_dup_func;
#line 68 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_destroy_func = i_destroy_func;
#line 68 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_type = t_type;
#line 68 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_dup_func = t_dup_func;
#line 68 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_destroy_func = t_destroy_func;
#line 69 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_history_action_get_item_property (self);
#line 67 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self;
#line 981 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_new_canvas_changed (GType i_type,
                                                                  GBoxedCopyFunc i_dup_func,
                                                                  GDestroyNotify i_destroy_func,
                                                                  GType t_type,
                                                                  GBoxedCopyFunc t_dup_func,
                                                                  GDestroyNotify t_destroy_func,
                                                                  gconstpointer item,
                                                                  const gchar* property)
{
#line 67 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return spice_services_history_manager_history_action_construct_canvas_changed (SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, i_type, i_dup_func, i_destroy_func, t_type, t_dup_func, t_destroy_func, item, property);
#line 996 "HistoryManager.c"
}

static void
spice_services_history_manager_history_action_get_item_property (SpiceServicesHistoryManagerHistoryAction* self)
{
	GValue _tmp0_ = {0};
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
#line 72 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 73 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_value_init (&_tmp0_, self->priv->t_type);
#line 73 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_IS_VALUE (&self->priv->value) ? (g_value_unset (&self->priv->value), NULL) : NULL;
#line 73 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->value = _tmp0_;
#line 74 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp1_ = self->priv->_item;
#line 74 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp2_ = self->priv->_property;
#line 74 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_get_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), _tmp2_, &self->priv->value);
#line 1019 "HistoryManager.c"
}

void
spice_services_history_manager_history_action_action (SpiceServicesHistoryManagerHistoryAction* self)
{
	SpiceHistoryActionType _tmp0_;
#line 77 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 78 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->_history_type;
#line 78 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (_tmp0_ != SPICE_HISTORY_ACTION_TYPE_ITEM_DEPTH) {
#line 1032 "HistoryManager.c"
		GValue temp = {0};
		GValue _tmp1_ = {0};
		gconstpointer _tmp2_;
		const gchar* _tmp3_;
		gconstpointer _tmp4_;
		const gchar* _tmp5_;
		GValue _tmp6_;
		SpiceHistoryActionType _tmp7_;
		GValue _tmp11_;
		GValue _tmp12_;
		GValue _tmp13_ = {0};
#line 79 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_init (&_tmp1_, self->priv->t_type);
#line 79 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		temp = _tmp1_;
#line 80 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp2_ = self->priv->_item;
#line 80 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp3_ = self->priv->_property;
#line 80 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_object_get_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), _tmp3_, &temp);
#line 81 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp4_ = self->priv->_item;
#line 81 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp5_ = self->priv->_property;
#line 81 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp6_ = self->priv->value;
#line 81 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_object_set_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), _tmp5_, &_tmp6_);
#line 83 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp7_ = self->priv->_history_type;
#line 83 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		if (_tmp7_ == SPICE_HISTORY_ACTION_TYPE_ITEM_CHANGED) {
#line 1066 "HistoryManager.c"
			gconstpointer _tmp8_;
#line 84 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			_tmp8_ = self->priv->_item;
#line 84 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			spice_canvas_item_style (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 1072 "HistoryManager.c"
		} else {
			SpiceHistoryActionType _tmp9_;
#line 85 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			_tmp9_ = self->priv->_history_type;
#line 85 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			if (_tmp9_ == SPICE_HISTORY_ACTION_TYPE_CANVAS_CHANGED) {
#line 1079 "HistoryManager.c"
				gconstpointer _tmp10_;
#line 86 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
				_tmp10_ = self->priv->_item;
#line 86 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
				spice_canvas_style (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SPICE_TYPE_CANVAS, SpiceCanvas));
#line 1085 "HistoryManager.c"
			}
		}
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp11_ = temp;
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp12_ = _tmp11_;
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		if (G_IS_VALUE (&_tmp12_)) {
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			g_value_init (&_tmp13_, G_VALUE_TYPE (&_tmp12_));
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			g_value_copy (&_tmp12_, &_tmp13_);
#line 1098 "HistoryManager.c"
		} else {
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			_tmp13_ = _tmp12_;
#line 1102 "HistoryManager.c"
		}
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		G_IS_VALUE (&self->priv->value) ? (g_value_unset (&self->priv->value), NULL) : NULL;
#line 89 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->value = _tmp13_;
#line 78 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		G_IS_VALUE (&temp) ? (g_value_unset (&temp), NULL) : NULL;
#line 1110 "HistoryManager.c"
	} else {
#line 91 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		if (g_value_get_boolean (&self->priv->value)) {
#line 1114 "HistoryManager.c"
			SpiceCanvas* _tmp14_;
			gconstpointer _tmp15_;
#line 92 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			_tmp14_ = self->priv->_parent;
#line 92 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			_tmp15_ = self->priv->_item;
#line 92 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			spice_canvas_move_down (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem), FALSE);
#line 1123 "HistoryManager.c"
		} else {
			SpiceCanvas* _tmp16_;
			gconstpointer _tmp17_;
#line 94 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			_tmp16_ = self->priv->_parent;
#line 94 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			_tmp17_ = self->priv->_item;
#line 94 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
			spice_canvas_move_up (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem), FALSE);
#line 1133 "HistoryManager.c"
		}
#line 97 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_boolean (&self->priv->value, !g_value_get_boolean (&self->priv->value));
#line 1137 "HistoryManager.c"
	}
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_construct (GType object_type,
                                                         GType i_type,
                                                         GBoxedCopyFunc i_dup_func,
                                                         GDestroyNotify i_destroy_func,
                                                         GType t_type,
                                                         GBoxedCopyFunc t_dup_func,
                                                         GDestroyNotify t_destroy_func)
{
	SpiceServicesHistoryManagerHistoryAction * self = NULL;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = (SpiceServicesHistoryManagerHistoryAction*) g_object_new (object_type, "i-type", i_type, "i-dup-func", i_dup_func, "i-destroy-func", i_destroy_func, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, NULL);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_type = i_type;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_dup_func = i_dup_func;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->i_destroy_func = i_destroy_func;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_type = t_type;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_dup_func = t_dup_func;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv->t_destroy_func = t_destroy_func;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return self;
#line 1167 "HistoryManager.c"
}

SpiceServicesHistoryManagerHistoryAction*
spice_services_history_manager_history_action_new (GType i_type,
                                                   GBoxedCopyFunc i_dup_func,
                                                   GDestroyNotify i_destroy_func,
                                                   GType t_type,
                                                   GBoxedCopyFunc t_dup_func,
                                                   GDestroyNotify t_destroy_func)
{
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return spice_services_history_manager_history_action_construct (SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, i_type, i_dup_func, i_destroy_func, t_type, t_dup_func, t_destroy_func);
#line 1180 "HistoryManager.c"
}

SpiceHistoryActionType
spice_services_history_manager_history_action_get_history_type (SpiceServicesHistoryManagerHistoryAction* self)
{
	SpiceHistoryActionType result;
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	result = self->priv->_history_type;
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return result;
#line 1193 "HistoryManager.c"
}

void
spice_services_history_manager_history_action_set_history_type (SpiceServicesHistoryManagerHistoryAction* self,
                                                                SpiceHistoryActionType value)
{
	SpiceHistoryActionType old_value;
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	old_value = spice_services_history_manager_history_action_get_history_type (self);
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (old_value != value) {
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->_history_type = value;
#line 41 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_HISTORY_TYPE_PROPERTY]);
#line 1211 "HistoryManager.c"
	}
}

gconstpointer
spice_services_history_manager_history_action_get_item (SpiceServicesHistoryManagerHistoryAction* self)
{
	gconstpointer result;
	gconstpointer _tmp0_;
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->_item;
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	result = _tmp0_;
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return result;
#line 1228 "HistoryManager.c"
}

void
spice_services_history_manager_history_action_set_item (SpiceServicesHistoryManagerHistoryAction* self,
                                                        gconstpointer value)
{
	gconstpointer old_value;
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	old_value = spice_services_history_manager_history_action_get_item (self);
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (old_value != value) {
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->_item = value;
#line 42 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_ITEM_PROPERTY]);
#line 1246 "HistoryManager.c"
	}
}

static SpiceCanvas*
spice_services_history_manager_history_action_get_parent (SpiceServicesHistoryManagerHistoryAction* self)
{
	SpiceCanvas* result;
	SpiceCanvas* _tmp0_;
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->_parent;
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	result = _tmp0_;
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return result;
#line 1263 "HistoryManager.c"
}

void
spice_services_history_manager_history_action_set_parent (SpiceServicesHistoryManagerHistoryAction* self,
                                                          SpiceCanvas* value)
{
	SpiceCanvas* old_value;
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	old_value = spice_services_history_manager_history_action_get_parent (self);
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (old_value != value) {
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->_parent = value;
#line 43 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PARENT_PROPERTY]);
#line 1281 "HistoryManager.c"
	}
}

const gchar*
spice_services_history_manager_history_action_get_property (SpiceServicesHistoryManagerHistoryAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_tmp0_ = self->priv->_property;
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	result = _tmp0_;
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	return result;
#line 1298 "HistoryManager.c"
}

void
spice_services_history_manager_history_action_set_property (SpiceServicesHistoryManagerHistoryAction* self,
                                                            const gchar* value)
{
	gchar* old_value;
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_return_if_fail (self != NULL);
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	old_value = spice_services_history_manager_history_action_get_property (self);
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1312 "HistoryManager.c"
		gchar* _tmp0_;
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_tmp0_ = g_strdup (value);
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		_g_free0 (self->priv->_property);
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->_property = _tmp0_;
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PROPERTY_PROPERTY]);
#line 1322 "HistoryManager.c"
	}
}

static void
spice_services_history_manager_history_action_class_init (SpiceServicesHistoryManagerHistoryActionClass * klass,
                                                          gpointer klass_data)
{
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_history_action_parent_class = g_type_class_peek_parent (klass);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_type_class_adjust_private_offset (klass, &SpiceServicesHistoryManagerHistoryAction_private_offset);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_services_history_manager_history_action_get_property;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_services_history_manager_history_action_set_property;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_services_history_manager_history_action_finalize;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_TYPE, g_param_spec_gtype ("i-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DUP_FUNC, g_param_spec_pointer ("i-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DESTROY_FUNC, g_param_spec_pointer ("i-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_HISTORY_TYPE_PROPERTY, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_HISTORY_TYPE_PROPERTY] = g_param_spec_enum ("history-type", "history-type", "history-type", SPICE_TYPE_HISTORY_ACTION_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_ITEM_PROPERTY, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_ITEM_PROPERTY] = g_param_spec_pointer ("item", "item", "item", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PARENT_PROPERTY, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", SPICE_TYPE_CANVAS, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PROPERTY_PROPERTY, spice_services_history_manager_history_action_properties[SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PROPERTY_PROPERTY] = g_param_spec_string ("property", "property", "property", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1360 "HistoryManager.c"
}

static void
spice_services_history_manager_history_action_instance_init (SpiceServicesHistoryManagerHistoryAction * self,
                                                             gpointer klass)
{
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv = spice_services_history_manager_history_action_get_instance_private (self);
#line 1369 "HistoryManager.c"
}

static void
spice_services_history_manager_history_action_finalize (GObject * obj)
{
	SpiceServicesHistoryManagerHistoryAction * self;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction);
#line 39 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_IS_VALUE (&self->priv->value) ? (g_value_unset (&self->priv->value), NULL) : NULL;
#line 45 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	_g_free0 (self->priv->_property);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_OBJECT_CLASS (spice_services_history_manager_history_action_parent_class)->finalize (obj);
#line 1384 "HistoryManager.c"
}

static GType
spice_services_history_manager_history_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceServicesHistoryManagerHistoryActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_services_history_manager_history_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceServicesHistoryManagerHistoryAction), 0, (GInstanceInitFunc) spice_services_history_manager_history_action_instance_init, NULL };
	GType spice_services_history_manager_history_action_type_id;
	spice_services_history_manager_history_action_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceServicesHistoryManagerHistoryAction", &g_define_type_info, 0);
	SpiceServicesHistoryManagerHistoryAction_private_offset = g_type_add_instance_private (spice_services_history_manager_history_action_type_id, sizeof (SpiceServicesHistoryManagerHistoryActionPrivate));
	return spice_services_history_manager_history_action_type_id;
}

GType
spice_services_history_manager_history_action_get_type (void)
{
	static volatile gsize spice_services_history_manager_history_action_type_id__once = 0;
	if (g_once_init_enter (&spice_services_history_manager_history_action_type_id__once)) {
		GType spice_services_history_manager_history_action_type_id;
		spice_services_history_manager_history_action_type_id = spice_services_history_manager_history_action_get_type_once ();
		g_once_init_leave (&spice_services_history_manager_history_action_type_id__once, spice_services_history_manager_history_action_type_id);
	}
	return spice_services_history_manager_history_action_type_id__once;
}

static void
_vala_spice_services_history_manager_history_action_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec)
{
	SpiceServicesHistoryManagerHistoryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	switch (property_id) {
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_HISTORY_TYPE_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_enum (value, spice_services_history_manager_history_action_get_history_type (self));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_ITEM_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_pointer (value, spice_services_history_manager_history_action_get_item (self));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PARENT_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_object (value, spice_services_history_manager_history_action_get_parent (self));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PROPERTY_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_string (value, spice_services_history_manager_history_action_get_property (self));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_TYPE:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_gtype (value, self->priv->i_type);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DUP_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_pointer (value, self->priv->i_dup_func);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DESTROY_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_pointer (value, self->priv->i_destroy_func);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_TYPE:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_gtype (value, self->priv->t_type);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DUP_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_pointer (value, self->priv->t_dup_func);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DESTROY_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		g_value_set_pointer (value, self->priv->t_destroy_func);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 1479 "HistoryManager.c"
		default:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 1485 "HistoryManager.c"
	}
}

static void
_vala_spice_services_history_manager_history_action_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec)
{
	SpiceServicesHistoryManagerHistoryAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	switch (property_id) {
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_HISTORY_TYPE_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		spice_services_history_manager_history_action_set_history_type (self, g_value_get_enum (value));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_ITEM_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		spice_services_history_manager_history_action_set_item (self, g_value_get_pointer (value));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PARENT_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		spice_services_history_manager_history_action_set_parent (self, g_value_get_object (value));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_PROPERTY_PROPERTY:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		spice_services_history_manager_history_action_set_property (self, g_value_get_string (value));
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_TYPE:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->i_type = g_value_get_gtype (value);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DUP_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->i_dup_func = g_value_get_pointer (value);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_I_DESTROY_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->i_destroy_func = g_value_get_pointer (value);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_TYPE:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->t_type = g_value_get_gtype (value);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DUP_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->t_dup_func = g_value_get_pointer (value);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		case SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_T_DESTROY_FUNC:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		self->priv->t_destroy_func = g_value_get_pointer (value);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 1559 "HistoryManager.c"
		default:
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
		break;
#line 1565 "HistoryManager.c"
	}
}

static void
spice_services_history_manager_class_init (SpiceServicesHistoryManagerClass * klass,
                                           gpointer klass_data)
{
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_parent_class = g_type_class_peek_parent (klass);
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	g_type_class_adjust_private_offset (klass, &SpiceServicesHistoryManager_private_offset);
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_services_history_manager_finalize;
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_ACTION_CALLED_SIGNAL] = g_signal_new ("action-called", SPICE_SERVICES_TYPE_HISTORY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SPICE_TYPE_CANVAS_ITEM);
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_UNDO_CHANGED_SIGNAL] = g_signal_new ("undo-changed", SPICE_SERVICES_TYPE_HISTORY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	spice_services_history_manager_signals[SPICE_SERVICES_HISTORY_MANAGER_REDO_CHANGED_SIGNAL] = g_signal_new ("redo-changed", SPICE_SERVICES_TYPE_HISTORY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 1585 "HistoryManager.c"
}

static void
spice_services_history_manager_instance_init (SpiceServicesHistoryManager * self,
                                              gpointer klass)
{
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self->priv = spice_services_history_manager_get_instance_private (self);
#line 1594 "HistoryManager.c"
}

static void
spice_services_history_manager_finalize (GObject * obj)
{
	SpiceServicesHistoryManager * self;
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager);
#line 102 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	(self->priv->undo_history == NULL) ? NULL : (self->priv->undo_history = (_g_queue_free__g_object_unref0_ (self->priv->undo_history), NULL));
#line 103 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	(self->priv->redo_history == NULL) ? NULL : (self->priv->redo_history = (_g_queue_free__g_object_unref0_ (self->priv->redo_history), NULL));
#line 30 "../Spice-up-1.9.1/src/Services/HistoryManager.vala"
	G_OBJECT_CLASS (spice_services_history_manager_parent_class)->finalize (obj);
#line 1609 "HistoryManager.c"
}

static GType
spice_services_history_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceServicesHistoryManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_services_history_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceServicesHistoryManager), 0, (GInstanceInitFunc) spice_services_history_manager_instance_init, NULL };
	GType spice_services_history_manager_type_id;
	spice_services_history_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceServicesHistoryManager", &g_define_type_info, 0);
	SpiceServicesHistoryManager_private_offset = g_type_add_instance_private (spice_services_history_manager_type_id, sizeof (SpiceServicesHistoryManagerPrivate));
	return spice_services_history_manager_type_id;
}

GType
spice_services_history_manager_get_type (void)
{
	static volatile gsize spice_services_history_manager_type_id__once = 0;
	if (g_once_init_enter (&spice_services_history_manager_type_id__once)) {
		GType spice_services_history_manager_type_id;
		spice_services_history_manager_type_id = spice_services_history_manager_get_type_once ();
		g_once_init_leave (&spice_services_history_manager_type_id__once, spice_services_history_manager_type_id);
	}
	return spice_services_history_manager_type_id__once;
}

