/* Device.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Device.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "bluetooth.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef GDBusProxy BluetoothServicesDeviceProxy;
typedef GDBusProxyClass BluetoothServicesDeviceProxyClass;
typedef struct _BluetoothServicesDeviceConnectReadyData BluetoothServicesDeviceConnectReadyData;
typedef struct _BluetoothServicesDeviceDisconnectReadyData BluetoothServicesDeviceDisconnectReadyData;
typedef struct _BluetoothServicesDevicePairReadyData BluetoothServicesDevicePairReadyData;

struct _BluetoothServicesDeviceConnectReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BluetoothServicesDeviceDisconnectReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BluetoothServicesDevicePairReadyData {
	GDBusMethodInvocation* _invocation_;
};

static GType bluetooth_services_device_get_type_once (void);
static void bluetooth_services_device_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters);
static void bluetooth_services_device_proxy_cancel_pairing (BluetoothServicesDevice* self,
                                                     GError** error);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void bluetooth_services_device_proxy_connect_async (BluetoothServicesDevice* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static void bluetooth_services_device_proxy_connect_finish (BluetoothServicesDevice* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static void bluetooth_services_device_proxy_connect_profile (BluetoothServicesDevice* self,
                                                      const gchar* UUID,
                                                      GError** error);
static void bluetooth_services_device_proxy_disconnect_async (BluetoothServicesDevice* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void bluetooth_services_device_proxy_disconnect_finish (BluetoothServicesDevice* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void bluetooth_services_device_proxy_disconnect_profile (BluetoothServicesDevice* self,
                                                         const gchar* UUID,
                                                         GError** error);
static void bluetooth_services_device_proxy_pair_async (BluetoothServicesDevice* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void bluetooth_services_device_proxy_pair_finish (BluetoothServicesDevice* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static gchar** bluetooth_services_device_dbus_proxy_get_UUIDs (BluetoothServicesDevice* self,
                                                        gint* result_length1);
static gboolean bluetooth_services_device_dbus_proxy_get_blocked (BluetoothServicesDevice* self);
static void bluetooth_services_device_dbus_proxy_set_blocked (BluetoothServicesDevice* self,
                                                       gboolean value);
static gboolean bluetooth_services_device_dbus_proxy_get_connected (BluetoothServicesDevice* self);
static gboolean bluetooth_services_device_dbus_proxy_get_legacy_pairing (BluetoothServicesDevice* self);
static gboolean bluetooth_services_device_dbus_proxy_get_paired (BluetoothServicesDevice* self);
static gboolean bluetooth_services_device_dbus_proxy_get_trusted (BluetoothServicesDevice* self);
static void bluetooth_services_device_dbus_proxy_set_trusted (BluetoothServicesDevice* self,
                                                       gboolean value);
static gint16 bluetooth_services_device_dbus_proxy_get_RSSI (BluetoothServicesDevice* self);
static char* bluetooth_services_device_dbus_proxy_get_adapter (BluetoothServicesDevice* self);
static gchar* bluetooth_services_device_dbus_proxy_get_address (BluetoothServicesDevice* self);
static gchar* bluetooth_services_device_dbus_proxy_get_alias (BluetoothServicesDevice* self);
static void bluetooth_services_device_dbus_proxy_set_alias (BluetoothServicesDevice* self,
                                                     const gchar* value);
static gchar* bluetooth_services_device_dbus_proxy_get_icon (BluetoothServicesDevice* self);
static gchar* bluetooth_services_device_dbus_proxy_get_modalias (BluetoothServicesDevice* self);
static gchar* bluetooth_services_device_dbus_proxy_get_name (BluetoothServicesDevice* self);
static guint16 bluetooth_services_device_dbus_proxy_get_appearance (BluetoothServicesDevice* self);
static guint32 bluetooth_services_device_dbus_proxy_get_class (BluetoothServicesDevice* self);
static void bluetooth_services_device_proxy_bluetooth_services_device_interface_init (BluetoothServicesDeviceIface* iface);
static void _dbus_bluetooth_services_device_cancel_pairing (BluetoothServicesDevice* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_device_connect (BluetoothServicesDevice* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_device_connect_ready (GObject * source_object,
                                                    GAsyncResult * _res_,
                                                    gpointer _user_data_);
static void _dbus_bluetooth_services_device_connect_profile (BluetoothServicesDevice* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_device_disconnect (BluetoothServicesDevice* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_device_disconnect_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_bluetooth_services_device_disconnect_profile (BluetoothServicesDevice* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_device_pair (BluetoothServicesDevice* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_device_pair_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_);
static void bluetooth_services_device_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* bluetooth_services_device_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static GVariant* _dbus_bluetooth_services_device_get_UUIDs (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_blocked (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_connected (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_legacy_pairing (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_paired (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_trusted (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_RSSI (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_adapter (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_address (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_alias (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_icon (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_modalias (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_name (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_appearance (BluetoothServicesDevice* self);
static GVariant* _dbus_bluetooth_services_device_get_class (BluetoothServicesDevice* self);
static gboolean bluetooth_services_device_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _dbus_bluetooth_services_device_set_blocked (BluetoothServicesDevice* self,
                                                  GVariant* _value);
static void _dbus_bluetooth_services_device_set_trusted (BluetoothServicesDevice* self,
                                                  GVariant* _value);
static void _dbus_bluetooth_services_device_set_alias (BluetoothServicesDevice* self,
                                                GVariant* _value);
static void _bluetooth_services_device_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_cancel_pairing_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_cancel_pairing_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_device_dbus_method_info_cancel_pairing = {-1, "CancelPairing", (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_cancel_pairing_in), (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_cancel_pairing_out), NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_connect_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_connect_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_device_dbus_method_info_connect = {-1, "Connect", (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_connect_in), (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_connect_out), NULL};
static const GDBusArgInfo _bluetooth_services_device_dbus_arg_info_connect_profile_UUID = {-1, "UUID", "s", NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_connect_profile_in[] = {&_bluetooth_services_device_dbus_arg_info_connect_profile_UUID, NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_connect_profile_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_device_dbus_method_info_connect_profile = {-1, "ConnectProfile", (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_connect_profile_in), (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_connect_profile_out), NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_disconnect_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_disconnect_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_device_dbus_method_info_disconnect = {-1, "Disconnect", (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_disconnect_in), (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_disconnect_out), NULL};
static const GDBusArgInfo _bluetooth_services_device_dbus_arg_info_disconnect_profile_UUID = {-1, "UUID", "s", NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_disconnect_profile_in[] = {&_bluetooth_services_device_dbus_arg_info_disconnect_profile_UUID, NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_disconnect_profile_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_device_dbus_method_info_disconnect_profile = {-1, "DisconnectProfile", (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_disconnect_profile_in), (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_disconnect_profile_out), NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_pair_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_services_device_dbus_arg_info_pair_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_device_dbus_method_info_pair = {-1, "Pair", (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_pair_in), (GDBusArgInfo **) (&_bluetooth_services_device_dbus_arg_info_pair_out), NULL};
static const GDBusMethodInfo * const _bluetooth_services_device_dbus_method_info[] = {&_bluetooth_services_device_dbus_method_info_cancel_pairing, &_bluetooth_services_device_dbus_method_info_connect, &_bluetooth_services_device_dbus_method_info_connect_profile, &_bluetooth_services_device_dbus_method_info_disconnect, &_bluetooth_services_device_dbus_method_info_disconnect_profile, &_bluetooth_services_device_dbus_method_info_pair, NULL};
static const GDBusSignalInfo * const _bluetooth_services_device_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_UUIDs = {-1, "UUIDs", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_blocked = {-1, "Blocked", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_connected = {-1, "Connected", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_legacy_pairing = {-1, "LegacyPairing", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_paired = {-1, "Paired", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_trusted = {-1, "Trusted", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_RSSI = {-1, "RSSI", "n", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_adapter = {-1, "Adapter", "o", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_address = {-1, "Address", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_alias = {-1, "Alias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_icon = {-1, "Icon", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_modalias = {-1, "Modalias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_appearance = {-1, "Appearance", "q", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_services_device_dbus_property_info_class = {-1, "Class", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _bluetooth_services_device_dbus_property_info[] = {&_bluetooth_services_device_dbus_property_info_UUIDs, &_bluetooth_services_device_dbus_property_info_blocked, &_bluetooth_services_device_dbus_property_info_connected, &_bluetooth_services_device_dbus_property_info_legacy_pairing, &_bluetooth_services_device_dbus_property_info_paired, &_bluetooth_services_device_dbus_property_info_trusted, &_bluetooth_services_device_dbus_property_info_RSSI, &_bluetooth_services_device_dbus_property_info_adapter, &_bluetooth_services_device_dbus_property_info_address, &_bluetooth_services_device_dbus_property_info_alias, &_bluetooth_services_device_dbus_property_info_icon, &_bluetooth_services_device_dbus_property_info_modalias, &_bluetooth_services_device_dbus_property_info_name, &_bluetooth_services_device_dbus_property_info_appearance, &_bluetooth_services_device_dbus_property_info_class, NULL};
static const GDBusInterfaceInfo _bluetooth_services_device_dbus_interface_info = {-1, "org.bluez.Device1", (GDBusMethodInfo **) (&_bluetooth_services_device_dbus_method_info), (GDBusSignalInfo **) (&_bluetooth_services_device_dbus_signal_info), (GDBusPropertyInfo **) (&_bluetooth_services_device_dbus_property_info), NULL};
static const GDBusInterfaceVTable _bluetooth_services_device_dbus_interface_vtable = {bluetooth_services_device_dbus_interface_method_call, bluetooth_services_device_dbus_interface_get_property, bluetooth_services_device_dbus_interface_set_property};

void
bluetooth_services_device_cancel_pairing (BluetoothServicesDevice* self,
                                          GError** error)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->cancel_pairing) {
		_iface_->cancel_pairing (self, error);
	}
}

void
bluetooth_services_device_connect (BluetoothServicesDevice* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	BluetoothServicesDeviceIface* _iface_;
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->connect) {
		_iface_->connect (self, _callback_, _user_data_);
	}
}

void
bluetooth_services_device_connect_finish (BluetoothServicesDevice* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	BluetoothServicesDeviceIface* _iface_;
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->connect_finish) {
		_iface_->connect_finish (self, _res_, error);
	}
}

void
bluetooth_services_device_connect_profile (BluetoothServicesDevice* self,
                                           const gchar* UUID,
                                           GError** error)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->connect_profile) {
		_iface_->connect_profile (self, UUID, error);
	}
}

void
bluetooth_services_device_disconnect (BluetoothServicesDevice* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	BluetoothServicesDeviceIface* _iface_;
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->disconnect) {
		_iface_->disconnect (self, _callback_, _user_data_);
	}
}

void
bluetooth_services_device_disconnect_finish (BluetoothServicesDevice* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	BluetoothServicesDeviceIface* _iface_;
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->disconnect_finish) {
		_iface_->disconnect_finish (self, _res_, error);
	}
}

void
bluetooth_services_device_disconnect_profile (BluetoothServicesDevice* self,
                                              const gchar* UUID,
                                              GError** error)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->disconnect_profile) {
		_iface_->disconnect_profile (self, UUID, error);
	}
}

void
bluetooth_services_device_pair (BluetoothServicesDevice* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	BluetoothServicesDeviceIface* _iface_;
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->pair) {
		_iface_->pair (self, _callback_, _user_data_);
	}
}

void
bluetooth_services_device_pair_finish (BluetoothServicesDevice* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	BluetoothServicesDeviceIface* _iface_;
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->pair_finish) {
		_iface_->pair_finish (self, _res_, error);
	}
}

gint
bluetooth_services_device_compare (BluetoothServicesDevice* device1,
                                   BluetoothServicesDevice* device2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp10_ = FALSE;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp18_ = FALSE;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* name1 = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* name2 = NULL;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gint result;
	g_return_val_if_fail (device1 != NULL, 0);
	g_return_val_if_fail (device2 != NULL, 0);
	_tmp1_ = bluetooth_services_device_get_connected (device1);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = bluetooth_services_device_get_connected (device2);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = -1;
		return result;
	}
	_tmp6_ = bluetooth_services_device_get_connected (device1);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = bluetooth_services_device_get_connected (device2);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = 1;
		return result;
	}
	_tmp11_ = bluetooth_services_device_get_name (device1);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_ != NULL;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = bluetooth_services_device_get_name (device2);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp10_ = _tmp17_ == NULL;
		_g_free0 (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = -1;
		return result;
	}
	_tmp19_ = bluetooth_services_device_get_name (device1);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_ == NULL;
	_g_free0 (_tmp21_);
	if (_tmp22_) {
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp23_ = bluetooth_services_device_get_name (device2);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp18_ = _tmp25_ != NULL;
		_g_free0 (_tmp25_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		result = 1;
		return result;
	}
	_tmp27_ = bluetooth_services_device_get_name (device1);
	_tmp28_ = _tmp27_;
	_tmp26_ = _tmp28_;
	if (_tmp26_ == NULL) {
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp29_ = bluetooth_services_device_get_address (device1);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp26_);
		_tmp26_ = _tmp30_;
	}
	_tmp31_ = _tmp26_;
	_tmp26_ = NULL;
	name1 = _tmp31_;
	_tmp33_ = bluetooth_services_device_get_name (device2);
	_tmp34_ = _tmp33_;
	_tmp32_ = _tmp34_;
	if (_tmp32_ == NULL) {
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = bluetooth_services_device_get_address (device2);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp32_);
		_tmp32_ = _tmp36_;
	}
	_tmp37_ = _tmp32_;
	_tmp32_ = NULL;
	name2 = _tmp37_;
	_tmp38_ = name1;
	_tmp39_ = name2;
	result = g_utf8_collate (_tmp38_, _tmp39_);
	_g_free0 (name2);
	_g_free0 (_tmp32_);
	_g_free0 (name1);
	_g_free0 (_tmp26_);
	return result;
}

gchar**
bluetooth_services_device_get_UUIDs (BluetoothServicesDevice* self,
                                     gint* result_length1)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_UUIDs) {
		return _iface_->get_UUIDs (self, result_length1);
	}
	return NULL;
}

gboolean
bluetooth_services_device_get_blocked (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_blocked) {
		return _iface_->get_blocked (self);
	}
	return FALSE;
}

void
bluetooth_services_device_set_blocked (BluetoothServicesDevice* self,
                                       gboolean value)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->set_blocked) {
		_iface_->set_blocked (self, value);
	}
}

gboolean
bluetooth_services_device_get_connected (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_connected) {
		return _iface_->get_connected (self);
	}
	return FALSE;
}

gboolean
bluetooth_services_device_get_legacy_pairing (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_legacy_pairing) {
		return _iface_->get_legacy_pairing (self);
	}
	return FALSE;
}

gboolean
bluetooth_services_device_get_paired (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_paired) {
		return _iface_->get_paired (self);
	}
	return FALSE;
}

gboolean
bluetooth_services_device_get_trusted (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_trusted) {
		return _iface_->get_trusted (self);
	}
	return FALSE;
}

void
bluetooth_services_device_set_trusted (BluetoothServicesDevice* self,
                                       gboolean value)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->set_trusted) {
		_iface_->set_trusted (self, value);
	}
}

gint16
bluetooth_services_device_get_RSSI (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_RSSI) {
		return _iface_->get_RSSI (self);
	}
	return -1;
}

char*
bluetooth_services_device_get_adapter (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_adapter) {
		return _iface_->get_adapter (self);
	}
	return NULL;
}

gchar*
bluetooth_services_device_get_address (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_address) {
		return _iface_->get_address (self);
	}
	return NULL;
}

gchar*
bluetooth_services_device_get_alias (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_alias) {
		return _iface_->get_alias (self);
	}
	return NULL;
}

void
bluetooth_services_device_set_alias (BluetoothServicesDevice* self,
                                     const gchar* value)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->set_alias) {
		_iface_->set_alias (self, value);
	}
}

gchar*
bluetooth_services_device_get_icon (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_icon) {
		return _iface_->get_icon (self);
	}
	return NULL;
}

gchar*
bluetooth_services_device_get_modalias (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_modalias) {
		return _iface_->get_modalias (self);
	}
	return NULL;
}

gchar*
bluetooth_services_device_get_name (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

guint16
bluetooth_services_device_get_appearance (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_appearance) {
		return _iface_->get_appearance (self);
	}
	return 0U;
}

guint32
bluetooth_services_device_get_class (BluetoothServicesDevice* self)
{
	BluetoothServicesDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = BLUETOOTH_SERVICES_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_class) {
		return _iface_->get_class (self);
	}
	return 0U;
}

static void
bluetooth_services_device_default_init (BluetoothServicesDeviceIface * iface,
                                        gpointer iface_data)
{
}

static GType
bluetooth_services_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothServicesDeviceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_services_device_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType bluetooth_services_device_type_id;
	bluetooth_services_device_type_id = g_type_register_static (G_TYPE_INTERFACE, "BluetoothServicesDevice", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (bluetooth_services_device_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (bluetooth_services_device_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) bluetooth_services_device_proxy_get_type);
	g_type_set_qdata (bluetooth_services_device_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.Device1");
	g_type_set_qdata (bluetooth_services_device_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_bluetooth_services_device_dbus_interface_info));
	g_type_set_qdata (bluetooth_services_device_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) bluetooth_services_device_register_object);
	return bluetooth_services_device_type_id;
}

GType
bluetooth_services_device_get_type (void)
{
	static volatile gsize bluetooth_services_device_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_services_device_type_id__once)) {
		GType bluetooth_services_device_type_id;
		bluetooth_services_device_type_id = bluetooth_services_device_get_type_once ();
		g_once_init_leave (&bluetooth_services_device_type_id__once, bluetooth_services_device_type_id);
	}
	return bluetooth_services_device_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BluetoothServicesDeviceProxy, bluetooth_services_device_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BLUETOOTH_SERVICES_TYPE_DEVICE, bluetooth_services_device_proxy_bluetooth_services_device_interface_init) )
static void
bluetooth_services_device_proxy_class_init (BluetoothServicesDeviceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = bluetooth_services_device_proxy_g_signal;
}

static void
bluetooth_services_device_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters)
{
}

static void
bluetooth_services_device_proxy_init (BluetoothServicesDeviceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_bluetooth_services_device_dbus_interface_info));
}

static void
bluetooth_services_device_proxy_cancel_pairing (BluetoothServicesDevice* self,
                                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "CancelPairing");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
bluetooth_services_device_proxy_connect_async (BluetoothServicesDevice* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Connect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
bluetooth_services_device_proxy_connect_finish (BluetoothServicesDevice* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_services_device_proxy_connect_profile (BluetoothServicesDevice* self,
                                                 const gchar* UUID,
                                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "ConnectProfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (UUID));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_services_device_proxy_disconnect_async (BluetoothServicesDevice* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Disconnect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
bluetooth_services_device_proxy_disconnect_finish (BluetoothServicesDevice* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_services_device_proxy_disconnect_profile (BluetoothServicesDevice* self,
                                                    const gchar* UUID,
                                                    GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "DisconnectProfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (UUID));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_services_device_proxy_pair_async (BluetoothServicesDevice* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Pair");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
bluetooth_services_device_proxy_pair_finish (BluetoothServicesDevice* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar**
bluetooth_services_device_dbus_proxy_get_UUIDs (BluetoothServicesDevice* self,
                                                gint* result_length1)
{
	GVariant *_inner_reply;
	gchar** _result;
	gint _result_length1;
	gchar** _tmp16_;
	gint _tmp16__length;
	gint _tmp16__size;
	gint _tmp16__length1;
	GVariantIter _tmp17_;
	GVariant* _tmp18_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "UUIDs");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("UUIDs"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp16_ = g_new (gchar*, 5);
	_tmp16__length = 0;
	_tmp16__size = 4;
	_tmp16__length1 = 0;
	g_variant_iter_init (&_tmp17_, _inner_reply);
	for (; (_tmp18_ = g_variant_iter_next_value (&_tmp17_)) != NULL; _tmp16__length1++) {
		if (_tmp16__size == _tmp16__length) {
			_tmp16__size = 2 * _tmp16__size;
			_tmp16_ = g_renew (gchar*, _tmp16_, _tmp16__size + 1);
		}
		_tmp16_[_tmp16__length++] = g_variant_dup_string (_tmp18_, NULL);
		g_variant_unref (_tmp18_);
	}
	_result_length1 = _tmp16__length1;
	_tmp16_[_tmp16__length] = NULL;
	_result = _tmp16_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_services_device_dbus_proxy_get_blocked (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Blocked");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp19_ = FALSE;
			return _tmp19_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_services_device_dbus_proxy_set_blocked (BluetoothServicesDevice* self,
                                                  gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gboolean
bluetooth_services_device_dbus_proxy_get_connected (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Connected");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Connected"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp20_ = FALSE;
			return _tmp20_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_services_device_dbus_proxy_get_legacy_pairing (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LegacyPairing");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LegacyPairing"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp21_ = FALSE;
			return _tmp21_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_services_device_dbus_proxy_get_paired (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Paired");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Paired"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp22_ = FALSE;
			return _tmp22_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_services_device_dbus_proxy_get_trusted (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Trusted");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp23_ = FALSE;
			return _tmp23_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_services_device_dbus_proxy_set_trusted (BluetoothServicesDevice* self,
                                                  gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gint16
bluetooth_services_device_dbus_proxy_get_RSSI (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "RSSI");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("RSSI"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint16 _tmp24_ = 0;
			return _tmp24_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static char*
bluetooth_services_device_dbus_proxy_get_adapter (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	char* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Adapter");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Adapter"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_services_device_dbus_proxy_get_address (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Address");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Address"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_services_device_dbus_proxy_get_alias (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Alias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_services_device_dbus_proxy_set_alias (BluetoothServicesDevice* self,
                                                const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gchar*
bluetooth_services_device_dbus_proxy_get_icon (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Icon");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Icon"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_services_device_dbus_proxy_get_modalias (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Modalias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Modalias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_services_device_dbus_proxy_get_name (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint16
bluetooth_services_device_dbus_proxy_get_appearance (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	guint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Appearance");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Appearance"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint16 _tmp25_ = 0U;
			return _tmp25_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint32
bluetooth_services_device_dbus_proxy_get_class (BluetoothServicesDevice* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Class");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Class"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp26_ = 0U;
			return _tmp26_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_services_device_proxy_bluetooth_services_device_interface_init (BluetoothServicesDeviceIface* iface)
{
	iface->cancel_pairing = bluetooth_services_device_proxy_cancel_pairing;
	iface->connect = bluetooth_services_device_proxy_connect_async;
	iface->connect_finish = bluetooth_services_device_proxy_connect_finish;
	iface->connect_profile = bluetooth_services_device_proxy_connect_profile;
	iface->disconnect = bluetooth_services_device_proxy_disconnect_async;
	iface->disconnect_finish = bluetooth_services_device_proxy_disconnect_finish;
	iface->disconnect_profile = bluetooth_services_device_proxy_disconnect_profile;
	iface->pair = bluetooth_services_device_proxy_pair_async;
	iface->pair_finish = bluetooth_services_device_proxy_pair_finish;
	iface->get_UUIDs = bluetooth_services_device_dbus_proxy_get_UUIDs;
	iface->get_blocked = bluetooth_services_device_dbus_proxy_get_blocked;
	iface->set_blocked = bluetooth_services_device_dbus_proxy_set_blocked;
	iface->get_connected = bluetooth_services_device_dbus_proxy_get_connected;
	iface->get_legacy_pairing = bluetooth_services_device_dbus_proxy_get_legacy_pairing;
	iface->get_paired = bluetooth_services_device_dbus_proxy_get_paired;
	iface->get_trusted = bluetooth_services_device_dbus_proxy_get_trusted;
	iface->set_trusted = bluetooth_services_device_dbus_proxy_set_trusted;
	iface->get_RSSI = bluetooth_services_device_dbus_proxy_get_RSSI;
	iface->get_adapter = bluetooth_services_device_dbus_proxy_get_adapter;
	iface->get_address = bluetooth_services_device_dbus_proxy_get_address;
	iface->get_alias = bluetooth_services_device_dbus_proxy_get_alias;
	iface->set_alias = bluetooth_services_device_dbus_proxy_set_alias;
	iface->get_icon = bluetooth_services_device_dbus_proxy_get_icon;
	iface->get_modalias = bluetooth_services_device_dbus_proxy_get_modalias;
	iface->get_name = bluetooth_services_device_dbus_proxy_get_name;
	iface->get_appearance = bluetooth_services_device_dbus_proxy_get_appearance;
	iface->get_class = bluetooth_services_device_dbus_proxy_get_class;
}

static void
_dbus_bluetooth_services_device_cancel_pairing (BluetoothServicesDevice* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	bluetooth_services_device_cancel_pairing (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_bluetooth_services_device_connect (BluetoothServicesDevice* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesDeviceConnectReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesDeviceConnectReadyData);
	_ready_data->_invocation_ = invocation;
	bluetooth_services_device_connect (self, (GAsyncReadyCallback) _dbus_bluetooth_services_device_connect_ready, _ready_data);
}

static void
_dbus_bluetooth_services_device_connect_ready (GObject * source_object,
                                               GAsyncResult * _res_,
                                               gpointer _user_data_)
{
	BluetoothServicesDeviceConnectReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_services_device_connect_finish ((BluetoothServicesDevice*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BluetoothServicesDeviceConnectReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_device_connect_profile (BluetoothServicesDevice* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* UUID = NULL;
	GVariant* _tmp27_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	UUID = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	bluetooth_services_device_connect_profile (self, UUID, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (UUID);
	;
}

static void
_dbus_bluetooth_services_device_disconnect (BluetoothServicesDevice* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesDeviceDisconnectReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesDeviceDisconnectReadyData);
	_ready_data->_invocation_ = invocation;
	bluetooth_services_device_disconnect (self, (GAsyncReadyCallback) _dbus_bluetooth_services_device_disconnect_ready, _ready_data);
}

static void
_dbus_bluetooth_services_device_disconnect_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	BluetoothServicesDeviceDisconnectReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_services_device_disconnect_finish ((BluetoothServicesDevice*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BluetoothServicesDeviceDisconnectReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_device_disconnect_profile (BluetoothServicesDevice* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* UUID = NULL;
	GVariant* _tmp28_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	UUID = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	bluetooth_services_device_disconnect_profile (self, UUID, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (UUID);
	;
}

static void
_dbus_bluetooth_services_device_pair (BluetoothServicesDevice* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesDevicePairReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesDevicePairReadyData);
	_ready_data->_invocation_ = invocation;
	bluetooth_services_device_pair (self, (GAsyncReadyCallback) _dbus_bluetooth_services_device_pair_ready, _ready_data);
}

static void
_dbus_bluetooth_services_device_pair_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_)
{
	BluetoothServicesDevicePairReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_services_device_pair_finish ((BluetoothServicesDevice*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BluetoothServicesDevicePairReadyData, _ready_data);
}

static void
bluetooth_services_device_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "CancelPairing") == 0) {
		_dbus_bluetooth_services_device_cancel_pairing (object, parameters, invocation);
	} else if (strcmp (method_name, "Connect") == 0) {
		_dbus_bluetooth_services_device_connect (object, parameters, invocation);
	} else if (strcmp (method_name, "ConnectProfile") == 0) {
		_dbus_bluetooth_services_device_connect_profile (object, parameters, invocation);
	} else if (strcmp (method_name, "Disconnect") == 0) {
		_dbus_bluetooth_services_device_disconnect (object, parameters, invocation);
	} else if (strcmp (method_name, "DisconnectProfile") == 0) {
		_dbus_bluetooth_services_device_disconnect_profile (object, parameters, invocation);
	} else if (strcmp (method_name, "Pair") == 0) {
		_dbus_bluetooth_services_device_pair (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_bluetooth_services_device_get_UUIDs (BluetoothServicesDevice* self)
{
	gchar** result;
	gint result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp29_;
	GVariantBuilder _tmp30_;
	gint _tmp31_;
	result = bluetooth_services_device_get_UUIDs (self, &result_length1);
	_tmp29_ = result;
	g_variant_builder_init (&_tmp30_, G_VARIANT_TYPE ("as"));
	for (_tmp31_ = 0; _tmp31_ < result_length1; _tmp31_++) {
		g_variant_builder_add_value (&_tmp30_, g_variant_new_string (*_tmp29_));
		_tmp29_++;
	}
	_reply = g_variant_builder_end (&_tmp30_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_blocked (BluetoothServicesDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_services_device_get_blocked (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_connected (BluetoothServicesDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_services_device_get_connected (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_legacy_pairing (BluetoothServicesDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_services_device_get_legacy_pairing (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_paired (BluetoothServicesDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_services_device_get_paired (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_trusted (BluetoothServicesDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_services_device_get_trusted (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_RSSI (BluetoothServicesDevice* self)
{
	gint16 result;
	GVariant* _reply;
	result = bluetooth_services_device_get_RSSI (self);
	_reply = g_variant_new_int16 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_adapter (BluetoothServicesDevice* self)
{
	char* result;
	GVariant* _reply;
	result = bluetooth_services_device_get_adapter (self);
	_reply = g_variant_new_object_path (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_address (BluetoothServicesDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_services_device_get_address (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_alias (BluetoothServicesDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_services_device_get_alias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_icon (BluetoothServicesDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_services_device_get_icon (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_modalias (BluetoothServicesDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_services_device_get_modalias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_name (BluetoothServicesDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_services_device_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_appearance (BluetoothServicesDevice* self)
{
	guint16 result;
	GVariant* _reply;
	result = bluetooth_services_device_get_appearance (self);
	_reply = g_variant_new_uint16 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_services_device_get_class (BluetoothServicesDevice* self)
{
	guint32 result;
	GVariant* _reply;
	result = bluetooth_services_device_get_class (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
bluetooth_services_device_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "UUIDs") == 0) {
		return _dbus_bluetooth_services_device_get_UUIDs (object);
	} else if (strcmp (property_name, "Blocked") == 0) {
		return _dbus_bluetooth_services_device_get_blocked (object);
	} else if (strcmp (property_name, "Connected") == 0) {
		return _dbus_bluetooth_services_device_get_connected (object);
	} else if (strcmp (property_name, "LegacyPairing") == 0) {
		return _dbus_bluetooth_services_device_get_legacy_pairing (object);
	} else if (strcmp (property_name, "Paired") == 0) {
		return _dbus_bluetooth_services_device_get_paired (object);
	} else if (strcmp (property_name, "Trusted") == 0) {
		return _dbus_bluetooth_services_device_get_trusted (object);
	} else if (strcmp (property_name, "RSSI") == 0) {
		return _dbus_bluetooth_services_device_get_RSSI (object);
	} else if (strcmp (property_name, "Adapter") == 0) {
		return _dbus_bluetooth_services_device_get_adapter (object);
	} else if (strcmp (property_name, "Address") == 0) {
		return _dbus_bluetooth_services_device_get_address (object);
	} else if (strcmp (property_name, "Alias") == 0) {
		return _dbus_bluetooth_services_device_get_alias (object);
	} else if (strcmp (property_name, "Icon") == 0) {
		return _dbus_bluetooth_services_device_get_icon (object);
	} else if (strcmp (property_name, "Modalias") == 0) {
		return _dbus_bluetooth_services_device_get_modalias (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_bluetooth_services_device_get_name (object);
	} else if (strcmp (property_name, "Appearance") == 0) {
		return _dbus_bluetooth_services_device_get_appearance (object);
	} else if (strcmp (property_name, "Class") == 0) {
		return _dbus_bluetooth_services_device_get_class (object);
	}
	return NULL;
}

static void
_dbus_bluetooth_services_device_set_blocked (BluetoothServicesDevice* self,
                                             GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	bluetooth_services_device_set_blocked (self, value);
}

static void
_dbus_bluetooth_services_device_set_trusted (BluetoothServicesDevice* self,
                                             GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	bluetooth_services_device_set_trusted (self, value);
}

static void
_dbus_bluetooth_services_device_set_alias (BluetoothServicesDevice* self,
                                           GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	bluetooth_services_device_set_alias (self, value);
	_g_free0 (value);
}

static gboolean
bluetooth_services_device_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Blocked") == 0) {
		_dbus_bluetooth_services_device_set_blocked (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Trusted") == 0) {
		_dbus_bluetooth_services_device_set_trusted (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Alias") == 0) {
		_dbus_bluetooth_services_device_set_alias (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
bluetooth_services_device_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_bluetooth_services_device_dbus_interface_info), &_bluetooth_services_device_dbus_interface_vtable, data, _bluetooth_services_device_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_bluetooth_services_device_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

