/* MainView.c generated by valac 0.56.17, the Vala compiler
 * generated from MainView.vala, do not modify */

/*
 * Copyright 2014–2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "datetime.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define DATE_TIME_TYPE_DATE_TIME1 (date_time_date_time1_get_type ())
#define DATE_TIME_DATE_TIME1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DATE_TIME_TYPE_DATE_TIME1, DateTimeDateTime1))
#define DATE_TIME_IS_DATE_TIME1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DATE_TIME_TYPE_DATE_TIME1))
#define DATE_TIME_DATE_TIME1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DATE_TIME_TYPE_DATE_TIME1, DateTimeDateTime1Iface))

typedef struct _DateTimeDateTime1 DateTimeDateTime1;
typedef struct _DateTimeDateTime1Iface DateTimeDateTime1Iface;

#define DATE_TIME_TYPE_DATE_TIME1_PROXY (date_time_date_time1_proxy_get_type ())

#define DATE_TIME_PANTHEON_TYPE_ACCOUNTS_SERVICE (date_time_pantheon_accounts_service_get_type ())
#define DATE_TIME_PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DATE_TIME_PANTHEON_TYPE_ACCOUNTS_SERVICE, DateTimePantheonAccountsService))
#define DATE_TIME_PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DATE_TIME_PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define DATE_TIME_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DATE_TIME_PANTHEON_TYPE_ACCOUNTS_SERVICE, DateTimePantheonAccountsServiceIface))

typedef struct _DateTimePantheonAccountsService DateTimePantheonAccountsService;
typedef struct _DateTimePantheonAccountsServiceIface DateTimePantheonAccountsServiceIface;

#define DATE_TIME_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (date_time_pantheon_accounts_service_proxy_get_type ())
enum  {
	DATE_TIME_MAIN_VIEW_0_PROPERTY,
	DATE_TIME_MAIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* date_time_main_view_properties[DATE_TIME_MAIN_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DATE_TIME_FDO_TYPE_ACCOUNTS (date_time_fdo_accounts_get_type ())
#define DATE_TIME_FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DATE_TIME_FDO_TYPE_ACCOUNTS, DateTimeFDOAccounts))
#define DATE_TIME_FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DATE_TIME_FDO_TYPE_ACCOUNTS))
#define DATE_TIME_FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DATE_TIME_FDO_TYPE_ACCOUNTS, DateTimeFDOAccountsIface))

typedef struct _DateTimeFDOAccounts DateTimeFDOAccounts;
typedef struct _DateTimeFDOAccountsIface DateTimeFDOAccountsIface;

#define DATE_TIME_FDO_TYPE_ACCOUNTS_PROXY (date_time_fdo_accounts_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DateTimeMainViewSetupTimeFormatData DateTimeMainViewSetupTimeFormatData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

struct _DateTimeDateTime1Iface {
	GTypeInterface parent_iface;
	void (*set_time) (DateTimeDateTime1* self, gint64 usec_utc, gboolean relative, gboolean user_interaction, GError** error);
	void (*set_timezone) (DateTimeDateTime1* self, const gchar* timezone, gboolean user_interaction, GError** error);
	void (*SetLocalRTC) (DateTimeDateTime1* self, gboolean local_rtc, gboolean fix_system, gboolean user_interaction, GError** error);
	void (*SetNTP) (DateTimeDateTime1* self, gboolean use_ntp, gboolean user_interaction, GError** error);
	gchar* (*get_Timezone) (DateTimeDateTime1* self);
	gboolean (*get_LocalRTC) (DateTimeDateTime1* self);
	gboolean (*get_CanNTP) (DateTimeDateTime1* self);
	gboolean (*get_NTP) (DateTimeDateTime1* self);
};

struct _DateTimePantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gchar* (*get_time_format) (DateTimePantheonAccountsService* self);
	void (*set_time_format) (DateTimePantheonAccountsService* self, const gchar* value);
};

struct _DateTimeMainViewPrivate {
	DateTimeTimeZoneGrid* time_zone_picker;
	DateTimeDateTime1* datetime1;
	DateTimeCurrentTimeManager* ct_manager;
	GSettings* clock_settings;
	GtkCheckButton* meridiem_time_format;
	GtkCheckButton* military_time_format;
	DateTimePantheonAccountsService* pantheon_act;
};

struct _DateTimeFDOAccountsIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (DateTimeFDOAccounts* self, const gchar* username, GError** error);
};

struct _DateTimeMainViewSetupTimeFormatData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DateTimeMainView* self;
	DateTimeFDOAccounts* accounts_service;
	DateTimeFDOAccounts* _tmp0_;
	gchar* user_path;
	DateTimeFDOAccounts* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	DateTimePantheonAccountsService* _tmp4_;
	const gchar* _tmp5_;
	DateTimePantheonAccountsService* _tmp6_;
	DateTimePantheonAccountsService* _tmp7_;
	DateTimePantheonAccountsService* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GtkCheckButton* _tmp13_;
	GtkCheckButton* _tmp14_;
	GError* e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	GtkCheckButton* _tmp22_;
	GtkCheckButton* _tmp23_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	DateTimeMainView* self;
	GtkCheckButton* network_time_radio;
	GtkCheckButton* manual_time_radio;
	GraniteTimePicker* time_picker;
	GraniteDatePicker* date_picker;
	GSettings* wingpanel_settings;
	gboolean syncing_datetime;
};

static gint DateTimeMainView_private_offset;
static gpointer date_time_main_view_parent_class = NULL;
static GSettings* date_time_main_view_time_zone_settings;
static GSettings* date_time_main_view_time_zone_settings = NULL;

VALA_EXTERN GType date_time_date_time1_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint date_time_date_time1_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GType date_time_date_time1_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType date_time_pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType date_time_pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint date_time_pantheon_accounts_service_register_object (void* object,
                                                           GDBusConnection* connection,
                                                           const gchar* path,
                                                           GError** error);
static void date_time_main_view_setup_time_format_data_free (gpointer _data);
static void date_time_main_view_setup_time_format (DateTimeMainView* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void date_time_main_view_setup_time_format_finish (DateTimeMainView* self,
                                                   GAsyncResult* _res_);
static gboolean date_time_main_view_setup_time_format_co (DateTimeMainViewSetupTimeFormatData* _data_);
VALA_EXTERN GType date_time_fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint date_time_fdo_accounts_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN GType date_time_fdo_accounts_get_type (void) G_GNUC_CONST ;
static void date_time_main_view_setup_time_format_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN gchar* date_time_fdo_accounts_find_user_by_name (DateTimeFDOAccounts* self,
                                                 const gchar* username,
                                                 GError** error);
VALA_EXTERN gchar* date_time_pantheon_accounts_service_get_time_format (DateTimePantheonAccountsService* self);
static void ___lambda7_ (DateTimeMainView* self);
static void ____lambda7__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void date_time_main_view_change_tz (DateTimeMainView* self,
                                    const gchar* _tz);
VALA_EXTERN gchar* date_time_date_time1_get_Timezone (DateTimeDateTime1* self);
VALA_EXTERN void date_time_date_time1_set_timezone (DateTimeDateTime1* self,
                                        const gchar* timezone,
                                        gboolean user_interaction,
                                        GError** error);
static GObject * date_time_main_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _date_time_main_view_change_tz_date_time_time_zone_grid_request_timezone_change (DateTimeTimeZoneGrid* _sender,
                                                                                      const gchar* tz,
                                                                                      gpointer self);
static void _date_time_main_view___lambda8_ (Block1Data* _data1_);
VALA_EXTERN void date_time_date_time1_set_time (DateTimeDateTime1* self,
                                    gint64 usec_utc,
                                    gboolean relative,
                                    gboolean user_interaction,
                                    GError** error);
static void __date_time_main_view___lambda8__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                        gpointer self);
static void _date_time_main_view___lambda9_ (Block1Data* _data1_);
static void __date_time_main_view___lambda9__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _date_time_main_view___lambda10_ (Block1Data* _data1_,
                                       GDateTime* dt);
static void __date_time_main_view___lambda10__date_time_current_time_manager_time_has_changed (DateTimeCurrentTimeManager* _sender,
                                                                                        GDateTime* dt,
                                                                                        gpointer self);
static void _date_time_main_view___lambda11_ (Block1Data* _data1_);
VALA_EXTERN void date_time_pantheon_accounts_service_set_time_format (DateTimePantheonAccountsService* self,
                                                          const gchar* value);
static void __date_time_main_view___lambda11__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                 gpointer self);
VALA_EXTERN gboolean date_time_date_time1_get_CanNTP (DateTimeDateTime1* self);
VALA_EXTERN gboolean date_time_date_time1_get_NTP (DateTimeDateTime1* self);
static void _date_time_main_view___lambda12_ (Block1Data* _data1_);
VALA_EXTERN void date_time_date_time1_SetNTP (DateTimeDateTime1* self,
                                  gboolean use_ntp,
                                  gboolean user_interaction,
                                  GError** error);
static void __date_time_main_view___lambda12__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                 gpointer self);
static gboolean _date_time_main_view___lambda13_ (GValue* value,
                                           GVariant* variant,
                                           void* user_data);
static gboolean __date_time_main_view___lambda13__gsettings_bind_get_mapping (GValue* value,
                                                                       GVariant* variant,
                                                                       void* user_data);
static GVariant* _date_time_main_view___lambda14_ (void);
static GVariant* _variant_new1 (gboolean value);
static GVariant* __date_time_main_view___lambda14__gsettings_bind_set_mapping (GValue* value,
                                                                        const GVariantType* expected_type,
                                                                        void* user_data);
static void date_time_main_view_finalize (GObject * obj);
static GType date_time_main_view_get_type_once (void);

static inline gpointer
date_time_main_view_get_instance_private (DateTimeMainView* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimeMainView_private_offset);
}

DateTimeMainView*
date_time_main_view_construct (GType object_type)
{
	DateTimeMainView * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-system-time");
	_tmp1_ = _tmp0_;
	self = (DateTimeMainView*) g_object_new (object_type, "icon", _tmp1_, "title", _ ("Date & Time"), NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

DateTimeMainView*
date_time_main_view_new (void)
{
	return date_time_main_view_construct (DATE_TIME_TYPE_MAIN_VIEW);
}

static void
date_time_main_view_setup_time_format_data_free (gpointer _data)
{
	DateTimeMainViewSetupTimeFormatData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DateTimeMainViewSetupTimeFormatData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
date_time_main_view_setup_time_format (DateTimeMainView* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	DateTimeMainViewSetupTimeFormatData* _data_;
	DateTimeMainView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DateTimeMainViewSetupTimeFormatData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, date_time_main_view_setup_time_format_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	date_time_main_view_setup_time_format_co (_data_);
}

static void
date_time_main_view_setup_time_format_finish (DateTimeMainView* self,
                                              GAsyncResult* _res_)
{
	DateTimeMainViewSetupTimeFormatData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
date_time_main_view_setup_time_format_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	DateTimeMainViewSetupTimeFormatData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	date_time_main_view_setup_time_format_co (_data_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
___lambda7_ (DateTimeMainView* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->clock_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "clock-format");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_contains (_tmp2_, "12h");
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GtkCheckButton* _tmp4_;
		_tmp4_ = self->priv->meridiem_time_format;
		gtk_check_button_set_active (_tmp4_, TRUE);
	} else {
		GtkCheckButton* _tmp5_;
		_tmp5_ = self->priv->meridiem_time_format;
		gtk_check_button_set_active (_tmp5_, FALSE);
	}
}

static void
____lambda7__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	___lambda7_ ((DateTimeMainView*) self);
}

static gboolean
date_time_main_view_setup_time_format_co (DateTimeMainViewSetupTimeFormatData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (DATE_TIME_FDO_TYPE_ACCOUNTS_PROXY, 0, NULL, date_time_main_view_setup_time_format_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = (DateTimeFDOAccounts*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->accounts_service = (DateTimeFDOAccounts*) _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->accounts_service;
		_data_->_tmp2_ = g_get_user_name ();
		_data_->_tmp3_ = date_time_fdo_accounts_find_user_by_name (_data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error0_);
		_data_->user_path = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->accounts_service);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->user_path;
		_data_->_state_ = 2;
		g_async_initable_new_async (DATE_TIME_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY, 0, NULL, date_time_main_view_setup_time_format_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp5_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = (DateTimePantheonAccountsService*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = (DateTimePantheonAccountsService*) _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->user_path);
			_g_object_unref0 (_data_->accounts_service);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->self->priv->pantheon_act);
		_data_->self->priv->pantheon_act = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->self->priv->pantheon_act;
		_data_->_tmp9_ = date_time_pantheon_accounts_service_get_time_format (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = g_strcmp0 (_data_->_tmp11_, "12h") == 0;
		_g_free0 (_data_->_tmp11_);
		if (_data_->_tmp12_) {
			_data_->_tmp13_ = _data_->self->priv->meridiem_time_format;
			gtk_check_button_set_active (_data_->_tmp13_, TRUE);
		} else {
			_data_->_tmp14_ = _data_->self->priv->military_time_format;
			gtk_check_button_set_active (_data_->_tmp14_, TRUE);
		}
		_g_object_unref0 (_data_->_tmp4_);
		_g_free0 (_data_->user_path);
		_g_object_unref0 (_data_->accounts_service);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp15_ = _data_->e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_critical ("MainView.vala:311: %s", _data_->_tmp16_);
		_data_->_tmp17_ = _data_->self->priv->clock_settings;
		g_signal_connect_object (_data_->_tmp17_, "changed::clock-format", (GCallback) ____lambda7__g_settings_changed, _data_->self, 0);
		_data_->_tmp18_ = _data_->self->priv->clock_settings;
		_data_->_tmp19_ = g_settings_get_string (_data_->_tmp18_, "clock-format");
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = string_contains (_data_->_tmp20_, "12h");
		_g_free0 (_data_->_tmp20_);
		if (_data_->_tmp21_) {
			_data_->_tmp22_ = _data_->self->priv->meridiem_time_format;
			gtk_check_button_set_active (_data_->_tmp22_, TRUE);
		} else {
			_data_->_tmp23_ = _data_->self->priv->meridiem_time_format;
			gtk_check_button_set_active (_data_->_tmp23_, FALSE);
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
date_time_main_view_change_tz (DateTimeMainView* self,
                               const gchar* _tz)
{
	DateTimeTimeZoneGrid* _tmp0_;
	DateTimeDateTime1* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	GDateTime* local_time = NULL;
	GDateTime* _tmp10_;
	gfloat offset = 0.0F;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_tz != NULL);
	_tmp0_ = self->priv->time_zone_picker;
	date_time_time_zone_grid_set_time_zone (_tmp0_, _tz);
	_tmp1_ = self->priv->datetime1;
	_tmp2_ = date_time_date_time1_get_Timezone (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, _tz) != 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		DateTimeCurrentTimeManager* _tmp9_;
		{
			DateTimeDateTime1* _tmp6_;
			_tmp6_ = self->priv->datetime1;
			date_time_date_time1_set_timezone (_tmp6_, _tz, TRUE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_critical ("MainView.vala:336: %s", _tmp8_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp9_ = self->priv->ct_manager;
		date_time_current_time_manager_timezone_has_changed (_tmp9_);
	}
	_tmp10_ = g_date_time_new_now_local ();
	local_time = _tmp10_;
	_tmp11_ = local_time;
	offset = ((gfloat) g_date_time_get_utc_offset (_tmp11_)) / ((gfloat) G_TIME_SPAN_HOUR);
	_tmp12_ = local_time;
	if (g_date_time_is_daylight_savings (_tmp12_)) {
		gfloat _tmp13_;
		_tmp13_ = offset;
		offset = _tmp13_ - 1;
	}
	_g_date_time_unref0 (local_time);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DateTimeMainView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->wingpanel_settings);
		_g_object_unref0 (_data1_->date_picker);
		_g_object_unref0 (_data1_->time_picker);
		_g_object_unref0 (_data1_->manual_time_radio);
		_g_object_unref0 (_data1_->network_time_radio);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_date_time_main_view_change_tz_date_time_time_zone_grid_request_timezone_change (DateTimeTimeZoneGrid* _sender,
                                                                                 const gchar* tz,
                                                                                 gpointer self)
{
	date_time_main_view_change_tz ((DateTimeMainView*) self, tz);
}

static void
_date_time_main_view___lambda8_ (Block1Data* _data1_)
{
	DateTimeMainView* self;
	GDateTime* now_local = NULL;
	GDateTime* _tmp0_;
	gint minutes = 0;
	GraniteTimePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gint hours = 0;
	GraniteTimePicker* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* now_utc = NULL;
	GDateTime* _tmp9_;
	gint64 usec_utc = 0LL;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	gint64 _tmp15_;
	DateTimeCurrentTimeManager* _tmp19_;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	_tmp0_ = g_date_time_new_now_local ();
	now_local = _tmp0_;
	_tmp1_ = _data1_->time_picker;
	_tmp2_ = granite_time_picker_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = now_local;
	minutes = g_date_time_get_minute (_tmp3_) - g_date_time_get_minute (_tmp4_);
	_tmp5_ = _data1_->time_picker;
	_tmp6_ = granite_time_picker_get_time (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = now_local;
	hours = g_date_time_get_hour (_tmp7_) - g_date_time_get_hour (_tmp8_);
	_tmp9_ = g_date_time_new_now_utc ();
	now_utc = _tmp9_;
	_tmp10_ = now_utc;
	_tmp11_ = g_date_time_add_hours (_tmp10_, hours);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_date_time_add_minutes (_tmp12_, minutes);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_date_time_to_unix (_tmp14_);
	_g_date_time_unref0 (_tmp14_);
	_g_date_time_unref0 (_tmp12_);
	usec_utc = _tmp15_;
	{
		DateTimeDateTime1* _tmp16_;
		_tmp16_ = self->priv->datetime1;
		date_time_date_time1_set_time (_tmp16_, usec_utc * 1000000, FALSE, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_critical ("MainView.vala:197: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_date_time_unref0 (now_utc);
		_g_date_time_unref0 (now_local);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp19_ = self->priv->ct_manager;
	date_time_current_time_manager_datetime_has_changed (_tmp19_, FALSE);
	_g_date_time_unref0 (now_utc);
	_g_date_time_unref0 (now_local);
}

static void
__date_time_main_view___lambda8__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                   gpointer self)
{
	_date_time_main_view___lambda8_ (self);
}

static void
_date_time_main_view___lambda9_ (Block1Data* _data1_)
{
	DateTimeMainView* self;
	GDateTime* now_local = NULL;
	GDateTime* _tmp0_;
	gint years = 0;
	GraniteDatePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gint days = 0;
	GraniteDatePicker* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* now_utc = NULL;
	GDateTime* _tmp9_;
	gint64 usec_utc = 0LL;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	gint64 _tmp15_;
	DateTimeCurrentTimeManager* _tmp19_;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	if (_data1_->syncing_datetime == TRUE) {
		return;
	}
	_tmp0_ = g_date_time_new_now_local ();
	now_local = _tmp0_;
	_tmp1_ = _data1_->date_picker;
	_tmp2_ = granite_date_picker_get_date (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = now_local;
	years = g_date_time_get_year (_tmp3_) - g_date_time_get_year (_tmp4_);
	_tmp5_ = _data1_->date_picker;
	_tmp6_ = granite_date_picker_get_date (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = now_local;
	days = g_date_time_get_day_of_year (_tmp7_) - g_date_time_get_day_of_year (_tmp8_);
	_tmp9_ = g_date_time_new_now_utc ();
	now_utc = _tmp9_;
	_tmp10_ = now_utc;
	_tmp11_ = g_date_time_add_years (_tmp10_, years);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_date_time_add_days (_tmp12_, days);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_date_time_to_unix (_tmp14_);
	_g_date_time_unref0 (_tmp14_);
	_g_date_time_unref0 (_tmp12_);
	usec_utc = _tmp15_;
	{
		DateTimeDateTime1* _tmp16_;
		_tmp16_ = self->priv->datetime1;
		date_time_date_time1_set_time (_tmp16_, usec_utc * 1000000, FALSE, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_critical ("MainView.vala:214: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_date_time_unref0 (now_utc);
		_g_date_time_unref0 (now_local);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp19_ = self->priv->ct_manager;
	date_time_current_time_manager_datetime_has_changed (_tmp19_, FALSE);
	_g_date_time_unref0 (now_utc);
	_g_date_time_unref0 (now_local);
}

static void
__date_time_main_view___lambda9__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_date_time_main_view___lambda9_ (self);
}

static void
_date_time_main_view___lambda10_ (Block1Data* _data1_,
                                  GDateTime* dt)
{
	DateTimeMainView* self;
	GraniteTimePicker* _tmp0_;
	GraniteDatePicker* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (dt != NULL);
	_data1_->syncing_datetime = TRUE;
	_tmp0_ = _data1_->time_picker;
	granite_time_picker_set_time (_tmp0_, dt);
	_tmp1_ = _data1_->date_picker;
	granite_date_picker_set_date (_tmp1_, dt);
	_data1_->syncing_datetime = FALSE;
}

static void
__date_time_main_view___lambda10__date_time_current_time_manager_time_has_changed (DateTimeCurrentTimeManager* _sender,
                                                                                   GDateTime* dt,
                                                                                   gpointer self)
{
	_date_time_main_view___lambda10_ (self, dt);
}

static void
_date_time_main_view___lambda11_ (Block1Data* _data1_)
{
	DateTimeMainView* self;
	const gchar* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* new_format = NULL;
	GSettings* _tmp4_;
	const gchar* _tmp5_;
	GSettings* _tmp6_;
	DateTimePantheonAccountsService* _tmp9_;
	DateTimeCurrentTimeManager* _tmp12_;
	self = _data1_->self;
	_tmp1_ = self->priv->meridiem_time_format;
	_tmp2_ = gtk_check_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == TRUE) {
		_tmp0_ = "12h";
	} else {
		_tmp0_ = "24h";
	}
	new_format = _tmp0_;
	_tmp4_ = self->priv->clock_settings;
	_tmp5_ = new_format;
	g_settings_set_string (_tmp4_, "clock-format", _tmp5_);
	_tmp6_ = _data1_->wingpanel_settings;
	if (_tmp6_ != NULL) {
		GSettings* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = _data1_->wingpanel_settings;
		_tmp8_ = new_format;
		g_settings_set_string (_tmp7_, "clock-format", _tmp8_);
	}
	_tmp9_ = self->priv->pantheon_act;
	if (_tmp9_ != NULL) {
		DateTimePantheonAccountsService* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->pantheon_act;
		_tmp11_ = new_format;
		date_time_pantheon_accounts_service_set_time_format (_tmp10_, _tmp11_);
	}
	_tmp12_ = self->priv->ct_manager;
	date_time_current_time_manager_datetime_has_changed (_tmp12_, TRUE);
}

static void
__date_time_main_view___lambda11__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                            gpointer self)
{
	_date_time_main_view___lambda11_ (self);
}

static void
_date_time_main_view___lambda12_ (Block1Data* _data1_)
{
	DateTimeMainView* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	{
		DateTimeDateTime1* _tmp0_;
		GtkCheckButton* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		DateTimeCurrentTimeManager* _tmp4_;
		_tmp0_ = self->priv->datetime1;
		_tmp1_ = _data1_->network_time_radio;
		_tmp2_ = gtk_check_button_get_active (_tmp1_);
		_tmp3_ = _tmp2_;
		date_time_date_time1_SetNTP (_tmp0_, _tmp3_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->priv->ct_manager;
		date_time_current_time_manager_datetime_has_changed (_tmp4_, FALSE);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkCheckButton* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _data1_->manual_time_radio;
		g_signal_emit_by_name (_tmp5_, "activate");
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("MainView.vala:266: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__date_time_main_view___lambda12__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                            gpointer self)
{
	_date_time_main_view___lambda12_ (self);
}

static gboolean
_date_time_main_view___lambda13_ (GValue* value,
                                  GVariant* variant,
                                  void* user_data)
{
	const gchar* _tmp0_ = NULL;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	if (g_variant_get_boolean (variant)) {
		_tmp0_ = "location-active-symbolic";
	} else {
		_tmp0_ = "location-inactive-symbolic";
	}
	g_value_set_string (value, _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
__date_time_main_view___lambda13__gsettings_bind_get_mapping (GValue* value,
                                                              GVariant* variant,
                                                              void* user_data)
{
	gboolean result;
	result = _date_time_main_view___lambda13_ (value, variant, user_data);
	return result;
}

static GVariant*
_variant_new1 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_date_time_main_view___lambda14_ (void)
{
	GVariant* _tmp0_;
	GVariant* result;
	_tmp0_ = _variant_new1 (TRUE);
	result = _tmp0_;
	return result;
}

static GVariant*
__date_time_main_view___lambda14__gsettings_bind_set_mapping (GValue* value,
                                                              const GVariantType* expected_type,
                                                              void* user_data)
{
	GVariant* result;
	result = _date_time_main_view___lambda14_ ();
	return result;
}

static GObject *
date_time_main_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DateTimeMainView * self;
	Block1Data* _data1_;
	GraniteHeaderLabel* appearance_header = NULL;
	GraniteHeaderLabel* _tmp0_;
	GtkLabel* time_format_label = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkCheckButton* _tmp2_;
	GtkCheckButton* _tmp3_;
	GtkCheckButton* _tmp4_;
	GtkCheckButton* _tmp5_ = NULL;
	GtkBox* time_format_box = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkCheckButton* _tmp8_;
	GtkBox* _tmp9_;
	GtkCheckButton* _tmp10_;
	GraniteHeaderLabel* time_zone_label = NULL;
	GraniteHeaderLabel* _tmp11_;
	GtkImage* auto_time_zone_icon = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkLabel* auto_time_zone_label = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* auto_time_zone_hint = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkCheckButton* auto_time_zone_radio = NULL;
	GtkCheckButton* _tmp19_;
	GtkGrid* auto_time_zone_grid = NULL;
	GtkGrid* _tmp20_ = NULL;
	GtkGrid* _tmp21_;
	GtkImage* _tmp22_;
	GtkGrid* _tmp23_;
	GtkLabel* _tmp24_;
	GtkGrid* _tmp25_;
	GtkLabel* _tmp26_;
	GtkGrid* _tmp27_;
	GtkCheckButton* _tmp28_;
	GtkCheckButton* manual_time_zone_radio = NULL;
	GtkCheckButton* _tmp29_;
	GtkCheckButton* _tmp30_;
	GtkCheckButton* _tmp31_ = NULL;
	DateTimeTimeZoneGrid* _tmp32_ = NULL;
	DateTimeTimeZoneGrid* _tmp33_;
	GtkCheckButton* _tmp34_;
	GraniteHeaderLabel* date_time_header = NULL;
	GraniteHeaderLabel* _tmp35_;
	GtkCheckButton* _tmp36_;
	GtkCheckButton* _tmp37_;
	GtkCheckButton* _tmp38_;
	GtkCheckButton* _tmp39_ = NULL;
	GraniteTimePicker* _tmp40_ = NULL;
	GraniteDatePicker* _tmp41_;
	GtkBox* manual_time_box = NULL;
	GtkBox* _tmp42_ = NULL;
	GtkBox* _tmp43_;
	GraniteTimePicker* _tmp44_;
	GtkBox* _tmp45_;
	GraniteDatePicker* _tmp46_;
	GtkBox* _tmp47_;
	GtkCheckButton* _tmp48_;
	GtkSwitch* week_number_switch = NULL;
	GtkSwitch* _tmp49_ = NULL;
	GraniteHeaderLabel* week_number_label = NULL;
	GtkSwitch* _tmp50_;
	GtkWidget* _tmp51_;
	gchar* _tmp52_;
	GraniteHeaderLabel* _tmp53_ = NULL;
	GtkBox* week_number_box = NULL;
	GtkBox* _tmp54_;
	GtkBox* _tmp55_;
	GraniteHeaderLabel* _tmp56_;
	GtkBox* _tmp57_;
	GtkSwitch* _tmp58_;
	GtkLabel* panel_label = NULL;
	GtkLabel* _tmp59_ = NULL;
	GtkCheckButton* date_check = NULL;
	GtkCheckButton* _tmp60_;
	GtkCheckButton* weekday_check = NULL;
	GtkCheckButton* _tmp61_;
	GtkCheckButton* seconds_check = NULL;
	GtkCheckButton* _tmp62_;
	GtkBox* panel_check_box = NULL;
	GtkBox* _tmp63_;
	GtkBox* _tmp64_;
	GtkCheckButton* _tmp65_;
	GtkBox* _tmp66_;
	GtkCheckButton* _tmp67_;
	GtkBox* _tmp68_;
	GtkCheckButton* _tmp69_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp70_ = NULL;
	GtkGrid* _tmp71_;
	GraniteHeaderLabel* _tmp72_;
	GtkGrid* _tmp73_;
	GtkLabel* _tmp74_;
	GtkGrid* _tmp75_;
	GtkBox* _tmp76_;
	GtkGrid* _tmp77_;
	GtkLabel* _tmp78_;
	GtkGrid* _tmp79_;
	GtkBox* _tmp80_;
	GtkGrid* _tmp81_;
	GtkBox* _tmp82_;
	GtkGrid* _tmp83_;
	GraniteHeaderLabel* _tmp84_;
	GtkGrid* _tmp85_;
	GtkCheckButton* _tmp86_;
	GtkGrid* _tmp87_;
	GtkCheckButton* _tmp88_;
	GtkGrid* _tmp89_;
	GraniteHeaderLabel* _tmp90_;
	GtkGrid* _tmp91_;
	GtkCheckButton* _tmp92_;
	GtkGrid* _tmp93_;
	GtkCheckButton* _tmp94_;
	GtkGrid* _tmp95_;
	GSettingsSchemaSource* source = NULL;
	GSettingsSchemaSource* _tmp96_;
	GSettingsSchemaSource* _tmp97_;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp98_;
	GSettingsSchema* _tmp99_;
	GSettingsSchema* _tmp100_;
	DateTimeTimeZoneGrid* _tmp116_;
	GraniteTimePicker* _tmp117_;
	GraniteDatePicker* _tmp118_;
	DateTimeCurrentTimeManager* _tmp119_;
	DateTimeCurrentTimeManager* _tmp120_;
	GSettings* _tmp121_;
	GtkCheckButton* _tmp122_;
	GtkCheckButton* _tmp136_;
	DateTimeDateTime1* _tmp137_;
	gchar* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	GtkCheckButton* _tmp141_;
	GtkBox* _tmp142_;
	GtkCheckButton* _tmp143_;
	GtkCheckButton* _tmp144_;
	GSettings* _tmp145_;
	GtkCheckButton* _tmp146_;
	GSettings* _tmp147_;
	DateTimeTimeZoneGrid* _tmp148_;
	GSettings* _tmp149_;
	GtkImage* _tmp150_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (date_time_main_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_MAIN_VIEW, DateTimeMainView);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = granite_header_label_new (_ ("Appearance"));
	g_object_ref_sink (_tmp0_);
	appearance_header = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Time format:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp1_);
	time_format_label = _tmp1_;
	_tmp2_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("AM/PM"));
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->meridiem_time_format);
	self->priv->meridiem_time_format = _tmp2_;
	_tmp3_ = self->priv->meridiem_time_format;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("24-hour"));
	gtk_check_button_set_group (_tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->military_time_format);
	self->priv->military_time_format = _tmp5_;
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp6_);
	time_format_box = _tmp6_;
	_tmp7_ = time_format_box;
	_tmp8_ = self->priv->meridiem_time_format;
	gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = time_format_box;
	_tmp10_ = self->priv->military_time_format;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = granite_header_label_new (_ ("Time Zone"));
	g_object_ref_sink (_tmp11_);
	time_zone_label = _tmp11_;
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("location-inactive-symbolic");
	gtk_image_set_pixel_size (_tmp12_, 24);
	g_object_ref_sink (_tmp12_);
	auto_time_zone_icon = _tmp12_;
	_tmp13_ = auto_time_zone_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp14_ = auto_time_zone_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp14_, "purple");
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Based on location"));
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp15_);
	auto_time_zone_label = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Automatically updates the time zone when activated"));
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	gtk_label_set_wrap (_tmp16_, TRUE);
	g_object_ref_sink (_tmp16_);
	auto_time_zone_hint = _tmp16_;
	_tmp17_ = auto_time_zone_hint;
	gtk_widget_add_css_class ((GtkWidget*) _tmp17_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp18_ = auto_time_zone_hint;
	gtk_widget_add_css_class ((GtkWidget*) _tmp18_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp19_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp19_);
	auto_time_zone_radio = _tmp19_;
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp20_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, 3);
	g_object_ref_sink (_tmp20_);
	auto_time_zone_grid = _tmp20_;
	_tmp21_ = auto_time_zone_grid;
	_tmp22_ = auto_time_zone_icon;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 0, 0, 1, 2);
	_tmp23_ = auto_time_zone_grid;
	_tmp24_ = auto_time_zone_label;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp24_, 1, 0, 1, 1);
	_tmp25_ = auto_time_zone_grid;
	_tmp26_ = auto_time_zone_hint;
	gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 1, 1, 1, 1);
	_tmp27_ = auto_time_zone_grid;
	_tmp28_ = auto_time_zone_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = auto_time_zone_radio;
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_tmp31_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp31_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	manual_time_zone_radio = _tmp31_;
	_tmp32_ = date_time_time_zone_grid_new ();
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 6);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->time_zone_picker);
	self->priv->time_zone_picker = _tmp32_;
	_tmp33_ = self->priv->time_zone_picker;
	_tmp34_ = manual_time_zone_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = granite_header_label_new (_ ("Date & Time"));
	g_object_ref_sink (_tmp35_);
	date_time_header = _tmp35_;
	_tmp36_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Set automatically"));
	g_object_ref_sink (_tmp36_);
	_data1_->network_time_radio = _tmp36_;
	_tmp37_ = _data1_->network_time_radio;
	_tmp38_ = _g_object_ref0 (_tmp37_);
	_tmp39_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp39_, _tmp38_);
	_g_object_unref0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	_data1_->manual_time_radio = _tmp39_;
	_tmp40_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
	g_object_ref_sink (_tmp40_);
	_data1_->time_picker = _tmp40_;
	_tmp41_ = granite_date_picker_new ();
	g_object_ref_sink (_tmp41_);
	_data1_->date_picker = _tmp41_;
	_tmp42_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_box_set_homogeneous (_tmp42_, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp42_, 6);
	g_object_ref_sink (_tmp42_);
	manual_time_box = _tmp42_;
	_tmp43_ = manual_time_box;
	_tmp44_ = _data1_->time_picker;
	gtk_box_append (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = manual_time_box;
	_tmp46_ = _data1_->date_picker;
	gtk_box_append (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = manual_time_box;
	_tmp48_ = _data1_->manual_time_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp49_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp49_);
	week_number_switch = _tmp49_;
	_tmp50_ = week_number_switch;
	_tmp51_ = _g_object_ref0 ((GtkWidget*) _tmp50_);
	_tmp52_ = g_strdup (_ ("e.g. in Calendar and the Date &amp; Time Panel indicator"));
	_tmp53_ = granite_header_label_new (_ ("Show Week Numbers"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp53_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp53_, _tmp51_);
	_g_object_unref0 (_tmp51_);
	granite_header_label_set_secondary_text (_tmp53_, _tmp52_);
	_g_free0 (_tmp52_);
	g_object_ref_sink (_tmp53_);
	week_number_label = _tmp53_;
	_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp54_);
	week_number_box = _tmp54_;
	_tmp55_ = week_number_box;
	_tmp56_ = week_number_label;
	gtk_box_append (_tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = week_number_box;
	_tmp58_ = week_number_switch;
	gtk_box_append (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = (GtkLabel*) gtk_label_new (_ ("Show in Panel:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp59_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp59_);
	panel_label = _tmp59_;
	_tmp60_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Date"));
	g_object_ref_sink (_tmp60_);
	date_check = _tmp60_;
	_tmp61_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Day of the week"));
	g_object_ref_sink (_tmp61_);
	weekday_check = _tmp61_;
	_tmp62_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Seconds"));
	g_object_ref_sink (_tmp62_);
	seconds_check = _tmp62_;
	_tmp63_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp63_);
	panel_check_box = _tmp63_;
	_tmp64_ = panel_check_box;
	_tmp65_ = date_check;
	gtk_box_append (_tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = panel_check_box;
	_tmp67_ = weekday_check;
	gtk_box_append (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = panel_check_box;
	_tmp69_ = seconds_check;
	gtk_box_append (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp70_, 12);
	gtk_grid_set_row_spacing (_tmp70_, 12);
	g_object_ref_sink (_tmp70_);
	grid = _tmp70_;
	_tmp71_ = grid;
	_tmp72_ = appearance_header;
	gtk_grid_attach (_tmp71_, (GtkWidget*) _tmp72_, 0, 0, 2, 1);
	_tmp73_ = grid;
	_tmp74_ = time_format_label;
	gtk_grid_attach (_tmp73_, (GtkWidget*) _tmp74_, 0, 1, 1, 1);
	_tmp75_ = grid;
	_tmp76_ = time_format_box;
	gtk_grid_attach (_tmp75_, (GtkWidget*) _tmp76_, 1, 1, 1, 1);
	_tmp77_ = grid;
	_tmp78_ = panel_label;
	gtk_grid_attach (_tmp77_, (GtkWidget*) _tmp78_, 0, 2, 1, 1);
	_tmp79_ = grid;
	_tmp80_ = panel_check_box;
	gtk_grid_attach (_tmp79_, (GtkWidget*) _tmp80_, 1, 2, 1, 1);
	_tmp81_ = grid;
	_tmp82_ = week_number_box;
	gtk_grid_attach (_tmp81_, (GtkWidget*) _tmp82_, 0, 3, 2, 1);
	_tmp83_ = grid;
	_tmp84_ = time_zone_label;
	gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp84_, 0, 4, 2, 1);
	_tmp85_ = grid;
	_tmp86_ = auto_time_zone_radio;
	gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 0, 5, 2, 1);
	_tmp87_ = grid;
	_tmp88_ = manual_time_zone_radio;
	gtk_grid_attach (_tmp87_, (GtkWidget*) _tmp88_, 0, 6, 2, 1);
	_tmp89_ = grid;
	_tmp90_ = date_time_header;
	gtk_grid_attach (_tmp89_, (GtkWidget*) _tmp90_, 0, 7, 2, 1);
	_tmp91_ = grid;
	_tmp92_ = _data1_->network_time_radio;
	gtk_grid_attach (_tmp91_, (GtkWidget*) _tmp92_, 0, 8, 2, 1);
	_tmp93_ = grid;
	_tmp94_ = _data1_->manual_time_radio;
	gtk_grid_attach (_tmp93_, (GtkWidget*) _tmp94_, 0, 9, 2, 1);
	_tmp95_ = grid;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp95_);
	_tmp96_ = g_settings_schema_source_get_default ();
	_tmp97_ = _g_settings_schema_source_ref0 (_tmp96_);
	source = _tmp97_;
	_tmp98_ = source;
	_tmp99_ = g_settings_schema_source_lookup (_tmp98_, "io.elementary.desktop.wingpanel.datetime", TRUE);
	schema = _tmp99_;
	_data1_->wingpanel_settings = NULL;
	_tmp100_ = schema;
	if (_tmp100_ == NULL) {
		GtkGrid* _tmp101_;
		GtkBox* _tmp102_;
		GtkLabel* _tmp103_;
		GtkBox* _tmp104_;
		_tmp101_ = grid;
		_tmp102_ = week_number_box;
		gtk_grid_remove (_tmp101_, (GtkWidget*) _tmp102_);
		_tmp103_ = panel_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp103_, FALSE);
		_tmp104_ = panel_check_box;
		gtk_widget_set_visible ((GtkWidget*) _tmp104_, FALSE);
	} else {
		GSettings* _tmp105_;
		GSettings* _tmp106_;
		GtkCheckButton* _tmp107_;
		GSettings* _tmp108_;
		GtkCheckButton* _tmp109_;
		GSettings* _tmp110_;
		GtkCheckButton* _tmp111_;
		GSettings* _tmp112_;
		GtkCheckButton* _tmp113_;
		GSettings* _tmp114_;
		GtkSwitch* _tmp115_;
		_tmp105_ = g_settings_new ("io.elementary.desktop.wingpanel.datetime");
		_g_object_unref0 (_data1_->wingpanel_settings);
		_data1_->wingpanel_settings = _tmp105_;
		_tmp106_ = _data1_->wingpanel_settings;
		_tmp107_ = date_check;
		g_settings_bind (_tmp106_, "clock-show-date", (GObject*) _tmp107_, "active", G_SETTINGS_BIND_DEFAULT);
		_tmp108_ = _data1_->wingpanel_settings;
		_tmp109_ = weekday_check;
		g_settings_bind (_tmp108_, "clock-show-weekday", (GObject*) _tmp109_, "active", G_SETTINGS_BIND_DEFAULT);
		_tmp110_ = _data1_->wingpanel_settings;
		_tmp111_ = seconds_check;
		g_settings_bind (_tmp110_, "clock-show-seconds", (GObject*) _tmp111_, "active", G_SETTINGS_BIND_DEFAULT);
		_tmp112_ = _data1_->wingpanel_settings;
		_tmp113_ = weekday_check;
		g_settings_bind (_tmp112_, "clock-show-date", (GObject*) _tmp113_, "sensitive", G_SETTINGS_BIND_DEFAULT);
		_tmp114_ = _data1_->wingpanel_settings;
		_tmp115_ = week_number_switch;
		g_settings_bind (_tmp114_, "show-weeks", (GObject*) _tmp115_, "active", G_SETTINGS_BIND_DEFAULT);
	}
	_tmp116_ = self->priv->time_zone_picker;
	g_signal_connect_object (_tmp116_, "request-timezone-change", (GCallback) _date_time_main_view_change_tz_date_time_time_zone_grid_request_timezone_change, self, 0);
	_data1_->syncing_datetime = FALSE;
	_tmp117_ = _data1_->time_picker;
	g_signal_connect_data (_tmp117_, "time-changed", (GCallback) __date_time_main_view___lambda8__granite_time_picker_time_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp118_ = _data1_->date_picker;
	g_signal_connect_data ((GObject*) _tmp118_, "notify::date", (GCallback) __date_time_main_view___lambda9__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp119_ = date_time_current_time_manager_new ();
	_g_object_unref0 (self->priv->ct_manager);
	self->priv->ct_manager = _tmp119_;
	_tmp120_ = self->priv->ct_manager;
	g_signal_connect_data (_tmp120_, "time-has-changed", (GCallback) __date_time_main_view___lambda10__date_time_current_time_manager_time_has_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp121_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->clock_settings);
	self->priv->clock_settings = _tmp121_;
	_tmp122_ = self->priv->meridiem_time_format;
	g_signal_connect_data (_tmp122_, "toggled", (GCallback) __date_time_main_view___lambda11__gtk_check_button_toggled, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	date_time_main_view_setup_time_format (self, NULL, NULL);
	{
		DateTimeDateTime1* _tmp123_ = NULL;
		DateTimeDateTime1* _tmp124_;
		DateTimeDateTime1* _tmp125_;
		DateTimeDateTime1* _tmp126_;
		gboolean _tmp127_;
		gboolean _tmp128_;
		_tmp124_ = (DateTimeDateTime1*) g_initable_new (DATE_TIME_TYPE_DATE_TIME1_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.timedate1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/timedate1", "g-interface-name", "org.freedesktop.timedate1", NULL);
		_tmp123_ = (DateTimeDateTime1*) _tmp124_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_settings_schema_unref0 (schema);
			_g_settings_schema_source_unref0 (source);
			_g_object_unref0 (grid);
			_g_object_unref0 (panel_check_box);
			_g_object_unref0 (seconds_check);
			_g_object_unref0 (weekday_check);
			_g_object_unref0 (date_check);
			_g_object_unref0 (panel_label);
			_g_object_unref0 (week_number_box);
			_g_object_unref0 (week_number_label);
			_g_object_unref0 (week_number_switch);
			_g_object_unref0 (manual_time_box);
			_g_object_unref0 (date_time_header);
			_g_object_unref0 (manual_time_zone_radio);
			_g_object_unref0 (auto_time_zone_grid);
			_g_object_unref0 (auto_time_zone_radio);
			_g_object_unref0 (auto_time_zone_hint);
			_g_object_unref0 (auto_time_zone_label);
			_g_object_unref0 (auto_time_zone_icon);
			_g_object_unref0 (time_zone_label);
			_g_object_unref0 (time_format_box);
			_g_object_unref0 (time_format_label);
			_g_object_unref0 (appearance_header);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp125_ = _tmp123_;
		_tmp123_ = NULL;
		_g_object_unref0 (self->priv->datetime1);
		self->priv->datetime1 = _tmp125_;
		_tmp126_ = self->priv->datetime1;
		_tmp127_ = date_time_date_time1_get_CanNTP (_tmp126_);
		_tmp128_ = _tmp127_;
		if (_tmp128_ == FALSE) {
			GtkCheckButton* _tmp129_;
			_tmp129_ = _data1_->network_time_radio;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp129_, FALSE);
		} else {
			DateTimeDateTime1* _tmp130_;
			gboolean _tmp131_;
			gboolean _tmp132_;
			_tmp130_ = self->priv->datetime1;
			_tmp131_ = date_time_date_time1_get_NTP (_tmp130_);
			_tmp132_ = _tmp131_;
			if (_tmp132_) {
				GtkCheckButton* _tmp133_;
				_tmp133_ = _data1_->network_time_radio;
				gtk_check_button_set_active (_tmp133_, TRUE);
			}
		}
		_g_object_unref0 (_tmp123_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp134_;
		const gchar* _tmp135_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp134_ = e;
		_tmp135_ = _tmp134_->message;
		g_critical ("MainView.vala:257: %s", _tmp135_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_settings_schema_unref0 (schema);
		_g_settings_schema_source_unref0 (source);
		_g_object_unref0 (grid);
		_g_object_unref0 (panel_check_box);
		_g_object_unref0 (seconds_check);
		_g_object_unref0 (weekday_check);
		_g_object_unref0 (date_check);
		_g_object_unref0 (panel_label);
		_g_object_unref0 (week_number_box);
		_g_object_unref0 (week_number_label);
		_g_object_unref0 (week_number_switch);
		_g_object_unref0 (manual_time_box);
		_g_object_unref0 (date_time_header);
		_g_object_unref0 (manual_time_zone_radio);
		_g_object_unref0 (auto_time_zone_grid);
		_g_object_unref0 (auto_time_zone_radio);
		_g_object_unref0 (auto_time_zone_hint);
		_g_object_unref0 (auto_time_zone_label);
		_g_object_unref0 (auto_time_zone_icon);
		_g_object_unref0 (time_zone_label);
		_g_object_unref0 (time_format_box);
		_g_object_unref0 (time_format_label);
		_g_object_unref0 (appearance_header);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp136_ = _data1_->network_time_radio;
	g_signal_connect_data (_tmp136_, "toggled", (GCallback) __date_time_main_view___lambda12__gtk_check_button_toggled, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp137_ = self->priv->datetime1;
	_tmp138_ = date_time_date_time1_get_Timezone (_tmp137_);
	_tmp139_ = _tmp138_;
	_tmp140_ = _tmp139_;
	date_time_main_view_change_tz (self, _tmp140_);
	_g_free0 (_tmp140_);
	_tmp141_ = _data1_->network_time_radio;
	_tmp142_ = manual_time_box;
	g_object_bind_property_with_closures ((GObject*) _tmp141_, "active", (GObject*) _tmp142_, "sensitive", G_BINDING_INVERT_BOOLEAN | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp143_ = auto_time_zone_radio;
	_tmp144_ = manual_time_zone_radio;
	g_object_bind_property_with_closures ((GObject*) _tmp143_, "active", (GObject*) _tmp144_, "active", G_BINDING_INVERT_BOOLEAN | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp145_ = date_time_main_view_time_zone_settings;
	_tmp146_ = auto_time_zone_radio;
	g_settings_bind (_tmp145_, "automatic-timezone", (GObject*) _tmp146_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp147_ = date_time_main_view_time_zone_settings;
	_tmp148_ = self->priv->time_zone_picker;
	g_settings_bind (_tmp147_, "automatic-timezone", (GObject*) _tmp148_, "sensitive", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp149_ = date_time_main_view_time_zone_settings;
	_tmp150_ = auto_time_zone_icon;
	g_settings_bind_with_mapping (_tmp149_, "automatic-timezone", (GObject*) _tmp150_, "icon-name", G_SETTINGS_BIND_GET, __date_time_main_view___lambda13__gsettings_bind_get_mapping, __date_time_main_view___lambda14__gsettings_bind_set_mapping, NULL, NULL);
	_g_settings_schema_unref0 (schema);
	_g_settings_schema_source_unref0 (source);
	_g_object_unref0 (grid);
	_g_object_unref0 (panel_check_box);
	_g_object_unref0 (seconds_check);
	_g_object_unref0 (weekday_check);
	_g_object_unref0 (date_check);
	_g_object_unref0 (panel_label);
	_g_object_unref0 (week_number_box);
	_g_object_unref0 (week_number_label);
	_g_object_unref0 (week_number_switch);
	_g_object_unref0 (manual_time_box);
	_g_object_unref0 (date_time_header);
	_g_object_unref0 (manual_time_zone_radio);
	_g_object_unref0 (auto_time_zone_grid);
	_g_object_unref0 (auto_time_zone_radio);
	_g_object_unref0 (auto_time_zone_hint);
	_g_object_unref0 (auto_time_zone_label);
	_g_object_unref0 (auto_time_zone_icon);
	_g_object_unref0 (time_zone_label);
	_g_object_unref0 (time_format_box);
	_g_object_unref0 (time_format_label);
	_g_object_unref0 (appearance_header);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
date_time_main_view_class_init (DateTimeMainViewClass * klass,
                                gpointer klass_data)
{
	GSettings* _tmp0_;
	date_time_main_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimeMainView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = date_time_main_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = date_time_main_view_finalize;
	_tmp0_ = g_settings_new ("org.gnome.desktop.datetime");
	_g_object_unref0 (date_time_main_view_time_zone_settings);
	date_time_main_view_time_zone_settings = _tmp0_;
}

static void
date_time_main_view_instance_init (DateTimeMainView * self,
                                   gpointer klass)
{
	self->priv = date_time_main_view_get_instance_private (self);
	self->priv->pantheon_act = NULL;
}

static void
date_time_main_view_finalize (GObject * obj)
{
	DateTimeMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_MAIN_VIEW, DateTimeMainView);
	_g_object_unref0 (self->priv->time_zone_picker);
	_g_object_unref0 (self->priv->datetime1);
	_g_object_unref0 (self->priv->ct_manager);
	_g_object_unref0 (self->priv->clock_settings);
	_g_object_unref0 (self->priv->meridiem_time_format);
	_g_object_unref0 (self->priv->military_time_format);
	_g_object_unref0 (self->priv->pantheon_act);
	G_OBJECT_CLASS (date_time_main_view_parent_class)->finalize (obj);
}

static GType
date_time_main_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimeMainViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_main_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimeMainView), 0, (GInstanceInitFunc) date_time_main_view_instance_init, NULL };
	GType date_time_main_view_type_id;
	date_time_main_view_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "DateTimeMainView", &g_define_type_info, 0);
	DateTimeMainView_private_offset = g_type_add_instance_private (date_time_main_view_type_id, sizeof (DateTimeMainViewPrivate));
	return date_time_main_view_type_id;
}

GType
date_time_main_view_get_type (void)
{
	static volatile gsize date_time_main_view_type_id__once = 0;
	if (g_once_init_enter (&date_time_main_view_type_id__once)) {
		GType date_time_main_view_type_id;
		date_time_main_view_type_id = date_time_main_view_get_type_once ();
		g_once_init_leave (&date_time_main_view_type_id__once, date_time_main_view_type_id);
	}
	return date_time_main_view_type_id__once;
}

