/* WallpaperContainer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WallpaperContainer.vala, do not modify */

/*-
 * Copyright 2015-2022 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Erasmo Marín
 *
 */

#include "desktop.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gexiv2/gexiv2.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PANTHEON_SHELL_WALLPAPER_CONTAINER_0_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pantheon_shell_thumbnail_generator_unref0(var) ((var == NULL) ? NULL : (var = (pantheon_shell_thumbnail_generator_unref (var), NULL)))
typedef struct _PantheonShellWallpaperContainerUpdateThumbData PantheonShellWallpaperContainerUpdateThumbData;
typedef struct _Block5Data Block5Data;
enum  {
	PANTHEON_SHELL_WALLPAPER_CONTAINER_TRASH_SIGNAL,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_SIGNALS
};
static guint pantheon_shell_wallpaper_container_signals[PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_SIGNALS] = {0};

struct _PantheonShellWallpaperContainerPrivate {
	GtkBox* card_box;
	GtkRevealer* check_revealer;
	gchar* _thumb_path;
	gboolean _thumb_valid;
	gchar* _uri;
};

struct _PantheonShellWallpaperContainerUpdateThumbData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PantheonShellWallpaperContainer* self;
	const gchar* _tmp0_;
	GtkPicture* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* path;
	gchar* _tmp4_;
	GExiv2Metadata* metadata;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GExiv2Metadata* _tmp9_;
	GExiv2Metadata* _tmp10_;
	const gchar* _tmp11_;
	GError* e;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GExiv2Metadata* _tmp15_;
	gchar* artist_name;
	GExiv2Metadata* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError* _vala1_e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	PantheonShellWallpaperContainer* self;
	GtkPopoverMenu* context_menu;
	GtkGestureClick* secondary_click_gesture;
};

static gint PantheonShellWallpaperContainer_private_offset;
static gpointer pantheon_shell_wallpaper_container_parent_class = NULL;

static void pantheon_shell_wallpaper_container_generate_and_load_thumb (PantheonShellWallpaperContainer* self);
static void __lambda6_ (PantheonShellWallpaperContainer* self);
static void pantheon_shell_wallpaper_container_update_thumb (PantheonShellWallpaperContainer* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void pantheon_shell_wallpaper_container_update_thumb_finish (PantheonShellWallpaperContainer* self,
                                                             GAsyncResult* _res_);
static void ___lambda6__pantheon_shell_thumbnail_generator_thumbnail_ready (gpointer self);
static void pantheon_shell_wallpaper_container_update_thumb_data_free (gpointer _data);
static gboolean pantheon_shell_wallpaper_container_update_thumb_co (PantheonShellWallpaperContainerUpdateThumbData* _data_);
static GObject * pantheon_shell_wallpaper_container_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _pantheon_shell_wallpaper_container____lambda7_ (PantheonShellWallpaperContainer* self);
static void __pantheon_shell_wallpaper_container____lambda7__g_simple_action_activate (GSimpleAction* _sender,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void _pantheon_shell_wallpaper_container____lambda8_ (Block5Data* _data5_,
                                                      gint n_press,
                                                      gdouble x,
                                                      gdouble y);
static void __pantheon_shell_wallpaper_container____lambda8__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                  gint n_press,
                                                                                  gdouble x,
                                                                                  gdouble y,
                                                                                  gpointer self);
static void _pantheon_shell_wallpaper_container___lambda9_ (PantheonShellWallpaperContainer* self);
static void __pantheon_shell_wallpaper_container___lambda9__gtk_flow_box_child_activate (GtkFlowBoxChild* _sender,
                                                                                  gpointer self);
static void pantheon_shell_wallpaper_container_finalize (GObject * obj);
static GType pantheon_shell_wallpaper_container_get_type_once (void);
static void _vala_pantheon_shell_wallpaper_container_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_pantheon_shell_wallpaper_container_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
pantheon_shell_wallpaper_container_get_instance_private (PantheonShellWallpaperContainer* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellWallpaperContainer_private_offset);
}

PantheonShellWallpaperContainer*
pantheon_shell_wallpaper_container_construct (GType object_type,
                                              const gchar* uri,
                                              const gchar* thumb_path,
                                              gboolean thumb_valid)
{
	PantheonShellWallpaperContainer * self = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (PantheonShellWallpaperContainer*) g_object_new (object_type, "uri", uri, "thumb-path", thumb_path, "thumb-valid", thumb_valid, NULL);
	return self;
}

PantheonShellWallpaperContainer*
pantheon_shell_wallpaper_container_new (const gchar* uri,
                                        const gchar* thumb_path,
                                        gboolean thumb_valid)
{
	return pantheon_shell_wallpaper_container_construct (PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, uri, thumb_path, thumb_valid);
}

static void
__lambda6_ (PantheonShellWallpaperContainer* self)
{
	GError* _inner_error0_ = NULL;
	{
		GFile* file = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFileInfo* info = NULL;
		GFileInfo* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->_uri;
		_tmp1_ = g_file_new_for_uri (_tmp0_);
		file = _tmp1_;
		_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_THUMBNAIL_PATH "," G_FILE_ATTRIBUTE_THUMBNAIL_IS_VALID, 0, NULL, &_inner_error0_);
		info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp3_ = g_file_info_get_attribute_as_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
		_tmp4_ = _tmp3_;
		pantheon_shell_wallpaper_container_set_thumb_path (self, _tmp4_);
		_g_free0 (_tmp4_);
		pantheon_shell_wallpaper_container_update_thumb (self, NULL, NULL);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = self->priv->_uri;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("WallpaperContainer.vala:172: Error loading thumbnail for '%s': %s", _tmp5_, _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__pantheon_shell_thumbnail_generator_thumbnail_ready (gpointer self)
{
	__lambda6_ ((PantheonShellWallpaperContainer*) self);
}

static void
pantheon_shell_wallpaper_container_generate_and_load_thumb (PantheonShellWallpaperContainer* self)
{
	PantheonShellThumbnailGenerator* _tmp0_;
	PantheonShellThumbnailGenerator* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_thumbnail_generator_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_uri;
	_tmp3_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp4_ = _tmp3_;
	pantheon_shell_thumbnail_generator_get_thumbnail (_tmp1_, _tmp2_, (guint) (PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_WIDTH * _tmp4_), ___lambda6__pantheon_shell_thumbnail_generator_thumbnail_ready, self);
	_pantheon_shell_thumbnail_generator_unref0 (_tmp1_);
}

static void
pantheon_shell_wallpaper_container_update_thumb_data_free (gpointer _data)
{
	PantheonShellWallpaperContainerUpdateThumbData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PantheonShellWallpaperContainerUpdateThumbData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pantheon_shell_wallpaper_container_update_thumb (PantheonShellWallpaperContainer* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	PantheonShellWallpaperContainerUpdateThumbData* _data_;
	PantheonShellWallpaperContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PantheonShellWallpaperContainerUpdateThumbData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pantheon_shell_wallpaper_container_update_thumb_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pantheon_shell_wallpaper_container_update_thumb_co (_data_);
}

static void
pantheon_shell_wallpaper_container_update_thumb_finish (PantheonShellWallpaperContainer* self,
                                                        GAsyncResult* _res_)
{
	PantheonShellWallpaperContainerUpdateThumbData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
pantheon_shell_wallpaper_container_update_thumb_co (PantheonShellWallpaperContainerUpdateThumbData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_thumb_path;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->image;
	_data_->_tmp2_ = _data_->self->priv->_thumb_path;
	gtk_picture_set_filename (_data_->_tmp1_, _data_->_tmp2_);
	_data_->_tmp3_ = _data_->self->priv->_uri;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = g_strdup ("");
		_data_->path = _data_->_tmp4_;
		{
			_data_->_tmp6_ = _data_->self->priv->_uri;
			_data_->_tmp7_ = g_filename_from_uri (_data_->_tmp6_, NULL, &_data_->_inner_error0_);
			_data_->_tmp5_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp8_ = _data_->_tmp5_;
			_data_->_tmp5_ = NULL;
			_g_free0 (_data_->path);
			_data_->path = _data_->_tmp8_;
			_data_->_tmp9_ = gexiv2_metadata_new ();
			_g_object_unref0 (_data_->metadata);
			_data_->metadata = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->metadata;
			_data_->_tmp11_ = _data_->path;
			gexiv2_metadata_open_path (_data_->_tmp10_, _data_->_tmp11_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->_tmp5_);
				goto __catch0_g_error;
			}
			_g_free0 (_data_->_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp12_ = _data_->path;
			_data_->_tmp13_ = _data_->e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			g_warning ("WallpaperContainer.vala:192: Error parsing exif metadata of \"%s\": %s", _data_->_tmp12_, _data_->_tmp14_);
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->metadata);
			_g_free0 (_data_->path);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->metadata);
			_g_free0 (_data_->path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = _data_->metadata;
		if (gexiv2_metadata_has_exif (_data_->_tmp15_)) {
			{
				_data_->_tmp16_ = _data_->metadata;
				_data_->_tmp17_ = gexiv2_metadata_try_get_tag_string (_data_->_tmp16_, "Exif.Image.Artist", &_data_->_inner_error0_);
				_data_->artist_name = _data_->_tmp17_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_data_->_tmp18_ = _data_->artist_name;
				if (_data_->_tmp18_ != NULL) {
					_data_->_tmp19_ = _data_->artist_name;
					_data_->_tmp20_ = g_strdup_printf (_ ("Artist: %s"), _data_->_tmp19_);
					_data_->_tmp21_ = _data_->_tmp20_;
					gtk_widget_set_tooltip_text ((GtkWidget*) _data_->self, _data_->_tmp21_);
					_g_free0 (_data_->_tmp21_);
				}
				_g_free0 (_data_->artist_name);
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp22_ = _data_->_vala1_e;
				_data_->_tmp23_ = _data_->_tmp22_->message;
				g_critical ("WallpaperContainer.vala:203: Unable to set wallpaper artist name: %s", _data_->_tmp23_);
				_g_error_free0 (_data_->_vala1_e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->metadata);
				_g_free0 (_data_->path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->metadata);
		_g_free0 (_data_->path);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

const gchar*
pantheon_shell_wallpaper_container_get_thumb_path (PantheonShellWallpaperContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_thumb_path;
	result = _tmp0_;
	return result;
}

void
pantheon_shell_wallpaper_container_set_thumb_path (PantheonShellWallpaperContainer* self,
                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_container_get_thumb_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumb_path);
		self->priv->_thumb_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY]);
	}
}

gboolean
pantheon_shell_wallpaper_container_get_thumb_valid (PantheonShellWallpaperContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_thumb_valid;
	return result;
}

static void
pantheon_shell_wallpaper_container_set_thumb_valid (PantheonShellWallpaperContainer* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_container_get_thumb_valid (self);
	if (old_value != value) {
		self->priv->_thumb_valid = value;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY]);
	}
}

const gchar*
pantheon_shell_wallpaper_container_get_uri (PantheonShellWallpaperContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
pantheon_shell_wallpaper_container_set_uri (PantheonShellWallpaperContainer* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_container_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY]);
	}
}

gboolean
pantheon_shell_wallpaper_container_get_checked (PantheonShellWallpaperContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_CHECKED) == GTK_STATE_FLAG_CHECKED;
	return result;
}

void
pantheon_shell_wallpaper_container_set_checked (PantheonShellWallpaperContainer* self,
                                                gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkBox* _tmp0_;
		GtkRevealer* _tmp1_;
		_tmp0_ = self->priv->card_box;
		gtk_widget_set_state_flags ((GtkWidget*) _tmp0_, GTK_STATE_FLAG_CHECKED, FALSE);
		_tmp1_ = self->priv->check_revealer;
		gtk_revealer_set_reveal_child (_tmp1_, TRUE);
	} else {
		GtkBox* _tmp2_;
		GtkRevealer* _tmp3_;
		_tmp2_ = self->priv->card_box;
		gtk_widget_unset_state_flags ((GtkWidget*) _tmp2_, GTK_STATE_FLAG_CHECKED);
		_tmp3_ = self->priv->check_revealer;
		gtk_revealer_set_reveal_child (_tmp3_, FALSE);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY]);
}

gboolean
pantheon_shell_wallpaper_container_get_selected (PantheonShellWallpaperContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_SELECTED) == GTK_STATE_FLAG_SELECTED;
	return result;
}

void
pantheon_shell_wallpaper_container_set_selected (PantheonShellWallpaperContainer* self,
                                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_SELECTED, FALSE);
	} else {
		gtk_widget_unset_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_SELECTED);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY]);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PantheonShellWallpaperContainer* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->secondary_click_gesture);
		_g_object_unref0 (_data5_->context_menu);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_pantheon_shell_wallpaper_container____lambda7_ (PantheonShellWallpaperContainer* self)
{
	g_signal_emit (self, pantheon_shell_wallpaper_container_signals[PANTHEON_SHELL_WALLPAPER_CONTAINER_TRASH_SIGNAL], 0);
}

static void
__pantheon_shell_wallpaper_container____lambda7__g_simple_action_activate (GSimpleAction* _sender,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	_pantheon_shell_wallpaper_container____lambda7_ ((PantheonShellWallpaperContainer*) self);
}

static void
_pantheon_shell_wallpaper_container____lambda8_ (Block5Data* _data5_,
                                                 gint n_press,
                                                 gdouble x,
                                                 gdouble y)
{
	PantheonShellWallpaperContainer* self;
	GtkGestureClick* _tmp0_;
	GtkPopoverMenu* _tmp1_;
	GdkRectangle _tmp2_ = {0};
	GtkPopoverMenu* _tmp3_;
	self = _data5_->self;
	_tmp0_ = _data5_->secondary_click_gesture;
	gtk_gesture_set_state ((GtkGesture*) _tmp0_, GTK_EVENT_SEQUENCE_CLAIMED);
	_tmp1_ = _data5_->context_menu;
	memset (&_tmp2_, 0, sizeof (GdkRectangle));
	_tmp2_.x = (gint) x;
	_tmp2_.y = (gint) y;
	g_object_set ((GtkPopover*) _tmp1_, "pointing-to", &_tmp2_, NULL);
	_tmp3_ = _data5_->context_menu;
	gtk_popover_popup ((GtkPopover*) _tmp3_);
}

static void
__pantheon_shell_wallpaper_container____lambda8__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                             gint n_press,
                                                                             gdouble x,
                                                                             gdouble y,
                                                                             gpointer self)
{
	_pantheon_shell_wallpaper_container____lambda8_ (self, n_press, x, y);
}

static void
_pantheon_shell_wallpaper_container___lambda9_ (PantheonShellWallpaperContainer* self)
{
	pantheon_shell_wallpaper_container_set_checked (self, TRUE);
}

static void
__pantheon_shell_wallpaper_container___lambda9__gtk_flow_box_child_activate (GtkFlowBoxChild* _sender,
                                                                             gpointer self)
{
	_pantheon_shell_wallpaper_container___lambda9_ ((PantheonShellWallpaperContainer*) self);
}

static GObject *
pantheon_shell_wallpaper_container_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellWallpaperContainer * self;
	GtkPicture* _tmp0_ = NULL;
	GtkPicture* _tmp1_;
	GtkPicture* _tmp2_;
	GtkCheckButton* check = NULL;
	GtkCheckButton* _tmp3_ = NULL;
	GtkCheckButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkRevealer* _tmp6_ = NULL;
	GtkOverlay* overlay = NULL;
	GtkPicture* _tmp7_;
	GtkWidget* _tmp8_;
	GtkOverlay* _tmp9_ = NULL;
	GtkOverlay* _tmp10_;
	GtkRevealer* _tmp11_;
	GtkOverlay* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pantheon_shell_wallpaper_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	gtk_widget_add_css_class ((GtkWidget*) self, "wallpaper-container");
	_tmp0_ = (GtkPicture*) gtk_picture_new ();
	gtk_picture_set_content_fit (_tmp0_, GTK_CONTENT_FIT_COVER);
	g_object_set ((GtkWidget*) _tmp0_, "height-request", PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_HEIGHT, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->image);
	self->image = _tmp0_;
	_tmp1_ = self->image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, GRANITE_STYLE_CLASS_CARD);
	_tmp2_ = self->image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp3_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_active (_tmp3_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp3_, FALSE);
	gtk_widget_set_can_target ((GtkWidget*) _tmp3_, FALSE);
	g_object_ref_sink (_tmp3_);
	check = _tmp3_;
	_tmp4_ = check;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	_tmp6_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp6_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	gtk_revealer_set_transition_type (_tmp6_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->check_revealer);
	self->priv->check_revealer = _tmp6_;
	_tmp7_ = self->image;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	overlay = _tmp9_;
	_tmp10_ = overlay;
	_tmp11_ = self->priv->check_revealer;
	gtk_overlay_add_overlay (_tmp10_, (GtkWidget*) _tmp11_);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	_tmp12_ = overlay;
	gtk_flow_box_child_set_child ((GtkFlowBoxChild*) self, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->_uri;
	if (_tmp13_ != NULL) {
		Block5Data* _data5_;
		GSimpleAction* remove_wallpaper_action = NULL;
		GSimpleAction* _tmp14_;
		GSimpleAction* _tmp15_;
		GSimpleActionGroup* action_group = NULL;
		GSimpleActionGroup* _tmp16_;
		GSimpleActionGroup* _tmp17_;
		GSimpleAction* _tmp18_;
		GSimpleActionGroup* _tmp19_;
		GFile* file = NULL;
		const gchar* _tmp20_;
		GFile* _tmp21_;
		GMenu* menu_model = NULL;
		GMenu* _tmp29_;
		GMenu* _tmp30_;
		GMenu* _tmp31_;
		GtkPopoverMenu* _tmp32_ = NULL;
		GtkPopoverMenu* _tmp33_;
		GtkGestureClick* _tmp34_ = NULL;
		GtkGestureClick* _tmp35_;
		GtkGestureClick* _tmp36_;
		GtkEventController* _tmp37_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->self = g_object_ref (self);
		_tmp14_ = g_simple_action_new ("trash", NULL);
		remove_wallpaper_action = _tmp14_;
		_tmp15_ = remove_wallpaper_action;
		g_signal_connect_object (_tmp15_, "activate", (GCallback) __pantheon_shell_wallpaper_container____lambda7__g_simple_action_activate, self, 0);
		_tmp16_ = g_simple_action_group_new ();
		action_group = _tmp16_;
		_tmp17_ = action_group;
		_tmp18_ = remove_wallpaper_action;
		g_action_map_add_action ((GActionMap*) _tmp17_, (GAction*) _tmp18_);
		_tmp19_ = action_group;
		gtk_widget_insert_action_group ((GtkWidget*) self, "wallpaper", (GActionGroup*) _tmp19_);
		_tmp20_ = self->priv->_uri;
		_tmp21_ = g_file_new_for_uri (_tmp20_);
		file = _tmp21_;
		{
			GFileInfo* info = NULL;
			GFile* _tmp22_;
			GFileInfo* _tmp23_;
			GFileInfo* _tmp24_;
			GSimpleAction* _tmp25_;
			GFileInfo* _tmp26_;
			_tmp22_ = file;
			_tmp23_ = g_file_query_info (_tmp22_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp23_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp24_ = info;
			self->creation_date = g_file_info_get_attribute_uint64 (_tmp24_, G_FILE_ATTRIBUTE_TIME_CREATED);
			_tmp25_ = remove_wallpaper_action;
			_tmp26_ = info;
			g_simple_action_set_enabled (_tmp25_, g_file_info_get_attribute_boolean (_tmp26_, G_FILE_ATTRIBUTE_ACCESS_CAN_DELETE));
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			g_critical ("WallpaperContainer.vala:118: %s", _tmp28_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_object_unref0 (action_group);
			_g_object_unref0 (remove_wallpaper_action);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			_g_object_unref0 (overlay);
			_g_object_unref0 (check);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp29_ = g_menu_new ();
		menu_model = _tmp29_;
		_tmp30_ = menu_model;
		g_menu_append (_tmp30_, _ ("Remove"), "wallpaper.trash");
		_tmp31_ = menu_model;
		_tmp32_ = (GtkPopoverMenu*) gtk_popover_menu_new_from_model ((GMenuModel*) _tmp31_);
		gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_START);
		gtk_popover_set_has_arrow ((GtkPopover*) _tmp32_, FALSE);
		g_object_ref_sink (_tmp32_);
		_data5_->context_menu = _tmp32_;
		_tmp33_ = _data5_->context_menu;
		gtk_widget_set_parent ((GtkWidget*) _tmp33_, (GtkWidget*) self);
		_tmp34_ = (GtkGestureClick*) gtk_gesture_click_new ();
		gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp34_, (guint) GDK_BUTTON_SECONDARY);
		_data5_->secondary_click_gesture = _tmp34_;
		_tmp35_ = _data5_->secondary_click_gesture;
		g_signal_connect_data (_tmp35_, "released", (GCallback) __pantheon_shell_wallpaper_container____lambda8__gtk_gesture_click_released, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_tmp36_ = _data5_->secondary_click_gesture;
		_tmp37_ = _g_object_ref0 ((GtkEventController*) _tmp36_);
		gtk_widget_add_controller ((GtkWidget*) self, _tmp37_);
		_g_object_unref0 (menu_model);
		_g_object_unref0 (file);
		_g_object_unref0 (action_group);
		_g_object_unref0 (remove_wallpaper_action);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	g_signal_connect_object ((GtkFlowBoxChild*) self, "activate", (GCallback) __pantheon_shell_wallpaper_container___lambda9__gtk_flow_box_child_activate, self, 0);
	{
		const gchar* _tmp38_;
		_tmp38_ = self->priv->_uri;
		if (_tmp38_ != NULL) {
			gboolean _tmp39_ = FALSE;
			const gchar* _tmp40_;
			_tmp40_ = self->priv->_thumb_path;
			if (_tmp40_ != NULL) {
				gboolean _tmp41_;
				_tmp41_ = self->priv->_thumb_valid;
				_tmp39_ = _tmp41_;
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				pantheon_shell_wallpaper_container_update_thumb (self, NULL, NULL);
			} else {
				pantheon_shell_wallpaper_container_generate_and_load_thumb (self);
			}
		} else {
			GtkPicture* _tmp42_;
			const gchar* _tmp43_;
			_tmp42_ = self->image;
			_tmp43_ = self->priv->_thumb_path;
			gtk_picture_set_filename (_tmp42_, _tmp43_);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_critical ("WallpaperContainer.vala:159: Failed to load wallpaper thumbnail: %s", _tmp45_);
		_g_error_free0 (e);
		_g_object_unref0 (overlay);
		_g_object_unref0 (check);
		return obj;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (overlay);
		_g_object_unref0 (check);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_object_unref0 (overlay);
	_g_object_unref0 (check);
	return obj;
}

static void
pantheon_shell_wallpaper_container_class_init (PantheonShellWallpaperContainerClass * klass,
                                               gpointer klass_data)
{
	pantheon_shell_wallpaper_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellWallpaperContainer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_shell_wallpaper_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_shell_wallpaper_container_set_property;
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_wallpaper_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_wallpaper_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY] = g_param_spec_string ("thumb-path", "thumb-path", "thumb-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY] = g_param_spec_boolean ("thumb-valid", "thumb-valid", "thumb-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY] = g_param_spec_boolean ("checked", "checked", "checked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	pantheon_shell_wallpaper_container_signals[PANTHEON_SHELL_WALLPAPER_CONTAINER_TRASH_SIGNAL] = g_signal_new ("trash", PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pantheon_shell_wallpaper_container_instance_init (PantheonShellWallpaperContainer * self,
                                                  gpointer klass)
{
	self->priv = pantheon_shell_wallpaper_container_get_instance_private (self);
	self->creation_date = (guint64) 0;
}

static void
pantheon_shell_wallpaper_container_finalize (GObject * obj)
{
	PantheonShellWallpaperContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->priv->card_box);
	_g_object_unref0 (self->priv->check_revealer);
	_g_free0 (self->priv->_thumb_path);
	_g_free0 (self->priv->_uri);
	G_OBJECT_CLASS (pantheon_shell_wallpaper_container_parent_class)->finalize (obj);
}

static GType
pantheon_shell_wallpaper_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellWallpaperContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_wallpaper_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellWallpaperContainer), 0, (GInstanceInitFunc) pantheon_shell_wallpaper_container_instance_init, NULL };
	GType pantheon_shell_wallpaper_container_type_id;
	pantheon_shell_wallpaper_container_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "PantheonShellWallpaperContainer", &g_define_type_info, 0);
	PantheonShellWallpaperContainer_private_offset = g_type_add_instance_private (pantheon_shell_wallpaper_container_type_id, sizeof (PantheonShellWallpaperContainerPrivate));
	return pantheon_shell_wallpaper_container_type_id;
}

GType
pantheon_shell_wallpaper_container_get_type (void)
{
	static volatile gsize pantheon_shell_wallpaper_container_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_wallpaper_container_type_id__once)) {
		GType pantheon_shell_wallpaper_container_type_id;
		pantheon_shell_wallpaper_container_type_id = pantheon_shell_wallpaper_container_get_type_once ();
		g_once_init_leave (&pantheon_shell_wallpaper_container_type_id__once, pantheon_shell_wallpaper_container_type_id);
	}
	return pantheon_shell_wallpaper_container_type_id__once;
}

static void
_vala_pantheon_shell_wallpaper_container_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	PantheonShellWallpaperContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	switch (property_id) {
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY:
		g_value_set_string (value, pantheon_shell_wallpaper_container_get_thumb_path (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY:
		g_value_set_boolean (value, pantheon_shell_wallpaper_container_get_thumb_valid (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY:
		g_value_set_string (value, pantheon_shell_wallpaper_container_get_uri (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY:
		g_value_set_boolean (value, pantheon_shell_wallpaper_container_get_checked (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY:
		g_value_set_boolean (value, pantheon_shell_wallpaper_container_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_shell_wallpaper_container_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	PantheonShellWallpaperContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	switch (property_id) {
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY:
		pantheon_shell_wallpaper_container_set_thumb_path (self, g_value_get_string (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY:
		pantheon_shell_wallpaper_container_set_thumb_valid (self, g_value_get_boolean (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY:
		pantheon_shell_wallpaper_container_set_uri (self, g_value_get_string (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY:
		pantheon_shell_wallpaper_container_set_checked (self, g_value_get_boolean (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY:
		pantheon_shell_wallpaper_container_set_selected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

