/* WacomToolMap.c generated by valac 0.56.18, the Vala compiler
 * generated from WacomToolMap.vala, do not modify */

/*
 * Copyright (c) 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "wacom.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <libwacom/libwacom.h>
#include <glib/gstdio.h>

#define WACOM_BACKEND_WACOM_TOOL_MAP_GENERIC_STYLUS "Generic"
#define WACOM_BACKEND_WACOM_TOOL_MAP_KEY_TOOL_ID "ID"
#define WACOM_BACKEND_WACOM_TOOL_MAP_KEY_DEVICE_STYLI "Styli"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_BACKEND_WACOM_TOOL_MAP_0_PROPERTY,
	WACOM_BACKEND_WACOM_TOOL_MAP_NUM_PROPERTIES
};
static GParamSpec* wacom_backend_wacom_tool_map_properties[WACOM_BACKEND_WACOM_TOOL_MAP_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _libwacom_database_destroy0(var) ((var == NULL) ? NULL : (var = (libwacom_database_destroy (var), NULL)))
#define _libwacom_destroy0(var) ((var == NULL) ? NULL : (var = (libwacom_destroy (var), NULL)))
#define __vala_WacomError_free_function_address_of0(var) ((var == NULL) ? NULL : (var = (_vala_WacomError_free_function_address_of (var), NULL)))

struct _WacomBackendWacomToolMapPrivate {
	GKeyFile* tablets;
	GKeyFile* tools;
	gchar* tablet_path;
	gchar* tool_path;
	GeeHashMap* tablet_map;
	GeeHashMap* tool_map;
	GeeHashMap* no_serial_tool_map;
};

static gint WacomBackendWacomToolMap_private_offset;
static gpointer wacom_backend_wacom_tool_map_parent_class = NULL;
static WacomDeviceDatabase* wacom_backend_wacom_tool_map_wacom_db;
static WacomDeviceDatabase* wacom_backend_wacom_tool_map_wacom_db = NULL;
static GOnce wacom_backend_wacom_tool_map_instance;
static GOnce wacom_backend_wacom_tool_map_instance = G_ONCE_INIT;

static WacomBackendWacomToolMap* __lambda5_ (void);
static gpointer ___lambda5__gthread_func (gpointer self);
static void wacom_backend_wacom_tool_map_load_keyfiles (WacomBackendWacomToolMap* self);
static void wacom_backend_wacom_tool_map_cache_tools (WacomBackendWacomToolMap* self);
static void wacom_backend_wacom_tool_map_cache_devices (WacomBackendWacomToolMap* self);
static gchar* wacom_backend_wacom_tool_map_get_tool_key (guint64 serial);
static void wacom_backend_wacom_tool_map_keyfile_add_stylus (WacomBackendWacomToolMap* self,
                                                      const gchar* tool_key,
                                                      guint64 id);
static void wacom_backend_wacom_tool_map_keyfile_add_device_stylus (WacomBackendWacomToolMap* self,
                                                             const gchar* device_key,
                                                             const gchar* tool_key);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_WacomError_free_function_address_of (WacomError* self);
static void wacom_backend_wacom_tool_map_finalize (GObject * obj);
static GType wacom_backend_wacom_tool_map_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
wacom_backend_wacom_tool_map_get_instance_private (WacomBackendWacomToolMap* self)
{
	return G_STRUCT_MEMBER_P (self, WacomBackendWacomToolMap_private_offset);
}

static WacomBackendWacomToolMap*
__lambda5_ (void)
{
	WacomBackendWacomToolMap* _tmp0_;
	WacomBackendWacomToolMap* result;
	_tmp0_ = wacom_backend_wacom_tool_map_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda5__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda5_ ();
	return result;
}

WacomBackendWacomToolMap*
wacom_backend_wacom_tool_map_get_default (void)
{
	gconstpointer _tmp0_;
	WacomBackendWacomToolMap* result;
	_tmp0_ = g_once (&wacom_backend_wacom_tool_map_instance, ___lambda5__gthread_func, NULL);
	result = (WacomBackendWacomToolMap*) _tmp0_;
	return result;
}

WacomBackendWacomToolMap*
wacom_backend_wacom_tool_map_construct (GType object_type)
{
	WacomBackendWacomToolMap * self = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	self = (WacomBackendWacomToolMap*) g_object_new (object_type, NULL);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->tablets);
	self->priv->tablets = _tmp0_;
	_tmp1_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->tools);
	self->priv->tools = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tablet_map);
	self->priv->tablet_map = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WACOM_BACKEND_TYPE_WACOM_TOOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tool_map);
	self->priv->tool_map = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WACOM_BACKEND_TYPE_WACOM_TOOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->no_serial_tool_map);
	self->priv->no_serial_tool_map = _tmp4_;
	wacom_backend_wacom_tool_map_load_keyfiles (self);
	wacom_backend_wacom_tool_map_cache_tools (self);
	wacom_backend_wacom_tool_map_cache_devices (self);
	return self;
}

WacomBackendWacomToolMap*
wacom_backend_wacom_tool_map_new (void)
{
	return wacom_backend_wacom_tool_map_construct (WACOM_BACKEND_TYPE_WACOM_TOOL_MAP);
}

static void
wacom_backend_wacom_tool_map_load_keyfiles (WacomBackendWacomToolMap* self)
{
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "io.elementary.settings", "wacom", NULL);
	dir = _tmp1_;
	_tmp2_ = dir;
	if (g_mkdir_with_parents (_tmp2_, 0700) < 0) {
		const gchar* _tmp3_;
		_tmp3_ = dir;
		g_warning ("WacomToolMap.vala:61: Could not create directory '%s', stylus mapping " \
"may not work well", _tmp3_);
		_g_free0 (dir);
		return;
	}
	_tmp4_ = dir;
	_tmp5_ = g_build_filename (_tmp4_, "devices", NULL);
	_g_free0 (self->priv->tablet_path);
	self->priv->tablet_path = _tmp5_;
	{
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->tablets;
		_tmp7_ = self->priv->tablet_path;
		g_key_file_load_from_file (_tmp6_, _tmp7_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = self->priv->tablet_path;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("WacomToolMap.vala:69: Could not load tablets keyfile '%s': %s", _tmp8_, _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = dir;
	_tmp12_ = g_build_filename (_tmp11_, "tools", NULL);
	_g_free0 (self->priv->tool_path);
	self->priv->tool_path = _tmp12_;
	{
		GKeyFile* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = self->priv->tools;
		_tmp14_ = self->priv->tool_path;
		g_key_file_load_from_file (_tmp13_, _tmp14_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = self->priv->tool_path;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("WacomToolMap.vala:76: Could not load tools keyfile '%s': %s", _tmp15_, _tmp17_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (dir);
}

static void
wacom_backend_wacom_tool_map_cache_tools (WacomBackendWacomToolMap* self)
{
	gchar** serials = NULL;
	GKeyFile* _tmp0_;
	gsize _tmp1_ = 0;
	gchar** _tmp2_;
	gint serials_length1;
	gint _serials_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tools;
	_tmp2_ = g_key_file_get_groups (_tmp0_, &_tmp1_);
	serials = _tmp2_;
	serials_length1 = _tmp1_;
	_serials_size_ = serials_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar** _tmp5_;
				gint _tmp5__length1;
				guint64 serial = 0ULL;
				guint64 id = 0ULL;
				gchar* str = NULL;
				GeeHashMap* _tmp31_;
				gchar** _tmp32_;
				gint _tmp32__length1;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				WacomBackendWacomTool* _tmp36_;
				WacomBackendWacomTool* _tmp37_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = serials;
				_tmp5__length1 = serials_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				{
					gboolean _tmp6_ = FALSE;
					gchar** _tmp7_;
					gint _tmp7__length1;
					const gchar* _tmp8_;
					guint64 _tmp9_ = 0ULL;
					gboolean _tmp10_;
					_tmp7_ = serials;
					_tmp7__length1 = serials_length1;
					_tmp8_ = _tmp7_[i];
					_tmp10_ = g_ascii_string_to_unsigned (_tmp8_, (guint) 16, 0ULL, G_MAXUINT64, &_tmp9_, &_inner_error0_);
					serial = _tmp9_;
					_tmp6_ = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					if (!_tmp6_) {
						gchar** _tmp11_;
						gint _tmp11__length1;
						const gchar* _tmp12_;
						_tmp11_ = serials;
						_tmp11__length1 = serials_length1;
						_tmp12_ = _tmp11_[i];
						g_warning ("WacomToolMap.vala:86: Invalid tool serial %s", _tmp12_);
						continue;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					g_clear_error (&_inner_error0_);
					_tmp13_ = serials;
					_tmp13__length1 = serials_length1;
					_tmp14_ = _tmp13_[i];
					g_warning ("WacomToolMap.vala:90: Invalid tool serial %s", _tmp14_);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					serials = (_vala_array_free (serials, serials_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				{
					gchar* _tmp15_ = NULL;
					GKeyFile* _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp16_ = self->priv->tools;
					_tmp17_ = serials;
					_tmp17__length1 = serials_length1;
					_tmp18_ = _tmp17_[i];
					_tmp19_ = g_key_file_get_string (_tmp16_, _tmp18_, WACOM_BACKEND_WACOM_TOOL_MAP_KEY_TOOL_ID, &_inner_error0_);
					_tmp15_ = _tmp19_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp20_ = _tmp15_;
					_tmp15_ = NULL;
					_g_free0 (str);
					str = _tmp20_;
					_g_free0 (_tmp15_);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					GError* _tmp23_;
					const gchar* _tmp24_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp21_ = serials;
					_tmp21__length1 = serials_length1;
					_tmp22_ = _tmp21_[i];
					_tmp23_ = e;
					_tmp24_ = _tmp23_->message;
					g_warning ("WacomToolMap.vala:98: Could not get cached ID for tool with serial %s:" \
" %s", _tmp22_, _tmp24_);
					_g_error_free0 (e);
					_g_free0 (str);
					continue;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (str);
					serials = (_vala_array_free (serials, serials_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				{
					gboolean _tmp25_ = FALSE;
					const gchar* _tmp26_;
					guint64 _tmp27_ = 0ULL;
					gboolean _tmp28_;
					_tmp26_ = str;
					_tmp28_ = g_ascii_string_to_unsigned (_tmp26_, (guint) 16, 0ULL, G_MAXUINT64, &_tmp27_, &_inner_error0_);
					id = _tmp27_;
					_tmp25_ = _tmp28_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
					if (!_tmp25_) {
						const gchar* _tmp29_;
						_tmp29_ = str;
						g_warning ("WacomToolMap.vala:104: Invalid tool ID %s", _tmp29_);
						_g_free0 (str);
						continue;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					const gchar* _tmp30_;
					g_clear_error (&_inner_error0_);
					_tmp30_ = str;
					g_warning ("WacomToolMap.vala:108: Invalid tool ID %s", _tmp30_);
					_g_free0 (str);
					continue;
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (str);
					serials = (_vala_array_free (serials, serials_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp31_ = self->priv->tool_map;
				_tmp32_ = serials;
				_tmp32__length1 = serials_length1;
				_tmp33_ = _tmp32_[i];
				_tmp34_ = g_strdup_printf ("/org/gnome/desktop/peripherals/stylus/%llx/", serial);
				_tmp35_ = _tmp34_;
				_tmp36_ = wacom_backend_wacom_tool_new (serial, id, _tmp35_);
				_tmp37_ = _tmp36_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp33_, _tmp37_);
				_g_object_unref0 (_tmp37_);
				_g_free0 (_tmp35_);
				_g_free0 (str);
			}
		}
	}
	serials = (_vala_array_free (serials, serials_length1, (GDestroyNotify) g_free), NULL);
}

static void
wacom_backend_wacom_tool_map_cache_devices (WacomBackendWacomToolMap* self)
{
	gchar** ids = NULL;
	GKeyFile* _tmp0_;
	gsize _tmp1_ = 0;
	gchar** _tmp2_;
	gint ids_length1;
	gint _ids_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tablets;
	_tmp2_ = g_key_file_get_groups (_tmp0_, &_tmp1_);
	ids = _tmp2_;
	ids_length1 = _tmp1_;
	_ids_size_ = ids_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar** _tmp5_;
				gint _tmp5__length1;
				GeeArrayList* tools = NULL;
				GeeArrayList* _tmp6_;
				gchar** styli = NULL;
				gint styli_length1;
				gint _styli_size_;
				GeeArrayList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = ids;
				_tmp5__length1 = ids_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = gee_array_list_new (WACOM_BACKEND_TYPE_WACOM_TOOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				tools = _tmp6_;
				styli = NULL;
				styli_length1 = 0;
				_styli_size_ = styli_length1;
				{
					gchar** _tmp7_ = NULL;
					GKeyFile* _tmp8_;
					gchar** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					gsize _tmp11_ = 0;
					gchar** _tmp12_;
					gint _tmp7__length1;
					gint __tmp7__size_;
					gchar** _tmp13_;
					gint _tmp13__length1;
					_tmp8_ = self->priv->tablets;
					_tmp9_ = ids;
					_tmp9__length1 = ids_length1;
					_tmp10_ = _tmp9_[i];
					_tmp12_ = g_key_file_get_string_list (_tmp8_, _tmp10_, WACOM_BACKEND_WACOM_TOOL_MAP_KEY_DEVICE_STYLI, &_tmp11_, &_inner_error0_);
					_tmp7_ = _tmp12_;
					_tmp7__length1 = _tmp11_;
					__tmp7__size_ = _tmp7__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (tools);
						ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_tmp13_ = _tmp7_;
					_tmp13__length1 = _tmp7__length1;
					_tmp7_ = NULL;
					_tmp7__length1 = 0;
					styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
					styli = _tmp13_;
					styli_length1 = _tmp13__length1;
					_styli_size_ = styli_length1;
					_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					GError* e = NULL;
					gchar** _tmp14_;
					gint _tmp14__length1;
					const gchar* _tmp15_;
					GError* _tmp16_;
					const gchar* _tmp17_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp14_ = ids;
					_tmp14__length1 = ids_length1;
					_tmp15_ = _tmp14_[i];
					_tmp16_ = e;
					_tmp17_ = _tmp16_->message;
					g_warning ("WacomToolMap.vala:125: Could not get cached styli for tablet with id %" \
"s: %s", _tmp15_, _tmp17_);
					_g_error_free0 (e);
					styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (tools);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (tools);
					ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							gchar** _tmp20_;
							gint _tmp20__length1;
							gchar** _tmp21_;
							gint _tmp21__length1;
							const gchar* _tmp22_;
							WacomBackendWacomTool* tool = NULL;
							GeeHashMap* _tmp26_;
							gchar** _tmp27_;
							gint _tmp27__length1;
							const gchar* _tmp28_;
							gpointer _tmp29_;
							WacomBackendWacomTool* _tmp30_;
							if (!_tmp18_) {
								gint _tmp19_;
								_tmp19_ = j;
								j = _tmp19_ + 1;
							}
							_tmp18_ = FALSE;
							_tmp20_ = styli;
							_tmp20__length1 = styli_length1;
							if (!(j < _tmp20__length1)) {
								break;
							}
							_tmp21_ = styli;
							_tmp21__length1 = styli_length1;
							_tmp22_ = _tmp21_[j];
							if (g_strcmp0 (_tmp22_, WACOM_BACKEND_WACOM_TOOL_MAP_GENERIC_STYLUS) == 0) {
								GeeHashMap* _tmp23_;
								gchar** _tmp24_;
								gint _tmp24__length1;
								const gchar* _tmp25_;
								_tmp23_ = self->priv->no_serial_tool_map;
								_tmp24_ = ids;
								_tmp24__length1 = ids_length1;
								_tmp25_ = _tmp24_[i];
								gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp25_, NULL);
							}
							_tmp26_ = self->priv->tool_map;
							_tmp27_ = styli;
							_tmp27__length1 = styli_length1;
							_tmp28_ = _tmp27_[j];
							_tmp29_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp28_);
							tool = (WacomBackendWacomTool*) _tmp29_;
							_tmp30_ = tool;
							if (_tmp30_ != NULL) {
								GeeArrayList* _tmp31_;
								WacomBackendWacomTool* _tmp32_;
								_tmp31_ = tools;
								_tmp32_ = tool;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
							}
							_g_object_unref0 (tool);
						}
					}
				}
				_tmp33_ = tools;
				_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				if (_tmp35_ > 0) {
					GeeHashMap* _tmp36_;
					gchar** _tmp37_;
					gint _tmp37__length1;
					const gchar* _tmp38_;
					GeeArrayList* _tmp39_;
					_tmp36_ = self->priv->tablet_map;
					_tmp37_ = ids;
					_tmp37__length1 = ids_length1;
					_tmp38_ = _tmp37_[i];
					_tmp39_ = tools;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, _tmp38_, _tmp39_);
				}
				styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (tools);
			}
		}
	}
	ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
wacom_backend_wacom_tool_map_get_tool_key (guint64 serial)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("%llx", serial);
	result = _tmp0_;
	return result;
}

void
wacom_backend_wacom_tool_map_add_relation (WacomBackendWacomToolMap* self,
                                           const gchar* device_key,
                                           WacomBackendWacomTool* tool)
{
	gchar* tool_key = NULL;
	gboolean tools_changed = FALSE;
	gboolean tablets_changed = FALSE;
	guint64 serial = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
	GeeArrayList* styli = NULL;
	GeeHashMap* _tmp19_;
	gpointer _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_key != NULL);
	g_return_if_fail (tool != NULL);
	tools_changed = FALSE;
	tablets_changed = FALSE;
	_tmp0_ = wacom_backend_wacom_tool_get_serial (tool);
	_tmp1_ = _tmp0_;
	serial = _tmp1_;
	if (serial == ((guint64) 0)) {
		gchar* _tmp2_;
		GeeHashMap* _tmp3_;
		_tmp2_ = g_strdup (WACOM_BACKEND_WACOM_TOOL_MAP_GENERIC_STYLUS);
		_g_free0 (tool_key);
		tool_key = _tmp2_;
		_tmp3_ = self->priv->no_serial_tool_map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, device_key, tool);
	} else {
		gchar* _tmp4_;
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = wacom_backend_wacom_tool_map_get_tool_key (serial);
		_g_free0 (tool_key);
		tool_key = _tmp4_;
		_tmp5_ = self->priv->tool_map;
		_tmp6_ = tool_key;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_)) {
			const gchar* _tmp7_;
			guint64 _tmp8_;
			guint64 _tmp9_;
			GeeHashMap* _tmp10_;
			const gchar* _tmp11_;
			_tmp7_ = tool_key;
			_tmp8_ = wacom_backend_wacom_tool_get_id (tool);
			_tmp9_ = _tmp8_;
			wacom_backend_wacom_tool_map_keyfile_add_stylus (self, _tmp7_, _tmp9_);
			tools_changed = TRUE;
			_tmp10_ = self->priv->tool_map;
			_tmp11_ = tool_key;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp11_, tool);
		} else {
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_;
			WacomBackendWacomTool* _tmp15_;
			gboolean _tmp16_;
			_tmp12_ = self->priv->tool_map;
			_tmp13_ = tool_key;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
			_tmp15_ = (WacomBackendWacomTool*) _tmp14_;
			_tmp16_ = _tmp15_ == NULL;
			_g_object_unref0 (_tmp15_);
			if (_tmp16_) {
				GeeHashMap* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = self->priv->tool_map;
				_tmp18_ = tool_key;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp18_, tool);
			}
		}
	}
	_tmp19_ = self->priv->tablet_map;
	_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, device_key);
	styli = (GeeArrayList*) _tmp20_;
	_tmp21_ = styli;
	if (_tmp21_ == NULL) {
		GeeArrayList* _tmp22_;
		GeeHashMap* _tmp23_;
		GeeArrayList* _tmp24_;
		_tmp22_ = gee_array_list_new (WACOM_BACKEND_TYPE_WACOM_TOOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (styli);
		styli = _tmp22_;
		_tmp23_ = self->priv->tablet_map;
		_tmp24_ = styli;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, device_key, _tmp24_);
	}
	_tmp25_ = styli;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp25_, tool)) {
		const gchar* _tmp26_;
		GeeArrayList* _tmp27_;
		tablets_changed = TRUE;
		_tmp26_ = tool_key;
		wacom_backend_wacom_tool_map_keyfile_add_device_stylus (self, device_key, _tmp26_);
		_tmp27_ = styli;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, tool);
	}
	if (tools_changed) {
		{
			GKeyFile* _tmp28_;
			const gchar* _tmp29_;
			_tmp28_ = self->priv->tools;
			_tmp29_ = self->priv->tool_path;
			g_key_file_save_to_file (_tmp28_, _tmp29_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_object_unref0 (styli);
				_g_free0 (tool_key);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp30_;
			GError* _tmp31_;
			const gchar* _tmp32_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp30_ = self->priv->tool_path;
			_tmp31_ = e;
			_tmp32_ = _tmp31_->message;
			g_warning ("WacomToolMap.vala:186: Error saving tools keyfile '%s': %s", _tmp30_, _tmp32_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (styli);
			_g_free0 (tool_key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (tablets_changed) {
		{
			GKeyFile* _tmp33_;
			const gchar* _tmp34_;
			_tmp33_ = self->priv->tablets;
			_tmp34_ = self->priv->tablet_path;
			g_key_file_save_to_file (_tmp33_, _tmp34_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch1_g_file_error;
				}
				_g_object_unref0 (styli);
				_g_free0 (tool_key);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally1;
		__catch1_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp35_;
			GError* _tmp36_;
			const gchar* _tmp37_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp35_ = self->priv->tablet_path;
			_tmp36_ = e;
			_tmp37_ = _tmp36_->message;
			g_warning ("WacomToolMap.vala:194: Error saving tablets keyfile '%s': %s", _tmp35_, _tmp37_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (styli);
			_g_free0 (tool_key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (styli);
	_g_free0 (tool_key);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
wacom_backend_wacom_tool_map_keyfile_add_device_stylus (WacomBackendWacomToolMap* self,
                                                        const gchar* device_key,
                                                        const gchar* tool_key)
{
	gchar** styli = NULL;
	gint styli_length1;
	gint _styli_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp7_;
	GKeyFile* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_key != NULL);
	g_return_if_fail (tool_key != NULL);
	styli = NULL;
	styli_length1 = 0;
	_styli_size_ = styli_length1;
	{
		gchar** _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		gsize _tmp2_ = 0;
		gchar** _tmp3_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = self->priv->tablets;
		_tmp3_ = g_key_file_get_string_list (_tmp1_, device_key, WACOM_BACKEND_WACOM_TOOL_MAP_KEY_DEVICE_STYLI, &_tmp2_, &_inner_error0_);
		_tmp0_ = _tmp3_;
		_tmp0__length1 = _tmp2_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = _tmp0_;
		_tmp4__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
		styli = _tmp4_;
		styli_length1 = _tmp4__length1;
		_styli_size_ = styli_length1;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = styli;
	_tmp5__length1 = styli_length1;
	if (_tmp5_ == NULL) {
		gchar** _tmp6_;
		_tmp6_ = g_new0 (gchar*, 0 + 1);
		styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
		styli = _tmp6_;
		styli_length1 = 0;
		_styli_size_ = styli_length1;
	}
	_tmp7_ = g_strdup (tool_key);
	_vala_array_add1 (&styli, &styli_length1, &_styli_size_, _tmp7_);
	_tmp8_ = self->priv->tablets;
	_tmp9_ = styli;
	_tmp9__length1 = styli_length1;
	g_key_file_set_string_list (_tmp8_, device_key, WACOM_BACKEND_WACOM_TOOL_MAP_KEY_DEVICE_STYLI, (const gchar* const*) _tmp9_, (gint) _tmp9__length1);
	styli = (_vala_array_free (styli, styli_length1, (GDestroyNotify) g_free), NULL);
}

static void
wacom_backend_wacom_tool_map_keyfile_add_stylus (WacomBackendWacomToolMap* self,
                                                 const gchar* tool_key,
                                                 guint64 id)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool_key != NULL);
	_tmp0_ = wacom_backend_wacom_tool_map_get_tool_key (id);
	str = _tmp0_;
	_tmp1_ = self->priv->tools;
	g_key_file_set_string (_tmp1_, tool_key, WACOM_BACKEND_WACOM_TOOL_MAP_KEY_TOOL_ID, str);
	_g_free0 (str);
}

WacomBackendWacomTool*
wacom_backend_wacom_tool_map_lookup_tool (WacomBackendWacomToolMap* self,
                                          guint64 serial,
                                          const gchar* device_key)
{
	WacomBackendWacomTool* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_key != NULL, NULL);
	if (serial == ((guint64) 0)) {
		GeeHashMap* _tmp0_;
		gpointer _tmp1_;
		_tmp0_ = self->priv->no_serial_tool_map;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, device_key);
		result = (WacomBackendWacomTool*) _tmp1_;
		return result;
	} else {
		GeeHashMap* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gpointer _tmp5_;
		WacomBackendWacomTool* _tmp6_;
		_tmp2_ = self->priv->tool_map;
		_tmp3_ = wacom_backend_wacom_tool_map_get_tool_key (serial);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp4_);
		_tmp6_ = (WacomBackendWacomTool*) _tmp5_;
		_g_free0 (_tmp4_);
		result = _tmp6_;
		return result;
	}
}

static void
_vala_WacomError_free_function_address_of (WacomError* self)
{
	libwacom_error_free (&self);
}

GeeArrayList*
wacom_backend_wacom_tool_map_list_tools (WacomBackendWacomToolMap* self,
                                         WacomBackendDevice* device,
                                         GError** error)
{
	GeeArrayList* styli = NULL;
	GeeArrayList* _tmp0_;
	gchar* key = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GeeArrayList* tablet_tools = NULL;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_;
	GeeArrayList* _tmp9_;
	GeeHashMap* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = gee_array_list_new (WACOM_BACKEND_TYPE_WACOM_TOOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	styli = _tmp0_;
	_tmp1_ = wacom_backend_device_get_vendor_id (device);
	_tmp2_ = _tmp1_;
	_tmp3_ = wacom_backend_device_get_product_id (device);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s:%s", _tmp2_, _tmp4_);
	key = _tmp5_;
	_tmp6_ = self->priv->tablet_map;
	_tmp7_ = key;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
	tablet_tools = (GeeArrayList*) _tmp8_;
	_tmp9_ = tablet_tools;
	if (_tmp9_ != NULL) {
		GeeArrayList* _tmp10_;
		GeeHashMap* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_;
		GeeArrayList* _tmp14_;
		_tmp10_ = styli;
		_tmp11_ = self->priv->tablet_map;
		_tmp12_ = key;
		_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
		_tmp14_ = (GeeArrayList*) _tmp13_;
		gee_array_list_add_all (_tmp10_, (GeeCollection*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->no_serial_tool_map;
	_tmp16_ = key;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp15_, _tmp16_)) {
		WacomBackendWacomTool* no_serial_tool = NULL;
		GeeHashMap* _tmp17_;
		const gchar* _tmp18_;
		gpointer _tmp19_;
		WacomBackendWacomTool* _tmp20_;
		GeeArrayList* _tmp50_;
		WacomBackendWacomTool* _tmp51_;
		_tmp17_ = self->priv->no_serial_tool_map;
		_tmp18_ = key;
		_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
		no_serial_tool = (WacomBackendWacomTool*) _tmp19_;
		_tmp20_ = no_serial_tool;
		if (_tmp20_ == NULL) {
			WacomDeviceDatabase* _tmp21_;
			WacomError* _error_ = NULL;
			WacomError* _tmp23_;
			WacomDevice* wacom_device = NULL;
			WacomDeviceDatabase* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			WacomError* _tmp27_;
			WacomDevice* _tmp28_;
			WacomDevice* _tmp29_;
			gint id = 0;
			gint* supported_styli = NULL;
			WacomDevice* _tmp34_;
			gint _tmp35_ = 0;
			gint* _tmp36_;
			gint supported_styli_length1;
			gint _supported_styli_size_;
			gint* _tmp37_;
			gint _tmp37__length1;
			gchar* settings_path = NULL;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			const gchar* _tmp45_;
			WacomBackendWacomTool* _tmp46_;
			GeeHashMap* _tmp47_;
			const gchar* _tmp48_;
			WacomBackendWacomTool* _tmp49_;
			_tmp21_ = wacom_backend_wacom_tool_map_wacom_db;
			if (_tmp21_ == NULL) {
				WacomDeviceDatabase* _tmp22_;
				_tmp22_ = libwacom_database_new ();
				_libwacom_database_destroy0 (wacom_backend_wacom_tool_map_wacom_db);
				wacom_backend_wacom_tool_map_wacom_db = _tmp22_;
			}
			_tmp23_ = libwacom_error_new ();
			_error_ = _tmp23_;
			_tmp24_ = wacom_backend_wacom_tool_map_wacom_db;
			_tmp25_ = wacom_backend_device_get_device_file (device);
			_tmp26_ = _tmp25_;
			_tmp27_ = _error_;
			_tmp28_ = libwacom_new_from_path (_tmp24_, _tmp26_, WFALLBACK_NONE, _tmp27_);
			wacom_device = _tmp28_;
			_tmp29_ = wacom_device;
			if (_tmp29_ == NULL) {
				const gchar* _tmp30_ = NULL;
				WacomError* _tmp31_;
				const gchar* _tmp32_;
				GError* _tmp33_;
				_tmp31_ = _error_;
				_tmp32_ = libwacom_error_get_message (_tmp31_);
				_tmp30_ = _tmp32_;
				if (_tmp30_ == NULL) {
					_tmp30_ = "";
				}
				_tmp33_ = g_error_new_literal (WACOM_EXCEPTION, WACOM_EXCEPTION_LIBWACOM_ERROR, _tmp30_);
				_inner_error0_ = _tmp33_;
				if (_inner_error0_->domain == WACOM_EXCEPTION) {
					g_propagate_error (error, _inner_error0_);
					_libwacom_destroy0 (wacom_device);
					__vala_WacomError_free_function_address_of0 (_error_);
					_g_object_unref0 (no_serial_tool);
					_g_object_unref0 (tablet_tools);
					_g_free0 (key);
					_g_object_unref0 (styli);
					return NULL;
				} else {
					_libwacom_destroy0 (wacom_device);
					__vala_WacomError_free_function_address_of0 (_error_);
					_g_object_unref0 (no_serial_tool);
					_g_object_unref0 (tablet_tools);
					_g_free0 (key);
					_g_object_unref0 (styli);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			id = 0;
			_tmp34_ = wacom_device;
			_tmp36_ = libwacom_get_supported_styli (_tmp34_, &_tmp35_);
			supported_styli = _tmp36_;
			supported_styli_length1 = _tmp35_;
			_supported_styli_size_ = supported_styli_length1;
			_tmp37_ = supported_styli;
			_tmp37__length1 = supported_styli_length1;
			if (_tmp37__length1 > 0) {
				gint* _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				_tmp38_ = supported_styli;
				_tmp38__length1 = supported_styli_length1;
				_tmp39_ = _tmp38_[0];
				id = _tmp39_;
			}
			_tmp40_ = wacom_backend_device_get_vendor_id (device);
			_tmp41_ = _tmp40_;
			_tmp42_ = wacom_backend_device_get_product_id (device);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strdup_printf ("/org/gnome/desktop/peripherals/stylus/default-%s:%s/", _tmp41_, _tmp43_);
			settings_path = _tmp44_;
			_tmp45_ = settings_path;
			_tmp46_ = wacom_backend_wacom_tool_new ((guint64) 0, (guint64) id, _tmp45_);
			_g_object_unref0 (no_serial_tool);
			no_serial_tool = _tmp46_;
			_tmp47_ = self->priv->no_serial_tool_map;
			_tmp48_ = key;
			_tmp49_ = no_serial_tool;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp47_, _tmp48_, _tmp49_);
			_g_free0 (settings_path);
			supported_styli = (g_free (supported_styli), NULL);
			_libwacom_destroy0 (wacom_device);
			__vala_WacomError_free_function_address_of0 (_error_);
		}
		_tmp50_ = styli;
		_tmp51_ = no_serial_tool;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
		_g_object_unref0 (no_serial_tool);
	}
	result = styli;
	_g_object_unref0 (tablet_tools);
	_g_free0 (key);
	return result;
}

static void
wacom_backend_wacom_tool_map_class_init (WacomBackendWacomToolMapClass * klass,
                                         gpointer klass_data)
{
	wacom_backend_wacom_tool_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomBackendWacomToolMap_private_offset);
	G_OBJECT_CLASS (klass)->finalize = wacom_backend_wacom_tool_map_finalize;
}

static void
wacom_backend_wacom_tool_map_instance_init (WacomBackendWacomToolMap * self,
                                            gpointer klass)
{
	self->priv = wacom_backend_wacom_tool_map_get_instance_private (self);
}

static void
wacom_backend_wacom_tool_map_finalize (GObject * obj)
{
	WacomBackendWacomToolMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_BACKEND_TYPE_WACOM_TOOL_MAP, WacomBackendWacomToolMap);
	_g_key_file_unref0 (self->priv->tablets);
	_g_key_file_unref0 (self->priv->tools);
	_g_free0 (self->priv->tablet_path);
	_g_free0 (self->priv->tool_path);
	_g_object_unref0 (self->priv->tablet_map);
	_g_object_unref0 (self->priv->tool_map);
	_g_object_unref0 (self->priv->no_serial_tool_map);
	G_OBJECT_CLASS (wacom_backend_wacom_tool_map_parent_class)->finalize (obj);
}

static GType
wacom_backend_wacom_tool_map_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomBackendWacomToolMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_backend_wacom_tool_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomBackendWacomToolMap), 0, (GInstanceInitFunc) wacom_backend_wacom_tool_map_instance_init, NULL };
	GType wacom_backend_wacom_tool_map_type_id;
	wacom_backend_wacom_tool_map_type_id = g_type_register_static (G_TYPE_OBJECT, "WacomBackendWacomToolMap", &g_define_type_info, 0);
	WacomBackendWacomToolMap_private_offset = g_type_add_instance_private (wacom_backend_wacom_tool_map_type_id, sizeof (WacomBackendWacomToolMapPrivate));
	return wacom_backend_wacom_tool_map_type_id;
}

GType
wacom_backend_wacom_tool_map_get_type (void)
{
	static volatile gsize wacom_backend_wacom_tool_map_type_id__once = 0;
	if (g_once_init_enter (&wacom_backend_wacom_tool_map_type_id__once)) {
		GType wacom_backend_wacom_tool_map_type_id;
		wacom_backend_wacom_tool_map_type_id = wacom_backend_wacom_tool_map_get_type_once ();
		g_once_init_leave (&wacom_backend_wacom_tool_map_type_id__once, wacom_backend_wacom_tool_map_type_id);
	}
	return wacom_backend_wacom_tool_map_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

