/* utils.c generated by valac 0.56.17, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "synapse-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <gee.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseUtilsQueryExistsAsyncData SynapseUtilsQueryExistsAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef enum  {
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_BLACK,
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_RED,
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_GREEN,
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_YELLOW,
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_BLUE,
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_MAGENTA,
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_CYAN,
	SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_WHITE
} SynapseUtilsLoggerConsoleColor;

#define SYNAPSE_UTILS_LOGGER_TYPE_CONSOLE_COLOR (synapse_utils_logger_console_color_get_type ())

#define SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE (synapse_utils_logger_log_message_get_type ())
#define SYNAPSE_UTILS_LOGGER_LOG_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, SynapseUtilsLoggerLogMessage))
#define SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, SynapseUtilsLoggerLogMessageClass))
#define SYNAPSE_UTILS_LOGGER_IS_LOG_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE))
#define SYNAPSE_UTILS_LOGGER_IS_LOG_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE))
#define SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, SynapseUtilsLoggerLogMessageClass))

typedef struct _SynapseUtilsLoggerLogMessage SynapseUtilsLoggerLogMessage;
typedef struct _SynapseUtilsLoggerLogMessageClass SynapseUtilsLoggerLogMessageClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _SynapseUtilsLoggerLogMessagePrivate SynapseUtilsLoggerLogMessagePrivate;
enum  {
	SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_0_PROPERTY,
	SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_LEVEL_PROPERTY,
	SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_MESSAGE_PROPERTY,
	SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_NUM_PROPERTIES
};
static GParamSpec* synapse_utils_logger_log_message_properties[SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_NUM_PROPERTIES];
typedef struct _SynapseUtilsParamSpecLogger SynapseUtilsParamSpecLogger;
typedef struct _SynapseUtilsDelegateWrapper SynapseUtilsDelegateWrapper;
typedef enum  {
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED,
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS,
	SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE
} SynapseUtilsAsyncOnceOperationState;

#define SYNAPSE_UTILS_ASYNC_ONCE_TYPE_OPERATION_STATE (synapse_utils_async_once_operation_state_get_type ())
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
typedef struct _SynapseUtilsAsyncOnceEnterData SynapseUtilsAsyncOnceEnterData;
typedef struct _SynapseUtilsAsyncOnceWaitAsyncData SynapseUtilsAsyncOnceWaitAsyncData;
typedef struct _SynapseUtilsParamSpecAsyncOnce SynapseUtilsParamSpecAsyncOnce;
#define _synapse_utils_file_info_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_file_info_unref (var), NULL)))
typedef struct _SynapseUtilsFileInfoInitializeData SynapseUtilsFileInfoInitializeData;
typedef struct _SynapseUtilsFileInfoExistsData SynapseUtilsFileInfoExistsData;
typedef struct _SynapseUtilsParamSpecFileInfo SynapseUtilsParamSpecFileInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SynapseUtilsQueryExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* f;
	gboolean result;
	gboolean exists;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GError* _inner_error0_;
};

struct _SynapseUtilsLoggerLogMessage {
	GObject parent_instance;
	SynapseUtilsLoggerLogMessagePrivate * priv;
};

struct _SynapseUtilsLoggerLogMessageClass {
	GObjectClass parent_class;
};

struct _SynapseUtilsLoggerLogMessagePrivate {
	SynapseUtilsLoggerLogLevel _Level;
	gchar* _Message;
};

struct _SynapseUtilsParamSpecLogger {
	GParamSpec parent_instance;
};

struct _SynapseUtilsDelegateWrapper {
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _SynapseUtilsAsyncOncePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer inner;
	SynapseUtilsAsyncOnceOperationState state;
	SynapseUtilsDelegateWrapper** callbacks;
	gint callbacks_length1;
	gint _callbacks_size_;
};

struct _SynapseUtilsAsyncOnceEnterData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsAsyncOnce* self;
	gboolean result;
};

struct _SynapseUtilsAsyncOnceWaitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsAsyncOnce* self;
	SynapseUtilsDelegateWrapper* _tmp0_;
};

struct _SynapseUtilsParamSpecAsyncOnce {
	GParamSpec parent_instance;
};

struct _SynapseUtilsFileInfoPrivate {
	gboolean initialized;
	GType match_obj_type;
};

struct _SynapseUtilsFileInfoInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsFileInfo* self;
	GFile* f;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* fi;
	const gchar* _tmp2_;
	GFileInfo* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	GIcon* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GObject* _tmp14_;
	GObject* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* mime_type;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	SynapseUriMatch* _tmp24_;
	SynapseUriMatch* _tmp25_;
	const gchar* _tmp26_;
	GError* err;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _inner_error0_;
};

struct _SynapseUtilsFileInfoExistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseUtilsFileInfo* self;
	gboolean result;
	GFile* f;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean _result_;
};

struct _SynapseUtilsParamSpecFileInfo {
	GParamSpec parent_instance;
};

static gpointer synapse_utils_logger_parent_class = NULL;
static SynapseUtilsLoggerLogLevel synapse_utils_logger__DisplayLevel;
static SynapseUtilsLoggerLogLevel synapse_utils_logger__DisplayLevel = SYNAPSE_UTILS_LOGGER_LOG_LEVEL_WARN;
static GObject* synapse_utils_logger_queue_lock;
static GRecMutex __lock_synapse_utils_logger_synapse_utils_logger_queue_lock = {0};
static GObject* synapse_utils_logger_queue_lock = NULL;
static GeeArrayList* synapse_utils_logger_log_queue;
static GeeArrayList* synapse_utils_logger_log_queue = NULL;
static gboolean synapse_utils_logger_is_writing;
static gboolean synapse_utils_logger_is_writing = FALSE;
static GRegex* synapse_utils_logger_re;
static GRegex* synapse_utils_logger_re = NULL;
static gint SynapseUtilsLoggerLogMessage_private_offset;
static gpointer synapse_utils_logger_log_message_parent_class = NULL;
static gint SynapseUtilsAsyncOnce_private_offset;
static gpointer synapse_utils_async_once_parent_class = NULL;
static gint SynapseUtilsFileInfo_private_offset;
static gpointer synapse_utils_file_info_parent_class = NULL;
static gchar* synapse_utils_file_info_interesting_attributes;
static gchar* synapse_utils_file_info_interesting_attributes = NULL;

static void synapse_utils_query_exists_async_data_free (gpointer _data);
static gboolean synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* _data_);
static void synapse_utils_query_exists_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GType synapse_utils_logger_console_color_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType synapse_utils_logger_log_message_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseUtilsLogger* synapse_utils_logger_new (void);
static SynapseUtilsLogger* synapse_utils_logger_construct (GType object_type);
static void synapse_utils_logger_glib_log_func (const gchar* d,
                                         GLogLevelFlags flags,
                                         const gchar* msg);
static void _synapse_utils_logger_glib_log_func_glog_func (const gchar* log_domain,
                                                    GLogLevelFlags log_levels,
                                                    const gchar* message,
                                                    gpointer self);
static gchar* synapse_utils_logger_format_message (const gchar* msg);
static gchar* synapse_utils_logger_get_time (void);
static void synapse_utils_logger_write (SynapseUtilsLoggerLogLevel level,
                                 const gchar* msg);
static SynapseUtilsLoggerLogMessage* synapse_utils_logger_log_message_new (SynapseUtilsLoggerLogLevel level,
                                                                    const gchar* message);
static SynapseUtilsLoggerLogMessage* synapse_utils_logger_log_message_construct (GType object_type,
                                                                          SynapseUtilsLoggerLogLevel level,
                                                                          const gchar* message);
static void synapse_utils_logger_print_log (SynapseUtilsLoggerLogMessage* log);
static void synapse_utils_logger_set_color_for_level (SynapseUtilsLoggerLogLevel level);
static SynapseUtilsLoggerLogLevel synapse_utils_logger_log_message_get_Level (SynapseUtilsLoggerLogMessage* self);
static void synapse_utils_logger_reset_color (void);
static const gchar* synapse_utils_logger_log_message_get_Message (SynapseUtilsLoggerLogMessage* self);
static void synapse_utils_logger_set_foreground (SynapseUtilsLoggerConsoleColor color);
static void synapse_utils_logger_set_background (SynapseUtilsLoggerConsoleColor color);
static void synapse_utils_logger_set_color (SynapseUtilsLoggerConsoleColor color,
                                     gboolean isForeground);
static void synapse_utils_logger_log_message_set_Level (SynapseUtilsLoggerLogMessage* self,
                                                 SynapseUtilsLoggerLogLevel value);
static void synapse_utils_logger_log_message_set_Message (SynapseUtilsLoggerLogMessage* self,
                                                   const gchar* value);
static void synapse_utils_logger_log_message_finalize (GObject * obj);
static GType synapse_utils_logger_log_message_get_type_once (void);
static void _vala_synapse_utils_logger_log_message_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_synapse_utils_logger_log_message_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void synapse_utils_logger_finalize (SynapseUtilsLogger * obj);
static GType synapse_utils_logger_get_type_once (void);
VALA_EXTERN void synapse_utils_delegate_wrapper_free (SynapseUtilsDelegateWrapper * self);
static void synapse_utils_delegate_wrapper_instance_init (SynapseUtilsDelegateWrapper * self);
VALA_EXTERN SynapseUtilsDelegateWrapper* synapse_utils_delegate_wrapper_new (GSourceFunc cb,
                                                                 gpointer cb_target,
                                                                 GDestroyNotify cb_target_destroy_notify);
static GType synapse_utils_async_once_operation_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_utils_async_once_enter_data_free (gpointer _data);
static gboolean synapse_utils_async_once_enter_co (SynapseUtilsAsyncOnceEnterData* _data_);
static void synapse_utils_async_once_wait_async (SynapseUtilsAsyncOnce* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void synapse_utils_async_once_wait_finish (SynapseUtilsAsyncOnce* self,
                                           GAsyncResult* _res_);
static void synapse_utils_async_once_enter_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void synapse_utils_async_once_notify_all (SynapseUtilsAsyncOnce* self);
static void synapse_utils_async_once_wait_async_data_free (gpointer _data);
static gboolean synapse_utils_async_once_wait_async_co (SynapseUtilsAsyncOnceWaitAsyncData* _data_);
static gboolean _synapse_utils_async_once_wait_async_co_gsource_func (gpointer self);
static void _vala_array_add8 (SynapseUtilsDelegateWrapper** * array,
                       gint* length,
                       gint* size,
                       SynapseUtilsDelegateWrapper* value);
static void synapse_utils_async_once_finalize (SynapseUtilsAsyncOnce * obj);
static GType synapse_utils_async_once_get_type_once (void);
static void synapse_utils_file_info_initialize_data_free (gpointer _data);
static gboolean synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* _data_);
static void synapse_utils_file_info_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void synapse_utils_file_info_exists_data_free (gpointer _data);
static gboolean synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* _data_);
static void synapse_utils_file_info_exists_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void synapse_utils_file_info_finalize (SynapseUtilsFileInfo * obj);
static GType synapse_utils_file_info_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
synapse_utils_remove_accents (const gchar* input)
{
	gchar* _result_ = NULL;
	const gchar* charset = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 29 "utils.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 33 "utils.vala"
	g_get_charset (&_tmp0_);
#line 33 "utils.vala"
	charset = _tmp0_;
#line 371 "utils.c"
	{
		gchar* _tmp1_ = NULL;
		gint _tmp2_;
		gint _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
#line 36 "utils.vala"
		_tmp2_ = strlen (input);
#line 36 "utils.vala"
		_tmp3_ = _tmp2_;
#line 36 "utils.vala"
		_tmp4_ = charset;
#line 36 "utils.vala"
		_tmp5_ = g_convert (input, (gssize) _tmp3_, "US-ASCII//TRANSLIT", _tmp4_, NULL, NULL, &_inner_error0_);
#line 36 "utils.vala"
		_tmp1_ = _tmp5_;
#line 36 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 36 "utils.vala"
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 394 "utils.c"
				goto __catch0_g_convert_error;
			}
#line 36 "utils.vala"
			_g_free0 (_result_);
#line 36 "utils.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 36 "utils.vala"
			g_clear_error (&_inner_error0_);
#line 36 "utils.vala"
			return NULL;
#line 405 "utils.c"
		}
#line 36 "utils.vala"
		_tmp6_ = _tmp1_;
#line 36 "utils.vala"
		_tmp1_ = NULL;
#line 36 "utils.vala"
		_g_free0 (_result_);
#line 36 "utils.vala"
		_result_ = _tmp6_;
#line 39 "utils.vala"
		_tmp7_ = _result_;
#line 39 "utils.vala"
		if (g_strcmp0 (input, _tmp7_) == 0) {
#line 39 "utils.vala"
			result = NULL;
#line 39 "utils.vala"
			_g_free0 (_tmp1_);
#line 39 "utils.vala"
			_g_free0 (_result_);
#line 39 "utils.vala"
			return result;
#line 427 "utils.c"
		}
#line 34 "utils.vala"
		_g_free0 (_tmp1_);
#line 431 "utils.c"
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
#line 34 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 43 "utils.vala"
		_g_free0 (_result_);
#line 43 "utils.vala"
		_result_ = NULL;
#line 442 "utils.c"
	}
	__finally0:
#line 34 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 34 "utils.vala"
		_g_free0 (_result_);
#line 34 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 34 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 34 "utils.vala"
		return NULL;
#line 455 "utils.c"
	}
#line 46 "utils.vala"
	result = _result_;
#line 46 "utils.vala"
	return result;
#line 461 "utils.c"
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
#line 1333 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1334 "glib-2.0.vapi"
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
#line 1334 "glib-2.0.vapi"
	result = (gint) (_tmp0_ - ((gchar*) self));
#line 1334 "glib-2.0.vapi"
	return result;
#line 478 "utils.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 501 "utils.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 510 "utils.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 529 "utils.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 533 "utils.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 539 "utils.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 549 "utils.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 557 "utils.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 561 "utils.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 567 "utils.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 577 "utils.c"
}

gchar*
synapse_utils_remove_last_unichar (const gchar* input)
{
	glong char_count = 0L;
	gint len = 0;
	gchar* _tmp0_;
	gchar* result;
#line 49 "utils.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 51 "utils.vala"
	char_count = (glong) g_utf8_strlen (input, (gssize) -1);
#line 53 "utils.vala"
	len = string_index_of_nth_char (input, char_count - 1);
#line 54 "utils.vala"
	_tmp0_ = string_substring (input, (glong) 0, (glong) len);
#line 54 "utils.vala"
	result = _tmp0_;
#line 54 "utils.vala"
	return result;
#line 599 "utils.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 613 "utils.c"
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
#line 1341 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1342 "glib-2.0.vapi"
	if (0 < (*index)) {
#line 627 "utils.c"
		gchar* _tmp0_;
#line 1343 "glib-2.0.vapi"
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
#line 1343 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1344 "glib-2.0.vapi"
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1345 "glib-2.0.vapi"
		result = TRUE;
#line 1345 "glib-2.0.vapi"
		if (c) {
#line 1345 "glib-2.0.vapi"
			*c = _vala_c;
#line 641 "utils.c"
		}
#line 1345 "glib-2.0.vapi"
		return result;
#line 645 "utils.c"
	} else {
#line 1347 "glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1348 "glib-2.0.vapi"
		result = FALSE;
#line 1348 "glib-2.0.vapi"
		if (c) {
#line 1348 "glib-2.0.vapi"
			*c = _vala_c;
#line 655 "utils.c"
		}
#line 1348 "glib-2.0.vapi"
		return result;
#line 659 "utils.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 687 "utils.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 693 "utils.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 699 "utils.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 703 "utils.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 711 "utils.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 715 "utils.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 727 "utils.c"
}

gchar*
synapse_utils_remove_last_word (const gchar* input)
{
	glong char_count = 0L;
	gint index = 0;
	gunichar pchar = 0U;
	gint next_index = 0;
	gchar* result;
#line 57 "utils.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 59 "utils.vala"
	char_count = (glong) g_utf8_strlen (input, (gssize) -1);
#line 60 "utils.vala"
	index = string_index_of_nth_char (input, char_count - 1);
#line 61 "utils.vala"
	pchar = string_get_char (input, (glong) index);
#line 63 "utils.vala"
	while (TRUE) {
#line 748 "utils.c"
		gboolean _tmp0_ = FALSE;
		gunichar _tmp1_ = 0U;
#line 63 "utils.vala"
		if (pchar == ((gunichar) ' ')) {
#line 63 "utils.vala"
			_tmp0_ = index > 0;
#line 755 "utils.c"
		} else {
#line 63 "utils.vala"
			_tmp0_ = FALSE;
#line 759 "utils.c"
		}
#line 63 "utils.vala"
		if (!_tmp0_) {
#line 63 "utils.vala"
			break;
#line 765 "utils.c"
		}
#line 65 "utils.vala"
		string_get_prev_char (input, &index, &_tmp1_);
#line 65 "utils.vala"
		pchar = _tmp1_;
#line 771 "utils.c"
	}
#line 68 "utils.vala"
	next_index = index;
#line 775 "utils.c"
	{
		gboolean _tmp2_ = FALSE;
#line 70 "utils.vala"
		_tmp2_ = TRUE;
#line 70 "utils.vala"
		while (TRUE) {
#line 782 "utils.c"
			gunichar _tmp4_ = 0U;
#line 70 "utils.vala"
			if (!_tmp2_) {
#line 786 "utils.c"
				gboolean _tmp3_ = FALSE;
#line 75 "utils.vala"
				if (pchar != ((gunichar) ' ')) {
#line 75 "utils.vala"
					_tmp3_ = next_index > 0;
#line 792 "utils.c"
				} else {
#line 75 "utils.vala"
					_tmp3_ = FALSE;
#line 796 "utils.c"
				}
#line 75 "utils.vala"
				if (!_tmp3_) {
#line 75 "utils.vala"
					break;
#line 802 "utils.c"
				}
			}
#line 70 "utils.vala"
			_tmp2_ = FALSE;
#line 72 "utils.vala"
			index = next_index;
#line 73 "utils.vala"
			string_get_prev_char (input, &next_index, &_tmp4_);
#line 73 "utils.vala"
			pchar = _tmp4_;
#line 813 "utils.c"
		}
	}
#line 77 "utils.vala"
	if (next_index <= 0) {
#line 818 "utils.c"
		gchar* _tmp5_;
#line 78 "utils.vala"
		_tmp5_ = g_strdup ("");
#line 78 "utils.vala"
		result = _tmp5_;
#line 78 "utils.vala"
		return result;
#line 826 "utils.c"
	} else {
		gchar* _tmp6_;
#line 80 "utils.vala"
		_tmp6_ = string_slice (input, (glong) 0, (glong) index);
#line 80 "utils.vala"
		result = _tmp6_;
#line 80 "utils.vala"
		return result;
#line 835 "utils.c"
	}
}

static void
synapse_utils_query_exists_async_data_free (gpointer _data)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
	_data_ = _data;
#line 239 "data-sink.vala"
	_g_object_unref0 (_data_->f);
#line 239 "data-sink.vala"
	g_slice_free (SynapseUtilsQueryExistsAsyncData, _data_);
#line 848 "utils.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 239 "data-sink.vala"
	return self ? g_object_ref (self) : NULL;
#line 856 "utils.c"
}

void
synapse_utils_query_exists_async (GFile* f,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
	GFile* _tmp0_;
#line 239 "data-sink.vala"
	g_return_if_fail (f != NULL);
#line 239 "data-sink.vala"
	_data_ = g_slice_new0 (SynapseUtilsQueryExistsAsyncData);
#line 239 "data-sink.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 239 "data-sink.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_query_exists_async_data_free);
#line 239 "data-sink.vala"
	_tmp0_ = _g_object_ref0 (f);
#line 239 "data-sink.vala"
	_g_object_unref0 (_data_->f);
#line 239 "data-sink.vala"
	_data_->f = _tmp0_;
#line 239 "data-sink.vala"
	synapse_utils_query_exists_async_co (_data_);
#line 882 "utils.c"
}

gboolean
synapse_utils_query_exists_finish (GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsQueryExistsAsyncData* _data_;
#line 239 "data-sink.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 239 "data-sink.vala"
	result = _data_->result;
#line 239 "data-sink.vala"
	return result;
#line 896 "utils.c"
}

static void
synapse_utils_query_exists_async_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SynapseUtilsQueryExistsAsyncData* _data_;
#line 88 "utils.vala"
	_data_ = _user_data_;
#line 88 "utils.vala"
	_data_->_source_object_ = source_object;
#line 88 "utils.vala"
	_data_->_res_ = _res_;
#line 88 "utils.vala"
	synapse_utils_query_exists_async_co (_data_);
#line 913 "utils.c"
}

static gboolean
synapse_utils_query_exists_async_co (SynapseUtilsQueryExistsAsyncData* _data_)
{
#line 83 "utils.vala"
	switch (_data_->_state_) {
#line 83 "utils.vala"
		case 0:
#line 923 "utils.c"
		goto _state_0;
#line 83 "utils.vala"
		case 1:
#line 927 "utils.c"
		goto _state_1;
		default:
#line 83 "utils.vala"
		g_assert_not_reached ();
#line 932 "utils.c"
	}
	_state_0:
	{
#line 88 "utils.vala"
		_data_->_state_ = 1;
#line 88 "utils.vala"
		g_file_query_info_async (_data_->f, G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_utils_query_exists_async_ready, _data_);
#line 88 "utils.vala"
		return FALSE;
#line 942 "utils.c"
		_state_1:
#line 88 "utils.vala"
		_data_->_tmp0_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error0_);
#line 88 "utils.vala"
		_data_->_tmp1_ = _data_->_tmp0_;
#line 88 "utils.vala"
		_g_object_unref0 (_data_->_tmp1_);
#line 88 "utils.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 952 "utils.c"
			goto __catch0_g_error;
		}
#line 89 "utils.vala"
		_data_->exists = TRUE;
#line 957 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 86 "utils.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 93 "utils.vala"
		_data_->exists = FALSE;
#line 966 "utils.c"
	}
	__finally0:
#line 86 "utils.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 86 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 86 "utils.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 86 "utils.vala"
		g_object_unref (_data_->_async_result);
#line 86 "utils.vala"
		return FALSE;
#line 979 "utils.c"
	}
#line 96 "utils.vala"
	_data_->result = _data_->exists;
#line 96 "utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 96 "utils.vala"
	if (_data_->_state_ != 0) {
#line 96 "utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 96 "utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 991 "utils.c"
		}
	}
#line 96 "utils.vala"
	g_object_unref (_data_->_async_result);
#line 96 "utils.vala"
	return FALSE;
#line 998 "utils.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 107 "utils.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1006 "utils.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 107 "utils.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1014 "utils.c"
}

void
synapse_utils_open_uri (const gchar* uri)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 99 "utils.vala"
	g_return_if_fail (uri != NULL);
#line 101 "utils.vala"
	_tmp0_ = g_file_new_for_uri (uri);
#line 101 "utils.vala"
	f = _tmp0_;
#line 1029 "utils.c"
	{
		GAppInfo* app_info = NULL;
		GFile* _tmp1_;
		GAppInfo* _tmp2_;
		GList* files = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GAppInfo* _tmp5_;
		GList* _tmp6_;
		GdkDisplay* _tmp7_;
		GdkAppLaunchContext* _tmp8_;
		GdkAppLaunchContext* _tmp9_;
#line 104 "utils.vala"
		_tmp1_ = f;
#line 104 "utils.vala"
		_tmp2_ = g_file_query_default_handler (_tmp1_, NULL, &_inner_error0_);
#line 104 "utils.vala"
		app_info = _tmp2_;
#line 104 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1050 "utils.c"
			goto __catch0_g_error;
		}
#line 105 "utils.vala"
		files = NULL;
#line 106 "utils.vala"
		_tmp3_ = f;
#line 106 "utils.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 106 "utils.vala"
		files = g_list_prepend (files, _tmp4_);
#line 107 "utils.vala"
		_tmp5_ = app_info;
#line 107 "utils.vala"
		_tmp6_ = files;
#line 107 "utils.vala"
		_tmp7_ = gdk_display_get_default ();
#line 107 "utils.vala"
		_tmp8_ = gdk_display_get_app_launch_context (_tmp7_);
#line 107 "utils.vala"
		_tmp9_ = _tmp8_;
#line 107 "utils.vala"
		g_app_info_launch (_tmp5_, _tmp6_, (GAppLaunchContext*) _tmp9_, &_inner_error0_);
#line 107 "utils.vala"
		_g_object_unref0 (_tmp9_);
#line 107 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 107 "utils.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 107 "utils.vala"
			_g_object_unref0 (app_info);
#line 1081 "utils.c"
			goto __catch0_g_error;
		}
#line 102 "utils.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 102 "utils.vala"
		_g_object_unref0 (app_info);
#line 1088 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 102 "utils.vala"
		err = _inner_error0_;
#line 102 "utils.vala"
		_inner_error0_ = NULL;
#line 111 "utils.vala"
		_tmp10_ = err;
#line 111 "utils.vala"
		_tmp11_ = _tmp10_->message;
#line 111 "utils.vala"
		g_warning ("utils.vala:111: %s", _tmp11_);
#line 102 "utils.vala"
		_g_error_free0 (err);
#line 1108 "utils.c"
	}
	__finally0:
#line 102 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 102 "utils.vala"
		_g_object_unref0 (f);
#line 102 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 102 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 102 "utils.vala"
		return;
#line 1121 "utils.c"
	}
#line 99 "utils.vala"
	_g_object_unref0 (f);
#line 1125 "utils.c"
}

void
synapse_utils_open_command_line (const gchar* command,
                                 const gchar* app_name,
                                 gboolean needs_terminal)
{
	GAppInfoCreateFlags using_terminal = 0U;
	gchar* commandline = NULL;
	gchar* _tmp0_;
	gchar* application_name = NULL;
	gchar* _tmp1_;
	const gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
#line 115 "utils.vala"
	g_return_if_fail (command != NULL);
#line 117 "utils.vala"
	using_terminal = G_APP_INFO_CREATE_NONE;
#line 118 "utils.vala"
	_tmp0_ = g_strdup (command);
#line 118 "utils.vala"
	commandline = _tmp0_;
#line 119 "utils.vala"
	_tmp1_ = g_strdup (app_name);
#line 119 "utils.vala"
	application_name = _tmp1_;
#line 121 "utils.vala"
	if (needs_terminal) {
#line 1154 "utils.c"
		GSettingsSchema* schema = NULL;
		SynapseDesktopFileService* _tmp2_;
		SynapseDesktopFileService* _tmp3_;
		gboolean _tmp4_;
		GSettingsSchema* _tmp7_;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		const gchar* _tmp17_;
#line 123 "utils.vala"
		schema = NULL;
#line 124 "utils.vala"
		_tmp2_ = synapse_desktop_file_service_get_default ();
#line 124 "utils.vala"
		_tmp3_ = _tmp2_;
#line 124 "utils.vala"
		_tmp4_ = (synapse_desktop_file_service_get_environment (_tmp3_) & SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME) == SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 124 "utils.vala"
		_g_object_unref0 (_tmp3_);
#line 124 "utils.vala"
		if (_tmp4_) {
#line 1175 "utils.c"
			GSettingsSchemaSource* _tmp5_;
			GSettingsSchema* _tmp6_;
#line 126 "utils.vala"
			_tmp5_ = g_settings_schema_source_get_default ();
#line 126 "utils.vala"
			_tmp6_ = g_settings_schema_source_lookup (_tmp5_, "org.gnome.desktop.default-applications.terminal", TRUE);
#line 126 "utils.vala"
			_g_settings_schema_unref0 (schema);
#line 126 "utils.vala"
			schema = _tmp6_;
#line 1186 "utils.c"
		}
#line 128 "utils.vala"
		_tmp7_ = schema;
#line 128 "utils.vala"
		if (_tmp7_ != NULL) {
#line 1192 "utils.c"
			GSettings* settings = NULL;
			GSettingsSchema* _tmp8_;
			GSettings* _tmp9_;
			GSettings* _tmp10_;
			gchar* _tmp11_;
#line 130 "utils.vala"
			_tmp8_ = schema;
#line 130 "utils.vala"
			_tmp9_ = g_settings_new_full (_tmp8_, NULL, NULL);
#line 130 "utils.vala"
			settings = _tmp9_;
#line 131 "utils.vala"
			_tmp10_ = settings;
#line 131 "utils.vala"
			_tmp11_ = g_settings_get_string (_tmp10_, "exec");
#line 131 "utils.vala"
			_g_free0 (application_name);
#line 131 "utils.vala"
			application_name = _tmp11_;
#line 128 "utils.vala"
			_g_object_unref0 (settings);
#line 1214 "utils.c"
		}
#line 134 "utils.vala"
		_tmp13_ = application_name;
#line 134 "utils.vala"
		if (_tmp13_ == NULL) {
#line 1220 "utils.c"
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 134 "utils.vala"
			_tmp14_ = g_find_program_in_path ("x-terminal-emulator");
#line 134 "utils.vala"
			_tmp15_ = _tmp14_;
#line 134 "utils.vala"
			_tmp12_ = _tmp15_ != NULL;
#line 134 "utils.vala"
			_g_free0 (_tmp15_);
#line 1231 "utils.c"
		} else {
#line 134 "utils.vala"
			_tmp12_ = FALSE;
#line 1235 "utils.c"
		}
#line 134 "utils.vala"
		if (_tmp12_) {
#line 1239 "utils.c"
			gchar* _tmp16_;
#line 136 "utils.vala"
			_tmp16_ = g_strdup ("x-terminal-emulator");
#line 136 "utils.vala"
			_g_free0 (application_name);
#line 136 "utils.vala"
			application_name = _tmp16_;
#line 1247 "utils.c"
		}
#line 139 "utils.vala"
		_tmp17_ = application_name;
#line 139 "utils.vala"
		if (_tmp17_ == NULL) {
#line 140 "utils.vala"
			using_terminal = G_APP_INFO_CREATE_NEEDS_TERMINAL;
#line 1255 "utils.c"
		}
#line 121 "utils.vala"
		_g_settings_schema_unref0 (schema);
#line 1259 "utils.c"
	}
#line 143 "utils.vala"
	_tmp18_ = application_name;
#line 143 "utils.vala"
	if (_tmp18_ != NULL) {
#line 1265 "utils.c"
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GQuark _tmp22_ = 0U;
#line 144 "utils.vala"
		static GQuark _tmp21_label0 = 0;
#line 144 "utils.vala"
		static GQuark _tmp21_label1 = 0;
#line 144 "utils.vala"
		_tmp19_ = application_name;
#line 144 "utils.vala"
		_tmp20_ = _tmp19_;
#line 144 "utils.vala"
		_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
#line 144 "utils.vala"
		if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("terminator")))) {
#line 144 "utils.vala"
			switch (0) {
#line 1283 "utils.c"
				default:
				{
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
#line 146 "utils.vala"
					_tmp23_ = application_name;
#line 146 "utils.vala"
					_tmp24_ = commandline;
#line 146 "utils.vala"
					_tmp25_ = g_strdup_printf ("%s -x \"%s\"", _tmp23_, _tmp24_);
#line 146 "utils.vala"
					_g_free0 (commandline);
#line 146 "utils.vala"
					commandline = _tmp25_;
#line 147 "utils.vala"
					break;
#line 1301 "utils.c"
				}
			}
		} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("aterm")))) {
#line 144 "utils.vala"
			switch (0) {
#line 1307 "utils.c"
				default:
				{
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
#line 149 "utils.vala"
					_tmp26_ = application_name;
#line 149 "utils.vala"
					_tmp27_ = commandline;
#line 149 "utils.vala"
					_tmp28_ = g_strdup_printf ("%s -e %s", _tmp26_, _tmp27_);
#line 149 "utils.vala"
					_g_free0 (commandline);
#line 149 "utils.vala"
					commandline = _tmp28_;
#line 150 "utils.vala"
					break;
#line 1325 "utils.c"
				}
			}
		} else {
#line 144 "utils.vala"
			switch (0) {
#line 1331 "utils.c"
				default:
				{
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
#line 154 "utils.vala"
					_tmp29_ = application_name;
#line 154 "utils.vala"
					_tmp30_ = commandline;
#line 154 "utils.vala"
					_tmp31_ = g_strdup_printf ("%s -e '%s'", _tmp29_, _tmp30_);
#line 154 "utils.vala"
					_g_free0 (commandline);
#line 154 "utils.vala"
					commandline = _tmp31_;
#line 155 "utils.vala"
					break;
#line 1349 "utils.c"
				}
			}
		}
	}
	{
		const gchar* _tmp32_;
		GAppInfo* app = NULL;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		GAppInfo* _tmp35_;
		GAppInfo* _tmp36_;
		GdkDisplay* _tmp37_;
		GdkAppLaunchContext* _tmp38_;
		GdkAppLaunchContext* _tmp39_;
#line 160 "utils.vala"
		_tmp32_ = commandline;
#line 160 "utils.vala"
		g_debug ("utils.vala:160: %s", _tmp32_);
#line 161 "utils.vala"
		_tmp33_ = commandline;
#line 161 "utils.vala"
		_tmp34_ = application_name;
#line 161 "utils.vala"
		_tmp35_ = g_app_info_create_from_commandline (_tmp33_, _tmp34_, using_terminal, &_inner_error0_);
#line 161 "utils.vala"
		app = _tmp35_;
#line 161 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1378 "utils.c"
			goto __catch0_g_error;
		}
#line 162 "utils.vala"
		_tmp36_ = app;
#line 162 "utils.vala"
		_tmp37_ = gdk_display_get_default ();
#line 162 "utils.vala"
		_tmp38_ = gdk_display_get_app_launch_context (_tmp37_);
#line 162 "utils.vala"
		_tmp39_ = _tmp38_;
#line 162 "utils.vala"
		g_app_info_launch (_tmp36_, NULL, (GAppLaunchContext*) _tmp39_, &_inner_error0_);
#line 162 "utils.vala"
		_g_object_unref0 (_tmp39_);
#line 162 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 162 "utils.vala"
			_g_object_unref0 (app);
#line 1397 "utils.c"
			goto __catch0_g_error;
		}
#line 158 "utils.vala"
		_g_object_unref0 (app);
#line 1402 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
#line 158 "utils.vala"
		err = _inner_error0_;
#line 158 "utils.vala"
		_inner_error0_ = NULL;
#line 166 "utils.vala"
		_tmp40_ = err;
#line 166 "utils.vala"
		_tmp41_ = _tmp40_->message;
#line 166 "utils.vala"
		g_warning ("utils.vala:166: %s", _tmp41_);
#line 158 "utils.vala"
		_g_error_free0 (err);
#line 1422 "utils.c"
	}
	__finally0:
#line 158 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 158 "utils.vala"
		_g_free0 (application_name);
#line 158 "utils.vala"
		_g_free0 (commandline);
#line 158 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 158 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 158 "utils.vala"
		return;
#line 1437 "utils.c"
	}
#line 115 "utils.vala"
	_g_free0 (application_name);
#line 115 "utils.vala"
	_g_free0 (commandline);
#line 1443 "utils.c"
}

gchar*
synapse_utils_extract_type_name (GType obj_type)
{
	gchar* obj_class = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
#line 172 "utils.vala"
	_tmp0_ = g_type_name (obj_type);
#line 172 "utils.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 172 "utils.vala"
	obj_class = _tmp1_;
#line 173 "utils.vala"
	_tmp2_ = obj_class;
#line 173 "utils.vala"
	if (g_str_has_prefix (_tmp2_, "Synapse")) {
#line 1464 "utils.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 173 "utils.vala"
		_tmp3_ = obj_class;
#line 173 "utils.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 7, (glong) -1);
#line 173 "utils.vala"
		result = _tmp4_;
#line 173 "utils.vala"
		_g_free0 (obj_class);
#line 173 "utils.vala"
		return result;
#line 1477 "utils.c"
	}
#line 175 "utils.vala"
	result = obj_class;
#line 175 "utils.vala"
	return result;
#line 1483 "utils.c"
}

static GType
synapse_utils_logger_log_level_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG, "SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG", "debug"}, {SYNAPSE_UTILS_LOGGER_LOG_LEVEL_INFO, "SYNAPSE_UTILS_LOGGER_LOG_LEVEL_INFO", "info"}, {SYNAPSE_UTILS_LOGGER_LOG_LEVEL_WARN, "SYNAPSE_UTILS_LOGGER_LOG_LEVEL_WARN", "warn"}, {SYNAPSE_UTILS_LOGGER_LOG_LEVEL_ERROR, "SYNAPSE_UTILS_LOGGER_LOG_LEVEL_ERROR", "error"}, {SYNAPSE_UTILS_LOGGER_LOG_LEVEL_FATAL, "SYNAPSE_UTILS_LOGGER_LOG_LEVEL_FATAL", "fatal"}, {0, NULL, NULL}};
	GType synapse_utils_logger_log_level_type_id;
	synapse_utils_logger_log_level_type_id = g_enum_register_static ("SynapseUtilsLoggerLogLevel", values);
	return synapse_utils_logger_log_level_type_id;
}

GType
synapse_utils_logger_log_level_get_type (void)
{
	static volatile gsize synapse_utils_logger_log_level_type_id__once = 0;
	if (g_once_init_enter (&synapse_utils_logger_log_level_type_id__once)) {
		GType synapse_utils_logger_log_level_type_id;
		synapse_utils_logger_log_level_type_id = synapse_utils_logger_log_level_get_type_once ();
		g_once_init_leave (&synapse_utils_logger_log_level_type_id__once, synapse_utils_logger_log_level_type_id);
	}
	return synapse_utils_logger_log_level_type_id__once;
}

static GType
synapse_utils_logger_console_color_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_BLACK, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_BLACK", "black"}, {SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_RED, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_RED", "red"}, {SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_GREEN, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_GREEN", "green"}, {SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_YELLOW, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_YELLOW", "yellow"}, {SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_BLUE, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_BLUE", "blue"}, {SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_MAGENTA, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_MAGENTA", "magenta"}, {SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_CYAN, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_CYAN", "cyan"}, {SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_WHITE, "SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_WHITE", "white"}, {0, NULL, NULL}};
	GType synapse_utils_logger_console_color_type_id;
	synapse_utils_logger_console_color_type_id = g_enum_register_static ("SynapseUtilsLoggerConsoleColor", values);
	return synapse_utils_logger_console_color_type_id;
}

static GType
synapse_utils_logger_console_color_get_type (void)
{
	static volatile gsize synapse_utils_logger_console_color_type_id__once = 0;
	if (g_once_init_enter (&synapse_utils_logger_console_color_type_id__once)) {
		GType synapse_utils_logger_console_color_type_id;
		synapse_utils_logger_console_color_type_id = synapse_utils_logger_console_color_get_type_once ();
		g_once_init_leave (&synapse_utils_logger_console_color_type_id__once, synapse_utils_logger_console_color_type_id);
	}
	return synapse_utils_logger_console_color_type_id__once;
}

static SynapseUtilsLogger*
synapse_utils_logger_construct (GType object_type)
{
	SynapseUtilsLogger* self = NULL;
#line 228 "utils.vala"
	self = (SynapseUtilsLogger*) g_type_create_instance (object_type);
#line 228 "utils.vala"
	return self;
#line 1536 "utils.c"
}

static SynapseUtilsLogger*
synapse_utils_logger_new (void)
{
#line 228 "utils.vala"
	return synapse_utils_logger_construct (SYNAPSE_UTILS_TYPE_LOGGER);
#line 1544 "utils.c"
}

/**
       * Initializes the logger for the application.
       */
static void
_synapse_utils_logger_glib_log_func_glog_func (const gchar* log_domain,
                                               GLogLevelFlags log_levels,
                                               const gchar* message,
                                               gpointer self)
{
#line 247 "utils.vala"
	synapse_utils_logger_glib_log_func (log_domain, log_levels, message);
#line 1558 "utils.c"
}

void
synapse_utils_logger_initialize (void)
{
	GeeArrayList* _tmp0_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 237 "utils.vala"
	synapse_utils_logger_is_writing = FALSE;
#line 238 "utils.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 238 "utils.vala"
	_g_object_unref0 (synapse_utils_logger_log_queue);
#line 238 "utils.vala"
	synapse_utils_logger_log_queue = _tmp0_;
#line 1575 "utils.c"
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
#line 240 "utils.vala"
		_tmp2_ = g_regex_new ("[(]?.*?([^/]*?)(\\.2)?\\.vala(:\\d+)[)]?:\\s*(.*)", 0, 0, &_inner_error0_);
#line 240 "utils.vala"
		_tmp1_ = _tmp2_;
#line 240 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1586 "utils.c"
			goto __catch0_g_error;
		}
#line 240 "utils.vala"
		_tmp3_ = _tmp1_;
#line 240 "utils.vala"
		_tmp1_ = NULL;
#line 240 "utils.vala"
		_g_regex_unref0 (synapse_utils_logger_re);
#line 240 "utils.vala"
		synapse_utils_logger_re = _tmp3_;
#line 239 "utils.vala"
		_g_regex_unref0 (_tmp1_);
#line 1599 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 239 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 1606 "utils.c"
	}
	__finally0:
#line 239 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 239 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 239 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 239 "utils.vala"
		return;
#line 1617 "utils.c"
	}
#line 243 "utils.vala"
	synapse_utils_logger_set_DisplayLevel (SYNAPSE_UTILS_LOGGER_LOG_LEVEL_INFO);
#line 244 "utils.vala"
	_tmp4_ = g_getenv ("SYNAPSE_DEBUG");
#line 244 "utils.vala"
	if (_tmp4_ != NULL) {
#line 245 "utils.vala"
		synapse_utils_logger_set_DisplayLevel (SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG);
#line 1627 "utils.c"
	}
#line 247 "utils.vala"
	g_log_set_default_handler (_synapse_utils_logger_glib_log_func_glog_func, NULL);
#line 1631 "utils.c"
}

static gchar*
synapse_utils_logger_format_message (const gchar* msg)
{
	gboolean _tmp0_ = FALSE;
	GRegex* _tmp1_;
	gchar* _tmp13_;
	gchar* result;
#line 250 "utils.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 252 "utils.vala"
	_tmp1_ = synapse_utils_logger_re;
#line 252 "utils.vala"
	if (_tmp1_ != NULL) {
#line 1647 "utils.c"
		GRegex* _tmp2_;
#line 252 "utils.vala"
		_tmp2_ = synapse_utils_logger_re;
#line 252 "utils.vala"
		_tmp0_ = g_regex_match (_tmp2_, msg, 0, NULL);
#line 1653 "utils.c"
	} else {
#line 252 "utils.vala"
		_tmp0_ = FALSE;
#line 1657 "utils.c"
	}
#line 252 "utils.vala"
	if (_tmp0_) {
#line 1661 "utils.c"
		gchar** parts = NULL;
		GRegex* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
#line 253 "utils.vala"
		_tmp3_ = synapse_utils_logger_re;
#line 253 "utils.vala"
		_tmp5_ = _tmp4_ = g_regex_split (_tmp3_, msg, 0);
#line 253 "utils.vala"
		parts = _tmp5_;
#line 253 "utils.vala"
		parts_length1 = _vala_array_length (_tmp4_);
#line 253 "utils.vala"
		_parts_size_ = parts_length1;
#line 254 "utils.vala"
		_tmp6_ = parts;
#line 254 "utils.vala"
		_tmp6__length1 = parts_length1;
#line 254 "utils.vala"
		_tmp7_ = _tmp6_[1];
#line 254 "utils.vala"
		_tmp8_ = parts;
#line 254 "utils.vala"
		_tmp8__length1 = parts_length1;
#line 254 "utils.vala"
		_tmp9_ = _tmp8_[3];
#line 254 "utils.vala"
		_tmp10_ = parts;
#line 254 "utils.vala"
		_tmp10__length1 = parts_length1;
#line 254 "utils.vala"
		_tmp11_ = _tmp10_[4];
#line 254 "utils.vala"
		_tmp12_ = g_strdup_printf ("[%s%s] %s", _tmp7_, _tmp9_, _tmp11_);
#line 254 "utils.vala"
		result = _tmp12_;
#line 254 "utils.vala"
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 254 "utils.vala"
		return result;
#line 1714 "utils.c"
	}
#line 256 "utils.vala"
	_tmp13_ = g_strdup (msg);
#line 256 "utils.vala"
	result = _tmp13_;
#line 256 "utils.vala"
	return result;
#line 1722 "utils.c"
}

static gchar*
synapse_utils_logger_get_time (void)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 261 "utils.vala"
	_tmp0_ = g_date_time_new_now_local ();
#line 261 "utils.vala"
	now = _tmp0_;
#line 262 "utils.vala"
	_tmp1_ = g_strdup_printf ("%.2d:%.2d:%.2d.%.6d", g_date_time_get_hour (now), g_date_time_get_minute (now), g_date_time_get_second (now), g_date_time_get_microsecond (now));
#line 262 "utils.vala"
	result = _tmp1_;
#line 262 "utils.vala"
	_g_date_time_unref0 (now);
#line 262 "utils.vala"
	return result;
#line 1744 "utils.c"
}

static void
synapse_utils_logger_write (SynapseUtilsLoggerLogLevel level,
                            const gchar* msg)
{
	SynapseUtilsLoggerLogLevel _tmp0_;
	SynapseUtilsLoggerLogLevel _tmp1_;
	GError* _inner_error0_ = NULL;
#line 265 "utils.vala"
	g_return_if_fail (msg != NULL);
#line 267 "utils.vala"
	_tmp0_ = synapse_utils_logger_get_DisplayLevel ();
#line 267 "utils.vala"
	_tmp1_ = _tmp0_;
#line 267 "utils.vala"
	if (level < _tmp1_) {
#line 268 "utils.vala"
		return;
#line 1764 "utils.c"
	}
#line 270 "utils.vala"
	if (synapse_utils_logger_is_writing) {
#line 1768 "utils.c"
		{
			GObject* _tmp2_;
#line 271 "utils.vala"
			_tmp2_ = synapse_utils_logger_queue_lock;
#line 271 "utils.vala"
			g_rec_mutex_lock (&__lock_synapse_utils_logger_synapse_utils_logger_queue_lock);
#line 1775 "utils.c"
			{
				GeeArrayList* _tmp3_;
				SynapseUtilsLoggerLogMessage* _tmp4_;
				SynapseUtilsLoggerLogMessage* _tmp5_;
#line 272 "utils.vala"
				_tmp3_ = synapse_utils_logger_log_queue;
#line 272 "utils.vala"
				_tmp4_ = synapse_utils_logger_log_message_new (level, msg);
#line 272 "utils.vala"
				_tmp5_ = _tmp4_;
#line 272 "utils.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp5_);
#line 272 "utils.vala"
				_g_object_unref0 (_tmp5_);
#line 1790 "utils.c"
			}
			__finally0:
			{
				GObject* _tmp6_;
#line 271 "utils.vala"
				_tmp6_ = synapse_utils_logger_queue_lock;
#line 271 "utils.vala"
				g_rec_mutex_unlock (&__lock_synapse_utils_logger_synapse_utils_logger_queue_lock);
#line 1799 "utils.c"
			}
#line 271 "utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 271 "utils.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 271 "utils.vala"
				g_clear_error (&_inner_error0_);
#line 271 "utils.vala"
				return;
#line 1809 "utils.c"
			}
		}
	} else {
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		SynapseUtilsLoggerLogMessage* _tmp24_;
		SynapseUtilsLoggerLogMessage* _tmp25_;
#line 274 "utils.vala"
		synapse_utils_logger_is_writing = TRUE;
#line 276 "utils.vala"
		_tmp7_ = synapse_utils_logger_log_queue;
#line 276 "utils.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
#line 276 "utils.vala"
		_tmp9_ = _tmp8_;
#line 276 "utils.vala"
		if (_tmp9_ > 0) {
#line 1828 "utils.c"
			GeeArrayList* logs = NULL;
			GeeArrayList* _tmp10_;
			GeeArrayList* _tmp11_;
#line 277 "utils.vala"
			_tmp10_ = synapse_utils_logger_log_queue;
#line 277 "utils.vala"
			_tmp11_ = _g_object_ref0 (_tmp10_);
#line 277 "utils.vala"
			logs = _tmp11_;
#line 1838 "utils.c"
			{
				GObject* _tmp12_;
#line 278 "utils.vala"
				_tmp12_ = synapse_utils_logger_queue_lock;
#line 278 "utils.vala"
				g_rec_mutex_lock (&__lock_synapse_utils_logger_synapse_utils_logger_queue_lock);
#line 1845 "utils.c"
				{
					GeeArrayList* _tmp13_;
#line 279 "utils.vala"
					_tmp13_ = gee_array_list_new (SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 279 "utils.vala"
					_g_object_unref0 (synapse_utils_logger_log_queue);
#line 279 "utils.vala"
					synapse_utils_logger_log_queue = _tmp13_;
#line 1854 "utils.c"
				}
				__finally1:
				{
					GObject* _tmp14_;
#line 278 "utils.vala"
					_tmp14_ = synapse_utils_logger_queue_lock;
#line 278 "utils.vala"
					g_rec_mutex_unlock (&__lock_synapse_utils_logger_synapse_utils_logger_queue_lock);
#line 1863 "utils.c"
				}
#line 278 "utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 278 "utils.vala"
					_g_object_unref0 (logs);
#line 278 "utils.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 278 "utils.vala"
					g_clear_error (&_inner_error0_);
#line 278 "utils.vala"
					return;
#line 1875 "utils.c"
				}
			}
			{
				GeeArrayList* _log_list = NULL;
				GeeArrayList* _tmp15_;
				gint _log_size = 0;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _log_index = 0;
#line 281 "utils.vala"
				_tmp15_ = logs;
#line 281 "utils.vala"
				_log_list = _tmp15_;
#line 281 "utils.vala"
				_tmp16_ = _log_list;
#line 281 "utils.vala"
				_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
#line 281 "utils.vala"
				_tmp18_ = _tmp17_;
#line 281 "utils.vala"
				_log_size = _tmp18_;
#line 281 "utils.vala"
				_log_index = -1;
#line 281 "utils.vala"
				while (TRUE) {
#line 1902 "utils.c"
					gint _tmp19_;
					gint _tmp20_;
					SynapseUtilsLoggerLogMessage* log = NULL;
					GeeArrayList* _tmp21_;
					gpointer _tmp22_;
					SynapseUtilsLoggerLogMessage* _tmp23_;
#line 281 "utils.vala"
					_log_index = _log_index + 1;
#line 281 "utils.vala"
					_tmp19_ = _log_index;
#line 281 "utils.vala"
					_tmp20_ = _log_size;
#line 281 "utils.vala"
					if (!(_tmp19_ < _tmp20_)) {
#line 281 "utils.vala"
						break;
#line 1919 "utils.c"
					}
#line 281 "utils.vala"
					_tmp21_ = _log_list;
#line 281 "utils.vala"
					_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _log_index);
#line 281 "utils.vala"
					log = (SynapseUtilsLoggerLogMessage*) _tmp22_;
#line 282 "utils.vala"
					_tmp23_ = log;
#line 282 "utils.vala"
					synapse_utils_logger_print_log (_tmp23_);
#line 281 "utils.vala"
					_g_object_unref0 (log);
#line 1933 "utils.c"
				}
			}
#line 276 "utils.vala"
			_g_object_unref0 (logs);
#line 1938 "utils.c"
		}
#line 285 "utils.vala"
		_tmp24_ = synapse_utils_logger_log_message_new (level, msg);
#line 285 "utils.vala"
		_tmp25_ = _tmp24_;
#line 285 "utils.vala"
		synapse_utils_logger_print_log (_tmp25_);
#line 285 "utils.vala"
		_g_object_unref0 (_tmp25_);
#line 287 "utils.vala"
		synapse_utils_logger_is_writing = FALSE;
#line 1950 "utils.c"
	}
}

static void
synapse_utils_logger_print_log (SynapseUtilsLoggerLogMessage* log)
{
	SynapseUtilsLoggerLogLevel _tmp0_;
	SynapseUtilsLoggerLogLevel _tmp1_;
	FILE* _tmp2_;
	SynapseUtilsLoggerLogLevel _tmp3_;
	SynapseUtilsLoggerLogLevel _tmp4_;
	GEnumValue* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	FILE* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
#line 291 "utils.vala"
	g_return_if_fail (log != NULL);
#line 293 "utils.vala"
	_tmp0_ = synapse_utils_logger_log_message_get_Level (log);
#line 293 "utils.vala"
	_tmp1_ = _tmp0_;
#line 293 "utils.vala"
	synapse_utils_logger_set_color_for_level (_tmp1_);
#line 294 "utils.vala"
	_tmp2_ = stdout;
#line 294 "utils.vala"
	_tmp3_ = synapse_utils_logger_log_message_get_Level (log);
#line 294 "utils.vala"
	_tmp4_ = _tmp3_;
#line 294 "utils.vala"
	_tmp5_ = g_enum_get_value (g_type_class_ref (SYNAPSE_UTILS_LOGGER_TYPE_LOG_LEVEL), _tmp4_);
#line 294 "utils.vala"
	_tmp6_ = string_substring ((_tmp5_ != NULL) ? _tmp5_->value_name : NULL, (glong) 31, (glong) -1);
#line 294 "utils.vala"
	_tmp7_ = _tmp6_;
#line 294 "utils.vala"
	_tmp8_ = synapse_utils_logger_get_time ();
#line 294 "utils.vala"
	_tmp9_ = _tmp8_;
#line 294 "utils.vala"
	fprintf (_tmp2_, "[%s %s]", _tmp7_, _tmp9_);
#line 294 "utils.vala"
	_g_free0 (_tmp9_);
#line 294 "utils.vala"
	_g_free0 (_tmp7_);
#line 296 "utils.vala"
	synapse_utils_logger_reset_color ();
#line 297 "utils.vala"
	_tmp10_ = stdout;
#line 297 "utils.vala"
	_tmp11_ = synapse_utils_logger_log_message_get_Message (log);
#line 297 "utils.vala"
	_tmp12_ = _tmp11_;
#line 297 "utils.vala"
	fprintf (_tmp10_, " %s\n", _tmp12_);
#line 2010 "utils.c"
}

static void
synapse_utils_logger_set_color_for_level (SynapseUtilsLoggerLogLevel level)
{
#line 302 "utils.vala"
	switch (level) {
#line 302 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG:
#line 2020 "utils.c"
		{
#line 304 "utils.vala"
			synapse_utils_logger_set_foreground (SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_GREEN);
#line 305 "utils.vala"
			break;
#line 2026 "utils.c"
		}
#line 302 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_LEVEL_INFO:
#line 2030 "utils.c"
		{
#line 307 "utils.vala"
			synapse_utils_logger_set_foreground (SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_BLUE);
#line 308 "utils.vala"
			break;
#line 2036 "utils.c"
		}
		default:
#line 302 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_LEVEL_WARN:
#line 2041 "utils.c"
		{
#line 311 "utils.vala"
			synapse_utils_logger_set_foreground (SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_YELLOW);
#line 312 "utils.vala"
			break;
#line 2047 "utils.c"
		}
#line 302 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_LEVEL_ERROR:
#line 2051 "utils.c"
		{
#line 314 "utils.vala"
			synapse_utils_logger_set_foreground (SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_RED);
#line 315 "utils.vala"
			break;
#line 2057 "utils.c"
		}
#line 302 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_LEVEL_FATAL:
#line 2061 "utils.c"
		{
#line 317 "utils.vala"
			synapse_utils_logger_set_background (SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_RED);
#line 318 "utils.vala"
			synapse_utils_logger_set_foreground (SYNAPSE_UTILS_LOGGER_CONSOLE_COLOR_WHITE);
#line 319 "utils.vala"
			break;
#line 2069 "utils.c"
		}
	}
}

static void
synapse_utils_logger_reset_color (void)
{
	FILE* _tmp0_;
#line 325 "utils.vala"
	_tmp0_ = stdout;
#line 325 "utils.vala"
	fprintf (_tmp0_, "\x001b[0m");
#line 2082 "utils.c"
}

static void
synapse_utils_logger_set_foreground (SynapseUtilsLoggerConsoleColor color)
{
#line 330 "utils.vala"
	synapse_utils_logger_set_color (color, TRUE);
#line 2090 "utils.c"
}

static void
synapse_utils_logger_set_background (SynapseUtilsLoggerConsoleColor color)
{
#line 335 "utils.vala"
	synapse_utils_logger_set_color (color, FALSE);
#line 2098 "utils.c"
}

static void
synapse_utils_logger_set_color (SynapseUtilsLoggerConsoleColor color,
                                gboolean isForeground)
{
	SynapseUtilsLoggerConsoleColor color_code = 0;
	FILE* _tmp0_;
#line 340 "utils.vala"
	color_code = (color + 30) + 60;
#line 341 "utils.vala"
	if (!isForeground) {
#line 342 "utils.vala"
		color_code += 10;
#line 2113 "utils.c"
	}
#line 343 "utils.vala"
	_tmp0_ = stdout;
#line 343 "utils.vala"
	fprintf (_tmp0_, "\x001b[%dm", (gint) color_code);
#line 2119 "utils.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 2141 "utils.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 2145 "utils.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 2151 "utils.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 2155 "utils.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 2159 "utils.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 2167 "utils.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2195 "utils.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 2204 "utils.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2218 "utils.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 2227 "utils.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 2241 "utils.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 2250 "utils.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 2259 "utils.c"
}

static void
synapse_utils_logger_glib_log_func (const gchar* d,
                                    GLogLevelFlags flags,
                                    const gchar* msg)
{
	gchar* domain = NULL;
	gchar* _tmp0_;
	gchar* message = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
#line 346 "utils.vala"
	g_return_if_fail (msg != NULL);
#line 348 "utils.vala"
	_tmp0_ = g_strdup ("");
#line 348 "utils.vala"
	domain = _tmp0_;
#line 349 "utils.vala"
	if (d != NULL) {
#line 2285 "utils.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
#line 350 "utils.vala"
		_tmp1_ = d;
#line 350 "utils.vala"
		if (_tmp1_ == NULL) {
#line 350 "utils.vala"
			_tmp1_ = "";
#line 2294 "utils.c"
		}
#line 350 "utils.vala"
		_tmp2_ = g_strdup_printf ("[%s] ", _tmp1_);
#line 350 "utils.vala"
		_g_free0 (domain);
#line 350 "utils.vala"
		domain = _tmp2_;
#line 2302 "utils.c"
	}
#line 352 "utils.vala"
	_tmp3_ = string_replace (msg, "\n", "");
#line 352 "utils.vala"
	_tmp4_ = _tmp3_;
#line 352 "utils.vala"
	_tmp5_ = string_replace (_tmp4_, "\r", "");
#line 352 "utils.vala"
	_tmp6_ = _tmp5_;
#line 352 "utils.vala"
	_g_free0 (_tmp4_);
#line 352 "utils.vala"
	message = _tmp6_;
#line 353 "utils.vala"
	_tmp7_ = domain;
#line 353 "utils.vala"
	_tmp8_ = message;
#line 353 "utils.vala"
	_tmp9_ = g_strdup_printf ("%s%s", _tmp7_, _tmp8_);
#line 353 "utils.vala"
	_g_free0 (message);
#line 353 "utils.vala"
	message = _tmp9_;
#line 355 "utils.vala"
	switch (flags) {
#line 355 "utils.vala"
		case G_LOG_LEVEL_CRITICAL:
#line 2330 "utils.c"
		{
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
#line 357 "utils.vala"
			_tmp10_ = message;
#line 357 "utils.vala"
			_tmp11_ = synapse_utils_logger_format_message (_tmp10_);
#line 357 "utils.vala"
			_tmp12_ = _tmp11_;
#line 357 "utils.vala"
			synapse_utils_logger_write (SYNAPSE_UTILS_LOGGER_LOG_LEVEL_FATAL, _tmp12_);
#line 357 "utils.vala"
			_g_free0 (_tmp12_);
#line 358 "utils.vala"
			break;
#line 2347 "utils.c"
		}
#line 355 "utils.vala"
		case G_LOG_LEVEL_ERROR:
#line 2351 "utils.c"
		{
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 361 "utils.vala"
			_tmp13_ = message;
#line 361 "utils.vala"
			_tmp14_ = synapse_utils_logger_format_message (_tmp13_);
#line 361 "utils.vala"
			_tmp15_ = _tmp14_;
#line 361 "utils.vala"
			synapse_utils_logger_write (SYNAPSE_UTILS_LOGGER_LOG_LEVEL_ERROR, _tmp15_);
#line 361 "utils.vala"
			_g_free0 (_tmp15_);
#line 362 "utils.vala"
			break;
#line 2368 "utils.c"
		}
#line 355 "utils.vala"
		case G_LOG_LEVEL_INFO:
#line 355 "utils.vala"
		case G_LOG_LEVEL_MESSAGE:
#line 2374 "utils.c"
		{
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
#line 366 "utils.vala"
			_tmp16_ = message;
#line 366 "utils.vala"
			_tmp17_ = synapse_utils_logger_format_message (_tmp16_);
#line 366 "utils.vala"
			_tmp18_ = _tmp17_;
#line 366 "utils.vala"
			synapse_utils_logger_write (SYNAPSE_UTILS_LOGGER_LOG_LEVEL_INFO, _tmp18_);
#line 366 "utils.vala"
			_g_free0 (_tmp18_);
#line 367 "utils.vala"
			break;
#line 2391 "utils.c"
		}
#line 355 "utils.vala"
		case G_LOG_LEVEL_DEBUG:
#line 2395 "utils.c"
		{
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
#line 370 "utils.vala"
			_tmp19_ = message;
#line 370 "utils.vala"
			_tmp20_ = synapse_utils_logger_format_message (_tmp19_);
#line 370 "utils.vala"
			_tmp21_ = _tmp20_;
#line 370 "utils.vala"
			synapse_utils_logger_write (SYNAPSE_UTILS_LOGGER_LOG_LEVEL_DEBUG, _tmp21_);
#line 370 "utils.vala"
			_g_free0 (_tmp21_);
#line 371 "utils.vala"
			break;
#line 2412 "utils.c"
		}
		default:
#line 355 "utils.vala"
		case G_LOG_LEVEL_WARNING:
#line 2417 "utils.c"
		{
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
#line 375 "utils.vala"
			_tmp22_ = message;
#line 375 "utils.vala"
			_tmp23_ = synapse_utils_logger_format_message (_tmp22_);
#line 375 "utils.vala"
			_tmp24_ = _tmp23_;
#line 375 "utils.vala"
			synapse_utils_logger_write (SYNAPSE_UTILS_LOGGER_LOG_LEVEL_WARN, _tmp24_);
#line 375 "utils.vala"
			_g_free0 (_tmp24_);
#line 376 "utils.vala"
			break;
#line 2434 "utils.c"
		}
	}
#line 346 "utils.vala"
	_g_free0 (message);
#line 346 "utils.vala"
	_g_free0 (domain);
#line 2441 "utils.c"
}

SynapseUtilsLoggerLogLevel
synapse_utils_logger_get_DisplayLevel (void)
{
	SynapseUtilsLoggerLogLevel result;
#line 219 "utils.vala"
	result = synapse_utils_logger__DisplayLevel;
#line 219 "utils.vala"
	return result;
#line 2452 "utils.c"
}

void
synapse_utils_logger_set_DisplayLevel (SynapseUtilsLoggerLogLevel value)
{
#line 219 "utils.vala"
	synapse_utils_logger__DisplayLevel = value;
#line 2460 "utils.c"
}

static inline gpointer
synapse_utils_logger_log_message_get_instance_private (SynapseUtilsLoggerLogMessage* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUtilsLoggerLogMessage_private_offset);
}

static SynapseUtilsLoggerLogMessage*
synapse_utils_logger_log_message_construct (GType object_type,
                                            SynapseUtilsLoggerLogLevel level,
                                            const gchar* message)
{
	SynapseUtilsLoggerLogMessage * self = NULL;
#line 210 "utils.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 212 "utils.vala"
	self = (SynapseUtilsLoggerLogMessage*) g_object_new (object_type, "Level", level, "Message", message, NULL);
#line 210 "utils.vala"
	return self;
#line 2481 "utils.c"
}

static SynapseUtilsLoggerLogMessage*
synapse_utils_logger_log_message_new (SynapseUtilsLoggerLogLevel level,
                                      const gchar* message)
{
#line 210 "utils.vala"
	return synapse_utils_logger_log_message_construct (SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, level, message);
#line 2490 "utils.c"
}

static SynapseUtilsLoggerLogLevel
synapse_utils_logger_log_message_get_Level (SynapseUtilsLoggerLogMessage* self)
{
	SynapseUtilsLoggerLogLevel result;
#line 207 "utils.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 207 "utils.vala"
	result = self->priv->_Level;
#line 207 "utils.vala"
	return result;
#line 2503 "utils.c"
}

static void
synapse_utils_logger_log_message_set_Level (SynapseUtilsLoggerLogMessage* self,
                                            SynapseUtilsLoggerLogLevel value)
{
	SynapseUtilsLoggerLogLevel old_value;
#line 207 "utils.vala"
	g_return_if_fail (self != NULL);
#line 207 "utils.vala"
	old_value = synapse_utils_logger_log_message_get_Level (self);
#line 207 "utils.vala"
	if (old_value != value) {
#line 207 "utils.vala"
		self->priv->_Level = value;
#line 207 "utils.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_utils_logger_log_message_properties[SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_LEVEL_PROPERTY]);
#line 2521 "utils.c"
	}
}

static const gchar*
synapse_utils_logger_log_message_get_Message (SynapseUtilsLoggerLogMessage* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 208 "utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 208 "utils.vala"
	_tmp0_ = self->priv->_Message;
#line 208 "utils.vala"
	result = _tmp0_;
#line 208 "utils.vala"
	return result;
#line 2538 "utils.c"
}

static void
synapse_utils_logger_log_message_set_Message (SynapseUtilsLoggerLogMessage* self,
                                              const gchar* value)
{
	gchar* old_value;
#line 208 "utils.vala"
	g_return_if_fail (self != NULL);
#line 208 "utils.vala"
	old_value = synapse_utils_logger_log_message_get_Message (self);
#line 208 "utils.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2552 "utils.c"
		gchar* _tmp0_;
#line 208 "utils.vala"
		_tmp0_ = g_strdup (value);
#line 208 "utils.vala"
		_g_free0 (self->priv->_Message);
#line 208 "utils.vala"
		self->priv->_Message = _tmp0_;
#line 208 "utils.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_utils_logger_log_message_properties[SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_MESSAGE_PROPERTY]);
#line 2562 "utils.c"
	}
}

static void
synapse_utils_logger_log_message_class_init (SynapseUtilsLoggerLogMessageClass * klass,
                                             gpointer klass_data)
{
#line 205 "utils.vala"
	synapse_utils_logger_log_message_parent_class = g_type_class_peek_parent (klass);
#line 205 "utils.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUtilsLoggerLogMessage_private_offset);
#line 205 "utils.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_utils_logger_log_message_get_property;
#line 205 "utils.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_utils_logger_log_message_set_property;
#line 205 "utils.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_utils_logger_log_message_finalize;
#line 205 "utils.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_LEVEL_PROPERTY, synapse_utils_logger_log_message_properties[SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_LEVEL_PROPERTY] = g_param_spec_enum ("Level", "Level", "Level", SYNAPSE_UTILS_LOGGER_TYPE_LOG_LEVEL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 205 "utils.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_MESSAGE_PROPERTY, synapse_utils_logger_log_message_properties[SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_MESSAGE_PROPERTY] = g_param_spec_string ("Message", "Message", "Message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2584 "utils.c"
}

static void
synapse_utils_logger_log_message_instance_init (SynapseUtilsLoggerLogMessage * self,
                                                gpointer klass)
{
#line 205 "utils.vala"
	self->priv = synapse_utils_logger_log_message_get_instance_private (self);
#line 2593 "utils.c"
}

static void
synapse_utils_logger_log_message_finalize (GObject * obj)
{
	SynapseUtilsLoggerLogMessage * self;
#line 205 "utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, SynapseUtilsLoggerLogMessage);
#line 208 "utils.vala"
	_g_free0 (self->priv->_Message);
#line 205 "utils.vala"
	G_OBJECT_CLASS (synapse_utils_logger_log_message_parent_class)->finalize (obj);
#line 2606 "utils.c"
}

static GType
synapse_utils_logger_log_message_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsLoggerLogMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_logger_log_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsLoggerLogMessage), 0, (GInstanceInitFunc) synapse_utils_logger_log_message_instance_init, NULL };
	GType synapse_utils_logger_log_message_type_id;
	synapse_utils_logger_log_message_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseUtilsLoggerLogMessage", &g_define_type_info, 0);
	SynapseUtilsLoggerLogMessage_private_offset = g_type_add_instance_private (synapse_utils_logger_log_message_type_id, sizeof (SynapseUtilsLoggerLogMessagePrivate));
	return synapse_utils_logger_log_message_type_id;
}

static GType
synapse_utils_logger_log_message_get_type (void)
{
	static volatile gsize synapse_utils_logger_log_message_type_id__once = 0;
	if (g_once_init_enter (&synapse_utils_logger_log_message_type_id__once)) {
		GType synapse_utils_logger_log_message_type_id;
		synapse_utils_logger_log_message_type_id = synapse_utils_logger_log_message_get_type_once ();
		g_once_init_leave (&synapse_utils_logger_log_message_type_id__once, synapse_utils_logger_log_message_type_id);
	}
	return synapse_utils_logger_log_message_type_id__once;
}

static void
_vala_synapse_utils_logger_log_message_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseUtilsLoggerLogMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, SynapseUtilsLoggerLogMessage);
#line 205 "utils.vala"
	switch (property_id) {
#line 205 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_LEVEL_PROPERTY:
#line 205 "utils.vala"
		g_value_set_enum (value, synapse_utils_logger_log_message_get_Level (self));
#line 205 "utils.vala"
		break;
#line 205 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_MESSAGE_PROPERTY:
#line 205 "utils.vala"
		g_value_set_string (value, synapse_utils_logger_log_message_get_Message (self));
#line 205 "utils.vala"
		break;
#line 2653 "utils.c"
		default:
#line 205 "utils.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 205 "utils.vala"
		break;
#line 2659 "utils.c"
	}
}

static void
_vala_synapse_utils_logger_log_message_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseUtilsLoggerLogMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_UTILS_LOGGER_TYPE_LOG_MESSAGE, SynapseUtilsLoggerLogMessage);
#line 205 "utils.vala"
	switch (property_id) {
#line 205 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_LEVEL_PROPERTY:
#line 205 "utils.vala"
		synapse_utils_logger_log_message_set_Level (self, g_value_get_enum (value));
#line 205 "utils.vala"
		break;
#line 205 "utils.vala"
		case SYNAPSE_UTILS_LOGGER_LOG_MESSAGE_MESSAGE_PROPERTY:
#line 205 "utils.vala"
		synapse_utils_logger_log_message_set_Message (self, g_value_get_string (value));
#line 205 "utils.vala"
		break;
#line 2685 "utils.c"
		default:
#line 205 "utils.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 205 "utils.vala"
		break;
#line 2691 "utils.c"
	}
}

static void
synapse_utils_value_logger_init (GValue* value)
{
#line 182 "utils.vala"
	value->data[0].v_pointer = NULL;
#line 2700 "utils.c"
}

static void
synapse_utils_value_logger_free_value (GValue* value)
{
#line 182 "utils.vala"
	if (value->data[0].v_pointer) {
#line 182 "utils.vala"
		synapse_utils_logger_unref (value->data[0].v_pointer);
#line 2710 "utils.c"
	}
}

static void
synapse_utils_value_logger_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
#line 182 "utils.vala"
	if (src_value->data[0].v_pointer) {
#line 182 "utils.vala"
		dest_value->data[0].v_pointer = synapse_utils_logger_ref (src_value->data[0].v_pointer);
#line 2722 "utils.c"
	} else {
#line 182 "utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2726 "utils.c"
	}
}

static gpointer
synapse_utils_value_logger_peek_pointer (const GValue* value)
{
#line 182 "utils.vala"
	return value->data[0].v_pointer;
#line 2735 "utils.c"
}

static gchar*
synapse_utils_value_logger_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
#line 182 "utils.vala"
	if (collect_values[0].v_pointer) {
#line 2746 "utils.c"
		SynapseUtilsLogger * object;
		object = collect_values[0].v_pointer;
#line 182 "utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 182 "utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2753 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 182 "utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2757 "utils.c"
		}
#line 182 "utils.vala"
		value->data[0].v_pointer = synapse_utils_logger_ref (object);
#line 2761 "utils.c"
	} else {
#line 182 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 2765 "utils.c"
	}
#line 182 "utils.vala"
	return NULL;
#line 2769 "utils.c"
}

static gchar*
synapse_utils_value_logger_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	SynapseUtilsLogger ** object_p;
	object_p = collect_values[0].v_pointer;
#line 182 "utils.vala"
	if (!object_p) {
#line 182 "utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2784 "utils.c"
	}
#line 182 "utils.vala"
	if (!value->data[0].v_pointer) {
#line 182 "utils.vala"
		*object_p = NULL;
#line 2790 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 182 "utils.vala"
		*object_p = value->data[0].v_pointer;
#line 2794 "utils.c"
	} else {
#line 182 "utils.vala"
		*object_p = synapse_utils_logger_ref (value->data[0].v_pointer);
#line 2798 "utils.c"
	}
#line 182 "utils.vala"
	return NULL;
#line 2802 "utils.c"
}

GParamSpec*
synapse_utils_param_spec_logger (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	SynapseUtilsParamSpecLogger* spec;
#line 182 "utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
#line 182 "utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 182 "utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 182 "utils.vala"
	return G_PARAM_SPEC (spec);
#line 2821 "utils.c"
}

gpointer
synapse_utils_value_get_logger (const GValue* value)
{
#line 182 "utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER), NULL);
#line 182 "utils.vala"
	return value->data[0].v_pointer;
#line 2831 "utils.c"
}

void
synapse_utils_value_set_logger (GValue* value,
                                gpointer v_object)
{
	SynapseUtilsLogger * old;
#line 182 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
#line 182 "utils.vala"
	old = value->data[0].v_pointer;
#line 182 "utils.vala"
	if (v_object) {
#line 182 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
#line 182 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 182 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 182 "utils.vala"
		synapse_utils_logger_ref (value->data[0].v_pointer);
#line 2853 "utils.c"
	} else {
#line 182 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 2857 "utils.c"
	}
#line 182 "utils.vala"
	if (old) {
#line 182 "utils.vala"
		synapse_utils_logger_unref (old);
#line 2863 "utils.c"
	}
}

void
synapse_utils_value_take_logger (GValue* value,
                                 gpointer v_object)
{
	SynapseUtilsLogger * old;
#line 182 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_LOGGER));
#line 182 "utils.vala"
	old = value->data[0].v_pointer;
#line 182 "utils.vala"
	if (v_object) {
#line 182 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_LOGGER));
#line 182 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 182 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 2884 "utils.c"
	} else {
#line 182 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 2888 "utils.c"
	}
#line 182 "utils.vala"
	if (old) {
#line 182 "utils.vala"
		synapse_utils_logger_unref (old);
#line 2894 "utils.c"
	}
}

static void
synapse_utils_logger_class_init (SynapseUtilsLoggerClass * klass,
                                 gpointer klass_data)
{
#line 182 "utils.vala"
	synapse_utils_logger_parent_class = g_type_class_peek_parent (klass);
#line 182 "utils.vala"
	((SynapseUtilsLoggerClass *) klass)->finalize = synapse_utils_logger_finalize;
#line 221 "utils.vala"
	g_rec_mutex_init (&__lock_synapse_utils_logger_synapse_utils_logger_queue_lock);
#line 2908 "utils.c"
}

static void
synapse_utils_logger_instance_init (SynapseUtilsLogger * self,
                                    gpointer klass)
{
#line 182 "utils.vala"
	self->ref_count = 1;
#line 2917 "utils.c"
}

static void
synapse_utils_logger_finalize (SynapseUtilsLogger * obj)
{
	SynapseUtilsLogger * self;
#line 182 "utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_LOGGER, SynapseUtilsLogger);
#line 182 "utils.vala"
	g_signal_handlers_destroy (self);
#line 2928 "utils.c"
}

/**
     * A logging class to display all console messages in a nice colored format.
     * Adapated source from plank (by Robert Dyer)
     */
static GType
synapse_utils_logger_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_logger_init, synapse_utils_value_logger_free_value, synapse_utils_value_logger_copy_value, synapse_utils_value_logger_peek_pointer, "p", synapse_utils_value_logger_collect_value, "p", synapse_utils_value_logger_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsLogger), 0, (GInstanceInitFunc) synapse_utils_logger_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_utils_logger_type_id;
	synapse_utils_logger_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsLogger", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return synapse_utils_logger_type_id;
}

GType
synapse_utils_logger_get_type (void)
{
	static volatile gsize synapse_utils_logger_type_id__once = 0;
	if (g_once_init_enter (&synapse_utils_logger_type_id__once)) {
		GType synapse_utils_logger_type_id;
		synapse_utils_logger_type_id = synapse_utils_logger_get_type_once ();
		g_once_init_leave (&synapse_utils_logger_type_id__once, synapse_utils_logger_type_id);
	}
	return synapse_utils_logger_type_id__once;
}

gpointer
synapse_utils_logger_ref (gpointer instance)
{
	SynapseUtilsLogger * self;
	self = instance;
#line 182 "utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 182 "utils.vala"
	return instance;
#line 2967 "utils.c"
}

void
synapse_utils_logger_unref (gpointer instance)
{
	SynapseUtilsLogger * self;
	self = instance;
#line 182 "utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 182 "utils.vala"
		SYNAPSE_UTILS_LOGGER_GET_CLASS (self)->finalize (self);
#line 182 "utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2981 "utils.c"
	}
}

SynapseUtilsDelegateWrapper*
synapse_utils_delegate_wrapper_new (GSourceFunc cb,
                                    gpointer cb_target,
                                    GDestroyNotify cb_target_destroy_notify)
{
	SynapseUtilsDelegateWrapper* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
#line 386 "utils.vala"
	self = g_slice_new0 (SynapseUtilsDelegateWrapper);
#line 386 "utils.vala"
	synapse_utils_delegate_wrapper_instance_init (self);
#line 388 "utils.vala"
	_tmp0_ = cb;
#line 388 "utils.vala"
	_tmp0__target = cb_target;
#line 388 "utils.vala"
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
#line 388 "utils.vala"
	cb = NULL;
#line 388 "utils.vala"
	cb_target = NULL;
#line 388 "utils.vala"
	cb_target_destroy_notify = NULL;
#line 388 "utils.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 388 "utils.vala"
	self->callback = NULL;
#line 388 "utils.vala"
	self->callback_target = NULL;
#line 388 "utils.vala"
	self->callback_target_destroy_notify = NULL;
#line 388 "utils.vala"
	self->callback = _tmp0_;
#line 388 "utils.vala"
	self->callback_target = _tmp0__target;
#line 388 "utils.vala"
	self->callback_target_destroy_notify = _tmp0__target_destroy_notify;
#line 386 "utils.vala"
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
#line 386 "utils.vala"
	cb = NULL;
#line 386 "utils.vala"
	cb_target = NULL;
#line 386 "utils.vala"
	cb_target_destroy_notify = NULL;
#line 386 "utils.vala"
	return self;
#line 3034 "utils.c"
}

static void
synapse_utils_delegate_wrapper_instance_init (SynapseUtilsDelegateWrapper * self)
{
}

void
synapse_utils_delegate_wrapper_free (SynapseUtilsDelegateWrapper * self)
{
#line 384 "utils.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 384 "utils.vala"
	self->callback = NULL;
#line 384 "utils.vala"
	self->callback_target = NULL;
#line 384 "utils.vala"
	self->callback_target_destroy_notify = NULL;
#line 382 "utils.vala"
	g_slice_free (SynapseUtilsDelegateWrapper, self);
#line 3055 "utils.c"
}

static inline gpointer
synapse_utils_async_once_get_instance_private (SynapseUtilsAsyncOnce* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUtilsAsyncOnce_private_offset);
}

static GType
synapse_utils_async_once_operation_state_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED", "not-started"}, {SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS", "in-progress"}, {SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE, "SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE", "done"}, {0, NULL, NULL}};
	GType synapse_utils_async_once_operation_state_type_id;
	synapse_utils_async_once_operation_state_type_id = g_enum_register_static ("SynapseUtilsAsyncOnceOperationState", values);
	return synapse_utils_async_once_operation_state_type_id;
}

static GType
synapse_utils_async_once_operation_state_get_type (void)
{
	static volatile gsize synapse_utils_async_once_operation_state_type_id__once = 0;
	if (g_once_init_enter (&synapse_utils_async_once_operation_state_type_id__once)) {
		GType synapse_utils_async_once_operation_state_type_id;
		synapse_utils_async_once_operation_state_type_id = synapse_utils_async_once_operation_state_get_type_once ();
		g_once_init_leave (&synapse_utils_async_once_operation_state_type_id__once, synapse_utils_async_once_operation_state_type_id);
	}
	return synapse_utils_async_once_operation_state_type_id__once;
}

SynapseUtilsAsyncOnce*
synapse_utils_async_once_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func)
{
	SynapseUtilsAsyncOnce* self = NULL;
#line 428 "utils.vala"
	self = (SynapseUtilsAsyncOnce*) g_type_create_instance (object_type);
#line 428 "utils.vala"
	self->priv->g_type = g_type;
#line 428 "utils.vala"
	self->priv->g_dup_func = g_dup_func;
#line 428 "utils.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 430 "utils.vala"
	self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED;
#line 428 "utils.vala"
	return self;
#line 3104 "utils.c"
}

SynapseUtilsAsyncOnce*
synapse_utils_async_once_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func)
{
#line 428 "utils.vala"
	return synapse_utils_async_once_construct (SYNAPSE_UTILS_TYPE_ASYNC_ONCE, g_type, g_dup_func, g_destroy_func);
#line 3114 "utils.c"
}

gconstpointer
synapse_utils_async_once_get_data (SynapseUtilsAsyncOnce* self)
{
	gconstpointer _tmp0_;
	gconstpointer result;
#line 433 "utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 435 "utils.vala"
	_tmp0_ = self->priv->inner;
#line 435 "utils.vala"
	result = _tmp0_;
#line 435 "utils.vala"
	return result;
#line 3130 "utils.c"
}

gboolean
synapse_utils_async_once_is_initialized (SynapseUtilsAsyncOnce* self)
{
	gboolean result;
#line 438 "utils.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 440 "utils.vala"
	result = self->priv->state == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE;
#line 440 "utils.vala"
	return result;
#line 3143 "utils.c"
}

static void
synapse_utils_async_once_enter_data_free (gpointer _data)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
	_data_ = _data;
#line 414 "utils.vala"
	_synapse_utils_async_once_unref0 (_data_->self);
#line 414 "utils.vala"
	g_slice_free (SynapseUtilsAsyncOnceEnterData, _data_);
#line 3155 "utils.c"
}

static gpointer
_synapse_utils_async_once_ref0 (gpointer self)
{
#line 414 "utils.vala"
	return self ? synapse_utils_async_once_ref (self) : NULL;
#line 3163 "utils.c"
}

void
synapse_utils_async_once_enter (SynapseUtilsAsyncOnce* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
	SynapseUtilsAsyncOnce* _tmp0_;
#line 414 "utils.vala"
	g_return_if_fail (self != NULL);
#line 414 "utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsAsyncOnceEnterData);
#line 414 "utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 414 "utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_async_once_enter_data_free);
#line 414 "utils.vala"
	_tmp0_ = _synapse_utils_async_once_ref0 (self);
#line 414 "utils.vala"
	_data_->self = _tmp0_;
#line 414 "utils.vala"
	synapse_utils_async_once_enter_co (_data_);
#line 3187 "utils.c"
}

gboolean
synapse_utils_async_once_enter_finish (SynapseUtilsAsyncOnce* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsAsyncOnceEnterData* _data_;
#line 414 "utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 414 "utils.vala"
	result = _data_->result;
#line 414 "utils.vala"
	return result;
#line 3202 "utils.c"
}

static void
synapse_utils_async_once_enter_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseUtilsAsyncOnceEnterData* _data_;
#line 452 "utils.vala"
	_data_ = _user_data_;
#line 452 "utils.vala"
	_data_->_source_object_ = source_object;
#line 452 "utils.vala"
	_data_->_res_ = _res_;
#line 452 "utils.vala"
	synapse_utils_async_once_enter_co (_data_);
#line 3219 "utils.c"
}

static gboolean
synapse_utils_async_once_enter_co (SynapseUtilsAsyncOnceEnterData* _data_)
{
#line 443 "utils.vala"
	switch (_data_->_state_) {
#line 443 "utils.vala"
		case 0:
#line 3229 "utils.c"
		goto _state_0;
#line 443 "utils.vala"
		case 1:
#line 3233 "utils.c"
		goto _state_1;
		default:
#line 443 "utils.vala"
		g_assert_not_reached ();
#line 3238 "utils.c"
	}
	_state_0:
#line 445 "utils.vala"
	if (_data_->self->priv->state == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED) {
#line 447 "utils.vala"
		_data_->self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS;
#line 448 "utils.vala"
		_data_->result = TRUE;
#line 448 "utils.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 448 "utils.vala"
		if (_data_->_state_ != 0) {
#line 448 "utils.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 448 "utils.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3255 "utils.c"
			}
		}
#line 448 "utils.vala"
		g_object_unref (_data_->_async_result);
#line 448 "utils.vala"
		return FALSE;
#line 3262 "utils.c"
	} else {
#line 450 "utils.vala"
		if (_data_->self->priv->state == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
#line 452 "utils.vala"
			_data_->_state_ = 1;
#line 452 "utils.vala"
			synapse_utils_async_once_wait_async (_data_->self, synapse_utils_async_once_enter_ready, _data_);
#line 452 "utils.vala"
			return FALSE;
#line 3272 "utils.c"
			_state_1:
#line 452 "utils.vala"
			synapse_utils_async_once_wait_finish (_data_->self, _data_->_res_);
#line 3276 "utils.c"
		}
	}
#line 455 "utils.vala"
	_data_->result = FALSE;
#line 455 "utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 455 "utils.vala"
	if (_data_->_state_ != 0) {
#line 455 "utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 455 "utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3289 "utils.c"
		}
	}
#line 455 "utils.vala"
	g_object_unref (_data_->_async_result);
#line 455 "utils.vala"
	return FALSE;
#line 3296 "utils.c"
}

void
synapse_utils_async_once_leave (SynapseUtilsAsyncOnce* self,
                                gconstpointer _result_)
{
	gpointer _tmp0_;
#line 458 "utils.vala"
	g_return_if_fail (self != NULL);
#line 460 "utils.vala"
	if (self->priv->state != SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
#line 462 "utils.vala"
		g_warning ("utils.vala:462: Incorrect usage of AsyncOnce");
#line 463 "utils.vala"
		return;
#line 3312 "utils.c"
	}
#line 465 "utils.vala"
	self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_DONE;
#line 466 "utils.vala"
	_tmp0_ = ((_result_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _result_) : ((gpointer) _result_);
#line 466 "utils.vala"
	((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
#line 466 "utils.vala"
	self->priv->inner = _tmp0_;
#line 467 "utils.vala"
	synapse_utils_async_once_notify_all (self);
#line 3324 "utils.c"
}

void
synapse_utils_async_once_reset (SynapseUtilsAsyncOnce* self)
{
#line 471 "utils.vala"
	g_return_if_fail (self != NULL);
#line 473 "utils.vala"
	if (self->priv->state == SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_IN_PROGRESS) {
#line 475 "utils.vala"
		g_warning ("utils.vala:475: AsyncOnce.reset() cannot be called in the middle of in" \
"itialization.");
#line 3336 "utils.c"
	} else {
#line 479 "utils.vala"
		self->priv->state = SYNAPSE_UTILS_ASYNC_ONCE_OPERATION_STATE_NOT_STARTED;
#line 480 "utils.vala"
		((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
#line 480 "utils.vala"
		self->priv->inner = NULL;
#line 3344 "utils.c"
	}
}

static void
synapse_utils_async_once_notify_all (SynapseUtilsAsyncOnce* self)
{
	SynapseUtilsDelegateWrapper** _tmp0_;
	gint _tmp0__length1;
	SynapseUtilsDelegateWrapper** _tmp3_;
#line 484 "utils.vala"
	g_return_if_fail (self != NULL);
#line 486 "utils.vala"
	_tmp0_ = self->priv->callbacks;
#line 486 "utils.vala"
	_tmp0__length1 = self->priv->callbacks_length1;
#line 3360 "utils.c"
	{
		SynapseUtilsDelegateWrapper** wrapper_collection = NULL;
		gint wrapper_collection_length1 = 0;
		gint _wrapper_collection_size_ = 0;
		gint wrapper_it = 0;
#line 486 "utils.vala"
		wrapper_collection = _tmp0_;
#line 486 "utils.vala"
		wrapper_collection_length1 = _tmp0__length1;
#line 486 "utils.vala"
		for (wrapper_it = 0; wrapper_it < wrapper_collection_length1; wrapper_it = wrapper_it + 1) {
#line 3372 "utils.c"
			SynapseUtilsDelegateWrapper* wrapper = NULL;
#line 486 "utils.vala"
			wrapper = wrapper_collection[wrapper_it];
#line 3376 "utils.c"
			{
				SynapseUtilsDelegateWrapper* _tmp1_;
				GSourceFunc _tmp2_;
				gpointer _tmp2__target;
#line 488 "utils.vala"
				_tmp1_ = wrapper;
#line 488 "utils.vala"
				_tmp2_ = _tmp1_->callback;
#line 488 "utils.vala"
				_tmp2__target = _tmp1_->callback_target;
#line 488 "utils.vala"
				_tmp2_ (_tmp2__target);
#line 3389 "utils.c"
			}
		}
	}
#line 490 "utils.vala"
	_tmp3_ = g_new0 (SynapseUtilsDelegateWrapper*, 0 + 1);
#line 490 "utils.vala"
	self->priv->callbacks = (_vala_array_free (self->priv->callbacks, self->priv->callbacks_length1, (GDestroyNotify) synapse_utils_delegate_wrapper_free), NULL);
#line 490 "utils.vala"
	self->priv->callbacks = _tmp3_;
#line 490 "utils.vala"
	self->priv->callbacks_length1 = 0;
#line 490 "utils.vala"
	self->priv->_callbacks_size_ = self->priv->callbacks_length1;
#line 3403 "utils.c"
}

static void
synapse_utils_async_once_wait_async_data_free (gpointer _data)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
	_data_ = _data;
#line 414 "utils.vala"
	_synapse_utils_async_once_unref0 (_data_->self);
#line 414 "utils.vala"
	g_slice_free (SynapseUtilsAsyncOnceWaitAsyncData, _data_);
#line 3415 "utils.c"
}

static void
synapse_utils_async_once_wait_async (SynapseUtilsAsyncOnce* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
	SynapseUtilsAsyncOnce* _tmp0_;
#line 414 "utils.vala"
	g_return_if_fail (self != NULL);
#line 414 "utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsAsyncOnceWaitAsyncData);
#line 414 "utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 414 "utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_async_once_wait_async_data_free);
#line 414 "utils.vala"
	_tmp0_ = _synapse_utils_async_once_ref0 (self);
#line 414 "utils.vala"
	_data_->self = _tmp0_;
#line 414 "utils.vala"
	synapse_utils_async_once_wait_async_co (_data_);
#line 3439 "utils.c"
}

static void
synapse_utils_async_once_wait_finish (SynapseUtilsAsyncOnce* self,
                                      GAsyncResult* _res_)
{
	SynapseUtilsAsyncOnceWaitAsyncData* _data_;
#line 414 "utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3449 "utils.c"
}

static gboolean
_synapse_utils_async_once_wait_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_utils_async_once_wait_async_co (self);
#line 495 "utils.vala"
	return result;
#line 3459 "utils.c"
}

static void
_vala_array_add8 (SynapseUtilsDelegateWrapper** * array,
                  gint* length,
                  gint* size,
                  SynapseUtilsDelegateWrapper* value)
{
#line 495 "utils.vala"
	if ((*length) == (*size)) {
#line 495 "utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 495 "utils.vala"
		*array = g_renew (SynapseUtilsDelegateWrapper*, *array, (*size) + 1);
#line 3474 "utils.c"
	}
#line 495 "utils.vala"
	(*array)[(*length)++] = value;
#line 495 "utils.vala"
	(*array)[*length] = NULL;
#line 3480 "utils.c"
}

static gboolean
synapse_utils_async_once_wait_async_co (SynapseUtilsAsyncOnceWaitAsyncData* _data_)
{
#line 493 "utils.vala"
	switch (_data_->_state_) {
#line 493 "utils.vala"
		case 0:
#line 3490 "utils.c"
		goto _state_0;
#line 493 "utils.vala"
		case 1:
#line 3494 "utils.c"
		goto _state_1;
		default:
#line 493 "utils.vala"
		g_assert_not_reached ();
#line 3499 "utils.c"
	}
	_state_0:
#line 495 "utils.vala"
	_data_->_tmp0_ = synapse_utils_delegate_wrapper_new (_synapse_utils_async_once_wait_async_co_gsource_func, _data_, NULL);
#line 495 "utils.vala"
	_vala_array_add8 (&_data_->self->priv->callbacks, &_data_->self->priv->callbacks_length1, &_data_->self->priv->_callbacks_size_, _data_->_tmp0_);
#line 496 "utils.vala"
	_data_->_state_ = 1;
#line 496 "utils.vala"
	return FALSE;
#line 3510 "utils.c"
	_state_1:
	;
#line 493 "utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 493 "utils.vala"
	if (_data_->_state_ != 0) {
#line 493 "utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 493 "utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3521 "utils.c"
		}
	}
#line 493 "utils.vala"
	g_object_unref (_data_->_async_result);
#line 493 "utils.vala"
	return FALSE;
#line 3528 "utils.c"
}

static void
synapse_utils_value_async_once_init (GValue* value)
{
#line 414 "utils.vala"
	value->data[0].v_pointer = NULL;
#line 3536 "utils.c"
}

static void
synapse_utils_value_async_once_free_value (GValue* value)
{
#line 414 "utils.vala"
	if (value->data[0].v_pointer) {
#line 414 "utils.vala"
		synapse_utils_async_once_unref (value->data[0].v_pointer);
#line 3546 "utils.c"
	}
}

static void
synapse_utils_value_async_once_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
#line 414 "utils.vala"
	if (src_value->data[0].v_pointer) {
#line 414 "utils.vala"
		dest_value->data[0].v_pointer = synapse_utils_async_once_ref (src_value->data[0].v_pointer);
#line 3558 "utils.c"
	} else {
#line 414 "utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3562 "utils.c"
	}
}

static gpointer
synapse_utils_value_async_once_peek_pointer (const GValue* value)
{
#line 414 "utils.vala"
	return value->data[0].v_pointer;
#line 3571 "utils.c"
}

static gchar*
synapse_utils_value_async_once_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
#line 414 "utils.vala"
	if (collect_values[0].v_pointer) {
#line 3582 "utils.c"
		SynapseUtilsAsyncOnce * object;
		object = collect_values[0].v_pointer;
#line 414 "utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 414 "utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3589 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 414 "utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3593 "utils.c"
		}
#line 414 "utils.vala"
		value->data[0].v_pointer = synapse_utils_async_once_ref (object);
#line 3597 "utils.c"
	} else {
#line 414 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3601 "utils.c"
	}
#line 414 "utils.vala"
	return NULL;
#line 3605 "utils.c"
}

static gchar*
synapse_utils_value_async_once_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	SynapseUtilsAsyncOnce ** object_p;
	object_p = collect_values[0].v_pointer;
#line 414 "utils.vala"
	if (!object_p) {
#line 414 "utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3620 "utils.c"
	}
#line 414 "utils.vala"
	if (!value->data[0].v_pointer) {
#line 414 "utils.vala"
		*object_p = NULL;
#line 3626 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 414 "utils.vala"
		*object_p = value->data[0].v_pointer;
#line 3630 "utils.c"
	} else {
#line 414 "utils.vala"
		*object_p = synapse_utils_async_once_ref (value->data[0].v_pointer);
#line 3634 "utils.c"
	}
#line 414 "utils.vala"
	return NULL;
#line 3638 "utils.c"
}

GParamSpec*
synapse_utils_param_spec_async_once (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	SynapseUtilsParamSpecAsyncOnce* spec;
#line 414 "utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_ASYNC_ONCE), NULL);
#line 414 "utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 414 "utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 414 "utils.vala"
	return G_PARAM_SPEC (spec);
#line 3657 "utils.c"
}

gpointer
synapse_utils_value_get_async_once (const GValue* value)
{
#line 414 "utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE), NULL);
#line 414 "utils.vala"
	return value->data[0].v_pointer;
#line 3667 "utils.c"
}

void
synapse_utils_value_set_async_once (GValue* value,
                                    gpointer v_object)
{
	SynapseUtilsAsyncOnce * old;
#line 414 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 414 "utils.vala"
	old = value->data[0].v_pointer;
#line 414 "utils.vala"
	if (v_object) {
#line 414 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 414 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 414 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 414 "utils.vala"
		synapse_utils_async_once_ref (value->data[0].v_pointer);
#line 3689 "utils.c"
	} else {
#line 414 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3693 "utils.c"
	}
#line 414 "utils.vala"
	if (old) {
#line 414 "utils.vala"
		synapse_utils_async_once_unref (old);
#line 3699 "utils.c"
	}
}

void
synapse_utils_value_take_async_once (GValue* value,
                                     gpointer v_object)
{
	SynapseUtilsAsyncOnce * old;
#line 414 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 414 "utils.vala"
	old = value->data[0].v_pointer;
#line 414 "utils.vala"
	if (v_object) {
#line 414 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_ASYNC_ONCE));
#line 414 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 414 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 3720 "utils.c"
	} else {
#line 414 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 3724 "utils.c"
	}
#line 414 "utils.vala"
	if (old) {
#line 414 "utils.vala"
		synapse_utils_async_once_unref (old);
#line 3730 "utils.c"
	}
}

static void
synapse_utils_async_once_class_init (SynapseUtilsAsyncOnceClass * klass,
                                     gpointer klass_data)
{
#line 414 "utils.vala"
	synapse_utils_async_once_parent_class = g_type_class_peek_parent (klass);
#line 414 "utils.vala"
	((SynapseUtilsAsyncOnceClass *) klass)->finalize = synapse_utils_async_once_finalize;
#line 414 "utils.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUtilsAsyncOnce_private_offset);
#line 3744 "utils.c"
}

static void
synapse_utils_async_once_instance_init (SynapseUtilsAsyncOnce * self,
                                        gpointer klass)
{
	SynapseUtilsDelegateWrapper** _tmp0_;
#line 414 "utils.vala"
	self->priv = synapse_utils_async_once_get_instance_private (self);
#line 426 "utils.vala"
	_tmp0_ = g_new0 (SynapseUtilsDelegateWrapper*, 0 + 1);
#line 426 "utils.vala"
	self->priv->callbacks = _tmp0_;
#line 426 "utils.vala"
	self->priv->callbacks_length1 = 0;
#line 426 "utils.vala"
	self->priv->_callbacks_size_ = self->priv->callbacks_length1;
#line 414 "utils.vala"
	self->ref_count = 1;
#line 3764 "utils.c"
}

static void
synapse_utils_async_once_finalize (SynapseUtilsAsyncOnce * obj)
{
	SynapseUtilsAsyncOnce * self;
#line 414 "utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_ASYNC_ONCE, SynapseUtilsAsyncOnce);
#line 414 "utils.vala"
	g_signal_handlers_destroy (self);
#line 423 "utils.vala"
	((self->priv->inner == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->inner = (self->priv->g_destroy_func (self->priv->inner), NULL));
#line 426 "utils.vala"
	self->priv->callbacks = (_vala_array_free (self->priv->callbacks, self->priv->callbacks_length1, (GDestroyNotify) synapse_utils_delegate_wrapper_free), NULL);
#line 3779 "utils.c"
}

static GType
synapse_utils_async_once_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_async_once_init, synapse_utils_value_async_once_free_value, synapse_utils_value_async_once_copy_value, synapse_utils_value_async_once_peek_pointer, "p", synapse_utils_value_async_once_collect_value, "p", synapse_utils_value_async_once_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsAsyncOnceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_async_once_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsAsyncOnce), 0, (GInstanceInitFunc) synapse_utils_async_once_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_utils_async_once_type_id;
	synapse_utils_async_once_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsAsyncOnce", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SynapseUtilsAsyncOnce_private_offset = g_type_add_instance_private (synapse_utils_async_once_type_id, sizeof (SynapseUtilsAsyncOncePrivate));
	return synapse_utils_async_once_type_id;
}

GType
synapse_utils_async_once_get_type (void)
{
	static volatile gsize synapse_utils_async_once_type_id__once = 0;
	if (g_once_init_enter (&synapse_utils_async_once_type_id__once)) {
		GType synapse_utils_async_once_type_id;
		synapse_utils_async_once_type_id = synapse_utils_async_once_get_type_once ();
		g_once_init_leave (&synapse_utils_async_once_type_id__once, synapse_utils_async_once_type_id);
	}
	return synapse_utils_async_once_type_id__once;
}

gpointer
synapse_utils_async_once_ref (gpointer instance)
{
	SynapseUtilsAsyncOnce * self;
	self = instance;
#line 414 "utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 414 "utils.vala"
	return instance;
#line 3815 "utils.c"
}

void
synapse_utils_async_once_unref (gpointer instance)
{
	SynapseUtilsAsyncOnce * self;
	self = instance;
#line 414 "utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 414 "utils.vala"
		SYNAPSE_UTILS_ASYNC_ONCE_GET_CLASS (self)->finalize (self);
#line 414 "utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3829 "utils.c"
	}
}

static inline gpointer
synapse_utils_file_info_get_instance_private (SynapseUtilsFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUtilsFileInfo_private_offset);
}

SynapseUtilsFileInfo*
synapse_utils_file_info_construct (GType object_type,
                                   const gchar* uri,
                                   GType obj_type)
{
	SynapseUtilsFileInfo* self = NULL;
	gchar* _tmp0_;
	GFile* f = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
#line 523 "utils.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 523 "utils.vala"
	self = (SynapseUtilsFileInfo*) g_type_create_instance (object_type);
#line 525 "utils.vala"
	_vala_assert (g_type_is_a (obj_type, SYNAPSE_TYPE_URI_MATCH), "obj_type.is_a (typeof (UriMatch))");
#line 526 "utils.vala"
	_tmp0_ = g_strdup (uri);
#line 526 "utils.vala"
	_g_free0 (self->uri);
#line 526 "utils.vala"
	self->uri = _tmp0_;
#line 527 "utils.vala"
	_g_object_unref0 (self->match_obj);
#line 527 "utils.vala"
	self->match_obj = NULL;
#line 528 "utils.vala"
	self->priv->match_obj_type = obj_type;
#line 529 "utils.vala"
	self->priv->initialized = FALSE;
#line 530 "utils.vala"
	self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
#line 532 "utils.vala"
	_tmp1_ = g_file_new_for_uri (uri);
#line 532 "utils.vala"
	f = _tmp1_;
#line 533 "utils.vala"
	_tmp2_ = g_file_get_parse_name (f);
#line 533 "utils.vala"
	_g_free0 (self->parse_name);
#line 533 "utils.vala"
	self->parse_name = _tmp2_;
#line 523 "utils.vala"
	_g_object_unref0 (f);
#line 523 "utils.vala"
	return self;
#line 3885 "utils.c"
}

SynapseUtilsFileInfo*
synapse_utils_file_info_new (const gchar* uri,
                             GType obj_type)
{
#line 523 "utils.vala"
	return synapse_utils_file_info_construct (SYNAPSE_UTILS_TYPE_FILE_INFO, uri, obj_type);
#line 3894 "utils.c"
}

gboolean
synapse_utils_file_info_is_initialized (SynapseUtilsFileInfo* self)
{
	gboolean result;
#line 536 "utils.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 538 "utils.vala"
	result = self->priv->initialized;
#line 538 "utils.vala"
	return result;
#line 3907 "utils.c"
}

static void
synapse_utils_file_info_initialize_data_free (gpointer _data)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	_data_ = _data;
#line 500 "utils.vala"
	_synapse_utils_file_info_unref0 (_data_->self);
#line 500 "utils.vala"
	g_slice_free (SynapseUtilsFileInfoInitializeData, _data_);
#line 3919 "utils.c"
}

static gpointer
_synapse_utils_file_info_ref0 (gpointer self)
{
#line 500 "utils.vala"
	return self ? synapse_utils_file_info_ref (self) : NULL;
#line 3927 "utils.c"
}

void
synapse_utils_file_info_initialize (SynapseUtilsFileInfo* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
	SynapseUtilsFileInfo* _tmp0_;
#line 500 "utils.vala"
	g_return_if_fail (self != NULL);
#line 500 "utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsFileInfoInitializeData);
#line 500 "utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 500 "utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_file_info_initialize_data_free);
#line 500 "utils.vala"
	_tmp0_ = _synapse_utils_file_info_ref0 (self);
#line 500 "utils.vala"
	_data_->self = _tmp0_;
#line 500 "utils.vala"
	synapse_utils_file_info_initialize_co (_data_);
#line 3951 "utils.c"
}

void
synapse_utils_file_info_initialize_finish (SynapseUtilsFileInfo* self,
                                           GAsyncResult* _res_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
#line 500 "utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3961 "utils.c"
}

static void
synapse_utils_file_info_initialize_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	SynapseUtilsFileInfoInitializeData* _data_;
#line 547 "utils.vala"
	_data_ = _user_data_;
#line 547 "utils.vala"
	_data_->_source_object_ = source_object;
#line 547 "utils.vala"
	_data_->_res_ = _res_;
#line 547 "utils.vala"
	synapse_utils_file_info_initialize_co (_data_);
#line 3978 "utils.c"
}

static gboolean
synapse_utils_file_info_initialize_co (SynapseUtilsFileInfoInitializeData* _data_)
{
#line 541 "utils.vala"
	switch (_data_->_state_) {
#line 541 "utils.vala"
		case 0:
#line 3988 "utils.c"
		goto _state_0;
#line 545 "utils.vala"
		case 1:
#line 3992 "utils.c"
		goto _state_1;
		default:
#line 545 "utils.vala"
		g_assert_not_reached ();
#line 3997 "utils.c"
	}
	_state_0:
#line 543 "utils.vala"
	_data_->self->priv->initialized = TRUE;
#line 544 "utils.vala"
	_data_->_tmp0_ = _data_->self->uri;
#line 544 "utils.vala"
	_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
#line 544 "utils.vala"
	_data_->f = _data_->_tmp1_;
#line 4008 "utils.c"
	{
#line 547 "utils.vala"
		_data_->_tmp2_ = synapse_utils_file_info_interesting_attributes;
#line 547 "utils.vala"
		_data_->_state_ = 1;
#line 547 "utils.vala"
		g_file_query_info_async (_data_->f, _data_->_tmp2_, 0, 0, NULL, synapse_utils_file_info_initialize_ready, _data_);
#line 547 "utils.vala"
		return FALSE;
#line 4018 "utils.c"
		_state_1:
#line 547 "utils.vala"
		_data_->_tmp3_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error0_);
#line 547 "utils.vala"
		_data_->fi = _data_->_tmp3_;
#line 547 "utils.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 4026 "utils.c"
			goto __catch0_g_error;
		}
#line 549 "utils.vala"
		if (g_file_info_get_file_type (_data_->fi) == G_FILE_TYPE_REGULAR) {
#line 550 "utils.vala"
			_data_->_tmp5_ = !g_file_info_get_is_hidden (_data_->fi);
#line 4033 "utils.c"
		} else {
#line 549 "utils.vala"
			_data_->_tmp5_ = FALSE;
#line 4037 "utils.c"
		}
#line 549 "utils.vala"
		if (_data_->_tmp5_) {
#line 551 "utils.vala"
			_data_->_tmp4_ = !g_file_info_get_is_backup (_data_->fi);
#line 4043 "utils.c"
		} else {
#line 549 "utils.vala"
			_data_->_tmp4_ = FALSE;
#line 4047 "utils.c"
		}
#line 549 "utils.vala"
		if (_data_->_tmp4_) {
#line 553 "utils.vala"
			_data_->_tmp6_ = g_file_info_get_attribute_byte_string (_data_->fi, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 553 "utils.vala"
			_data_->_tmp7_ = g_file_info_get_icon (_data_->fi);
#line 553 "utils.vala"
			_data_->_tmp8_ = g_icon_to_string (_data_->_tmp7_);
#line 553 "utils.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 553 "utils.vala"
			_data_->_tmp10_ = _data_->self->uri;
#line 553 "utils.vala"
			_data_->_tmp11_ = g_file_info_get_display_name (_data_->fi);
#line 553 "utils.vala"
			_data_->_tmp12_ = g_file_get_parse_name (_data_->f);
#line 553 "utils.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 553 "utils.vala"
			_data_->_tmp14_ = g_object_new (_data_->self->priv->match_obj_type, "thumbnail-path", _data_->_tmp6_, "icon-name", _data_->_tmp9_, "uri", _data_->_tmp10_, "title", _data_->_tmp11_, "description", _data_->_tmp13_, NULL, NULL);
#line 553 "utils.vala"
			_data_->_tmp15_ = G_IS_INITIALLY_UNOWNED (_data_->_tmp14_) ? g_object_ref_sink (_data_->_tmp14_) : _data_->_tmp14_;
#line 553 "utils.vala"
			_g_object_unref0 (_data_->self->match_obj);
#line 553 "utils.vala"
			_data_->self->match_obj = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 553 "utils.vala"
			_g_free0 (_data_->_tmp13_);
#line 553 "utils.vala"
			_g_free0 (_data_->_tmp9_);
#line 565 "utils.vala"
			_data_->_tmp17_ = g_file_info_get_attribute_string (_data_->fi, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
#line 565 "utils.vala"
			_data_->_tmp16_ = _data_->_tmp17_;
#line 565 "utils.vala"
			if (_data_->_tmp16_ == NULL) {
#line 565 "utils.vala"
				_data_->_tmp16_ = "application/octet-stream";
#line 4087 "utils.c"
			}
#line 564 "utils.vala"
			_data_->mime_type = _data_->_tmp16_;
#line 566 "utils.vala"
			_data_->_tmp18_ = _data_->mime_type;
#line 566 "utils.vala"
			if (g_content_type_is_unknown (_data_->_tmp18_)) {
#line 568 "utils.vala"
				_data_->self->file_type = SYNAPSE_QUERY_FLAGS_UNCATEGORIZED;
#line 4097 "utils.c"
			} else {
#line 570 "utils.vala"
				_data_->_tmp19_ = _data_->mime_type;
#line 570 "utils.vala"
				if (g_content_type_is_a (_data_->_tmp19_, "audio/*")) {
#line 572 "utils.vala"
					_data_->self->file_type = SYNAPSE_QUERY_FLAGS_AUDIO;
#line 4105 "utils.c"
				} else {
#line 574 "utils.vala"
					_data_->_tmp20_ = _data_->mime_type;
#line 574 "utils.vala"
					if (g_content_type_is_a (_data_->_tmp20_, "video/*")) {
#line 576 "utils.vala"
						_data_->self->file_type = SYNAPSE_QUERY_FLAGS_VIDEO;
#line 4113 "utils.c"
					} else {
#line 578 "utils.vala"
						_data_->_tmp21_ = _data_->mime_type;
#line 578 "utils.vala"
						if (g_content_type_is_a (_data_->_tmp21_, "image/*")) {
#line 580 "utils.vala"
							_data_->self->file_type = SYNAPSE_QUERY_FLAGS_IMAGES;
#line 4121 "utils.c"
						} else {
#line 582 "utils.vala"
							_data_->_tmp22_ = _data_->mime_type;
#line 582 "utils.vala"
							if (g_content_type_is_a (_data_->_tmp22_, "text/*")) {
#line 584 "utils.vala"
								_data_->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
#line 4129 "utils.c"
							} else {
#line 587 "utils.vala"
								_data_->_tmp23_ = _data_->mime_type;
#line 587 "utils.vala"
								if (g_content_type_is_a (_data_->_tmp23_, "application/*")) {
#line 589 "utils.vala"
									_data_->self->file_type = SYNAPSE_QUERY_FLAGS_DOCUMENTS;
#line 4137 "utils.c"
								}
							}
						}
					}
				}
			}
#line 592 "utils.vala"
			_data_->_tmp24_ = _data_->self->match_obj;
#line 592 "utils.vala"
			synapse_uri_match_set_file_type (_data_->_tmp24_, _data_->self->file_type);
#line 593 "utils.vala"
			_data_->_tmp25_ = _data_->self->match_obj;
#line 593 "utils.vala"
			_data_->_tmp26_ = _data_->mime_type;
#line 593 "utils.vala"
			synapse_uri_match_set_mime_type (_data_->_tmp25_, _data_->_tmp26_);
#line 4154 "utils.c"
		}
#line 549 "utils.vala"
		_g_object_unref0 (_data_->fi);
#line 4158 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 549 "utils.vala"
		_data_->err = _data_->_inner_error0_;
#line 549 "utils.vala"
		_data_->_inner_error0_ = NULL;
#line 598 "utils.vala"
		_data_->_tmp27_ = _data_->err;
#line 598 "utils.vala"
		_data_->_tmp28_ = _data_->_tmp27_->message;
#line 598 "utils.vala"
		g_warning ("utils.vala:598: %s", _data_->_tmp28_);
#line 549 "utils.vala"
		_g_error_free0 (_data_->err);
#line 4175 "utils.c"
	}
	__finally0:
#line 549 "utils.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 549 "utils.vala"
		_g_object_unref0 (_data_->f);
#line 549 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 549 "utils.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 549 "utils.vala"
		g_object_unref (_data_->_async_result);
#line 549 "utils.vala"
		return FALSE;
#line 4190 "utils.c"
	}
#line 545 "utils.vala"
	_g_object_unref0 (_data_->f);
#line 545 "utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 545 "utils.vala"
	if (_data_->_state_ != 0) {
#line 545 "utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 545 "utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4202 "utils.c"
		}
	}
#line 545 "utils.vala"
	g_object_unref (_data_->_async_result);
#line 545 "utils.vala"
	return FALSE;
#line 4209 "utils.c"
}

static void
synapse_utils_file_info_exists_data_free (gpointer _data)
{
	SynapseUtilsFileInfoExistsData* _data_;
	_data_ = _data;
#line 541 "utils.vala"
	_synapse_utils_file_info_unref0 (_data_->self);
#line 541 "utils.vala"
	g_slice_free (SynapseUtilsFileInfoExistsData, _data_);
#line 4221 "utils.c"
}

void
synapse_utils_file_info_exists (SynapseUtilsFileInfo* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SynapseUtilsFileInfoExistsData* _data_;
	SynapseUtilsFileInfo* _tmp0_;
#line 541 "utils.vala"
	g_return_if_fail (self != NULL);
#line 541 "utils.vala"
	_data_ = g_slice_new0 (SynapseUtilsFileInfoExistsData);
#line 541 "utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 541 "utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_utils_file_info_exists_data_free);
#line 541 "utils.vala"
	_tmp0_ = _synapse_utils_file_info_ref0 (self);
#line 541 "utils.vala"
	_data_->self = _tmp0_;
#line 541 "utils.vala"
	synapse_utils_file_info_exists_co (_data_);
#line 4245 "utils.c"
}

gboolean
synapse_utils_file_info_exists_finish (SynapseUtilsFileInfo* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	SynapseUtilsFileInfoExistsData* _data_;
#line 541 "utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 541 "utils.vala"
	result = _data_->result;
#line 541 "utils.vala"
	return result;
#line 4260 "utils.c"
}

static void
synapse_utils_file_info_exists_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SynapseUtilsFileInfoExistsData* _data_;
#line 605 "utils.vala"
	_data_ = _user_data_;
#line 605 "utils.vala"
	_data_->_source_object_ = source_object;
#line 605 "utils.vala"
	_data_->_res_ = _res_;
#line 605 "utils.vala"
	synapse_utils_file_info_exists_co (_data_);
#line 4277 "utils.c"
}

static gboolean
synapse_utils_file_info_exists_co (SynapseUtilsFileInfoExistsData* _data_)
{
#line 602 "utils.vala"
	switch (_data_->_state_) {
#line 602 "utils.vala"
		case 0:
#line 4287 "utils.c"
		goto _state_0;
#line 602 "utils.vala"
		case 1:
#line 4291 "utils.c"
		goto _state_1;
		default:
#line 602 "utils.vala"
		g_assert_not_reached ();
#line 4296 "utils.c"
	}
	_state_0:
#line 604 "utils.vala"
	_data_->_tmp0_ = _data_->self->uri;
#line 604 "utils.vala"
	_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
#line 604 "utils.vala"
	_data_->f = _data_->_tmp1_;
#line 605 "utils.vala"
	_data_->_state_ = 1;
#line 605 "utils.vala"
	synapse_utils_query_exists_async (_data_->f, synapse_utils_file_info_exists_ready, _data_);
#line 605 "utils.vala"
	return FALSE;
#line 4311 "utils.c"
	_state_1:
#line 605 "utils.vala"
	_data_->_result_ = synapse_utils_query_exists_finish (_data_->_res_);
#line 607 "utils.vala"
	_data_->result = _data_->_result_;
#line 607 "utils.vala"
	_g_object_unref0 (_data_->f);
#line 607 "utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 607 "utils.vala"
	if (_data_->_state_ != 0) {
#line 607 "utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 607 "utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4327 "utils.c"
		}
	}
#line 607 "utils.vala"
	g_object_unref (_data_->_async_result);
#line 607 "utils.vala"
	return FALSE;
#line 4334 "utils.c"
}

static void
synapse_utils_value_file_info_init (GValue* value)
{
#line 541 "utils.vala"
	value->data[0].v_pointer = NULL;
#line 4342 "utils.c"
}

static void
synapse_utils_value_file_info_free_value (GValue* value)
{
#line 541 "utils.vala"
	if (value->data[0].v_pointer) {
#line 541 "utils.vala"
		synapse_utils_file_info_unref (value->data[0].v_pointer);
#line 4352 "utils.c"
	}
}

static void
synapse_utils_value_file_info_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 541 "utils.vala"
	if (src_value->data[0].v_pointer) {
#line 541 "utils.vala"
		dest_value->data[0].v_pointer = synapse_utils_file_info_ref (src_value->data[0].v_pointer);
#line 4364 "utils.c"
	} else {
#line 541 "utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4368 "utils.c"
	}
}

static gpointer
synapse_utils_value_file_info_peek_pointer (const GValue* value)
{
#line 541 "utils.vala"
	return value->data[0].v_pointer;
#line 4377 "utils.c"
}

static gchar*
synapse_utils_value_file_info_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 541 "utils.vala"
	if (collect_values[0].v_pointer) {
#line 4388 "utils.c"
		SynapseUtilsFileInfo * object;
		object = collect_values[0].v_pointer;
#line 541 "utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 541 "utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4395 "utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 541 "utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4399 "utils.c"
		}
#line 541 "utils.vala"
		value->data[0].v_pointer = synapse_utils_file_info_ref (object);
#line 4403 "utils.c"
	} else {
#line 541 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 4407 "utils.c"
	}
#line 541 "utils.vala"
	return NULL;
#line 4411 "utils.c"
}

static gchar*
synapse_utils_value_file_info_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	SynapseUtilsFileInfo ** object_p;
	object_p = collect_values[0].v_pointer;
#line 541 "utils.vala"
	if (!object_p) {
#line 541 "utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4426 "utils.c"
	}
#line 541 "utils.vala"
	if (!value->data[0].v_pointer) {
#line 541 "utils.vala"
		*object_p = NULL;
#line 4432 "utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 541 "utils.vala"
		*object_p = value->data[0].v_pointer;
#line 4436 "utils.c"
	} else {
#line 541 "utils.vala"
		*object_p = synapse_utils_file_info_ref (value->data[0].v_pointer);
#line 4440 "utils.c"
	}
#line 541 "utils.vala"
	return NULL;
#line 4444 "utils.c"
}

GParamSpec*
synapse_utils_param_spec_file_info (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	SynapseUtilsParamSpecFileInfo* spec;
#line 541 "utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
#line 541 "utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 541 "utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 541 "utils.vala"
	return G_PARAM_SPEC (spec);
#line 4463 "utils.c"
}

gpointer
synapse_utils_value_get_file_info (const GValue* value)
{
#line 541 "utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO), NULL);
#line 541 "utils.vala"
	return value->data[0].v_pointer;
#line 4473 "utils.c"
}

void
synapse_utils_value_set_file_info (GValue* value,
                                   gpointer v_object)
{
	SynapseUtilsFileInfo * old;
#line 541 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 541 "utils.vala"
	old = value->data[0].v_pointer;
#line 541 "utils.vala"
	if (v_object) {
#line 541 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 541 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 541 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 541 "utils.vala"
		synapse_utils_file_info_ref (value->data[0].v_pointer);
#line 4495 "utils.c"
	} else {
#line 541 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 4499 "utils.c"
	}
#line 541 "utils.vala"
	if (old) {
#line 541 "utils.vala"
		synapse_utils_file_info_unref (old);
#line 4505 "utils.c"
	}
}

void
synapse_utils_value_take_file_info (GValue* value,
                                    gpointer v_object)
{
	SynapseUtilsFileInfo * old;
#line 541 "utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 541 "utils.vala"
	old = value->data[0].v_pointer;
#line 541 "utils.vala"
	if (v_object) {
#line 541 "utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SYNAPSE_UTILS_TYPE_FILE_INFO));
#line 541 "utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 541 "utils.vala"
		value->data[0].v_pointer = v_object;
#line 4526 "utils.c"
	} else {
#line 541 "utils.vala"
		value->data[0].v_pointer = NULL;
#line 4530 "utils.c"
	}
#line 541 "utils.vala"
	if (old) {
#line 541 "utils.vala"
		synapse_utils_file_info_unref (old);
#line 4536 "utils.c"
	}
}

static void
synapse_utils_file_info_class_init (SynapseUtilsFileInfoClass * klass,
                                    gpointer klass_data)
{
	gchar* _tmp0_;
#line 500 "utils.vala"
	synapse_utils_file_info_parent_class = g_type_class_peek_parent (klass);
#line 500 "utils.vala"
	((SynapseUtilsFileInfoClass *) klass)->finalize = synapse_utils_file_info_finalize;
#line 500 "utils.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUtilsFileInfo_private_offset);
#line 505 "utils.vala"
	_tmp0_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE, G_FILE_ATTRIBUTE_THUMBNAIL_PATH, NULL, NULL);
#line 505 "utils.vala"
	_g_free0 (synapse_utils_file_info_interesting_attributes);
#line 505 "utils.vala"
	synapse_utils_file_info_interesting_attributes = _tmp0_;
#line 4557 "utils.c"
}

static void
synapse_utils_file_info_instance_init (SynapseUtilsFileInfo * self,
                                       gpointer klass)
{
#line 500 "utils.vala"
	self->priv = synapse_utils_file_info_get_instance_private (self);
#line 541 "utils.vala"
	self->ref_count = 1;
#line 4568 "utils.c"
}

static void
synapse_utils_file_info_finalize (SynapseUtilsFileInfo * obj)
{
	SynapseUtilsFileInfo * self;
#line 500 "utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_UTILS_TYPE_FILE_INFO, SynapseUtilsFileInfo);
#line 500 "utils.vala"
	g_signal_handlers_destroy (self);
#line 516 "utils.vala"
	_g_free0 (self->uri);
#line 517 "utils.vala"
	_g_free0 (self->parse_name);
#line 519 "utils.vala"
	_g_object_unref0 (self->match_obj);
#line 4585 "utils.c"
}

static GType
synapse_utils_file_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { synapse_utils_value_file_info_init, synapse_utils_value_file_info_free_value, synapse_utils_value_file_info_copy_value, synapse_utils_value_file_info_peek_pointer, "p", synapse_utils_value_file_info_collect_value, "p", synapse_utils_value_file_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUtilsFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_utils_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUtilsFileInfo), 0, (GInstanceInitFunc) synapse_utils_file_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType synapse_utils_file_info_type_id;
	synapse_utils_file_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SynapseUtilsFileInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SynapseUtilsFileInfo_private_offset = g_type_add_instance_private (synapse_utils_file_info_type_id, sizeof (SynapseUtilsFileInfoPrivate));
	return synapse_utils_file_info_type_id;
}

GType
synapse_utils_file_info_get_type (void)
{
	static volatile gsize synapse_utils_file_info_type_id__once = 0;
	if (g_once_init_enter (&synapse_utils_file_info_type_id__once)) {
		GType synapse_utils_file_info_type_id;
		synapse_utils_file_info_type_id = synapse_utils_file_info_get_type_once ();
		g_once_init_leave (&synapse_utils_file_info_type_id__once, synapse_utils_file_info_type_id);
	}
	return synapse_utils_file_info_type_id__once;
}

gpointer
synapse_utils_file_info_ref (gpointer instance)
{
	SynapseUtilsFileInfo * self;
	self = instance;
#line 541 "utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 541 "utils.vala"
	return instance;
#line 4621 "utils.c"
}

void
synapse_utils_file_info_unref (gpointer instance)
{
	SynapseUtilsFileInfo * self;
	self = instance;
#line 541 "utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 541 "utils.vala"
		SYNAPSE_UTILS_FILE_INFO_GET_CLASS (self)->finalize (self);
#line 541 "utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4635 "utils.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 500 "utils.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 4646 "utils.c"
		gssize i;
#line 500 "utils.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 500 "utils.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 500 "utils.vala"
				destroy_func (((gpointer*) array)[i]);
#line 4654 "utils.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 500 "utils.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 500 "utils.vala"
	g_free (array);
#line 4669 "utils.c"
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
#line 500 "utils.vala"
	if (array) {
#line 500 "utils.vala"
		while (((gpointer*) array)[length]) {
#line 500 "utils.vala"
			length++;
#line 4683 "utils.c"
		}
	}
#line 500 "utils.vala"
	return length;
#line 4688 "utils.c"
}

