// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "CornerPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

CornerPropertyGroup::CornerPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_image = std::make_unique<ImagePropertyGroup>(m_style);
}

void CornerPropertyGroup::update(const std::optional<CornerProperty> &newState)
{
    m_state = newState;

    if (!newState) {
        m_image->update(std::nullopt);
    } else {
        m_image->update(newState.value().image());
    }

    Q_EMIT radiusChanged();
    Q_EMIT widthChanged();
    Q_EMIT heightChanged();
    Q_EMIT colorChanged();
    Q_EMIT updated();
}

QJSValue CornerPropertyGroup::radius() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().radius();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue CornerPropertyGroup::width() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().width();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue CornerPropertyGroup::height() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().height();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue CornerPropertyGroup::color() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().color();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

ImagePropertyGroup *CornerPropertyGroup::image() const
{
    return m_image.get();
}

#include "moc_CornerPropertyGroup.cpp"