package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetKeyPolicy invokes the kms.SetKeyPolicy API synchronously
func (client *Client) SetKeyPolicy(request *SetKeyPolicyRequest) (response *SetKeyPolicyResponse, err error) {
	response = CreateSetKeyPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// SetKeyPolicyWithChan invokes the kms.SetKeyPolicy API asynchronously
func (client *Client) SetKeyPolicyWithChan(request *SetKeyPolicyRequest) (<-chan *SetKeyPolicyResponse, <-chan error) {
	responseChan := make(chan *SetKeyPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetKeyPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetKeyPolicyWithCallback invokes the kms.SetKeyPolicy API asynchronously
func (client *Client) SetKeyPolicyWithCallback(request *SetKeyPolicyRequest, callback func(response *SetKeyPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetKeyPolicyResponse
		var err error
		defer close(result)
		response, err = client.SetKeyPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetKeyPolicyRequest is the request struct for api SetKeyPolicy
type SetKeyPolicyRequest struct {
	*requests.RpcRequest
	KeyId      string `position:"Query" name:"KeyId"`
	PolicyName string `position:"Query" name:"PolicyName"`
	Policy     string `position:"Query" name:"Policy"`
}

// SetKeyPolicyResponse is the response struct for api SetKeyPolicy
type SetKeyPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetKeyPolicyRequest creates a request to invoke SetKeyPolicy API
func CreateSetKeyPolicyRequest() (request *SetKeyPolicyRequest) {
	request = &SetKeyPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "SetKeyPolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetKeyPolicyResponse creates a response to parse from SetKeyPolicy response
func CreateSetKeyPolicyResponse() (response *SetKeyPolicyResponse) {
	response = &SetKeyPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
