/* Util.c generated by valac 0.56.17, the Vala compiler
 * generated from Util.vala, do not modify */

/*
 * Copyright 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "datetime.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <libical-glib/libical-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libedataserver/libedataserver.h>
#include <libecal/libecal.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN GeeHashMap* util_providers;
GeeHashMap* util_providers = NULL;

static void _vala_ECalComponentId_free (ECalComponentId* self);

GDateTime*
util_get_start_of_month (GDateTime* date)
{
	GDateTime* _tmp1_;
	GDateTime* result;
	if (date == NULL) {
		GDateTime* _tmp0_;
		_tmp0_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (date);
		date = _tmp0_;
	}
	_tmp1_ = g_date_time_new_local (g_date_time_get_year (date), g_date_time_get_month (date), 1, 0, 0, (gdouble) 0);
	result = _tmp1_;
	_g_date_time_unref0 (date);
	return result;
}

GDateTime*
util_strip_time (GDateTime* datetime)
{
	GDateTime* _tmp0_;
	GDateTime* result;
	g_return_val_if_fail (datetime != NULL, NULL);
	_tmp0_ = g_date_time_add_full (datetime, 0, 0, 0, -g_date_time_get_hour (datetime), -g_date_time_get_minute (datetime), (gdouble) (-g_date_time_get_second (datetime)));
	result = _tmp0_;
	return result;
}

/**
     * Gets the timezone of the given TimeType as a GLib.TimeZone.
     */
static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

GTimeZone*
util_timezone_from_ical (ICalTime* date)
{
	const gchar* tzid = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	static const char LIBICAL_TZ_PREFIX[] = "/freeassociation.sourceforge.net/";
	const gchar* _tmp5_;
	GTimeZone* result;
	g_return_val_if_fail (date != NULL, NULL);
	if (i_cal_time_is_date (date)) {
		GTimeZone* _tmp0_;
		_tmp0_ = g_time_zone_new_local ();
		result = _tmp0_;
		return result;
	}
	_tmp1_ = i_cal_time_get_tzid (date);
	tzid = _tmp1_;
	_tmp2_ = tzid;
	if (_tmp2_ == NULL) {
		ICalTimezone* _tmp3_;
		GTimeZone* _tmp4_;
		_tmp3_ = i_cal_time_get_timezone (date);
		_vala_assert (_tmp3_ == NULL, "date.get_timezone () == null");
		_tmp4_ = g_time_zone_new_local ();
		result = _tmp4_;
		return result;
	}
	_tmp5_ = tzid;
	if (g_str_has_prefix (_tmp5_, LIBICAL_TZ_PREFIX)) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		GTimeZone* _tmp10_;
		_tmp6_ = tzid;
		_tmp7_ = strlen (LIBICAL_TZ_PREFIX);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_offset (_tmp6_, (glong) _tmp8_);
		_tmp10_ = g_time_zone_new (_tmp9_);
		result = _tmp10_;
		return result;
	} else {
		const gchar* _tmp11_;
		GTimeZone* _tmp12_;
		_tmp11_ = tzid;
		_tmp12_ = g_time_zone_new (_tmp11_);
		result = _tmp12_;
		return result;
	}
}

/**
     * Converts the given ICal.Time to a DateTime.
     * XXX : Track next versions of evolution in order to convert ICal.Timezone to GLib.TimeZone with a dedicated function…
     */
GDateTime*
util_ical_to_date_time (ICalTime* date)
{
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint minute = 0;
	gint second = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GTimeZone* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* result;
	g_return_val_if_fail (date != NULL, NULL);
	i_cal_time_get_date (date, &_tmp0_, &_tmp1_, &_tmp2_);
	year = _tmp0_;
	month = _tmp1_;
	day = _tmp2_;
	i_cal_time_get_time (date, &_tmp3_, &_tmp4_, &_tmp5_);
	hour = _tmp3_;
	minute = _tmp4_;
	second = _tmp5_;
	_tmp6_ = util_timezone_from_ical (date);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_new (_tmp7_, year, month, day, hour, minute, (gdouble) second);
	_tmp9_ = _tmp8_;
	_g_time_zone_unref0 (_tmp7_);
	result = _tmp9_;
	return result;
}

/**
     * Say if an event lasts all day.
     */
gboolean
util_is_the_all_day (GDateTime* dtstart,
                     GDateTime* dtend)
{
	GDateTime* utc_start = NULL;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GTimeSpan timespan = 0LL;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (dtstart != NULL, FALSE);
	g_return_val_if_fail (dtend != NULL, FALSE);
	_tmp0_ = g_time_zone_new_utc ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_to_timezone (dtstart, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_time_zone_unref0 (_tmp1_);
	utc_start = _tmp3_;
	timespan = g_date_time_difference (dtend, dtstart);
	if ((timespan % G_TIME_SPAN_DAY) == ((GTimeSpan) 0)) {
		GDateTime* _tmp5_;
		_tmp5_ = utc_start;
		_tmp4_ = g_date_time_get_hour (_tmp5_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		_g_date_time_unref0 (utc_start);
		return result;
	} else {
		result = FALSE;
		_g_date_time_unref0 (utc_start);
		return result;
	}
}

void
util_set_component_calendar_color (ESourceSelectable* selectable,
                                   GtkWidget* widget)
{
	GeeHashMap* _tmp0_;
	gchar* color = NULL;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp18_;
	GeeHashMap* _tmp19_;
	const gchar* _tmp20_;
	gpointer _tmp21_;
	GtkCssProvider* _tmp22_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (selectable != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = util_providers;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_css_provider_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (util_providers);
		util_providers = _tmp1_;
	}
	_tmp2_ = e_source_selectable_dup_color (selectable);
	color = _tmp2_;
	_tmp3_ = util_providers;
	_tmp4_ = color;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_)) {
		gchar* style = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = color;
		_tmp6_ = g_strdup_printf ("\n                @define-color accent_color %s;\n            ", _tmp5_);
		style = _tmp6_;
		{
			GtkCssProvider* style_provider = NULL;
			GtkCssProvider* _tmp7_;
			GtkCssProvider* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GeeHashMap* _tmp13_;
			const gchar* _tmp14_;
			GtkCssProvider* _tmp15_;
			_tmp7_ = gtk_css_provider_new ();
			style_provider = _tmp7_;
			_tmp8_ = style_provider;
			_tmp9_ = style;
			_tmp10_ = style;
			_tmp11_ = strlen (_tmp10_);
			_tmp12_ = _tmp11_;
			gtk_css_provider_load_from_data (_tmp8_, _tmp9_, (gssize) _tmp12_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (style_provider);
				goto __catch0_g_error;
			}
			_tmp13_ = util_providers;
			_tmp14_ = color;
			_tmp15_ = style_provider;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, _tmp15_);
			_g_object_unref0 (style_provider);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_critical ("Util.vala:123: Unable to set calendar color: %s", _tmp17_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (style);
			_g_free0 (color);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (style);
	}
	_tmp18_ = gtk_widget_get_style_context (widget);
	style_context = _tmp18_;
	_tmp19_ = util_providers;
	_tmp20_ = color;
	_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
	_tmp22_ = (GtkCssProvider*) _tmp21_;
	gtk_style_context_add_provider (style_context, (GtkStyleProvider*) _tmp22_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (_tmp22_);
	_g_free0 (color);
}

guint
util_source_hash_func (ESource* key)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (key != NULL, 0U);
	_tmp0_ = e_source_dup_uid (key);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_hash (_tmp1_);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

gboolean
util_calcomponent_equal_func (ECalComponent* a,
                              ECalComponent* b)
{
	ECalComponentId* _tmp0_;
	ECalComponentId* _tmp1_;
	ECalComponentId* _tmp2_;
	ECalComponentId* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = e_cal_component_get_id (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_cal_component_get_id (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_id_equal (_tmp1_, _tmp3_);
	__vala_ECalComponentId_free0 (_tmp3_);
	__vala_ECalComponentId_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gint
util_calcomponent_compare_func (ECalComponent* a,
                                ECalComponent* b)
{
	gboolean _tmp0_ = FALSE;
	ECalComponentId* a_id = NULL;
	ECalComponentId* _tmp3_;
	ECalComponentId* b_id = NULL;
	ECalComponentId* _tmp4_;
	gint res = 0;
	GCompareFunc _tmp5_;
	ECalComponentId* _tmp6_;
	const gchar* _tmp7_;
	ECalComponentId* _tmp8_;
	const gchar* _tmp9_;
	gint result;
	if (a == NULL) {
		_tmp0_ = b != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 1;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (b == NULL) {
			_tmp1_ = a != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = -1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (b == NULL) {
				_tmp2_ = a == NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = 0;
				return result;
			}
		}
	}
	_tmp3_ = e_cal_component_get_id (a);
	a_id = _tmp3_;
	_tmp4_ = e_cal_component_get_id (b);
	b_id = _tmp4_;
	_tmp5_ = ((GCompareFunc) g_strcmp0);
	_tmp6_ = a_id;
	_tmp7_ = e_cal_component_id_get_uid (_tmp6_);
	_tmp8_ = b_id;
	_tmp9_ = e_cal_component_id_get_uid (_tmp8_);
	res = _tmp5_ (_tmp7_, _tmp9_);
	if (res == 0) {
		GCompareFunc _tmp10_;
		ECalComponentId* _tmp11_;
		const gchar* _tmp12_;
		ECalComponentId* _tmp13_;
		const gchar* _tmp14_;
		_tmp10_ = ((GCompareFunc) g_strcmp0);
		_tmp11_ = a_id;
		_tmp12_ = e_cal_component_id_get_rid (_tmp11_);
		_tmp13_ = b_id;
		_tmp14_ = e_cal_component_id_get_rid (_tmp13_);
		result = _tmp10_ (_tmp12_, _tmp14_);
		__vala_ECalComponentId_free0 (b_id);
		__vala_ECalComponentId_free0 (a_id);
		return result;
	}
	result = res;
	__vala_ECalComponentId_free0 (b_id);
	__vala_ECalComponentId_free0 (a_id);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
util_calcomp_is_on_day (ECalComponent* comp,
                        GDateTime* day)
{
	ICalTimezone* system_timezone = NULL;
	ICalTimezone* _tmp0_;
	GDateTime* stripped_time = NULL;
	GDateTime* _tmp1_;
	gint64 selected_date_unix = 0LL;
	GDateTime* _tmp2_;
	gint64 selected_date_unix_next = 0LL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gint64 _tmp6_;
	ICalComponent* icomp = NULL;
	ICalComponent* _tmp7_;
	ICalTime* start_time = NULL;
	ICalComponent* _tmp8_;
	ICalTime* _tmp9_;
	ICalTime* due_time = NULL;
	ICalComponent* _tmp10_;
	ICalTime* _tmp11_;
	ICalTime* end_time = NULL;
	ICalComponent* _tmp12_;
	ICalTime* _tmp13_;
	gboolean _tmp14_ = FALSE;
	ICalTime* _tmp15_;
	time_t start_unix = 0;
	ICalTime* _tmp24_;
	ICalTimezone* _tmp25_;
	time_t end_unix = 0;
	ICalTime* _tmp26_;
	ICalTimezone* _tmp27_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean result;
	g_return_val_if_fail (comp != NULL, FALSE);
	g_return_val_if_fail (day != NULL, FALSE);
	_tmp0_ = e_cal_util_get_system_timezone ();
	system_timezone = _tmp0_;
	_tmp1_ = g_date_time_new_local (g_date_time_get_year (day), g_date_time_get_month (day), g_date_time_get_day_of_month (day), 0, 0, (gdouble) 0);
	stripped_time = _tmp1_;
	_tmp2_ = stripped_time;
	selected_date_unix = g_date_time_to_unix (_tmp2_);
	_tmp3_ = stripped_time;
	_tmp4_ = g_date_time_add_days (_tmp3_, 1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_date_time_to_unix (_tmp5_);
	_g_date_time_unref0 (_tmp5_);
	selected_date_unix_next = _tmp6_;
	_tmp7_ = e_cal_component_get_icalcomponent (comp);
	icomp = _tmp7_;
	_tmp8_ = icomp;
	_tmp9_ = i_cal_component_get_dtstart (_tmp8_);
	start_time = _tmp9_;
	_tmp10_ = icomp;
	_tmp11_ = i_cal_component_get_due (_tmp10_);
	due_time = _tmp11_;
	_tmp12_ = icomp;
	_tmp13_ = i_cal_component_get_dtend (_tmp12_);
	end_time = _tmp13_;
	_tmp15_ = due_time;
	if (_tmp15_ != NULL) {
		ICalTime* _tmp16_;
		_tmp16_ = due_time;
		_tmp14_ = !i_cal_time_is_null_time (_tmp16_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ICalTime* _tmp17_;
		ICalTime* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ICalTime* _tmp20_;
		_tmp17_ = due_time;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (end_time);
		end_time = _tmp18_;
		_tmp20_ = start_time;
		if (_tmp20_ == NULL) {
			_tmp19_ = TRUE;
		} else {
			ICalTime* _tmp21_;
			_tmp21_ = start_time;
			_tmp19_ = i_cal_time_is_null_time (_tmp21_);
		}
		if (_tmp19_) {
			ICalTime* _tmp22_;
			ICalTime* _tmp23_;
			_tmp22_ = due_time;
			_tmp23_ = _g_object_ref0 (_tmp22_);
			_g_object_unref0 (start_time);
			start_time = _tmp23_;
		}
	}
	_tmp24_ = start_time;
	_tmp25_ = system_timezone;
	start_unix = i_cal_time_as_timet_with_zone (_tmp24_, _tmp25_);
	_tmp26_ = end_time;
	_tmp27_ = system_timezone;
	end_unix = i_cal_time_as_timet_with_zone (_tmp26_, _tmp27_);
	if (((gint64) start_unix) < selected_date_unix) {
		_tmp28_ = selected_date_unix_next < ((gint64) end_unix);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		result = TRUE;
		_g_object_unref0 (end_time);
		_g_object_unref0 (due_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	if (((gint64) start_unix) < selected_date_unix) {
		_tmp29_ = selected_date_unix < ((gint64) end_unix);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		result = TRUE;
		_g_object_unref0 (end_time);
		_g_object_unref0 (due_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	if (((gint64) start_unix) < selected_date_unix_next) {
		_tmp30_ = selected_date_unix_next < ((gint64) end_unix);
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		result = TRUE;
		_g_object_unref0 (end_time);
		_g_object_unref0 (due_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	if (((gint64) start_unix) < selected_date_unix_next) {
		_tmp31_ = selected_date_unix < ((gint64) end_unix);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		result = TRUE;
		_g_object_unref0 (end_time);
		_g_object_unref0 (due_time);
		_g_object_unref0 (start_time);
		_g_date_time_unref0 (stripped_time);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (end_time);
	_g_object_unref0 (due_time);
	_g_object_unref0 (start_time);
	_g_date_time_unref0 (stripped_time);
	return result;
}

gboolean
util_source_equal_func (ESource* a,
                        ESource* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = e_source_dup_uid (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_source_dup_uid (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

