// Copyright 2022 Woodpecker Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package woodpecker

// Event values.
const (
	EventPush         = "push"
	EventPull         = "pull_request"
	EventPullClosed   = "pull_request_closed"
	EventPullMetadata = "pull_request_metadata"
	EventTag          = "tag"
	EventRelease      = "release"
	EventDeploy       = "deployment"
	EventCron         = "cron"
	EventManual       = "manual"
)

// Status values.
const (
	StatusBlocked = "blocked"
	StatusSkipped = "skipped"
	StatusPending = "pending"
	StatusRunning = "running"
	StatusSuccess = "success"
	StatusFailure = "failure"
	StatusKilled  = "killed"
	StatusError   = "error"
)

// LogEntryType identifies the type of line in the logs.
type LogEntryType int

const (
	LogEntryStdout LogEntryType = iota
	LogEntryStderr
	LogEntryExitCode
	LogEntryMetadata
	LogEntryProgress
)

// StepType identifies the type of step.
type StepType string

const (
	StepTypeClone    StepType = "clone"
	StepTypeService  StepType = "service"
	StepTypePlugin   StepType = "plugin"
	StepTypeCommands StepType = "commands"
	StepTypeCache    StepType = "cache"
)

const defaultForgeID = 1
