/* sql.c generated by valac 0.56.17, the Vala compiler
 * generated from sql.vala, do not modify */

/* sql.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-internal.h"
#include <glib.h>
#include <sqlite3.h>
#include <glib-object.h>
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define ZEITGEIST_SQ_LITE_DATABASE_DEFAULT_OPEN_FLAGS (SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_SQ_LITE_DATABASE_0_PROPERTY,
	ZEITGEIST_SQ_LITE_DATABASE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_sq_lite_database_properties[ZEITGEIST_SQ_LITE_DATABASE_NUM_PROPERTIES];
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block2Data Block2Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistSQLiteDatabasePrivate {
	ZeitgeistSQLiteDeletionCallback deletion_callback;
	gpointer deletion_callback_target;
	GDestroyNotify deletion_callback_target_destroy_notify;
	gboolean is_read_only;
};

struct _Block1Data {
	int _ref_count_;
	ZeitgeistSQLiteDatabase* self;
	gint last_id;
};

struct _Block2Data {
	int _ref_count_;
	ZeitgeistSQLiteDatabase* self;
	ZeitgeistTimeRange* time_range;
};

static gint ZeitgeistSQLiteDatabase_private_offset;
static gpointer zeitgeist_sq_lite_database_parent_class = NULL;

static void zeitgeist_sq_lite_database_open_database (ZeitgeistSQLiteDatabase* self,
                                               gboolean retry,
                                               GError** error);
static void zeitgeist_sq_lite_database_prepare_read_queries (ZeitgeistSQLiteDatabase* self,
                                                      GError** error);
static void zeitgeist_sq_lite_database_prepare_modification_queries (ZeitgeistSQLiteDatabase* self,
                                                              GError** error);
static void _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback (gpointer self,
                                                                         int action,
                                                                         const gchar* dbname,
                                                                         const gchar* table,
                                                                         gint64 rowid);
static void zeitgeist_sq_lite_database_retire_database (GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gint __lambda5_ (Block1Data* _data1_,
                 gint n_columns,
                 gchar** values,
                 gchar** column_names);
static gint ___lambda5__sqlite3_callback (gpointer self,
                                   gint n_columns,
                                   gchar** values,
                                   gchar** column_names);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint __lambda6_ (Block2Data* _data2_,
                 gint n_columns,
                 gchar** values,
                 gchar** column_names);
static gint ___lambda6__sqlite3_callback (gpointer self,
                                   gint n_columns,
                                   gchar** values,
                                   gchar** column_names);
static void zeitgeist_sq_lite_database_finalize (GObject * obj);
static GType zeitgeist_sq_lite_database_get_type_once (void);

static GType
zeitgeist_sq_lite_event_view_rows_get_type_once (void)
{
	static const GEnumValue values[] = {{ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID", "id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP", "timestamp"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION", "interpretation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION", "manifestation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR", "actor"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD", "payload"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI", "subject-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID", "subject-id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION", "subject-interpretation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION", "subject-manifestation"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN", "subject-origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI", "subject-origin-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE", "subject-mimetype"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT", "subject-text"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE", "subject-storage"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE", "subject-storage-state"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN", "event-origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI", "event-origin-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI", "subject-current-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT", "subject-id-current"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT_ID", "subject-text-id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_ID, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_ID", "subject-storage-id"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR_URI", "actor-uri"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN", "subject-current-origin"}, {ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI, "ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI", "subject-current-origin-uri"}, {0, NULL, NULL}};
	GType zeitgeist_sq_lite_event_view_rows_type_id;
	zeitgeist_sq_lite_event_view_rows_type_id = g_enum_register_static ("ZeitgeistSQLiteEventViewRows", values);
	return zeitgeist_sq_lite_event_view_rows_type_id;
}

GType
zeitgeist_sq_lite_event_view_rows_get_type (void)
{
	static volatile gsize zeitgeist_sq_lite_event_view_rows_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_event_view_rows_type_id__once)) {
		GType zeitgeist_sq_lite_event_view_rows_type_id;
		zeitgeist_sq_lite_event_view_rows_type_id = zeitgeist_sq_lite_event_view_rows_get_type_once ();
		g_once_init_leave (&zeitgeist_sq_lite_event_view_rows_type_id__once, zeitgeist_sq_lite_event_view_rows_type_id);
	}
	return zeitgeist_sq_lite_event_view_rows_type_id__once;
}

static inline gpointer
zeitgeist_sq_lite_database_get_instance_private (ZeitgeistSQLiteDatabase* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistSQLiteDatabase_private_offset);
}

static void
_zeitgeist_sq_lite_database_update_callback_sqlite_update_callback (gpointer self,
                                                                    int action,
                                                                    const gchar* dbname,
                                                                    const gchar* table,
                                                                    gint64 rowid)
{
	zeitgeist_sq_lite_database_update_callback ((ZeitgeistSQLiteDatabase*) self, action, dbname, table, rowid);
}

ZeitgeistSQLiteDatabase*
zeitgeist_sq_lite_database_construct (GType object_type,
                                      GError** error)
{
	ZeitgeistSQLiteDatabase * self = NULL;
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistSQLiteDatabase*) g_object_new (object_type, NULL);
	zeitgeist_sq_lite_database_open_database (self, TRUE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_read_queries (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_modification_queries (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = self->database;
	sqlite3_update_hook (_tmp0_, _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback, self);
	return self;
}

ZeitgeistSQLiteDatabase*
zeitgeist_sq_lite_database_new (GError** error)
{
	return zeitgeist_sq_lite_database_construct (ZEITGEIST_SQ_LITE_TYPE_DATABASE, error);
}

ZeitgeistSQLiteDatabase*
zeitgeist_sq_lite_database_construct_read_only (GType object_type,
                                                GError** error)
{
	ZeitgeistSQLiteDatabase * self = NULL;
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistSQLiteDatabase*) g_object_new (object_type, NULL);
	self->priv->is_read_only = TRUE;
	zeitgeist_sq_lite_database_open_database (self, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	zeitgeist_sq_lite_database_prepare_read_queries (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = self->database;
	sqlite3_update_hook (_tmp0_, _zeitgeist_sq_lite_database_update_callback_sqlite_update_callback, self);
	return self;
}

ZeitgeistSQLiteDatabase*
zeitgeist_sq_lite_database_new_read_only (GError** error)
{
	return zeitgeist_sq_lite_database_construct_read_only (ZEITGEIST_SQ_LITE_TYPE_DATABASE, error);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
zeitgeist_sq_lite_database_open_database (ZeitgeistSQLiteDatabase* self,
                                          gboolean retry,
                                          GError** error)
{
	gint _tmp0_ = 0;
	gint flags = 0;
	gint rc = 0;
	const gchar* _tmp1_;
	sqlite3* _tmp2_ = NULL;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->is_read_only) {
		_tmp0_ = SQLITE_OPEN_READONLY;
	} else {
		_tmp0_ = ZEITGEIST_SQ_LITE_DATABASE_DEFAULT_OPEN_FLAGS;
	}
	flags = _tmp0_;
	_tmp1_ = zeitgeist_utils_get_database_file_path ();
	_tmp3_ = sqlite3_open_v2 (_tmp1_, &_tmp2_, flags, NULL);
	_sqlite3_close0 (self->database);
	self->database = _tmp2_;
	rc = _tmp3_;
	if (rc == SQLITE_OK) {
		{
			if (self->priv->is_read_only) {
				gint ver = 0;
				sqlite3* _tmp4_;
				_tmp4_ = self->database;
				ver = zeitgeist_sq_lite_database_schema_get_schema_version (_tmp4_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch0_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				if (ver < ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION) {
					GError* _tmp5_;
					_tmp5_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN, "Unable to open database: old schema version");
					_inner_error0_ = _tmp5_;
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch0_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			} else {
				sqlite3* _tmp6_;
				_tmp6_ = self->database;
				zeitgeist_sq_lite_database_schema_ensure_schema (_tmp6_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch0_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		goto __finally0;
		__catch0_zeitgeist_engine_error:
		{
			GError* err = NULL;
			gboolean _tmp7_ = FALSE;
			GError* _tmp8_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = err;
			if (g_error_matches (_tmp8_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT)) {
				_tmp7_ = retry;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				rc = SQLITE_CORRUPT;
			} else {
				GError* _tmp9_;
				_tmp9_ = err;
				if (g_error_matches (_tmp9_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
					rc = SQLITE_CANTOPEN;
				} else {
					GError* _tmp10_;
					_tmp10_ = err;
					if (g_error_matches (_tmp10_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
						rc = SQLITE_BUSY;
					} else {
						GError* _tmp11_;
						GError* _tmp12_;
						_tmp11_ = err;
						_tmp12_ = _g_error_copy0 (_tmp11_);
						_inner_error0_ = _tmp12_;
						_g_error_free0 (err);
						goto __finally0;
					}
				}
			}
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	if (rc != SQLITE_OK) {
		gboolean _tmp13_ = FALSE;
		if (rc == SQLITE_CORRUPT) {
			_tmp13_ = retry;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			g_warning ("sql.vala:150: %s", "It looks like your database is corrupt. " "It will be renamed and a new one will be created.");
			zeitgeist_sq_lite_database_retire_database (&_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			zeitgeist_sq_lite_database_open_database (self, FALSE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		} else {
			gboolean _tmp14_ = FALSE;
			if (rc == SQLITE_PERM) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = rc == SQLITE_CANTOPEN;
			}
			if (_tmp14_) {
				sqlite3* _tmp15_;
				const gchar* _tmp16_;
				GError* _tmp17_;
				_tmp15_ = self->database;
				_tmp16_ = sqlite3_errmsg (_tmp15_);
				_tmp17_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN, _tmp16_);
				_inner_error0_ = _tmp17_;
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			} else {
				if (rc == SQLITE_BUSY) {
					sqlite3* _tmp18_;
					const gchar* _tmp19_;
					GError* _tmp20_;
					_tmp18_ = self->database;
					_tmp19_ = sqlite3_errmsg (_tmp18_);
					_tmp20_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY, _tmp19_);
					_inner_error0_ = _tmp20_;
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				} else {
					gchar* message = NULL;
					sqlite3* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					const gchar* _tmp24_;
					GError* _tmp25_;
					_tmp21_ = self->database;
					_tmp22_ = sqlite3_errmsg (_tmp21_);
					_tmp23_ = g_strdup_printf ("Can't open database: %d, %s", rc, _tmp22_);
					message = _tmp23_;
					_tmp24_ = message;
					_tmp25_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp24_);
					_inner_error0_ = _tmp25_;
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (message);
						return;
					} else {
						_g_free0 (message);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_free0 (message);
				}
			}
		}
	}
}

static void
zeitgeist_sq_lite_database_retire_database (GError** error)
{
	GError* _inner_error0_ = NULL;
	{
		GFile* dbfile = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp0_ = zeitgeist_utils_get_database_file_path ();
		_tmp1_ = g_file_new_for_path (_tmp0_);
		dbfile = _tmp1_;
		_tmp2_ = dbfile;
		_tmp3_ = zeitgeist_utils_get_database_file_retire_name ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_set_display_name (_tmp2_, _tmp4_, NULL, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dbfile);
			goto __catch0_g_error;
		}
		_g_object_unref0 (dbfile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* message = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strdup_printf ("Could not rename database: %s", _tmp8_);
		message = _tmp9_;
		_tmp10_ = message;
		_tmp11_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED, _tmp10_);
		_inner_error0_ = _tmp11_;
		_g_free0 (message);
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ZeitgeistSQLiteDatabase* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static gint
__lambda5_ (Block1Data* _data1_,
            gint n_columns,
            gchar** values,
            gchar** column_names)
{
	ZeitgeistSQLiteDatabase* self;
	const gchar* _tmp0_;
	gint result;
	self = _data1_->self;
	_tmp0_ = values[0];
	if (_tmp0_ == NULL) {
		_data1_->last_id = 0;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = values[0];
		_data1_->last_id = atoi (_tmp1_);
	}
	result = 0;
	return result;
}

static gint
___lambda5__sqlite3_callback (gpointer self,
                              gint n_columns,
                              gchar** values,
                              gchar** column_names)
{
	gint result;
	result = __lambda5_ (self, n_columns, values, column_names);
	return result;
}

guint32
zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self,
                                        GError** error)
{
	Block1Data* _data1_;
	gint rc = 0;
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->last_id = -1;
	_tmp0_ = self->database;
	rc = _sqlite3_exec (_tmp0_, "SELECT MAX(id) FROM event", ___lambda5__sqlite3_callback, _data1_, NULL);
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:204: Can't query database", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			guint32 _tmp1_ = 0U;
			g_propagate_error (error, _inner_error0_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return _tmp1_;
		} else {
			guint32 _tmp2_ = 0U;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_vala_assert (_data1_->last_id != -1, "last_id != -1");
	result = (guint32) _data1_->last_id;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

void
zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self,
                                                  ZeitgeistSQLiteDeletionCallback callback,
                                                  gpointer callback_target,
                                                  GDestroyNotify callback_target_destroy_notify)
{
	ZeitgeistSQLiteDeletionCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_if_fail (self != NULL);
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	_tmp0__target_destroy_notify = callback_target_destroy_notify;
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	(self->priv->deletion_callback_target_destroy_notify == NULL) ? NULL : (self->priv->deletion_callback_target_destroy_notify (self->priv->deletion_callback_target), NULL);
	self->priv->deletion_callback = NULL;
	self->priv->deletion_callback_target = NULL;
	self->priv->deletion_callback_target_destroy_notify = NULL;
	self->priv->deletion_callback = _tmp0_;
	self->priv->deletion_callback_target = _tmp0__target;
	self->priv->deletion_callback_target_destroy_notify = _tmp0__target_destroy_notify;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
}

/**
         * Join all given event_ids into a comma-separated string suitable
         * for use in a SQL query like "WHERE id IN (...)".
         */
gchar*
zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self,
                                                          guint32* event_ids,
                                                          gint event_ids_length1)
{
	GString* sql_condition = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	guint32 _tmp2_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (event_ids_length1 > 0, "event_ids.length > 0", NULL);
	_tmp0_ = g_string_new ("");
	sql_condition = _tmp0_;
	_tmp1_ = sql_condition;
	_tmp2_ = event_ids[0];
	g_string_append_printf (_tmp1_, "%u", (guint) _tmp2_);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GString* _tmp5_;
				guint32 _tmp6_;
				if (!_tmp3_) {
					gint _tmp4_;
					i = i + 1;
					_tmp4_ = i;
				}
				_tmp3_ = FALSE;
				if (!(i < event_ids_length1)) {
					break;
				}
				_tmp5_ = sql_condition;
				_tmp6_ = event_ids[i];
				g_string_append_printf (_tmp5_, ", %u", (guint) _tmp6_);
			}
		}
	}
	_tmp7_ = sql_condition;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (sql_condition);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ZeitgeistSQLiteDatabase* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->time_range);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gint
__lambda6_ (Block2Data* _data2_,
            gint n_columns,
            gchar** values,
            gchar** column_names)
{
	ZeitgeistSQLiteDatabase* self;
	const gchar* _tmp0_;
	gint result;
	self = _data2_->self;
	_tmp0_ = values[0];
	if (_tmp0_ != NULL) {
		gint64 start = 0LL;
		const gchar* _tmp1_;
		gint64 end = 0LL;
		const gchar* _tmp2_;
		ZeitgeistTimeRange* _tmp3_;
		_tmp1_ = values[0];
		start = int64_parse (_tmp1_, (guint) 0);
		_tmp2_ = values[1];
		end = int64_parse (_tmp2_, (guint) 0);
		_tmp3_ = zeitgeist_time_range_new (start, end);
		_g_object_unref0 (_data2_->time_range);
		_data2_->time_range = _tmp3_;
	}
	result = 0;
	return result;
}

static gint
___lambda6__sqlite3_callback (gpointer self,
                              gint n_columns,
                              gchar** values,
                              gchar** column_names)
{
	gint result;
	result = __lambda6_ (self, n_columns, values, column_names);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ZeitgeistTimeRange*
zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self,
                                                         guint32* event_ids,
                                                         gint event_ids_length1,
                                                         GError** error)
{
	Block2Data* _data2_;
	gchar* sql = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint rc = 0;
	sqlite3* _tmp4_;
	const gchar* _tmp5_;
	ZeitgeistTimeRange* _tmp6_;
	ZeitgeistTimeRange* _tmp7_;
	GError* _inner_error0_ = NULL;
	ZeitgeistTimeRange* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (event_ids_length1 == 0) {
		result = NULL;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp0_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (self, event_ids, (gint) event_ids_length1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("\n" \
"                SELECT MIN(timestamp), MAX(timestamp)\n" \
"                FROM event\n" \
"                WHERE id IN (%s)\n" \
"                ", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	sql = _tmp3_;
	_data2_->time_range = NULL;
	_tmp4_ = self->database;
	_tmp5_ = sql;
	rc = _sqlite3_exec (_tmp4_, _tmp5_, ___lambda6__sqlite3_callback, _data2_, NULL);
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:253: SQL Error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return NULL;
		} else {
			_g_free0 (sql);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = _data2_->time_range;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	_g_free0 (sql);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

void
zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self,
                                                        const gchar* table_name,
                                                        GPtrArray* values,
                                                        GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	gint rc = 0;
	GString* sql = NULL;
	GString* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	sqlite3_stmt* _tmp14_ = NULL;
	gint _tmp15_;
	sqlite3_stmt* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table_name != NULL);
	g_return_if_fail (values != NULL);
	_tmp0_ = vala_g_ptr_array_get_length (values);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = g_string_new ("");
	sql = _tmp2_;
	_tmp3_ = sql;
	g_string_append (_tmp3_, "INSERT OR IGNORE INTO ");
	_tmp4_ = sql;
	g_string_append (_tmp4_, table_name);
	_tmp5_ = sql;
	g_string_append (_tmp5_, " (value) SELECT ?");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				GString* _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					i = i + 1;
					_tmp7_ = i;
				}
				_tmp6_ = FALSE;
				_tmp8_ = vala_g_ptr_array_get_length (values);
				_tmp9_ = _tmp8_;
				if (!(i < _tmp9_)) {
					break;
				}
				_tmp10_ = sql;
				g_string_append (_tmp10_, " UNION SELECT ?");
			}
		}
	}
	_tmp11_ = self->database;
	_tmp12_ = sql;
	_tmp13_ = _tmp12_->str;
	_tmp15_ = sqlite3_prepare_v2 (_tmp11_, _tmp13_, -1, &_tmp14_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp14_;
	rc = _tmp15_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:275: SQL error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			return;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				sqlite3_stmt* _tmp20_;
				gconstpointer _tmp21_;
				gchar* _tmp22_;
				GDestroyNotify _tmp23_;
				if (!_tmp16_) {
					gint _tmp17_;
					i = i + 1;
					_tmp17_ = i;
				}
				_tmp16_ = FALSE;
				_tmp18_ = vala_g_ptr_array_get_length (values);
				_tmp19_ = _tmp18_;
				if (!(i < _tmp19_)) {
					break;
				}
				_tmp20_ = stmt;
				_tmp21_ = g_ptr_array_index (values, (guint) i);
				_tmp22_ = g_strdup ((const gchar*) _tmp21_);
				_tmp23_ = g_free;
				sqlite3_bind_text (_tmp20_, i + 1, _tmp22_, -1, _tmp23_);
			}
		}
	}
	_tmp24_ = stmt;
	rc = sqlite3_step (_tmp24_);
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "SQL error", SQLITE_DONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			return;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_sqlite3_finalize0 (stmt);
	_g_string_free0 (sql);
}

void
zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self,
                                              GError** error)
{
	gint rc = 0;
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	rc = _sqlite3_exec (_tmp0_, "BEGIN", NULL, NULL, NULL);
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:287: Can't start transaction", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self,
                                            GError** error)
{
	gint rc = 0;
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	rc = _sqlite3_exec (_tmp0_, "COMMIT", NULL, NULL, NULL);
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:293: Can't commit transaction", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self,
                                              GError** error)
{
	gint rc = 0;
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	rc = _sqlite3_exec (_tmp0_, "ROLLBACK", NULL, NULL, NULL);
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:299: Can't rollback transaction", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self)
{
	g_return_if_fail (self != NULL);
	_sqlite3_close0 (self->database);
	self->database = NULL;
}

/**
         * Ensure `rc' is SQLITE_OK. If it isn't, print an error message
         * and throw an error.
         *
         * @param rc error code returned by a SQLite call
         * @param msg message to print if `rc' indicates an error
         * @throws EngineError err
         */
void
zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self,
                                                 gint rc,
                                                 const gchar* msg,
                                                 gint success_code,
                                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	if (G_UNLIKELY (rc != success_code)) {
		gchar* error_message = NULL;
		sqlite3* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp0_ = self->database;
		_tmp1_ = sqlite3_errmsg (_tmp0_);
		_tmp2_ = g_strdup_printf ("%s: %d, %s", msg, rc, _tmp1_);
		error_message = _tmp2_;
		_tmp3_ = error_message;
		g_warning ("sql.vala:350: %s\n", _tmp3_);
		zeitgeist_sq_lite_database_assert_not_corrupt (self, rc, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (error_message);
				return;
			} else {
				_g_free0 (error_message);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp4_ = error_message;
		_tmp5_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp4_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (error_message);
			return;
		} else {
			_g_free0 (error_message);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (error_message);
	}
}

/**
         * Ensure `rc' isn't SQLITE_CORRUPT. If it is, schedule a database
         * retire and Zeitgeist restart so a new database can be created,
         * unless in read-only mode, in which case EngineError.DATABASE_ERROR
         * will be thrown.
         *
         * This function should be called whenever assert_query_success isn't
         * used.
         *
         * @param rc error code returned by a SQLite call
         */
void
zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self,
                                               gint rc,
                                               GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (G_UNLIKELY (rc == SQLITE_CORRUPT)) {
		sqlite3* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		sqlite3* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		_tmp0_ = self->database;
		_tmp1_ = sqlite3_errmsg (_tmp0_);
		_tmp2_ = g_strdup_printf ("It looks like your database is corrupt: %s", _tmp1_);
		_tmp3_ = _tmp2_;
		g_warning ("sql.vala:372: %s", _tmp3_);
		_g_free0 (_tmp3_);
		if (!self->priv->is_read_only) {
			sqlite3* _tmp4_;
			_tmp4_ = self->database;
			zeitgeist_sq_lite_database_schema_set_corruption_flag (_tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		_tmp5_ = self->database;
		_tmp6_ = sqlite3_errmsg (_tmp5_);
		_tmp7_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT, _tmp6_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
zeitgeist_sq_lite_database_prepare_read_queries (ZeitgeistSQLiteDatabase* self,
                                                 GError** error)
{
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                SELECT id FROM event\n" \
"                WHERE timestamp=? AND interpretation=? AND\n" \
"                    manifestation=? AND actor=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->database;
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, sql, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (self->id_retrieval_stmt);
	self->id_retrieval_stmt = _tmp2_;
	rc = _tmp3_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:397: Event ID retrieval query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (sql);
}

static void
zeitgeist_sq_lite_database_prepare_modification_queries (ZeitgeistSQLiteDatabase* self,
                                                         GError** error)
{
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_;
	sqlite3* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gchar* _tmp5_;
	sqlite3* _tmp6_;
	const gchar* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_;
	gchar* _tmp10_;
	sqlite3* _tmp11_;
	const gchar* _tmp12_;
	sqlite3_stmt* _tmp13_ = NULL;
	gint _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                INSERT INTO event (\n" \
"                    id, timestamp, interpretation, manifestation, acto" \
"r,\n" \
"                    origin, payload, subj_id, subj_id_current,\n" \
"                    subj_interpretation, subj_manifestation, subj_orig" \
"in,\n" \
"                    subj_origin_current, subj_mimetype, subj_text, sub" \
"j_storage\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?, ?, ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?, ?,\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    (SELECT id FROM uri WHERE value=?),\n" \
"                    ?,\n" \
"                    (SELECT id FROM text WHERE value=?),\n" \
"                    (SELECT id FROM storage WHERE value=?)\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->database;
	_tmp2_ = sql;
	_tmp4_ = sqlite3_prepare_v2 (_tmp1_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (self->event_insertion_stmt);
	self->event_insertion_stmt = _tmp3_;
	rc = _tmp4_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:427: Insertion query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = g_strdup ("\n" \
"            UPDATE event\n" \
"                SET subj_id_current=(SELECT id FROM uri WHERE value=?)" \
"\n" \
"                ,   subj_origin_current=(SELECT id FROM uri WHERE valu" \
"e=?)\n" \
"                    WHERE subj_id_current=(SELECT id FROM uri WHERE va" \
"lue=?)\n" \
"                    AND interpretation!=? AND timestamp<?\n" \
"            ");
	_g_free0 (sql);
	sql = _tmp5_;
	_tmp6_ = self->database;
	_tmp7_ = sql;
	_tmp9_ = sqlite3_prepare_v2 (_tmp6_, _tmp7_, -1, &_tmp8_, NULL);
	_sqlite3_finalize0 (self->move_handling_stmt);
	self->move_handling_stmt = _tmp8_;
	rc = _tmp9_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:438: Move handling error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = g_strdup ("\n" \
"                INSERT INTO payload (value) VALUES (?)\n" \
"            ");
	_g_free0 (sql);
	sql = _tmp10_;
	_tmp11_ = self->database;
	_tmp12_ = sql;
	_tmp14_ = sqlite3_prepare_v2 (_tmp11_, _tmp12_, -1, &_tmp13_, NULL);
	_sqlite3_finalize0 (self->payload_insertion_stmt);
	self->payload_insertion_stmt = _tmp13_;
	rc = _tmp14_;
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:445: Payload insertion query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (sql);
}

gboolean
zeitgeist_sq_lite_database_analyze (ZeitgeistSQLiteDatabase* self,
                                    GError** error)
{
	gint rc = 0;
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->database;
	rc = _sqlite3_exec (_tmp0_, "ANALYZE", NULL, NULL, NULL);
	zeitgeist_sq_lite_database_assert_query_success (self, rc, "sql.vala:451: Event ID retrieval query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	result = FALSE;
	return result;
}

void
zeitgeist_sq_lite_database_set_cache_size (ZeitgeistSQLiteDatabase* self,
                                           gint size)
{
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->database;
	_tmp1_ = g_strdup_printf ("PRAGMA cache_size = %i", size);
	_tmp2_ = _tmp1_;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp0_, _tmp2_, &_inner_error0_);
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
zeitgeist_sq_lite_database_update_callback (ZeitgeistSQLiteDatabase* self,
                                            int action,
                                            const gchar* dbname,
                                            const gchar* table,
                                            gint64 rowid)
{
	ZeitgeistSQLiteDeletionCallback _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbname != NULL);
	g_return_if_fail (table != NULL);
	if (action != SQLITE_DELETE) {
		return;
	}
	_tmp0_ = self->priv->deletion_callback;
	_tmp0__target = self->priv->deletion_callback_target;
	if (_tmp0_ != NULL) {
		ZeitgeistSQLiteDeletionCallback _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->deletion_callback;
		_tmp1__target = self->priv->deletion_callback_target;
		_tmp1_ (table, rowid, _tmp1__target);
	}
}

static void
zeitgeist_sq_lite_database_class_init (ZeitgeistSQLiteDatabaseClass * klass,
                                       gpointer klass_data)
{
	zeitgeist_sq_lite_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistSQLiteDatabase_private_offset);
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_sq_lite_database_finalize;
}

static void
zeitgeist_sq_lite_database_instance_init (ZeitgeistSQLiteDatabase * self,
                                          gpointer klass)
{
	self->priv = zeitgeist_sq_lite_database_get_instance_private (self);
	self->priv->deletion_callback = NULL;
	self->priv->deletion_callback_target = NULL;
	self->priv->deletion_callback_target_destroy_notify = NULL;
	self->priv->is_read_only = FALSE;
}

static void
zeitgeist_sq_lite_database_finalize (GObject * obj)
{
	ZeitgeistSQLiteDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase);
	_sqlite3_finalize0 (self->event_insertion_stmt);
	_sqlite3_finalize0 (self->id_retrieval_stmt);
	_sqlite3_finalize0 (self->move_handling_stmt);
	_sqlite3_finalize0 (self->payload_insertion_stmt);
	_sqlite3_close0 (self->database);
	(self->priv->deletion_callback_target_destroy_notify == NULL) ? NULL : (self->priv->deletion_callback_target_destroy_notify (self->priv->deletion_callback_target), NULL);
	self->priv->deletion_callback = NULL;
	self->priv->deletion_callback_target = NULL;
	self->priv->deletion_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (zeitgeist_sq_lite_database_parent_class)->finalize (obj);
}

static GType
zeitgeist_sq_lite_database_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteDatabase), 0, (GInstanceInitFunc) zeitgeist_sq_lite_database_instance_init, NULL };
	GType zeitgeist_sq_lite_database_type_id;
	zeitgeist_sq_lite_database_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteDatabase", &g_define_type_info, 0);
	ZeitgeistSQLiteDatabase_private_offset = g_type_add_instance_private (zeitgeist_sq_lite_database_type_id, sizeof (ZeitgeistSQLiteDatabasePrivate));
	return zeitgeist_sq_lite_database_type_id;
}

GType
zeitgeist_sq_lite_database_get_type (void)
{
	static volatile gsize zeitgeist_sq_lite_database_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_database_type_id__once)) {
		GType zeitgeist_sq_lite_database_type_id;
		zeitgeist_sq_lite_database_type_id = zeitgeist_sq_lite_database_get_type_once ();
		g_once_init_leave (&zeitgeist_sq_lite_database_type_id__once, zeitgeist_sq_lite_database_type_id);
	}
	return zeitgeist_sq_lite_database_type_id__once;
}

