/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceManager {
    private final Logger logger = LoggerFactory.getLogger(WorkspaceManager.class);
    public static final String SAVE_CONFIRMATION_MESSAGE = "<html><body><b>Do you want to save changes that you made to the ontologies in this workspace?</b><br>Your changes will be lost if you don't save them.</body></html>";
    private Map<Workspace, WorkspaceFrame> workspaceFrameMap = new HashMap<Workspace, WorkspaceFrame>();

    public void addWorkspace(final Workspace workspace) {
        if (!this.workspaceFrameMap.containsKey(workspace)) {
            final WorkspaceFrame frame = new WorkspaceFrame(workspace);
            frame.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ WorkspaceManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    if (this.this$0.doClose(workspace)) {
                        frame.removeWindowListener(this);
                        frame.dispose();
                    }
                }
            });
            this.workspaceFrameMap.put(workspace, frame);
            frame.setDefaultCloseOperation(0);
            frame.setVisible(true);
        }
    }

    public boolean doClose(Workspace workspace) {
        try {
            boolean dirty = workspace.getEditorKit().getModelManager().isDirty();
            if (dirty) {
                int ret = JOptionPane.showConfirmDialog(workspace, SAVE_CONFIRMATION_MESSAGE, "Save workspace?", 1, 2);
                if (ret == 2 || ret == -1) {
                    return false;
                }
                if (ret == 0) {
                    workspace.getEditorKit().handleSave();
                    if (workspace.getEditorKit().getModelManager().isDirty()) {
                        return false;
                    }
                }
            }
            ProtegeManager.getInstance().disposeOfEditorKit(workspace.getEditorKit());
            return true;
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst closing the workspace.", (Throwable)e);
            return false;
        }
    }

    public void removeWorkspace(Workspace workspace) {
        WorkspaceFrame frame = this.workspaceFrameMap.get(workspace);
        if (frame != null) {
            frame.dispose();
            this.workspaceFrameMap.remove(workspace);
        }
    }

    public WorkspaceFrame getFrame(Workspace workspace) {
        return this.workspaceFrameMap.get(workspace);
    }
}

