# This file has been autogenerated by the pywayland scanner

# Copyright © 2015 Martin Gräßlin
# Copyright © 2022 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import Global, Interface, Proxy, Resource


class ExtIdleNotificationV1(Interface):
    """Idle notification

    This interface is used by the compositor to send idle notification events
    to clients.

    Initially the notification object is not idle. The notification object
    becomes idle when no user activity has happened for at least the timeout
    duration, starting from the creation of the notification object. User
    activity may include input events or a presence sensor, but is compositor-
    specific. If an idle inhibitor is active (e.g. another client has created a
    :class:`~pywayland.protocol.idle_inhibit_unstable_v1.ZwpIdleInhibitorV1` on
    a visible surface), the compositor must not make the notification object
    idle.

    When the notification object becomes idle, an idled event is sent. When
    user activity starts again, the notification object stops being idle, a
    resumed event is sent and the timeout is restarted.
    """

    name = "ext_idle_notification_v1"
    version = 1


class ExtIdleNotificationV1Proxy(Proxy[ExtIdleNotificationV1]):
    interface = ExtIdleNotificationV1

    @ExtIdleNotificationV1.request()
    def destroy(self) -> None:
        """Destroy the notification object

        Destroy the notification object.
        """
        self._marshal(0)
        self._destroy()


class ExtIdleNotificationV1Resource(Resource):
    interface = ExtIdleNotificationV1

    @ExtIdleNotificationV1.event()
    def idled(self) -> None:
        """Notification object is idle

        This event is sent when the notification object becomes idle.

        It's a compositor protocol error to send this event twice without a
        resumed event in-between.
        """
        self._post_event(0)

    @ExtIdleNotificationV1.event()
    def resumed(self) -> None:
        """Notification object is no longer idle

        This event is sent when the notification object stops being idle.

        It's a compositor protocol error to send this event twice without an
        idled event in-between. It's a compositor protocol error to send this
        event prior to any idled event.
        """
        self._post_event(1)


class ExtIdleNotificationV1Global(Global):
    interface = ExtIdleNotificationV1


ExtIdleNotificationV1._gen_c()
ExtIdleNotificationV1.proxy_class = ExtIdleNotificationV1Proxy
ExtIdleNotificationV1.resource_class = ExtIdleNotificationV1Resource
ExtIdleNotificationV1.global_class = ExtIdleNotificationV1Global
