;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bigloo/runtime/Llib/type.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan  8 08:52:32 1995                          */
;*    Last change :  Fri Nov  8 07:26:53 2024 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type description                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __type
   
   (use __error
	__bigloo
	__tvector
        __weakptr
	__ucs2
	__unicode
	__bignum
	__r4_equivalence_6_2
	__r4_numbers_6_5_fixnum
	__r4_booleans_6_1
	__r4_characters_6_6
	__r4_pairs_and_lists_6_3
	__r4_vectors_6_8
	__r4_numbers_6_5_flonum
	__r4_symbols_6_4
	__r4_strings_6_7
	__evenv
	__object
	__bit)
   
   (type
    
    ;; all type declarations
    (magic magic "obj_t" bigloo)
    (magic _ "_" bigloo)
    
    ;; debugging traces (used by `the_failure')
    (trace "struct trace *" _)

    ;; we start by the obj hierarchy
    (obj "obj_t" bigloo)
    (cnst* "obj_t" bigloo)
    
    (subtype dynamic-env "obj_t" (obj))
    (subtype procedure "obj_t" (obj))
    (subtype procedure-l "obj_t" (obj))
    (subtype procedure-el "obj_t" (obj))
    (subtype pair "obj_t" (obj))
    (subtype epair "obj_t" (obj))
    (subtype nil "obj_t" (obj))
    ;; There is a relationship that exists between list, pair-nil, nil and
    ;; pair which is nil > pair-nil and pair > pair-nil. This has introduced
    ;; a bug into one compiler optimization that attempts to statically
    ;; reduce runtime type check. I have not been able to find a better
    ;; solution than to hard code this relation into the compiler.
    ;; @ref ../../comptime/Reduce/typec.scm:pair-nil subtyping@
    ;; @label pair-nil subtyping@
    (subtype pair-nil "obj_t" (obj))
    (subtype list "obj_t" (obj))
    (subtype bint "obj_t" (obj) $bint-null)
    (subtype belong "obj_t" (obj))
    (subtype bllong "obj_t" (obj))
    (subtype bint8 "obj_t" (obj))
    (subtype buint8 "obj_t" (obj))
    (subtype bint16 "obj_t" (obj))
    (subtype buint16 "obj_t" (obj))
    (subtype bint32 "obj_t" (obj))
    (subtype buint32 "obj_t" (obj))
    (subtype bint64 "obj_t" (obj))
    (subtype buint64 "obj_t" (obj))
    (subtype bignum "obj_t" (obj))
    (subtype bbool "obj_t" (obj))
    (subtype cnst "obj_t" (obj))
    (subtype bstring "obj_t" (obj))
    (subtype ucs2string "obj_t" (obj))
    (subtype bchar "obj_t" (obj))
    (subtype bucs2 "obj_t" (obj))
    (subtype real "obj_t" (obj))
    (subtype vector "obj_t" (obj))
    (subtype tvector "obj_t" (obj))
    (subtype weakptr "obj_t" (obj))
    (subtype struct "obj_t" (obj))
    (subtype tstruct "obj_t" (obj))
    (subtype output-port "obj_t" (obj))
    (subtype input-port "obj_t" (obj))
    (subtype binary-port "obj_t" (obj))
    (subtype unspecified "obj_t" (obj))
    (subtype symbol "obj_t" (obj))
    (subtype keyword "obj_t" (obj))
    (subtype unsafe-cell "obj_t" (cobj))
    (subtype cell "obj_t" (obj))
    (subtype exit "void *" (obj))
    (subtype foreign "obj_t" (obj))
    (subtype process "obj_t" (obj))
    (subtype socket "obj_t" (obj))
    (subtype datagram-socket "obj_t" (obj))
    (subtype regexp "obj_t" (obj))
    (subtype custom "obj_t" (obj))
    (subtype date "obj_t" (obj))
    (subtype mutex "obj_t" (obj))
    (subtype condvar "obj_t" (obj))
    (subtype mmap "obj_t" (obj))
    (subtype semaphore "obj_t" (obj))
    (subtype opaque "obj_t" (obj))

    ;; srfi4 vectors
    (subtype s8vector "obj_t" (obj))
    (subtype u8vector "obj_t" (obj))
    (subtype s16vector "obj_t" (obj))
    (subtype u16vector "obj_t" (obj))
    (subtype s32vector "obj_t" (obj))
    (subtype u32vector "obj_t" (obj))
    (subtype s64vector "obj_t" (obj))
    (subtype u64vector "obj_t" (obj))

    (subtype f32vector "obj_t" (obj))
    (subtype f64vector "obj_t" (obj))

    ;; classes
    (subtype class "obj_t" (obj))
    (subtype class-field "obj_t" (obj))

    ;; we give now the foreign hierarchy
    (cobj "long" C)

    (subtype char "unsigned char" (cobj))
    (subtype uchar "unsigned char" (cobj))
    (subtype ucs2 "ucs2_t" (cobj))
    (subtype byte "char" (cobj))
    (subtype ubyte "unsigned char" (cobj))
    (subtype short "short" (cobj))
    (subtype ushort "unsigned short" (cobj))
    (subtype int "int" (cobj))
    (subtype uint "unsigned int" (cobj))
    (subtype long "long" (cobj) $long-null)
    (subtype ulong "unsigned long" (cobj))
    (subtype elong "long" (cobj))
    (subtype uelong "unsigned long" (cobj))
    (subtype llong "BGL_LONGLONG_T" (cobj))
    (subtype ullong "unsigned BGL_LONGLONG_T" (cobj))
    (subtype int8 "int8_t" (cobj))
    (subtype uint8 "uint8_t" (cobj))
    (subtype int16 "int16_t" (cobj))
    (subtype uint16 "uint16_t" (cobj))
    (subtype int32 "int32_t" (cobj))
    (subtype uint32 "uint32_t" (cobj))
    (subtype int64 "int64_t" (cobj))
    (subtype uint64 "uint64_t" (cobj))
    (subtype bool "bool_t" (cobj))
    (subtype string "char *" (cobj))
    (subtype file "FILE *" (cobj))
    (subtype double "double" (cobj))
    (subtype float "float" (cobj))
    (subtype void "void" (cobj))
    (subtype void* "void *" (cobj))
    (subtype function "(long *)()" (cobj))
    (subtype funptr "function_t" (cobj))

    ;; obj coercions
    (coerce obj magic () ())
    (coerce obj trace () ())
    (coerce obj cobj () ($obj->cobj))
    (coerce obj unspecified () ((lambda (x) #unspecified)))
    (coerce obj bbool ($boolean?) ())
    (coerce obj bool () ($obj->bool))
    (coerce obj bchar (c-char?) ())
    (coerce obj bucs2 (c-ucs2?) ())
    (coerce obj bint ($fixnum?) ())
    (coerce obj belong ($elong?) ())
    (coerce obj bllong ($llong?) ())
    (coerce obj bignum ($bignum?) ())
    (coerce obj bint8 ($int8?) ())
    (coerce obj buint8 ($uint8?) ())
    (coerce obj bint16 ($int16?) ())
    (coerce obj buint16 ($uint16?) ())
    (coerce obj bint32 ($int32?) ())
    (coerce obj buint32 ($uint32?) ())
    (coerce obj bint64 ($int64?) ())
    (coerce obj buint64 ($uint64?) ())
    (coerce obj symbol (c-symbol?) ())
    (coerce obj keyword (c-keyword?) ())
    (coerce obj bstring ($string?) ())
    (coerce obj ucs2string (c-ucs2-string?) ())
    (coerce obj real ($flonum?) ())
    (coerce obj vector ($vector?) ())
    (coerce obj s8vector ($s8vector?) ())
    (coerce obj u8vector ($u8vector?) ())
    (coerce obj s16vector ($s16vector?) ())
    (coerce obj u16vector ($u16vector?) ())
    (coerce obj s32vector ($s32vector?) ())
    (coerce obj u32vector ($u32vector?) ())
    (coerce obj s64vector ($s64vector?) ())
    (coerce obj u64vector ($u64vector?) ())
    (coerce obj f32vector ($f32vector?) ())
    (coerce obj f64vector ($f64vector?) ())
    (coerce obj tvector ($tvector?) ())
    (coerce obj weakptr ($weakptr?) ())
    (coerce obj dynamic-env ($dynamic-env?) ())
    (coerce obj procedure (c-procedure?) ())
    (coerce obj struct ($struct?) ())
    (coerce obj tstruct (c-tstruct?) ())
    (coerce obj pair ($pair?) ())
    (coerce obj epair ($epair?) ())
    (coerce obj nil ($null?) ())
    (coerce obj pair-nil (pair-or-null?) ())
    (coerce obj list (list?) ())
    (coerce obj cell () ())
    (coerce obj exit () ())
    (coerce obj input-port (c-input-port?) ())
    (coerce obj output-port (c-output-port?) ())
    (coerce obj binary-port (c-binary-port?) ())
    (coerce obj void* (c-foreign?) ($obj->void*))
    (coerce obj foreign (c-foreign?) ())
    (coerce obj process (c-process?) ())
    (coerce obj socket (c-socket?) ())
    (coerce obj datagram-socket ($datagram-socket?) ())
    (coerce obj regexp (regexp?) ())
    (coerce obj custom (c-custom?) ())
    (coerce obj date (c-date?) ())
    (coerce obj mutex ($mutex?) ())
    (coerce obj condvar ($condvar?) ())
    (coerce obj mmap ($mmap?) ())
    (coerce obj semaphore ($semaphore?) ())
    (coerce obj class ((@ class? __object)) ())
    (coerce obj class-field ((@ class-field? __object)) ())
    (coerce obj opaque (c-opaque?) ())
    
    ;; cobj
    (coerce cobj obj () ($cobj->obj))
    (coerce cobj bool () ())
    (coerce cobj char () ())
    (coerce cobj uchar () ())
    (coerce cobj ucs2 () ())
    (coerce cobj byte () ())
    (coerce cobj ubyte () ())
    (coerce cobj short () ())
    (coerce cobj ushort () ())
    (coerce cobj int () ())
    (coerce cobj uint () ())
    (coerce cobj long () ())
    (coerce cobj ulong () ())
    (coerce cobj elong () ())
    (coerce cobj uelong () ())
    (coerce cobj llong () ())
    (coerce cobj ullong () ())
    (coerce cobj int8 () ())
    (coerce cobj uint8 () ())
    (coerce cobj int16 () ())
    (coerce cobj uint16 () ())
    (coerce cobj int32 () ())
    (coerce cobj uint32 () ())
    (coerce cobj int64 () ())
    (coerce cobj uint64 () ())
    (coerce cobj string () ())
    (coerce cobj double () ())
    (coerce cobj float () ())
    (coerce cobj file () ())
    (coerce cobj void () ())
    (coerce cobj void* () ())

    ;; -> cobj
    (coerce bool cobj () ())
    (coerce string cobj () ())
    (coerce ucs2 cobj () ())
    (coerce char cobj () ())
    (coerce uchar cobj () ())
    (coerce byte cobj () ())
    (coerce ubyte cobj () ())
    (coerce short cobj () ())
    (coerce ushort cobj () ())
    (coerce int cobj () ())
    (coerce uint cobj () ())
    (coerce long cobj () ())
    (coerce ulong cobj () ())
    (coerce elong cobj () ())
    (coerce uelong cobj () ())
    (coerce llong cobj () ())
    (coerce ullong cobj () ())
    (coerce int8 cobj () ())
    (coerce uint8 cobj () ())
    (coerce int16 cobj () ())
    (coerce uint16 cobj () ())
    (coerce int32 cobj () ())
    (coerce uint32 cobj () ())
    (coerce int64 cobj () ())
    (coerce uint64 cobj () ())
    (coerce float cobj () ())
    (coerce double cobj () ())
    (coerce file cobj () ())
    (coerce void cobj () ())
    (coerce void* cobj () ())
    
    ;; -> obj
    (coerce bbool obj () ())
    (coerce cnst obj () ())
    (coerce unspecified obj () ())
    (coerce symbol obj () ())
    (coerce keyword obj () ())
    (coerce bstring obj () ())
    (coerce ucs2string obj () ())
    (coerce vector obj () ())
    (coerce s8vector obj () ())
    (coerce u8vector obj () ())
    (coerce s16vector obj () ())
    (coerce u16vector obj () ())
    (coerce s32vector obj () ())
    (coerce u32vector obj () ())
    (coerce s64vector obj () ())
    (coerce u64vector obj () ())
    (coerce f32vector obj () ())
    (coerce f64vector obj () ())
    (coerce bucs2 obj () ())
    (coerce bchar obj () ())
    (coerce bint obj () ())
    (coerce bint bool () ((lambda (x) #t)))
    (coerce belong obj () ())
    (coerce bllong obj () ())
    (coerce bignum obj () ())
    (coerce bint8 obj () ())
    (coerce buint8 obj () ())
    (coerce bint16 obj () ())
    (coerce buint16 obj () ())
    (coerce bint32 obj () ())
    (coerce buint32 obj () ())
    (coerce bint64 obj () ())
    (coerce buint64 obj () ())
    (coerce real obj () ())
    (coerce tvector obj () ())
    (coerce weakptr obj () ())
    (coerce dynamic-env obj () ())
    (coerce procedure obj () ())
    (coerce procedure-l obj () ())
    (coerce procedure-el obj () ())
    (coerce struct obj () ())
    (coerce tstruct obj () ())
    (coerce pair obj () ())
    (coerce epair obj () ())
    (coerce pair-nil obj () ())
    (coerce list obj () ())
    (coerce nil obj () ())
    (coerce cell obj () ())
    (coerce exit obj () ())
    (coerce input-port obj () ())
    (coerce output-port obj () ())
    (coerce binary-port obj () ())
    (coerce void* obj () ($void*->obj))
    (coerce foreign obj () ())
    (coerce process obj () ())
    (coerce socket obj () ())
    (coerce datagram-socket obj () ())
    (coerce regexp obj () ())
    (coerce custom obj () ())
    (coerce date obj () ())
    (coerce mutex obj () ())
    (coerce condvar obj () ())
    (coerce mmap obj () ())
    (coerce semaphore obj () ())
    (coerce opaque obj () ())
    (coerce class obj () ())
    (coerce class vector () ())
    (coerce vector class () ())
    (coerce class-field obj () ())
    (coerce class-field vector () ())
    (coerce vector class-field () ())

    ;; bool
    (coerce bool bbool () ($bool->bbool))
    (coerce bbool bool () ($bbool->bool))

    ;; cnst
    (coerce cnst bool () ((lambda (x) #t)))

    ;; unspecified
    (coerce unspecified  bool () ((lambda (x) #t)))

    ;; symbol
    (coerce symbol bool () ((lambda (x) #t)))

    ;; keyword
    (coerce keyword bool () ((lambda (x) #t)))

    ;; bstring
    (coerce bstring string () ($bstring->string))
    (coerce bstring bool () ((lambda (x) #t)))
    (coerce string bool () ((lambda (x::string) #t)))
    (coerce string bstring () ($string->bstring))

    ;; ucs2string
    (coerce ucs2string bool () ((lambda (x) #t)))

    ;; vector
    (coerce vector bool () ((lambda (x) #t)))
    (coerce s8vector bool () ((lambda (x) #t)))
    (coerce u8vector bool () ((lambda (x) #t)))
    (coerce s16vector bool () ((lambda (x) #t)))
    (coerce u16vector bool () ((lambda (x) #t)))
    (coerce s32vector bool () ((lambda (x) #t)))
    (coerce u32vector bool () ((lambda (x) #t)))
    (coerce s64vector bool () ((lambda (x) #t)))
    (coerce u64vector bool () ((lambda (x) #t)))
    (coerce f32vector bool () ((lambda (x) #t)))
    (coerce f64vector bool () ((lambda (x) #t)))

    ;; bucs2
    (coerce bucs2 ucs2 () ($bucs2->ucs2))
    (coerce bucs2 bool () ((lambda (x) #t)))
    (coerce ucs2 bool () ((lambda (x::char) #t)))
    (coerce ucs2 bucs2 () ($ucs2->bucs2))

    ;; bchar
    (coerce bchar char () ($bchar->char))
    (coerce bchar uchar () ($bchar->uchar))
    (coerce bchar bool () ((lambda (x) #t)))

    ;; char
    (coerce char bool () ((lambda (x::char) #t)))
    (coerce char uchar () ($char->uchar))
    (coerce char bchar () ($char->bchar))

    ;; uchar
    (coerce uchar bool () ((lambda (x::uchar) #t)))
    (coerce uchar char () ($uchar->char))
    (coerce uchar bchar () ($uchar->bchar))

    ;; byte
    (coerce byte bool () ((lambda (x::byte) #t)))
    (coerce byte bint () ($byte->bint))
    (coerce byte char () ($byte->char))
    (coerce byte uchar () ($byte->uchar))
    (coerce byte bool () ((lambda (x::byte) #t)))
    (coerce byte ubyte () ($byte->ubyte))
    (coerce byte short () ($byte->short))
    (coerce byte ushort () ($byte->ushort))
    (coerce byte int () ($byte->int))
    (coerce byte uint () ($byte->uint))
    (coerce byte long () ($byte->long))
    (coerce byte ulong () ($byte->ulong))
    (coerce byte int8 () ($byte->int8))
    (coerce byte uint8 () ($byte->uint8))
    (coerce byte int16 () ($byte->int16))
    (coerce byte uint16 () ($byte->uint16))
    (coerce byte int32 () ($byte->int32))
    (coerce byte uint32 () ($byte->uint32))
    (coerce byte int64 () ($byte->int64))
    (coerce byte uint64 () ($byte->uint64))

    ;; ubyte
    (coerce ubyte bool () ((lambda (x::ubyte) #t)))
    (coerce ubyte char () ($ubyte->char))
    (coerce ubyte uchar () ($ubyte->uchar))
    (coerce ubyte bool () ((lambda (x::ubyte) #t)))
    (coerce ubyte byte () ($ubyte->byte))
    (coerce ubyte short () ($ubyte->short))
    (coerce ubyte ushort () ($ubyte->ushort))
    (coerce ubyte int () ($ubyte->int))
    (coerce ubyte uint () ($ubyte->uint))
    (coerce ubyte long () ($ubyte->long))
    (coerce ubyte ulong () ($ubyte->ulong))
    (coerce ubyte bint () ($ubyte->bint))
    (coerce ubyte int8 () ($ubyte->int8))
    (coerce ubyte uint8 () ($ubyte->uint8))
    (coerce ubyte int16 () ($ubyte->int16))
    (coerce ubyte uint16 () ($ubyte->uint16))
    (coerce ubyte int32 () ($ubyte->int32))
    (coerce ubyte uint32 () ($ubyte->uint32))
    (coerce ubyte int64 () ($ubyte->int64))
    (coerce ubyte uint64 () ($ubyte->uint64))

    ;; short
    (coerce short bool () ((lambda (x::short) #t)))
    (coerce short byte () ($short->byte))
    (coerce short ubyte () ($short->ubyte))
    (coerce short ushort () ($short->ushort))
    (coerce short int () ($short->int))
    (coerce short uint () ($short->uint))
    (coerce short long () ($short->long))
    (coerce short ulong () ($short->ulong))
    (coerce short bint () ($short->bint))
    (coerce short int8 () ($short->int8))
    (coerce short uint8 () ($short->uint8))
    (coerce short int16 () ($short->int16))
    (coerce short uint16 () ($short->uint16))
    (coerce short int32 () ($short->int32))
    (coerce short uint32 () ($short->uint32))
    (coerce short int64 () ($short->int64))
    (coerce short uint64 () ($short->uint64))

    ;; ushort
    (coerce ushort bool () ((lambda (x::ushort) #t)))
    (coerce ushort byte () ($ushort->byte))
    (coerce ushort ubyte () ($ushort->ubyte))
    (coerce ushort short () ($ushort->short))
    (coerce ushort int () ($ushort->int))
    (coerce ushort uint () ($ushort->uint))
    (coerce ushort long () ($ushort->long))
    (coerce ushort ulong () ($ushort->ulong))
    (coerce ushort bint () ($ushort->bint))
    (coerce ushort int8 () ($ushort->int8))
    (coerce ushort uint8 () ($ushort->uint8))
    (coerce ushort int16 () ($ushort->int16))
    (coerce ushort uint16 () ($ushort->uint16))
    (coerce ushort int32 () ($ushort->int32))
    (coerce ushort uint32 () ($ushort->uint32))
    (coerce ushort int64 () ($ushort->int64))
    (coerce ushort uint64 () ($ushort->uint64))

    ;; integer
    (coerce bint byte () ($bint->byte))
    (coerce bint ubyte () ($bint->ubyte))
    (coerce bint short () ($bint->short))
    (coerce bint ushort () ($bint->ushort))
    (coerce bint int () ($bint->int))
    (coerce bint uint () ($bint->uint))
    (coerce bint long () ($bint->long))
    (coerce bint ulong () ($bint->ulong))
    
;*     (coerce bint int8 () ($bint->int8))                             */
;*     (coerce bint uint8 () ($bint->uint8))                           */
;*     (coerce bint int16 () ($bint->int16))                           */
;*     (coerce bint uint16 () ($bint->uint16))                         */
;*     (coerce bint int32 () ($bint->int32))                           */
;*     (coerce bint uint32 () ($bint->uint32))                         */
;*     (coerce bint int64 () ($bint->int64))                           */
;*     (coerce bint uint64 () ($bint->uint64))                         */

    ;; int
    (coerce int bool () ((lambda (x::int) #t)))
    (coerce int byte () ($int->byte))
    (coerce int ubyte () ($int->ubyte))
    (coerce int short () ($int->short))
    (coerce int ushort () ($int->ushort))
    (coerce int uint () ($int->uint))
    (coerce int long () ($int->long))
    (coerce int ulong () ($int->ulong))
    (coerce int bint () ($int->bint))
    (coerce int int8 () ($int->int8))
    (coerce int uint8 () ($int->uint8))
    (coerce int int16 () ($int->int16))
    (coerce int uint16 () ($int->uint16))
    (coerce int int32 () ($int->int32))
    (coerce int uint32 () ($int->uint32))
    (coerce int int64 () ($int->int64))
    (coerce int uint64 () ($int->uint64))
    (coerce int bool () ())

    ;; uint
    (coerce uint bool () ((lambda (x::uint) #t)))
    (coerce uint byte () ($uint->byte))
    (coerce uint ubyte () ($uint->ubyte))
    (coerce uint short () ($uint->short))
    (coerce uint ushort () ($uint->ushort))
    (coerce uint int () ($uint->int))
    (coerce uint long () ($uint->long))
    (coerce uint ulong () ($uint->ulong))
    (coerce uint bint () ($uint->bint))
    (coerce uint uint8 () ($uint->uint8))
    (coerce uint int16 () ($uint->int16))
    (coerce uint uint16 () ($uint->uint16))
    (coerce uint int32 () ($uint->int32))
    (coerce uint uint32 () ($uint->uint32))
    (coerce uint int64 () ($uint->int64))
    (coerce uint uint64 () ($uint->uint64))

    ;; long
    (coerce long elong () ($long->elong))
    (coerce long uelong () ($long->elong))
    (coerce long llong () ($long->llong))
    (coerce long ullong () ($long->ullong))
    (coerce long magic () ($long->bint))
    (coerce long bool () ((lambda (x::long) #t)))
    (coerce long byte () ($long->byte))
    (coerce long ubyte () ($long->ubyte))
    (coerce long short () ($long->short))
    (coerce long ushort () ($long->ushort))
    (coerce long int () ($long->int))
    (coerce long uint () ($long->uint))
    (coerce long ulong () ($long->ulong))
    (coerce long bint () ($long->bint))
    (coerce long int8 () ($long->int8))
    (coerce long uint8 () ($long->uint8))
    (coerce long int16 () ($long->int16))
    (coerce long uint16 () ($long->uint16))
    (coerce long int32 () ($long->int32))
    (coerce long uint32 () ($long->uint32))
    (coerce long int64 () ($long->int64))
    (coerce long uint64 () ($long->uint64))

    ;; ulong
    (coerce ulong bool () ((lambda (x::ulong) #t)))
    (coerce ulong byte () ($ulong->byte))
    (coerce ulong ubyte () ($ulong->ubyte))
    (coerce ulong short () ($ulong->short))
    (coerce ulong ushort () ($ulong->ushort))
    (coerce ulong int () ($ulong->int))
    (coerce ulong uint () ($ulong->uint))
    (coerce ulong long () ($ulong->long))
    (coerce ulong bint () ($ulong->bint))
    (coerce ulong int8 () ($ulong->int8))
    (coerce ulong uint8 () ($ulong->uint8))
    (coerce ulong int16 () ($ulong->int16))
    (coerce ulong uint16 () ($ulong->uint16))
    (coerce ulong int32 () ($ulong->int32))
    (coerce ulong uint32 () ($ulong->uint32))
    (coerce ulong int64 () ($ulong->int64))
    (coerce ulong uint64 () ($ulong->uint64))

    ;; elong
    (coerce belong elong () ($belong->elong))
    (coerce belong uelong () ($belong->elong))
    (coerce elong bool () ((lambda (x::ulong) #t)))
    (coerce elong long () ($elong->long))
    (coerce elong belong () ($elong->belong))
    (coerce uelong long () ($elong->long))
    (coerce uelong belong () ($elong->belong))
    (coerce uelong elong () ($uelong->elong))
    (coerce elong uelong () ($elong->uelong))
    (coerce elong int8 () ($elong->int8))
    (coerce elong uint8 () ($elong->uint8))
    (coerce elong int16 () ($elong->int16))
    (coerce elong uint16 () ($elong->uint16))
    (coerce elong int32 () ($elong->int32))
    (coerce elong uint32 () ($elong->uint32))
    (coerce elong int64 () ($elong->int64))
    (coerce elong uint64 () ($elong->uint64))

    ;; llong
    (coerce bllong ullong () ($bllong->ullong))
    (coerce bllong llong () ($bllong->llong))
    (coerce llong bool () ((lambda (x::ulong) #t)))
    (coerce llong long () ($llong->long))
    (coerce llong bllong () ($llong->bllong))
    (coerce int64 llong () ($int64->llong))
    (coerce int64 elong () ($int64->elong))
    (coerce ullong long () ($ullong->long))
    (coerce ullong bllong () ($ullong->bllong))
    (coerce ullong llong () ($ullong->llong))
    (coerce llong ullong () ($llong->ullong))
    (coerce llong int8 () ($llong->int8))
    (coerce llong uint8 () ($llong->uint8))
    (coerce llong int16 () ($llong->int16))
    (coerce llong uint16 () ($llong->uint16))
    (coerce llong int32 () ($llong->int32))
    (coerce llong uint32 () ($llong->uint32))
    (coerce llong int64 () ($llong->int64))
    (coerce llong uint64 () ($llong->uint64))

    ;; stdint
    (coerce int8 bint8 () ($int8->bint8))
    (coerce bint8 int8 () ($bint8->int8))
    (coerce uint8 buint8 () ($uint8->buint8))
    (coerce buint8 uint8 () ($buint8->uint8))
    (coerce uint8 int8 () ($uint8->int8))
    (coerce int8 uint8 () ($int8->uint8))
    (coerce int16 bint16 () ($int16->bint16))
    (coerce bint16 int16 () ($bint16->int16))
    (coerce uint16 buint16 () ($uint16->buint16))
    (coerce buint16 uint16 () ($buint16->uint16))
    (coerce uint16 int16 () ($uint16->int16))
    (coerce int16 uint16 () ($int16->uint16))
    (coerce int32 bint32 () ($int32->bint32))
    (coerce bint32 int32 () ($bint32->int32))
    (coerce uint32 buint32 () ($uint32->buint32))
    (coerce buint32 uint32 () ($buint32->uint32))
    (coerce uint32 int32 () ($uint32->int32))
    (coerce int32 uint32 () ($int32->uint32))
    (coerce int64 bint64 () ($int64->bint64))
    (coerce bint64 int64 () ($bint64->int64))
    (coerce uint64 buint64 () ($uint64->buint64))
    (coerce buint64 uint64 () ($buint64->uint64))
    (coerce uint64 int64 () ($uint64->int64))
    (coerce int64 uint64 () ($int64->uint64))
    
    ;; double
    (coerce real float () ($real->float))
    (coerce real double () ($real->double))
    (coerce real bool () ((lambda (x) #t)))
    (coerce float double () ($float->double))
    (coerce float bool () ((lambda (x::float) #t)))
    (coerce float real () ($float->real))
    (coerce double bool () ((lambda (x::double) #t)))
    (coerce double real () ($double->real))
    (coerce double float () ($double->float))

    ;; bignum
    (coerce bignum bool () ((lambda (x) #t)))
    (coerce bignum int () ($bignum->fixnum))

    ;; tvector
    (coerce tvector bool () ((lambda (x) #t)))

    ;; weakptr
    (coerce weakptr bool () ((lambda (x) #t)))

    ;; dynamic-env
    (coerce dynamic-env bool () ((lambda (x) #t)))

    ;; procedure
    (coerce procedure bool () ((lambda (x) #t)))
    (coerce procedure-l bool () ((lambda (x) #t)))
    (coerce procedure-el bool () ((lambda (x) #t)))
    (coerce procedure-l procedure () ())
    (coerce procedure-el procedure () ())
    (coerce procedure procedure-l () ())
    (coerce procedure procedure-el () ())

    ;; struct
    (coerce struct bool () ((lambda (x) #t)))
    (coerce tstruct bool () ((lambda (x) #t)))

    ;; pair
    (coerce pair epair ($epair?) ())
    (coerce pair bool () ((lambda (x) #t)))
    (coerce epair pair () ())
    (coerce epair pair-nil () ())
    (coerce epair bool () ((lambda (x) #t)))
    (coerce pair-nil pair (pair?) ())
    (coerce pair pair-nil () ())
    (coerce pair-nil epair (epair?) ())
    (coerce pair-nil nil (null?) ())
    (coerce pair-nil bool () ((lambda (x) #t)))
    (coerce nil pair-nil () ())
    (coerce nil bool () ((lambda (x) #t)))

    ;; cell
    (coerce cell bool () ((lambda (x) #t)))

    ;; ports
    (coerce file input-port () ($file->input-port))
    (coerce file output-port () ($file->output-port))
    (coerce input-port bool () ((lambda (x) #t)))
    (coerce output-port file () ($output-port->file))
    (coerce output-port bool () ((lambda (x) #t)))
    (coerce binary-port file () ($binary-port->file))
    (coerce binary-port bool () ((lambda (x) #t)))

    ;; process
    (coerce process bool () ((lambda (x) #t)))

    ;; srfi4 vectors
    (coerce s8vector bool () ((lambda (x) #t)))
    (coerce u8vector bool () ((lambda (x) #t)))
    (coerce s16vector bool () ((lambda (x) #t)))
    (coerce u16vector bool () ((lambda (x) #t)))
    (coerce s32vector bool () ((lambda (x) #t)))
    (coerce u32vector bool () ((lambda (x) #t)))
    (coerce s64vector bool () ((lambda (x) #t)))
    (coerce u64vector bool () ((lambda (x) #t)))
    (coerce f32vector bool () ((lambda (x) #t)))
    (coerce f64vector bool () ((lambda (x) #t)))
    
    ;; socket
    (coerce socket bool () ((lambda (x) #t)))
    (coerce datagram-socket bool () ((lambda (x) #t)))

    ;; regexp
    (coerce regexp bool () ((lambda (x) #t)))

    ;; custom
    (coerce custom bool () ((lambda (x) #t)))

    ;; date
    (coerce date bool () ((lambda (x) #t)))

    ;; mutex
    (coerce mutex bool () ((lambda (x) #t)))

    ;; condvar
    (coerce condvar bool () ((lambda (x) #t)))

    ;; mmap
    (coerce mmap bool () ((lambda (x) #t)))

    ;; semaphore
    (coerce semaphore bool () ((lambda (x) #t)))

    ;; class
    (coerce class bool () ((lambda (x) #t)))
    (coerce class-field bool () ((lambda (x) #t)))

    ;; opaque
    (coerce opaque bool () ((lambda (x) #t))))
   (extern
      (macro $bint-null::bint "BINT_NULL")
      (macro $long-null::long "0L")
      
      (macro $bool->bbool::bbool (::bool) "BBOOL")
      (macro $obj->bool::bool (::obj) "CBOOL")
      (macro $bbool->bool::bool (::bbool) "CBOOL")
      
      (macro $byte->bint::bint (::byte) "BINT")
      (macro $ubyte->bint::bint (::ubyte) "BINT")
      (macro $short->bint::bint (::short) "BINT")
      (macro $ushort->bint::bint (::ushort) "BINT")
      (macro $int->bint::bint (::int) "BINT")
      (macro $uint->bint::bint (::uint) "BINT")
      (macro $long->bint::bint (::long) "BINT")
      (macro $ulong->bint::bint (::ulong) "BINT")
      (macro $int8->bint::bint (::int8) "BINT")
      (macro $uint8->bint::bint (::uint8) "BINT")
      (macro $int16->bint::bint (::int16) "BINT")
      (macro $uint16->bint::bint (::uint16) "BINT")
      (macro $int32->bint::bint (::int32) "BINT")
      (macro $uint32->bint::bint (::uint32) "BINT")
      (macro $int64->bint::bint (::int64) "BINT")
      (macro $uint64->bint::bint (::uint64) "BINT")
      
      (macro $bint->byte::byte (::bint) "(signed char)CINT")
      (macro $bint->char::char (::bint) "(signed char)CINT")
      (macro $bint->ubyte::ubyte (::bint) "(unsigned char)CINT")
      (macro $bint->short::short (::bint) "(short)CINT")
      (macro $bint->ushort::ushort (::bint) "(unsigned short)CINT")
      (macro $bint->int::int (::bint) "CINT")
      (macro $bint->uint::uint (::bint) "(unsigned int)CINT")
      (macro $bint->long::long (::bint) "(long)CINT")
      (macro $bint->ulong::ulong (::bint) "(unsigned long)CINT")
      (macro $bint->int8::int8 (::bint) "(int8_t)CINT")
      (macro $bint->uint8::uint8 (::bint) "(uint8_t)CINT")
      (macro $bint->int16::int16 (::bint) "(int16_t)CINT")
      (macro $bint->uint16::uint16 (::bint) "(uint16_t)CINT")
      (macro $bint->int32::int32 (::bint) "(int32_t)CINT")
      (macro $bint->uint32::uint32 (::bint) "(uint32_t)CINT")
      (macro $bint->int64::int64 (::bint) "(int64_t)CINT")
      (macro $bint->uint64::uint64 (::bint) "(uint64_t)CINT")
      
      (macro $ubyte->byte::byte (::ubyte) "(signed char)")
      (macro $byte->ubyte::ubyte (::byte) "(unsigned char)")
      
      (macro $ubyte->short::short (::ubyte) "(short)")
      (macro $ubyte->ushort::ushort (::ubyte) "(unsigned short)")
      (macro $ubyte->int::int (::ubyte) "(int)")
      (macro $ubyte->uint::uint (::ubyte) "(unsigned int)")
      (macro $ubyte->long::long (::ubyte) "(long)")
      (macro $ubyte->ulong::ulong (::ubyte) "(unsigned long)")
      (macro $ubyte->int8::int8 (::ubyte) "(int8_t)")
      (macro $ubyte->uint8::uint8 (::ubyte) "(uint8_t)")
      (macro $ubyte->int16::int16 (::ubyte) "(int16_t)")
      (macro $ubyte->uint16::uint16 (::ubyte) "(uint16_t)")
      (macro $ubyte->int32::int32 (::ubyte) "(int32_t)")
      (macro $ubyte->uint32::uint32 (::ubyte) "(uint32_t)")
      (macro $ubyte->int64::int64 (::ubyte) "(int64_t)")
      (macro $ubyte->uint64::uint64 (::ubyte) "(uint64_t)")
      
      (macro $byte->short::short (::byte) "(short)")
      (macro $byte->ushort::ushort (::byte) "(unsigned short)")
      (macro $byte->int::int (::byte) "(int)")
      (macro $byte->uint::uint (::byte) "(unsigned int)")
      (macro $byte->long::long (::byte) "(long)")
      (macro $byte->ulong::ulong (::byte) "(unsigned long)")
      (macro $byte->int8::int8 (::byte) "(int8_t)")
      (macro $byte->uint8::uint8 (::byte) "(uint8_t)")
      (macro $byte->int16::int16 (::byte) "(int16_t)")
      (macro $byte->uint16::uint16 (::byte) "(uint16_t)")
      (macro $byte->int32::int32 (::byte) "(int32_t)")
      (macro $byte->uint32::uint32 (::byte) "(uint32_t)")
      (macro $byte->int64::int64 (::byte) "(int64_t)")
      (macro $byte->uint64::uint64 (::byte) "(uint64_t)")
      
      (macro $short->byte::byte (::short) "(signed char)")
      (macro $short->ubyte::ubyte (::short) "(unsigned char)")
      (macro $short->ushort::ushort (::short) "(unsigned short)")
      (macro $short->int::int (::short) "(int)")
      (macro $short->uint::uint (::short) "(unsigned int)")
      (macro $short->long::long (::short) "(long)")
      (macro $short->ulong::ulong (::short) "(unsigned long)")
      (macro $short->int8::int8 (::short) "(int8_t)")
      (macro $short->uint8::uint8 (::short) "(uint8_t)")
      (macro $short->int16::int16 (::short) "(int16_t)")
      (macro $short->uint16::uint16 (::short) "(uint16_t)")
      (macro $short->int32::int32 (::short) "(int32_t)")
      (macro $short->uint32::uint32 (::short) "(uint32_t)")
      (macro $short->int64::int64 (::short) "(int64_t)")
      (macro $short->uint64::uint64 (::short) "(uint64_t)")
      
      (macro $ushort->byte::byte (::ushort) "(signed char)")
      (macro $ushort->ubyte::ubyte (::ushort) "(unsigned char)")
      (macro $ushort->short::short (::ushort) "(short)")
      (macro $ushort->int::int (::ushort) "(int)")
      (macro $ushort->uint::uint (::ushort) "(unsigned int)")
      (macro $ushort->long::long (::ushort) "(long)")
      (macro $ushort->ulong::ulong (::ushort) "(unsigned long)")
      (macro $ushort->int8::int8 (::ushort) "(int8_t)")
      (macro $ushort->uint8::int8 (::ushort) "(uint8_t)")
      (macro $ushort->int16::int16 (::ushort) "(int16_t)")
      (macro $ushort->uint16::int16 (::ushort) "(uint16_t)")
      (macro $ushort->int32::int32 (::ushort) "(int32_t)")
      (macro $ushort->uint32::int32 (::ushort) "(uint32_t)")
      (macro $ushort->int64::int64 (::ushort) "(int64_t)")
      (macro $ushort->uint64::int64 (::ushort) "(uint64_t)")
      
      (macro $int->byte::byte (::int) "(signed char)")
      (macro $int->ubyte::ubyte (::int) "(unsigned char)")
      (macro $int->short::short (::int) "(short)")
      (macro $int->ushort::ushort (::int) "(unsigned short)")
      (macro $int->uint::uint (::int) "(unsigned int)")
      (macro $int->long::long (::int) "(long)")
      (macro $int->ulong::ulong (::int) "(unsigned long)")
      (macro $int->int8::int8 (::int) "(int8_t)")
      (macro $int->uint8::int8 (::int) "(uint8_t)")
      (macro $int->int16::int16 (::int) "(int16_t)")
      (macro $int->uint16::int16 (::int) "(uint16_t)")
      (macro $int->int32::int32 (::int) "(int32_t)")
      (macro $int->uint32::int32 (::int) "(uint32_t)")
      (macro $int->int64::int64 (::int) "(int64_t)")
      (macro $int->uint64::int64 (::int) "(uint64_t)")
      
      (macro $uint->byte::byte (::uint) "(signed char)")
      (macro $uint->ubyte::ubyte (::uint) "(unsigned char)")
      (macro $uint->short::short (::uint) "(short)")
      (macro $uint->ushort::ushort (::uint) "(unsigned short)")
      (macro $uint->int::uint (::uint) "(int)")
      (macro $uint->long::long (::uint) "(long)")
      (macro $uint->ulong::ulong (::uint) "(unsigned long)")
      (macro $uint->int8::int8 (::uint) "(int8_t)")
      (macro $uint->uint8::uint8 (::uint) "(uint8_t)")
      (macro $uint->int16::int16 (::uint) "(int16_t)")
      (macro $uint->uint16::uint16 (::uint) "(uint16_t)")
      (macro $uint->int32::int32 (::uint) "(int32_t)")
      (macro $uint->uint32::uint32 (::uint) "(uint32_t)")
      (macro $uint->int64::int64 (::uint) "(int64_t)")
      (macro $uint->uint64::uint64 (::uint) "(uint64_t)")
      
      (macro $long->byte::byte (::long) "(signed char)")
      (macro $long->char::char (::long) "(signed char)")
      (macro $long->ubyte::ubyte (::long) "(unsigned char)")
      (macro $long->short::short (::long) "(short)")
      (macro $long->ushort::ushort (::long) "(unsigned short)")
      (macro $long->int::int (::long) "(int)")
      (macro $long->uint::uint (::long) "(unsigned int)")
      (macro $long->ulong::ulong (::long) "(unsigned long)")
      (macro $long->int8::int8 (::long) "(int8_t)")
      (macro $long->uint8::uint8 (::long) "(uint8_t)")
      (macro $long->int16::int16 (::long) "(int16_t)")
      (macro $long->uint16::uint16 (::long) "(uint16_t)")
      (macro $long->int32::int32 (::long) "(int32_t)")
      (macro $long->uint32::uint32 (::long) "(uint32_t)")
      (macro $long->int64::int64 (::long) "(int64_t)")
      (macro $long->uint64::uint64 (::long) "(uint64_t)")
      
      (macro $ulong->byte::byte (::ulong) "(signed char)")
      (macro $ulong->char::char (::ulong) "(signed char)")
      (macro $ulong->ubyte::ubyte (::ulong) "(unsigned char)")
      (macro $ulong->short::short (::ulong) "(short)")
      (macro $ulong->ushort::ushort (::ulong) "(unsigned short)")
      (macro $ulong->int::int (::ulong) "(int)")
      (macro $ulong->uint::uint (::ulong) "(unsigned int)")
      (macro $ulong->long::long (::ulong) "(long)")
      (macro $ulong->int8::int8 (::ulong) "(int8_t)")
      (macro $ulong->uint8::uint8 (::ulong) "(uint8_t)")
      (macro $ulong->int16::int16 (::ulong) "(int16_t)")
      (macro $ulong->uint16::uint16 (::ulong) "(uint16_t)")
      (macro $ulong->int32::int32 (::ulong) "(int32_t)")
      (macro $ulong->uint32::uint32 (::ulong) "(uint32_t)")
      (macro $ulong->int64::int64 (::ulong) "(int64_t)")
      (macro $ulong->uint64::uint64 (::ulong) "(uint64_t)")
      
      (macro $uelong->elong::elong (::uelong) "(long)")
      (macro $elong->uelong::uelong (::elong) "(unsigned long)")
      
      (macro $ullong->llong::llong (::ullong) "(BGL_LONGLONG_T)")
      (macro $llong->ullong::ullong (::llong) "(unsigned BGL_LONGLONG_T)")
      (macro $llong->int8::int8 (::long) "(int8_t)")
      (macro $llong->uint8::uint8 (::long) "(uint8_t)")
      (macro $llong->int16::int16 (::long) "(int16_t)")
      (macro $llong->uint16::uint16 (::long) "(uint16_t)")
      (macro $llong->int32::int32 (::long) "(int32_t)")
      (macro $llong->uint32::uint32 (::long) "(uint32_t)")
      (macro $llong->int64::int64 (::long) "(int64_t)")
      (macro $llong->uint64::uint64 (::long) "(uint64_t)")
      
      (macro $string->bstring::bstring (::string) "string_to_bstring")
      (macro $bstring->string::string (::bstring) "BSTRING_TO_STRING")
      
      (macro $char->bchar::bchar (::char) "BCHAR")
      (macro $char->uchar::uchar (::char) "(unsigned char)")
      (macro $uchar->bchar::bchar (::uchar) "BCHAR")
      (macro $uchar->char::char (::uchar) "(char)")
      (macro $bchar->char::char (::bchar) "CCHAR")
      (macro $bchar->uchar::uchar (::bchar) "CCHAR")
      (macro $double->real::real (::double) "DOUBLE_TO_REAL")
      (macro $real->double::double (::real) "REAL_TO_DOUBLE")
      (macro $float->real::real (::float) "FLOAT_TO_REAL")
      (macro $real->float::float (::real) "REAL_TO_FLOAT")
      (macro $double->float::float (::double) "(float)")
      (macro $float->double::double (::float) "(double)")
      
      (macro $ucs2->bucs2::bucs2 (::ucs2) "BUCS2")
      (macro $bucs2->ucs2::ucs2 (::bucs2) "CUCS2")
      
      (macro $output-port->file::file (::output-port) "OUTPUT_PORT_TO_FILE")
      (macro $file->output-port::output-port (::file) "FILE_TO_OUTPUT_PORT")
      
      ($file->input-port::input-port (::file) "bgl_file_to_input_port")
      
      (macro $binary-port->file::file (::binary-port) "BINARY_PORT_TO_FILE")
      
      (macro $cobj->obj::obj (::cobj) "(obj_t)")
      ($obj->cobj::cobj (::obj) "obj_to_cobj")
      
      (macro $ubyte->char::char (::ubyte) "(char)")
      (macro $char->ubyte::ubyte (::char) "(unsigned char)")
      
      (macro $elong->belong::belong (::elong) "make_belong")
      (macro $uelong->belong::belong (::uelong) "make_belong")
      (macro $long->belong::belong (::long) "make_belong")
      (macro $long->elong::elong (::long) "(long)")
      (macro $long->uelong::uelong (::long) "(unsigned long)")
      (macro $elong->long::long (::elong) "(long)")
      (macro $uelong->long::long (::uelong) "(long)")
      (macro $belong->elong::elong (::belong) "BELONG_TO_LONG")
      (macro $belong->uelong::elong (::belong) "BELONG_TO_LONG")
      (macro $belong->long::long (::belong) "BELONG_TO_LONG")
      (macro $long->bint8::bint8 (::long) "BGL_INT8_TO_BINT8")
      (macro $long->buint8::buint8 (::long) "BGL_INT8_TO_BUINT8")
      (macro $long->bint16::bint16 (::long) "BGL_INT16_TO_BINT16")
      (macro $long->buint16::buint16 (::long) "BGL_INT16_TO_BUINT16")
      (macro $long->bint32::bint32 (::long) "BGL_INT32_TO_BINT32")
      (macro $long->buint32::buint32 (::long) "BGL_INT32_TO_BUINT32")
      (macro $long->bint64::bint64 (::long) "BGL_INT64_TO_BINT64")
      (macro $long->buint64::buint64 (::long) "BGL_INT64_TO_BUINT64")
      
      (macro $llong->bllong::bllong (::llong) "make_bllong")
      (macro $ullong->bllong::bllong (::ullong) "make_bllong")
      (macro $long->bllong::bllong (::long) "LONG_TO_BLLONG")
      (macro $long->llong::llong (::long) "LONG_TO_LLONG")
      (macro $long->ullong::ullong (::llong) "LONG_TO_LLONG")
      (macro $llong->long::long (::llong) "LLONG_TO_LONG")
      (macro $ullong->long::elong (::ullong) "LLONG_TO_LONG")
      (macro $bllong->llong::llong (::bllong) "BLLONG_TO_LLONG")
      (macro $bllong->ullong::ullong (::bllong) "BLLONG_TO_LLONG")
      (macro $bllong->long::long (::bllong) "BLLONG_TO_LONG")
      
      (macro $int8->bint8::bint8 (::int8) "BGL_INT8_TO_BINT8")
      (macro $bint8->int8::int8 (::bint8) "BGL_BINT8_TO_INT8")
      (macro $uint8->buint8::buint8 (::uint8) "BGL_UINT8_TO_BUINT8")
      (macro $buint8->uint8::uint8 (::buint8) "BGL_BUINT8_TO_UINT8")
      (macro $int16->bint16::bint16 (::int16) "BGL_INT16_TO_BINT16")
      (macro $bint16->int16::int16 (::bint16) "BGL_BINT16_TO_INT16")
      (macro $uint16->buint16::buint16 (::uint16) "BGL_UINT16_TO_BUINT16")
      (macro $buint16->uint16::uint16 (::buint16) "BGL_BUINT16_TO_UINT16")
      (macro $int32->bint32::bint32 (::int32) "BGL_INT32_TO_BINT32")
      (macro $bint32->int32::int32 (::bint32) "BGL_BINT32_TO_INT32")
      (macro $uint32->buint32::buint32 (::uint32) "BGL_UINT32_TO_BUINT32")
      (macro $buint32->uint32::uint32 (::buint32) "BGL_BUINT32_TO_UINT32")
      (macro $int64->bint64::bint64 (::int64) "BGL_INT64_TO_BINT64")
      (macro $bint64->int64::int64 (::bint64) "BGL_BINT64_TO_INT64")
      (macro $uint64->buint64::buint64 (::uint64) "BGL_UINT64_TO_BUINT64")
      (macro $buint64->uint64::uint64 (::buint64) "BGL_BINT64_TO_INT64")
      
      (macro $uint8->int8::int8 (::uint8) "(int8_t)")
      (macro $int8->uint8::uint8 (::int8) "(uint8_t)")
      (macro $uint16->int16::int16 (::uint16) "(int16_t)")
      (macro $int16->uint16::uint16 (::int16) "(uint16_t)")
      (macro $uint32->int32::int32 (::uint32) "(int32_t)")
      (macro $int32->uint32::uint32 (::int32) "(uint32_t)")
      (macro $uint64->int64::int64 (::uint64) "(int64_t)")
      (macro $int64->uint64::uint64 (::int64) "(uint64_t)")
      
      (macro $uint32->ulong::ulong (::uint32) "(unsigned long)")
      (macro $uint32->long::long (::uint32) "(long)")
      
      (macro $obj->void*::void* (::foreign) "FOREIGN_TO_COBJ")
      ($void*->obj::foreign (::void*) "void_star_to_obj"))

   (java
    (abstract-class foreign
       (field static $bint-null::bint "BINT_NULL")
       (field static $long-null::long "LONG_NULL")
       
       (method static $bool->bbool::bbool (::bool) "BBOOL")
       (method static $obj->bool::bool (::obj) "CBOOL")
       (method static $bbool->bool::bool (::bbool) "CBOOL")

       (method static $byte->bint::bint (::byte) "BINT")
       (method static $ubyte->bint::bint (::ubyte) "BINT")
       (method static $short->bint::bint (::short) "BINT")
       (method static $ushort->bint::bint (::ushort) "BINT")
       (method static $int->bint::bint (::int) "BINT")
       (method static $uint->bint::bint (::uint) "BINT")
       (method static $long->bint::bint (::long) "BINT")
       (method static $ulong->bint::bint (::ulong) "BINT")

       (method static $bint->byte::byte (::bint) "BINT_TO_BYTE")
       (method static $bint->char::char (::bint) "BINT_TO_CHAR")
       (method static $bint->ubyte::ubyte (::bint) "BINT_TO_UBYTE")
       (method static $bint->short::short (::bint) "BINT_TO_SHORT")
       (method static $bint->ushort::ushort (::bint) "BINT_TO_USHORT")
       (method static $bint->int::int (::bint) "CINT")
       (method static $bint->uint::uint (::bint) "BINT_TO_UINT")
       (method static $bint->long::long (::bint) "<inlined>")
       (method static $bint->ulong::ulong (::bint) "BINT_TO_ULONG")
       (method static $bint->int8::int8 (::bint) "BINT_TO_INT8")
       (method static $bint->uint8::uint8 (::bint) "BINT_TO_UINT8")
       (method static $bint->int16::int16 (::bint) "BINT_TO_INT16")
       (method static $bint->uint16::uint16 (::bint) "BINT_TO_INT16")
       (method static $bint->int32::int32 (::bint) "BINT_TO_INT32")
       (method static $bint->uint32::uint32 (::bint) "BINT_TO_INT32")
       (method static $bint->int64::int64 (::bint) "BINT_TO_INT64")
       (method static $bint->uint64::uint64 (::bint) "BINT_TO_INT64")

       (method static $ubyte->byte::byte (::ubyte) "UBYTE_TO_BYTE")
       (method static $ubyte->short::short (::ubyte) "UBYTE_TO_SHORT")
       (method static $ubyte->ushort::ushort (::ubyte) "UBYTE_TO_USHORT")
       (method static $ubyte->int::int (::ubyte) "UBYTE_TO_INT")
       (method static $ubyte->uint::uint (::ubyte) "UBYTE_TO_INT")
       (method static $ubyte->long::long (::ubyte) "UBYTE_TO_LONG")
       (method static $ubyte->ulong::ulong (::ubyte) "UBYTE_TO_ULONG")

       (method static $byte->ubyte::ubyte (::byte) "BYTE_TO_UBYTE")
       (method static $byte->short::short (::byte) "BYTE_TO_SHORT")
       (method static $byte->ushort::ushort (::byte) "BYTE_TO_USHORT")
       (method static $byte->int::int (::byte) "BYTE_TO_INT")
       (method static $byte->uint::uint (::byte) "BYTE_TO_UINT")
       (method static $byte->long::long (::byte) "BYTE_TO_LONG")
       (method static $byte->ulong::ulong (::byte) "BYTE_TO_ULONG")
       (method static $byte->uint32::uint32 (::byte) "BYTE_TO_INT")

       (method static $ubyte->short::short (::ubyte) "UBYTE_TO_SHORT")
       (method static $ubyte->ushort::ushort (::ubyte) "UBYTE_TO_USHORT")
       (method static $ubyte->int::int (::ubyte) "UBYTE_TO_INT")
       (method static $ubyte->long::long (::ubyte) "UBYTE_TO_LONG")
       (method static $ubyte->ulong::ulong (::ubyte) "UBYTE_TO_ULONG")

       (method static $short->byte::byte (::short) "SHORT_TO_BYTE")
       (method static $short->ubyte::ubyte (::short) "SHORT_TO_UBYTE")
       (method static $short->ushort::ushort (::short) "SHORT_TO_USHORT")
       (method static $short->int::int (::short) "SHORT_TO_INT")
       (method static $short->uint::uint (::short) "SHORT_TO_UINT")
       (method static $short->long::long (::short) "SHORT_TO_LONG")
       (method static $short->ulong::ulong (::short) "SHORT_TO_ULONG")

       (method static $ushort->byte::byte (::ushort) "USHORT_TO_BYTE")
       (method static $ushort->ubyte::ubyte (::ushort) "USHORT_TO_UBYTE")
       (method static $ushort->short::short (::ushort) "USHORT_TO_SHORT")
       (method static $ushort->int::int (::ushort) "USHORT_TO_INT")
       (method static $ushort->uint::uint (::ushort) "USHORT_TO_UINT")
       (method static $ushort->long::long (::ushort) "USHORT_TO_LONG")
       (method static $ushort->ulong::ulong (::ushort) "USHORT_TO_ULONG")

       (method static $int->byte::byte (::int) "INT_TO_BYTE")
       (method static $int->ubyte::ubyte (::int) "INT_TO_UBYTE")
       (method static $int->short::short (::int) "INT_TO_SHORT")
       (method static $int->ushort::ushort (::int) "INT_TO_USHORT")
       (method static $int->uint::uint (::int) "INT_TO_UINT")
       (method static $int->long::long (::int) "<inlined>")
       (method static $int->ulong::ulong (::int) "INT_TO_ULONG")
       (method static $int->uint8::uint8 (::int) "INT_TO_UINT")

       (method static $uint->byte::byte (::uint) "UINT_TO_BYTE")
       (method static $uint->ubyte::ubyte (::uint) "UINT_TO_UBYTE")
       (method static $uint->short::short (::uint) "UINT_TO_SHORT")
       (method static $uint->ushort::ushort (::uint) "UINT_TO_USHORT")
       (method static $uint->int::uint (::uint) "UINT_TO_INT")
       (method static $uint->long::long (::uint) "UINT_TO_LONG")
       (method static $uint->ulong::ulong (::uint) "UINT_TO_ULONG")
	  
       (method static $long->byte::byte (::long) "LONG_TO_BYTE")
       (method static $long->ubyte::ubyte (::long) "LONG_TO_UBYTE")
       (method static $long->char::char (::long) "LONG_TO_CHAR")
       (method static $long->short::short (::long) "LONG_TO_SHORT")
       (method static $long->ushort::ushort (::long) "LONG_TO_USHORT")
       (method static $long->int::int (::long) "LONG_TO_INT")
       (method static $long->uint::uint (::long) "LONG_TO_UINT")
       (method static $long->ulong::ulong (::long) "LONG_TO_ULONG")
       (method static $long->int8::int8 (::long) "LONG_TO_INT8")
       (method static $long->uint8::uint8 (::long) "LONG_TO_INT8")
       (method static $long->int16::int16 (::long) "LONG_TO_INT16")
       (method static $long->uint16::uint16 (::long) "LONG_TO_INT16")
       (method static $long->int32::int32 (::long) "LONG_TO_INT32")
       (method static $long->uint32::uint32 (::long) "LONG_TO_INT32")
       (method static $long->int64::int64 (::long) "LONG_TO_INT64")
       (method static $long->uint64::uint64 (::long) "LONG_TO_INT64")

       (method static $ulong->byte::byte (::ulong) "ULONG_TO_BYTE")
       (method static $ulong->ubyte::ubyte (::ulong) "ULONG_TO_UBYTE")
       (method static $ulong->char::char (::ulong) "ULONG_TO_CHAR")
       (method static $ulong->short::short (::ulong) "ULONG_TO_SHORT")
       (method static $ulong->ushort::ushort (::ulong) "ULONG_TO_USHORT")
       (method static $ulong->int::int (::ulong) "ULONG_TO_INT")
       (method static $ulong->uint::uint (::ulong) "ULONG_TO_INT")
       (method static $ulong->long::long (::ulong) "ULONG_TO_LONG")
       (method static $ulong->uint8::ulong (::uint8) "ULONG_TO_INT")
       (method static $ulong->uint32::ulong (::uint32) "ULONG_TO_INT")

       (method static $string->bstring::bstring (::string) "string_to_bstring")
       (method static $bstring->string::string (::bstring) "BSTRING_TO_STRING")

       (method static $char->bchar::bchar (::char) "BCHAR")
       (method static $char->uchar::uchar (::char) "CHAR_TO_UCHAR")
       (method static $uchar->bchar::bchar (::uchar) "BCHAR")
       (method static $uchar->char::char (::uchar) "UCHAR_TO_CHAR")
       (method static $bchar->char::char (::bchar) "CCHAR")
       (method static $bchar->uchar::uchar (::bchar) "BCHAR_TO_UCHAR")
       (method static $double->real::real (::double) "DOUBLE_TO_REAL")
       (method static $real->double::double (::real) "REAL_TO_DOUBLE")
       (method static $float->real::real (::float) "FLOAT_TO_REAL")
       (method static $real->float::float (::real) "REAL_TO_FLOAT")
       (method static $double->float::float (::double) "DOUBLE_TO_FLOAT")
       (method static $float->double::double (::float) "FLOAT_TO_DOUBLE")

       (method static $ucs2->bucs2::bucs2 (::ucs2) "BUCS2")
       (method static $bucs2->ucs2::ucs2 (::bucs2) "CUCS2")

       (method static $output-port->file::file (::output-port) "OUTPUT_PORT_TO_FILE")
       (method static $file->output-port::output-port (::file) "FILE_TO_OUTPUT_PORT")

       (method static $file->input-port::input-port (::file) "bgl_file_to_input_port")

       (method static $binary-port->file::file (::binary-port) "BINARY_PORT_TO_FILE")

       (method static $cobj->obj::obj (::cobj) "COBJ_TO_OBJ")
       (method static $obj->cobj::cobj (::obj) "obj_to_cobj")

       (method static $ubyte->char::char (::ubyte) "UBYTE_TO_CHAR")
       (method static $char->ubyte::ubyte (::char) "CHAR_TO_UBYTE")

       (method static $elong->belong::belong (::elong) "ELONG_TO_BELONG")
       (method static $long->belong::belong (::long) "LONG_TO_BELONG")
       (method static $long->elong::elong (::long) "LONG_TO_ELONG")
       (method static $elong->long::long (::elong) "ELONG_TO_LONG")
       (method static $belong->elong::elong (::belong) "BELONG_TO_ELONG")
       (method static $belong->long::long (::belong) "BELONG_TO_LONG")
       (method static $uelong->elong::elong (::uelong) "UELONG_TO_ELONG")
       (method static $elong->uelong::uelong (::elong) "ELONG_TO_UELONG")

       (method static $llong->bllong::bllong (::llong) "LLONG_TO_BLLONG")
       (method static $long->bllong::bllong (::long) "LONG_TO_BLLONG")
       (method static $long->llong::llong (::long) "LONG_TO_LLONG")
       (method static $long->ullong::ullong (::long) "LONG_TO_ULLONG")
       (method static $llong->long::long (::llong) "LLONG_TO_LONG")
       (method static $ullong->long::long (::ullong) "ULLONG_TO_LONG")
       (method static $ullong->bllong::bllong (::ullong) "ULLONG_TO_BLLONG")
       (method static $bllong->llong::llong (::bllong) "BLLONG_TO_LLONG")
       (method static $bllong->ullong::ullong (::bllong) "BLLONG_TO_ULLONG")
       (method static $bllong->long::long (::bllong) "BLLONG_TO_LONG")
       (method static $ullong->llong::llong (::ullong) "ULLONG_TO_LLONG")
       (method static $llong->ullong::ullong (::llong) "LLONG_TO_ULLONG")
       (method static $llong->int8::int8 (::llong) "LLONG_TO_INT8")
       (method static $llong->uint8::uint8 (::llong) "LLONG_TO_INT8")
       (method static $llong->int16::int16 (::llong) "LLONG_TO_INT16")
       (method static $llong->uint16::uint16 (::llong) "LLONG_TO_INT16")
       (method static $llong->int32::int32 (::llong) "LLONG_TO_INT32")
       (method static $llong->uint32::uint32 (::llong) "LLONG_TO_INT32")
       (method static $llong->int64::int64 (::llong) "LLONG_TO_INT64")
       (method static $llong->uint64::uint64 (::llong) "LLONG_TO_INT64")

       (method static $int8->bint8::bint8 (::int8) "BGL_INT8_TO_BINT8")
       (method static $bint8->int8::int8 (::bint8) "BGL_BINT8_TO_INT8")
       (method static $uint8->buint8::buint8 (::uint8) "BGL_INT8_TO_BINT8")
       (method static $buint8->uint8::uint8 (::buint8) "BGL_BINT8_TO_INT8")
       (method static $int16->bint16::bint16 (::int16) "BGL_INT16_TO_BINT16")
       (method static $bint16->int16::int16 (::bint16) "BGL_BINT16_TO_INT16")
       (method static $uint16->buint16::buint16 (::uint16) "BGL_INT16_TO_BINT16")
       (method static $buint16->uint16::uint16 (::buint16) "BGL_BINT16_TO_INT16")
       (method static $int32->bint32::bint32 (::int32) "BGL_INT32_TO_BINT32")
       (method static $bint32->int32::int32 (::bint32) "BGL_BINT32_TO_INT32")
       (method static $uint32->buint32::buint32 (::uint32) "BGL_INT32_TO_BINT32")
       (method static $buint32->uint32::uint32 (::buint32) "BGL_BINT32_TO_INT32")
       (method static $int64->bint64::bint64 (::int64) "BGL_INT64_TO_BINT64")
       (method static $bint64->int64::int64 (::bint64) "BGL_BINT64_TO_INT64")
       (method static $uint64->buint64::buint64 (::uint64) "BGL_INT64_TO_BINT64")
       (method static $buint64->uint64::uint64 (::buint64) "BGL_BINT64_TO_INT64")

       (method static $uint8->int8::int8 (::uint8) "BGL_INT8_ID")
       (method static $int8->uint8::uint8 (::int8) "BGL_INT8_ID")
       (method static $uint16->int16::int16 (::uint16) "BGL_INT16_ID")
       (method static $int16->uint16::uint16 (::int16) "BGL_INT16_ID")
       (method static $uint32->int32::int32 (::uint32) "BGL_INT32_ID")
       (method static $int32->uint32::uint32 (::int32) "BGL_INT32_ID")
       (method static $uint64->int64::int64 (::uint64) "BGL_INT64_ID")
       (method static $int64->uint64::uint64 (::int64) "BGL_INT64_ID")

       (method static $uint32->ulong::ulong (::uint32) "BGL_INT32_ID")
       (method static $uint32->long::long (::uint32) "BGL_INT32_ID")
    
       (method static $obj->void*::cobj (::void*) "FOREIGN_TO_COBJ")
       (method static $void*->obj::foreign (::void*) "void_star_to_obj")))

   (pragma
    ($bool->bbool no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bbool->bool no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($obj->bool no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($byte->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->bint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->byte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bint->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($byte->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($byte->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($byte->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($byte->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($byte->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($byte->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->byte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($short->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->byte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ushort->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->byte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($int->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->byte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uint->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->byte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->ulong no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->byte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->short no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->ushort no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->int no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->uint no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ulong->long no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bstring->string no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($string->bstring nesting args-safe fail-safe)
    ($char->bchar no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($char->uchar no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uchar->bchar no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($uchar->char no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bchar->char no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($bchar->uchar no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($ucs2->bucs2 side-effect-free nesting args-safe fail-safe (effect))
    ($bucs2->ucs2 no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($double->real side-effect-free args-safe fail-safe (effect))
    ($real->double no-alloc side-effect-free args-safe fail-safe (effect))
    ($double->float no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($float->double side-effect-free nesting args-safe fail-safe (effect))
    ($float->real side-effect-free args-safe fail-safe (effect))
    ($real->float side-effect-free nesting args-safe fail-safe (effect))
    ($cobj->obj side-effect-free nesting args-safe fail-safe (effect))
    ($obj->cobj side-effect-free nesting args-safe fail-safe (effect))
    ($ubyte->char side-effect-free nesting args-safe fail-safe (effect))
    ($char->ubyte no-alloc side-effect-free nesting args-safe fail-safe (effect))
    ($long->belong side-effect-free args-safe fail-safe (effect))
    ($llong->bllong side-effect-free args-safe fail-safe (effect))
    ($ullong->bllong side-effect-free args-safe fail-safe (effect))
    ($bllong->llong side-effect-free nesting args-safe fail-safe (effect))
    ($bllong->ullong side-effect-free nesting args-safe fail-safe (effect))
    ($obj->void* side-effect-free nesting args-safe fail-safe (effect))
    ($void*->obj side-effect-free nesting args-safe fail-safe (effect))))

