# NSKeyedUnArchiver

Unserializes any binary|text|file|memory plist data and returns a usable Python dict.

Plist files are very common in Apple platforms (macOS, iOS etc). Plist files are used to store data much like XML and JSON files, but can be pure text or binary (convertible with plutil command). Some Plist files were generated by Apple NSKeyedArchiver and contain a serialized version of objects stored in an intricate and complex schema of nested objects. NSKeyedUnArchiver converts it back to an hierarchical form as a Python dict.

Uses only Python 3.8 plistlib, no other dependencies.

Automatically converts well known data types to Python-equivalent data types:

- `NSArray` ➔ `list`
- `NSMutableDictionary`, `NSDictionary` ➔ `dict`
- `NSMutableString`, `NSString` ➔ unwrap the `string`
- `NSMutableData`, `NSData` ➔ unwrap the data
- `NSDate` ➔ `datetime`

Check [pypi](https://pypi.org/project/NSKeyedUnArchiver/) for packages.

See package name for your system package manager at [Repology](https://repology.org/project/python:nskeyedunarchiver/information).

License is LGPL 3.

## Sample usage

```python
import NSKeyedUnArchiver

file='/path/to/file.plist'
my_dict=NSKeyedUnArchiver.unserializeNSKeyedArchiver(file)


data=b'bplist00\xd4\x01\.........'
my_dict=NSKeyedUnArchiver.unserializeNSKeyedArchiver(data)


data='<plist version="1.0">......'
my_dict=NSKeyedUnArchiver.unserializeNSKeyedArchiver(data)


file=PurePath('/path/to/file.plist')
my_dict=NSKeyedUnArchiver.unserializeNSKeyedArchiver(file)
```
