---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet plugin'
canonical: "/puppet/latest/man/plugin.html"
---

# Man Page: puppet plugin

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-plugin** - Interact with the Puppet plugin system.

## SYNOPSIS
puppet plugin *action*

## DESCRIPTION
This subcommand provides network access to the puppet master\'s store of
plugins.

The puppet master serves Ruby code collected from the **lib**
directories of its modules. These plugins can be used on agent nodes to
extend Facter and implement custom types and providers. Plugins are
normally downloaded by puppet agent during the course of a run.

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

## ACTIONS
**download** - Download plugins from the puppet master.

:   **SYNOPSIS**

    puppet plugin download

    **DESCRIPTION**

    Downloads plugins from the configured puppet master. Any plugins
    downloaded in this way will be used in all subsequent Puppet
    activity. This action modifies files on disk.

    **RETURNS**

    A list of the files downloaded, or a confirmation that no files were
    downloaded. When used from the Ruby API, this action returns an
    array of the files downloaded, which will be empty if none were
    retrieved.

## EXAMPLES
**download**

Retrieve plugins from the puppet master:

\$ puppet plugin download

Retrieve plugins from the puppet master (API example):

\$ Puppet::Face\[:plugin, \'0.0.1\'\].download

## COPYRIGHT AND LICENSE
Copyright 2011 by Puppet Inc. Apache 2 license; see COPYING
