// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, SidebarItem, SidebarMode, SidebarSection};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwSidebar")]
    pub struct Sidebar(Object<ffi::AdwSidebar, ffi::AdwSidebarClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::adw_sidebar_get_type(),
    }
}

impl Sidebar {
    #[doc(alias = "adw_sidebar_new")]
    pub fn new() -> Sidebar {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::adw_sidebar_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Sidebar`] objects.
    ///
    /// This method returns an instance of [`SidebarBuilder`](crate::builders::SidebarBuilder) which can be used to create [`Sidebar`] objects.
    pub fn builder() -> SidebarBuilder {
        SidebarBuilder::new()
    }

    #[doc(alias = "adw_sidebar_append")]
    pub fn append(&self, section: SidebarSection) {
        unsafe {
            ffi::adw_sidebar_append(self.to_glib_none().0, section.into_glib_ptr());
        }
    }

    #[doc(alias = "adw_sidebar_get_drop_preload")]
    #[doc(alias = "get_drop_preload")]
    #[doc(alias = "drop-preload")]
    pub fn is_drop_preload(&self) -> bool {
        unsafe { from_glib(ffi::adw_sidebar_get_drop_preload(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_get_filter")]
    #[doc(alias = "get_filter")]
    pub fn filter(&self) -> Option<gtk::Filter> {
        unsafe { from_glib_none(ffi::adw_sidebar_get_filter(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_get_item")]
    #[doc(alias = "get_item")]
    pub fn item(&self, index: u32) -> Option<SidebarItem> {
        unsafe { from_glib_none(ffi::adw_sidebar_get_item(self.to_glib_none().0, index)) }
    }

    #[doc(alias = "adw_sidebar_get_items")]
    #[doc(alias = "get_items")]
    pub fn items(&self) -> gtk::SelectionModel {
        unsafe { from_glib_full(ffi::adw_sidebar_get_items(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_get_menu_model")]
    #[doc(alias = "get_menu_model")]
    #[doc(alias = "menu-model")]
    pub fn menu_model(&self) -> Option<gio::MenuModel> {
        unsafe { from_glib_none(ffi::adw_sidebar_get_menu_model(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_get_mode")]
    #[doc(alias = "get_mode")]
    pub fn mode(&self) -> SidebarMode {
        unsafe { from_glib(ffi::adw_sidebar_get_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_get_placeholder")]
    #[doc(alias = "get_placeholder")]
    pub fn placeholder(&self) -> Option<gtk::Widget> {
        unsafe { from_glib_none(ffi::adw_sidebar_get_placeholder(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_get_section")]
    #[doc(alias = "get_section")]
    pub fn section(&self, index: u32) -> Option<SidebarSection> {
        unsafe { from_glib_none(ffi::adw_sidebar_get_section(self.to_glib_none().0, index)) }
    }

    #[doc(alias = "adw_sidebar_get_sections")]
    #[doc(alias = "get_sections")]
    pub fn sections(&self) -> gio::ListModel {
        unsafe { from_glib_full(ffi::adw_sidebar_get_sections(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_get_selected")]
    #[doc(alias = "get_selected")]
    pub fn selected(&self) -> u32 {
        unsafe { ffi::adw_sidebar_get_selected(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_sidebar_get_selected_item")]
    #[doc(alias = "get_selected_item")]
    #[doc(alias = "selected-item")]
    pub fn selected_item(&self) -> Option<SidebarItem> {
        unsafe { from_glib_none(ffi::adw_sidebar_get_selected_item(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_sidebar_insert")]
    pub fn insert(&self, section: SidebarSection, position: i32) {
        unsafe {
            ffi::adw_sidebar_insert(self.to_glib_none().0, section.into_glib_ptr(), position);
        }
    }

    #[doc(alias = "adw_sidebar_prepend")]
    pub fn prepend(&self, section: SidebarSection) {
        unsafe {
            ffi::adw_sidebar_prepend(self.to_glib_none().0, section.into_glib_ptr());
        }
    }

    #[doc(alias = "adw_sidebar_remove")]
    pub fn remove(&self, section: &SidebarSection) {
        unsafe {
            ffi::adw_sidebar_remove(self.to_glib_none().0, section.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_sidebar_remove_all")]
    pub fn remove_all(&self) {
        unsafe {
            ffi::adw_sidebar_remove_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_sidebar_set_drop_preload")]
    #[doc(alias = "drop-preload")]
    pub fn set_drop_preload(&self, preload: bool) {
        unsafe {
            ffi::adw_sidebar_set_drop_preload(self.to_glib_none().0, preload.into_glib());
        }
    }

    #[doc(alias = "adw_sidebar_set_filter")]
    #[doc(alias = "filter")]
    pub fn set_filter(&self, filter: Option<&impl IsA<gtk::Filter>>) {
        unsafe {
            ffi::adw_sidebar_set_filter(
                self.to_glib_none().0,
                filter.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_set_menu_model")]
    #[doc(alias = "menu-model")]
    pub fn set_menu_model(&self, menu_model: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::adw_sidebar_set_menu_model(
                self.to_glib_none().0,
                menu_model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_set_mode")]
    #[doc(alias = "mode")]
    pub fn set_mode(&self, mode: SidebarMode) {
        unsafe {
            ffi::adw_sidebar_set_mode(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "adw_sidebar_set_placeholder")]
    #[doc(alias = "placeholder")]
    pub fn set_placeholder(&self, placeholder: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::adw_sidebar_set_placeholder(
                self.to_glib_none().0,
                placeholder.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_sidebar_set_selected")]
    #[doc(alias = "selected")]
    pub fn set_selected(&self, selected: u32) {
        unsafe {
            ffi::adw_sidebar_set_selected(self.to_glib_none().0, selected);
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "activated")]
    pub fn connect_activated<F: Fn(&Self, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activated_trampoline<F: Fn(&Sidebar, u32) + 'static>(
            this: *mut ffi::AdwSidebar,
            index: std::ffi::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), index)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"activated".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activated_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "drop")]
    pub fn connect_drop<F: Fn(&Self, u32, &glib::Value, gdk::DragAction) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drop_trampoline<
            F: Fn(&Sidebar, u32, &glib::Value, gdk::DragAction) -> bool + 'static,
        >(
            this: *mut ffi::AdwSidebar,
            index: std::ffi::c_uint,
            value: *mut glib::gobject_ffi::GValue,
            preferred_action: gdk::ffi::GdkDragAction,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                index,
                &from_glib_borrow(value),
                from_glib(preferred_action),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"drop".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    drop_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "drop-enter")]
    pub fn connect_drop_enter<F: Fn(&Self, u32) -> gdk::DragAction + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drop_enter_trampoline<
            F: Fn(&Sidebar, u32) -> gdk::DragAction + 'static,
        >(
            this: *mut ffi::AdwSidebar,
            index: std::ffi::c_uint,
            f: glib::ffi::gpointer,
        ) -> gdk::ffi::GdkDragAction {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), index).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"drop-enter".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    drop_enter_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "drop-value-loaded")]
    pub fn connect_drop_value_loaded<
        F: Fn(&Self, u32, &glib::Value) -> gdk::DragAction + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn drop_value_loaded_trampoline<
            F: Fn(&Sidebar, u32, &glib::Value) -> gdk::DragAction + 'static,
        >(
            this: *mut ffi::AdwSidebar,
            index: std::ffi::c_uint,
            value: *mut glib::gobject_ffi::GValue,
            f: glib::ffi::gpointer,
        ) -> gdk::ffi::GdkDragAction {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), index, &from_glib_borrow(value)).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"drop-value-loaded".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    drop_value_loaded_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "setup-menu")]
    pub fn connect_setup_menu<F: Fn(&Self, Option<&SidebarItem>) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn setup_menu_trampoline<
            F: Fn(&Sidebar, Option<&SidebarItem>) + 'static,
        >(
            this: *mut ffi::AdwSidebar,
            item: *mut ffi::AdwSidebarItem,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                Option::<SidebarItem>::from_glib_borrow(item)
                    .as_ref()
                    .as_ref(),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"setup-menu".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    setup_menu_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "drop-preload")]
    pub fn connect_drop_preload_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_drop_preload_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::drop-preload".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_drop_preload_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "filter")]
    pub fn connect_filter_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_filter_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::filter".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_filter_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "items")]
    pub fn connect_items_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_items_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::items".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_items_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "menu-model")]
    pub fn connect_menu_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_menu_model_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::menu-model".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_menu_model_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "mode")]
    pub fn connect_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mode_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "placeholder")]
    pub fn connect_placeholder_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::placeholder".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_placeholder_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "sections")]
    pub fn connect_sections_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sections_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::sections".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_sections_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "selected")]
    pub fn connect_selected_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selected_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::selected".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_selected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "selected-item")]
    pub fn connect_selected_item_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selected_item_trampoline<F: Fn(&Sidebar) + 'static>(
            this: *mut ffi::AdwSidebar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::selected-item".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_selected_item_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_9")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
impl Default for Sidebar {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Sidebar`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SidebarBuilder {
    builder: glib::object::ObjectBuilder<'static, Sidebar>,
}

impl SidebarBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn drop_preload(self, drop_preload: bool) -> Self {
        Self {
            builder: self.builder.property("drop-preload", drop_preload),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn filter(self, filter: &impl IsA<gtk::Filter>) -> Self {
        Self {
            builder: self.builder.property("filter", filter.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn menu_model(self, menu_model: &impl IsA<gio::MenuModel>) -> Self {
        Self {
            builder: self
                .builder
                .property("menu-model", menu_model.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn mode(self, mode: SidebarMode) -> Self {
        Self {
            builder: self.builder.property("mode", mode),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn placeholder(self, placeholder: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("placeholder", placeholder.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn selected(self, selected: u32) -> Self {
        Self {
            builder: self.builder.property("selected", selected),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "gtk_v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Sidebar`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Sidebar {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
