/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.parser.ADQLParser;
import adql.parser.IdentifierItems;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ADQLSet;
import adql.query.ClauseConstraints;
import adql.query.ClauseOffset;
import adql.query.ColumnReference;
import adql.query.IdentifierField;
import adql.query.SelectItem;
import adql.query.SetOperation;
import adql.query.SetOperationType;
import adql.query.TextPosition;
import adql.query.WithItem;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.constraint.ConstraintsGroup;
import adql.query.constraint.Exists;
import adql.query.constraint.In;
import adql.query.constraint.IsNull;
import adql.query.constraint.NotConstraint;
import adql.query.from.ADQLJoin;
import adql.query.from.ADQLTable;
import adql.query.from.CrossJoin;
import adql.query.from.FromContent;
import adql.query.from.InnerJoin;
import adql.query.from.OuterJoin;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NullValue;
import adql.query.operand.NumericConstant;
import adql.query.operand.Operation;
import adql.query.operand.OperationType;
import adql.query.operand.StringConstant;
import adql.query.operand.WrappedOperand;
import adql.query.operand.function.InUnitFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.MathFunctionType;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.cast.CastFunction;
import adql.query.operand.function.cast.TargetType;
import adql.query.operand.function.conditional.CoalesceFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.query.operand.function.string.LowerFunction;
import adql.query.operand.function.string.UpperFunction;
import java.util.Collection;

public class ADQLQueryFactory {
    @Deprecated
    public final ADQLQuery createQuery() throws Exception {
        return new ADQLQuery();
    }

    public ADQLQuery createQuery(ADQLParser.ADQLVersion version) throws Exception {
        return new ADQLQuery(version);
    }

    public SetOperation createSetOperation(ADQLParser.ADQLVersion version, ADQLSet leftSet, SetOperationType operation, ADQLSet rightSet) throws Exception {
        return new SetOperation(version, leftSet, operation, rightSet);
    }

    public ADQLTable createTable(IdentifierItems idItems, IdentifierItems.IdentifierItem alias) throws Exception {
        ADQLTable t = new ADQLTable(idItems.getCatalog(), idItems.getSchema(), idItems.getTable());
        if (alias != null) {
            t.setAlias(alias.identifier);
        }
        byte caseSensitivity = idItems.getCaseSensitivity();
        if (alias != null) {
            caseSensitivity = IdentifierField.ALIAS.setCaseSensitive(caseSensitivity, alias.caseSensitivity);
        }
        t.setCaseSensitive(caseSensitivity);
        return t;
    }

    public ADQLTable createTable(ADQLSet query, IdentifierItems.IdentifierItem alias) throws Exception {
        ADQLTable t = new ADQLTable(query);
        if (alias != null) {
            t.setAlias(alias.identifier);
            t.setCaseSensitive(IdentifierField.ALIAS, alias.caseSensitivity);
        }
        return t;
    }

    public ADQLJoin createJoin(JoinType type, FromContent leftTable, FromContent rightTable) throws Exception {
        switch (type) {
            case CROSS: {
                return new CrossJoin(leftTable, rightTable);
            }
            case INNER: {
                return new InnerJoin(leftTable, rightTable);
            }
            case OUTER_LEFT: {
                return new OuterJoin(leftTable, rightTable, OuterJoin.OuterType.LEFT);
            }
            case OUTER_RIGHT: {
                return new OuterJoin(leftTable, rightTable, OuterJoin.OuterType.RIGHT);
            }
            case OUTER_FULL: {
                return new OuterJoin(leftTable, rightTable, OuterJoin.OuterType.FULL);
            }
        }
        throw new Exception("Unknown join type: " + (Object)((Object)type));
    }

    public ADQLJoin createJoin(JoinType type, FromContent leftTable, FromContent rightTable, ClauseConstraints condition) throws Exception {
        switch (type) {
            case CROSS: {
                throw new Exception("A cross join must have no condition (that's to say: no part ON) !");
            }
        }
        ADQLJoin join = this.createJoin(type, leftTable, rightTable);
        join.setJoinCondition(condition);
        return join;
    }

    public ADQLJoin createJoin(JoinType type, FromContent leftTable, FromContent rightTable, Collection<ADQLColumn> lstColumns) throws Exception {
        switch (type) {
            case CROSS: {
                throw new Exception("A cross join must have no columns list (that's to say: no part USING) !");
            }
        }
        ADQLJoin join = this.createJoin(type, leftTable, rightTable);
        join.setJoinedColumns(lstColumns);
        return join;
    }

    public WithItem createWithItem(IdentifierItems.IdentifierItem queryLabel, ADQLSet query) throws Exception {
        WithItem item = new WithItem(queryLabel.identifier, query);
        item.setLabelCaseSensitive(queryLabel.caseSensitivity);
        return item;
    }

    public SelectItem createSelectItem(ADQLOperand operand, String alias) throws Exception {
        return new SelectItem(operand, alias);
    }

    public ADQLColumn createColumn(IdentifierItems idItems) throws Exception {
        ADQLColumn col = new ADQLColumn(idItems.getCatalog(), idItems.getSchema(), idItems.getTable(), idItems.getColumn());
        col.setCaseSensitive(idItems.getCaseSensitivity());
        col.setPosition(idItems.getPosition());
        return col;
    }

    public ADQLColumn createColumn(IdentifierItems.IdentifierItem columnName) throws Exception {
        ADQLColumn col = new ADQLColumn(null, null, null, columnName.identifier);
        col.setCaseSensitive(IdentifierField.COLUMN, columnName.caseSensitivity);
        col.setPosition(columnName.position);
        return col;
    }

    public NumericConstant createNumericConstant(String value) throws Exception {
        return new NumericConstant(value, true);
    }

    public StringConstant createStringConstant(String value) throws Exception {
        return new StringConstant(value);
    }

    public Operation createOperation(ADQLOperand leftOp, OperationType op, ADQLOperand rightOp) throws Exception {
        return new Operation(leftOp, op, rightOp);
    }

    public NegativeOperand createNegativeOperand(ADQLOperand opToNegativate) throws Exception {
        return new NegativeOperand(opToNegativate);
    }

    public Concatenation createConcatenation() throws Exception {
        return new Concatenation();
    }

    public WrappedOperand createWrappedOperand(ADQLOperand opToWrap) throws Exception {
        return new WrappedOperand(opToWrap);
    }

    public ConstraintsGroup createGroupOfConstraints() throws Exception {
        return new ConstraintsGroup();
    }

    public NotConstraint createNot(ADQLConstraint constraintToNot) throws Exception {
        return new NotConstraint(constraintToNot);
    }

    public Comparison createComparison(ADQLOperand leftOp, ComparisonOperator op, ADQLOperand rightOp) throws Exception {
        return new Comparison(leftOp, op, rightOp);
    }

    public Between createBetween(boolean not, ADQLOperand value, ADQLOperand min, ADQLOperand max) throws Exception {
        return new Between(value, min, max, not);
    }

    public IsNull createIsNull(boolean notNull, ADQLColumn column) throws Exception {
        return new IsNull(column, notNull);
    }

    public Exists createExists(ADQLSet query) throws Exception {
        return new Exists(query);
    }

    public In createIn(ADQLOperand leftOp, ADQLSet query, boolean notIn) throws Exception {
        return new In(leftOp, query, notIn);
    }

    public In createIn(ADQLOperand leftOp, ADQLOperand[] valuesList, boolean notIn) throws Exception {
        return new In(leftOp, valuesList, notIn);
    }

    public SQLFunction createSQLFunction(SQLFunctionType type, ADQLOperand op, boolean distinctValues) throws Exception {
        return new SQLFunction(type, op, distinctValues);
    }

    public LowerFunction createLowerFunction(ADQLOperand op) throws Exception {
        return new LowerFunction(op);
    }

    public UpperFunction createUpperFunction(ADQLOperand op) throws Exception {
        return new UpperFunction(op);
    }

    public MathFunction createMathFunction(MathFunctionType type, ADQLOperand param1, ADQLOperand param2) throws Exception {
        return new MathFunction(type, param1, param2);
    }

    public InUnitFunction createInUnitFunction(ADQLOperand value, ADQLOperand targetUnit) throws Exception {
        return new InUnitFunction(value, targetUnit);
    }

    public UserDefinedFunction createUserDefinedFunction(String name, ADQLOperand[] params) throws Exception {
        return new UserDefinedFunction(name, params);
    }

    @Deprecated
    public DistanceFunction createDistance(PointFunction point1, PointFunction point2) throws Exception {
        return this.createDistance((GeometryFunction)point1, (GeometryFunction)point2);
    }

    public DistanceFunction createDistance(GeometryFunction point1, GeometryFunction point2) throws Exception {
        return new DistanceFunction(new GeometryFunction.GeometryValue<GeometryFunction>(point1), new GeometryFunction.GeometryValue<GeometryFunction>(point2));
    }

    public DistanceFunction createDistance(GeometryFunction.GeometryValue<GeometryFunction> point1, GeometryFunction.GeometryValue<GeometryFunction> point2) throws Exception {
        return new DistanceFunction(point1, point2);
    }

    public PointFunction createPoint(ADQLOperand coordSys, ADQLOperand coords, ADQLOperand coords2) throws Exception {
        return new PointFunction(coordSys, coords, coords2);
    }

    public BoxFunction createBox(ADQLOperand coordinateSystem, ADQLOperand firstCoord, ADQLOperand secondCoord, ADQLOperand boxWidth, ADQLOperand boxHeight) throws Exception {
        return new BoxFunction(coordinateSystem, firstCoord, secondCoord, boxWidth, boxHeight);
    }

    public BoxFunction createBox(ADQLOperand coordinateSystem, GeometryFunction.GeometryValue<GeometryFunction> center, ADQLOperand boxWidth, ADQLOperand boxHeight) throws Exception {
        return new BoxFunction(coordinateSystem, center, boxWidth, boxHeight);
    }

    public CircleFunction createCircle(ADQLOperand coordSys, ADQLOperand coord1, ADQLOperand coord2, ADQLOperand radius) throws Exception {
        return new CircleFunction(coordSys, coord1, coord2, radius);
    }

    public CircleFunction createCircle(ADQLOperand coordSys, GeometryFunction.GeometryValue<GeometryFunction> center, ADQLOperand radius) throws Exception {
        return new CircleFunction(coordSys, center, radius);
    }

    public CentroidFunction createCentroid(GeometryFunction param) throws Exception {
        return new CentroidFunction(new GeometryFunction.GeometryValue<GeometryFunction>(param));
    }

    public CentroidFunction createCentroid(GeometryFunction.GeometryValue<GeometryFunction> param) throws Exception {
        return new CentroidFunction(param);
    }

    public RegionFunction createRegion(ADQLOperand param) throws Exception {
        return new RegionFunction(param);
    }

    public PolygonFunction createPolygon(ADQLOperand coordSys, Collection<? extends ADQLOperand> coords) throws Exception {
        return new PolygonFunction(coordSys, coords);
    }

    public AreaFunction createArea(GeometryFunction param) throws Exception {
        return new AreaFunction(new GeometryFunction.GeometryValue<GeometryFunction>(param));
    }

    public AreaFunction createArea(GeometryFunction.GeometryValue<GeometryFunction> param) throws Exception {
        return new AreaFunction(param);
    }

    public ExtractCoord createCoord1(PointFunction point) throws Exception {
        return new ExtractCoord(1, new GeometryFunction.GeometryValue<PointFunction>(point));
    }

    public ExtractCoord createCoord1(ADQLColumn point) throws Exception {
        return new ExtractCoord(1, new GeometryFunction.GeometryValue<PointFunction>(point));
    }

    public ExtractCoord createCoord2(PointFunction point) throws Exception {
        return new ExtractCoord(2, new GeometryFunction.GeometryValue<PointFunction>(point));
    }

    public ExtractCoord createCoord2(ADQLColumn point) throws Exception {
        return new ExtractCoord(2, new GeometryFunction.GeometryValue<PointFunction>(point));
    }

    public ExtractCoordSys createExtractCoordSys(GeometryFunction param) throws Exception {
        return new ExtractCoordSys(new GeometryFunction.GeometryValue<GeometryFunction>(param));
    }

    public ExtractCoordSys createExtractCoordSys(ADQLColumn param) throws Exception {
        return new ExtractCoordSys(new GeometryFunction.GeometryValue<GeometryFunction>(param));
    }

    public ExtractCoordSys createExtractCoordSys(GeometryFunction.GeometryValue<GeometryFunction> param) throws Exception {
        return new ExtractCoordSys(new GeometryFunction.GeometryValue<GeometryFunction>(param));
    }

    public ContainsFunction createContains(GeometryFunction left, GeometryFunction right) throws Exception {
        return new ContainsFunction(new GeometryFunction.GeometryValue<GeometryFunction>(left), new GeometryFunction.GeometryValue<GeometryFunction>(right));
    }

    public ContainsFunction createContains(GeometryFunction.GeometryValue<GeometryFunction> left, GeometryFunction.GeometryValue<GeometryFunction> right) throws Exception {
        return new ContainsFunction(left, right);
    }

    public IntersectsFunction createIntersects(GeometryFunction left, GeometryFunction right) throws Exception {
        return new IntersectsFunction(new GeometryFunction.GeometryValue<GeometryFunction>(left), new GeometryFunction.GeometryValue<GeometryFunction>(right));
    }

    public IntersectsFunction createIntersects(GeometryFunction.GeometryValue<GeometryFunction> left, GeometryFunction.GeometryValue<GeometryFunction> right) throws Exception {
        return new IntersectsFunction(left, right);
    }

    public ADQLOrder createOrder(int ind, boolean desc) throws Exception {
        return new ADQLOrder(ind, desc);
    }

    @Deprecated
    public ADQLOrder createOrder(int ind, boolean desc, TextPosition position) throws Exception {
        ADQLOrder order = new ADQLOrder(ind, desc);
        order.setPosition(position);
        return order;
    }

    @Deprecated
    public ADQLOrder createOrder(IdentifierItems.IdentifierItem colName, boolean desc) throws Exception {
        ADQLOrder order = new ADQLOrder(colName.identifier, desc);
        ((ADQLColumn)order.getExpression()).setCaseSensitive(colName.caseSensitivity);
        ((ADQLColumn)order.getExpression()).setPosition(colName.position);
        return order;
    }

    public ADQLOrder createOrder(ADQLOperand expr, boolean desc) throws Exception {
        return new ADQLOrder(expr, desc);
    }

    @Deprecated
    public ADQLOrder createOrder(IdentifierItems idItems, boolean desc) throws Exception {
        ADQLOrder order = new ADQLOrder(idItems.join("."), desc);
        order.getColumnReference().setCaseSensitive(idItems.getColumnCaseSensitivity());
        order.getColumnReference().setPosition(idItems.getPosition());
        return order;
    }

    public ColumnReference createColRef(int index, TextPosition position) throws Exception {
        ColumnReference colRef = new ColumnReference(index);
        colRef.setPosition(position);
        return colRef;
    }

    public ClauseOffset createOffset(int offsetValue) throws Exception {
        return new ClauseOffset(offsetValue);
    }

    public CastFunction createCastFunction(ADQLOperand value, TargetType type) throws Exception {
        return new CastFunction(value, type);
    }

    public CoalesceFunction createCoalesceFunction(Collection<ADQLOperand> operands) throws Exception {
        return new CoalesceFunction(operands);
    }

    public NullValue createNullValue() {
        return new NullValue();
    }

    public static enum JoinType {
        CROSS,
        INNER,
        OUTER_LEFT,
        OUTER_RIGHT,
        OUTER_FULL;

    }
}

