
#include <Arduino.h>

#include "rgbled.h"
extern RGBLED rgbLed;

#include "fade.h"
Fade fade;

byte current_fade_reg = 0;
byte fade_start = 0;
byte fade_end = 0;

void
fadeTo( int secs, byte r, byte g, byte b, byte w, byte w2 )
{
  fade.start = fade.last_notify = millis();

  fade.duration = 1000UL * secs;
  fade.notify_timeout = max(fade.duration/10,500);
  if( fade.notify_timeout > 1000UL * 10 )
    fade.notify_timeout = 1000UL * 10;

 fade.to[0] = r;
 fade.to[1] = g;
 fade.to[2] = b;
 fade.to[3] = w;
 fade.to[4] = w2;

  const byte *levels = rgbLed.getColors();
  for( byte i = 0; i < sizeof(fade.to); ++i )
    fade.diff[i] = fade.to[i] - levels[i];
}
