
// TODO: config register with pin mappings (readonly?)
//       send dmx rf message only after min intervall
//       make dmx base addr configurable
//       send brighness immediately if changed
//       configurable ramp times
//       virtual channels


#include "config.h"

//#define SERIAL_DEBUG

#ifdef SERIAL_DEBUG
# undef ENABLE_DMX
#endif

#include <panstamp.h>
//#include "digitalWriteFast.h"

#include "regtable.h"
#include "rgbled.h"

#define LED_PIN    4

#ifdef ENABLE_IR_RECV
# include <IRremote.h>
# define IR_RECV_PIN  A0
  IRrecv irrecv(IR_RECV_PIN);
  decode_results results;
#endif

# define IR_SEND_PIN  3
#ifdef ENABLE_IR_SEND
  IRsend irsend;
  byte ir_send_type = 0;
  unsigned long ir_send_value = 0;
#endif

#ifdef ENABLE_REPEATER
  byte maxRepeaterHop = 0;
#endif

#ifdef ENABLE_DMX
# include <DMXSerial.h>
#endif

// Global RGBLED object. Define your own PWM outputs here:
#ifdef ENABLE_IR_SEND | ENABLE_IR_RECEIVE
# ifdef USE_SOFT_PWM
#  ifdef ENABLE_IR_SEND
  RGBLED rgbLed = RGBLED(9, 6, 5, 8);
#  else
  RGBLED rgbLed = RGBLED(9, 6, 5, 3);
#  endif
# else
#  ifdef ENABLE_IR_SEND
  RGBLED rgbLed = RGBLED(9, 6, 5);
#  else
  RGBLED rgbLed = RGBLED(9, 6, 5, 3);
#  endif
# endif
#else
  RGBLED rgbLed = RGBLED(9, 6, 5, 3);
#endif

#include "eeprom.h"
irCmd ir_cmds[0x10];
fadeStep fade_steps[0x10];

void
getConfig()
{
  // get power on state
  for( byte i= 0; i < regTable[REGI_POWER_ON_STATE]->length; ++i )
    regTable[REGI_POWER_ON_STATE]->value[i] = EEPROM.read(EEPROM_POWER_ON_STATE + i);
  if( regTable[REGI_POWER_ON_STATE]->value[0] == 0xFF )
    regTable[REGI_POWER_ON_STATE]->value[0] = 0x30 | SOFT_POWER_ON_STATE_AUTOSAVE | HARD_POWER_ON_STATE_AUTOSAVE;

#ifdef ENABLE_REPEATER
  // get maxRepeaterHop
  maxRepeaterHop = EEPROM.read(EEPROM_CONFIG_REPEATER);
  if( maxRepeaterHop == 0xFF ) maxRepeaterHop = 0;
#endif

  // get ir commands
  for( byte i= 0; i < sizeof(ir_cmds); ++i )
    ((byte*)ir_cmds)[i] = EEPROM.read(EEPROM_CONFIG_IR + i);

  // get fade steps
  for( byte i= 0; i < sizeof(fade_steps); ++i )
    ((byte*)fade_steps)[i] = EEPROM.read(EEPROM_CONFIG_FADE + i);

#ifdef ENABLE_DMX
  regTable[REGI_DMX]->value[0] = EEPROM.read(EEPROM_CONFIG_DMX);
  if( regTable[REGI_DMX]->value[0] == 0xFF )
    regTable[REGI_DMX]->value[0] = 1;
#endif
}

/**
 * setup
 *
 * One-time setup function
 */
static unsigned long autosavetimeout;
void setup()
{
#if 0
  eepromToFactoryDefaults();
  EEPROM.write(EEPROM_DEVICE_ADDR, 0xCC);
#endif

  pinMode(LED_PIN, OUTPUT);
  digitalWrite(LED_PIN, HIGH);

  // just to be save
  pinMode(IR_SEND_PIN, OUTPUT);
  digitalWrite(IR_SEND_PIN, LOW);

#ifdef SERIAL_DEBUG
  Serial.begin(115200);
#endif

  getConfig();

  // Init panStamp
  panstamp.init();

#ifdef ENABLE_REPEATER
  // Initialize repeater
  if( maxRepeaterHop ) panstamp.enableRepeater(maxRepeaterHop);
#endif

  //bitSet(TCCR1B, WGM12); // fast pwm for timer1 also

  byte r,g,b,w; r = g = b = w = 0;
  switch( regTable[REGI_POWER_ON_STATE]->value[0] & _HARD_POWER_ON_MASK )
    {
      case HARD_POWER_ON_SATE_OFF:
        break;
      case HARD_POWER_ON_STATE_COLOR:
      case HARD_POWER_ON_STATE_AUTOSAVE:
        r = regTable[REGI_POWER_ON_STATE]->value[1];
        g = regTable[REGI_POWER_ON_STATE]->value[2];
        b = regTable[REGI_POWER_ON_STATE]->value[3];
        w = regTable[REGI_POWER_ON_STATE]->value[4];
#if 0
        if( r == 0 && g == 0 && b == 0 && w == 0 )
          r = g = b = w = 255;
#endif
        break;
      default:
        break;
    }

  rgbLed.begin( 60 );
  rgbLed.setColor( r, g, b, w );

  // Broadcast product status
  getRegister(REGI_PRODUCTCODE)->getData();

  panstamp.enterSystemState(SYSTATE_RXON);

  getRegister(REGI_RGBLEVELS)->getData();

#ifdef ENABLE_IR_RECV
  irrecv.enableIRIn(); // Start the receiver
  //irrecv.setIsr(rgbLed.begin( 60 ));
#endif

#ifdef ENABLE_DMX
  DMXSerial.init(DMXReceiver);

  // set some default values
  DMXSerial.write(regTable[REGI_DMX]->value[0], 0);
  DMXSerial.write(regTable[REGI_DMX]->value[0]+1, 0);
  DMXSerial.write(regTable[REGI_DMX]->value[0]+2, 0);
  DMXSerial.write(regTable[REGI_DMX]->value[0]+3, 0);
#endif

#ifdef ENABLE_BRIGHTNESS
#endif

  autosavetimeout = 1000 * 10 * ( regTable[REGI_POWER_ON_STATE]->value[0] & _AUTOSAVE_TIMEOUT_MASK >> 4 );
  if( autosavetimeout < 100 ) autosavetimeout = 100;

  digitalWrite(LED_PIN, LOW);

  //setBlink( 500 );
}

enum { IR_CMD_ON = 0x807FE11E,
       IR_CMD_OFF = 0x807F619E,
       IR_CMD_UP = 0x807FA15E,
       IR_CMD_DOWN = 0x807F21DE,
       IR_CMD_RED = 0x807F916E,
       IR_CMD_GREEN = 0x807F11EE,
       IR_CMD_BLUE = 0x807F51AE,
       IR_CMD_WHITE = 0x807FD12E,
};

#include "commands.h"

/**
 * loop
 *
 * Main loop
 */
#define TIMER_OFF ~0L
byte current_ir_reg = 0;
byte learn_ir = 0;

byte last_ir_type = 0;
unsigned long last_ir_value = 0;

static unsigned long blink = 0;
void setBlink( int intervall )
{
  if( !intervall )
    digitalWrite(4, rgbLed.isOff()?LOW:HIGH);

  blink = intervall;
}

#include "fade.h"

bool
isTime(unsigned long &timeMark, unsigned long timeInterval)
{
  if( millis() - timeMark >= timeInterval )
    {
      timeMark = millis();
      return true;
    }

  return false;
}
void loop()
{
#if 1
  static unsigned long last_eeprom_time = millis();
  if( regTable[REGI_POWER_ON_STATE]->value[0] & _HARD_POWER_ON_MASK == HARD_POWER_ON_STATE_AUTOSAVE
      && !isFading()                                       // if not fading
      && rgbLed.timestamp() > last_eeprom_time             // and color has changed
      && millis() - rgbLed.timestamp() > autosavetimeout ) // not less than autosavetimeout ago
    {
      if( !rgbLed.isOff() ) {
#if 1
        const byte *levels = rgbLed.getColors();

        for( byte i= 0; i < 4; ++i )
          {
            regTable[REGI_POWER_ON_STATE]->value[1+i] = levels[i];
            EEPROM.write(EEPROM_POWER_ON_STATE + 1 + i, levels[i]);
          }
#endif

#if 1
      digitalWrite(LED_PIN, !digitalRead(LED_PIN));   // flash led
      delay(500);
      digitalWrite(LED_PIN, !digitalRead(LED_PIN));
#endif

        getRegister(REGI_POWER_ON_STATE)->getData();
      }

      last_eeprom_time = millis();
    }
#endif

#ifdef ENABLE_IR_RECV
  if( irrecv.decode(&results) ) {
    static unsigned long last_ir_time = 0;

#if 0
      digitalWrite(LED_PIN, !digitalRead(LED_PIN));   // flash led
      delay(500);
      digitalWrite(LED_PIN, !digitalRead(LED_PIN));
#endif

    if( results.decode_type == NEC
        && results.value == 0xFFFFFFFF )
      results.value = last_ir_value;

    if( millis() - last_ir_time > 500
        || results.value != last_ir_value
        || results.decode_type != last_ir_type )
      {
        last_ir_value = results.value;
        last_ir_type = results.decode_type;

        if( learn_ir == 3 )
          {
            ir_cmds[current_ir_reg].ir_cmd = last_ir_value;
            for( byte i = sizeof(irCmd)*current_ir_reg; i < sizeof(irCmd)*(current_ir_reg+1); ++i )
              EEPROM.write(EEPROM_CONFIG_IR+i, ((byte*)ir_cmds)[i]);
            byte data[10];
            data[0] = CMD_GetIR;
            data[1] = current_ir_reg;
            copySwapped4( (byte *)&(ir_cmds[current_ir_reg].ir_cmd), data+2 );
            setCommand( REGI_COMMAND, data );
            getRegister(REGI_COMMAND)->getData();
            setCommand( REGI_COMMAND, ir_cmds[current_ir_reg].cmd );
            getRegister(REGI_COMMAND)->getData();
            learn_ir = 0;
            setBlink(0);
            last_ir_time = millis();            // slow repeat
          }
        else
          {
            bool found = false;
            for( byte i = 0; i < 0xf; ++i )
              {
                if( ir_cmds[i].cmd[0] != 0xFF
                    && ir_cmds[i].ir_cmd == last_ir_value )
                  {
                    found = true;
                    last_ir_time = millis()-250;            // medium repeat
                    setCommand( REGI_COMMAND, ir_cmds[i].cmd );
                  }
              }

#if 1
            if( !found ) {
              last_ir_time = millis();            // slow repeat
              getRegister(REGI_IR_RECV)->getData();
            }

#else
            if( !found )
              {
                byte rId = REGI_RGBLEVELS;
                switch( last_ir_value )
                  {
                    case IR_CMD_ON:
                      fadeStop();
                      if( rgbLed.isOff() )
                        switch( regTable[REGI_POWER_ON_STATE]->value[0] & _HARD_POWER_ON_MASK )
                          {
                            case HARD_POWER_ON_STATE_COLOR:
                            case HARD_POWER_ON_STATE_AUTOSAVE:
                              rgbLed.setColor( regTable[REGI_POWER_ON_STATE]->value[1],  regTable[REGI_POWER_ON_STATE]->value[2],  regTable[REGI_POWER_ON_STATE]->value[3], regTable[REGI_POWER_ON_STATE]->value[4] );
                              break;
                            default:
                              rgbLed.setColor( 255, 255, 255, 255 );
                              break;
                         }
                      else
                        rgbLed.setColor( 255, 255, 255 );
                      break;
                    case IR_CMD_OFF:
                      //rgbLed.setColor( 0, 0, 0 );
                      fadeTo( 1, 0, 0, 0 );
                      break;
                    case IR_CMD_UP:
                      fadeStop();
                      rgbLed.dimUp();
                      break;
                    case IR_CMD_DOWN:
                      fadeStop();
                      rgbLed.dimDown();
                      break;
                    case IR_CMD_RED:
                      //rgbLed.setColor( 255, 0, 0 );
                      fadeTo( 1, 255, 0, 0 );
                      break;
                    case IR_CMD_GREEN:
                      //rgbLed.setColor( 0, 255, 0 );
                      fadeTo( 1, 0, 255, 0 );
                      break;
                    case IR_CMD_BLUE:
                      //rgbLed.setColor( 0, 0, 255 );
                      fadeTo( 1, 0, 0, 255 );
                      break;
                    case IR_CMD_WHITE:
                      //rgbLed.setColor( 255, 255, 255 );
                      fadeTo( 1, 255, 255, 255 );
                      break;
                    default:
                      rId = REGI_IR_RECV;
                  }

                getRegister(rId)->getData();

                if( last_ir_value == IR_CMD_UP
                    || last_ir_value == IR_CMD_DOWN )
                  last_ir_time = millis() - 300;      // fast repeat
                else if( rId == REGI_IR_RECV )
                  last_ir_time = millis();            // slow repeat
                else
                  last_ir_time = millis() - 250;      // medium repeat
              }
#endif
          }
      }

    irrecv.resume(); // Receive the next value
  }
#endif

#ifdef ENABLE_IR_SEND
  if( ir_send_type )
    {
      switch( ir_send_type ) {
        case NEC:
          irsend.sendNEC(ir_send_value, sizeof(ir_send_value)*8);
          break;
        case SONY:
          irsend.sendSony(ir_send_value, sizeof(ir_send_value)*8);
          break;
      }

      ir_send_type = 0;
      irrecv.enableIRIn();
    }
#endif

  // current fade
  if( millis() > fade.start )
    {
      byte l[sizeof(fade.to)];

      for( byte i = 0; i < sizeof(fade.to); ++i )
        l[i] = fade.to[i];

      if( millis() >= fade.start+fade.duration )
        fadeStop();
      else
        {
          float d0 = millis() - fade.start;
          float d = 1 - d0/fade.duration;

          if( d == 0 )
            fadeStop();
          else
            {
              for( byte i = 0; i < sizeof(fade.to); ++i )
                l[i] -= fade.diff[i] * d;
            }
        }

      bool changed = false;
      const byte *levels = rgbLed.getColors();
      for( byte i = 0; i < sizeof(fade.to); ++i )
        if( l[i] != levels[i] )
          {
            changed = true;
            rgbLed.setColor( l );
            break;
          }

      if( !isFading() )
        getRegister(REGI_RGBLEVELS)->getData();
      else if( changed
               && (!inFade() || fade.notify_timeout > 5000 )
               && isTime(fade.last_notify, fade.notify_timeout) )
        getRegister(REGI_RGBLEVELS)->getData();
    }

  //next fade step
  if( fade_start != fade_end
      && millis() > fade.start + 1000UL * fade_steps[current_fade_reg].secs )
    {
      current_fade_reg++;
      if( current_fade_reg > fade_end )
        current_fade_reg = fade_start;
      fadeTo(fade_steps[current_fade_reg].secs, fade_steps[current_fade_reg].rgb[0],fade_steps[current_fade_reg].rgb[1],fade_steps[current_fade_reg].rgb[2]);
    }

#ifdef ENABLE_DMX
  static bool startup = true;
  static byte dmx_old[sizeof(fade.to)];
  if( DMXSerial.noDataSince() < 5000 ) {
    bool changed = false;
    byte dmx[sizeof(fade.to)];
    for( byte i = 0; i < sizeof(fade.to); ++i ) {
      dmx[i] = DMXSerial.read(regTable[REGI_DMX]->value[0]+i);
      if( dmx[i] != dmx_old[i] ) {
          changed = true;
          dmx_old[i] = dmx[i];
      }
    }

    if( changed
        && !startup ) { // ignore dmx touch pannel after power on
#if 0
      const byte *levels = rgbLed.getColors();
      for( byte i = 0; i < sizeof(fade.to); ++i )
        if( dmx[i] != levels[i] ) {
          rgbLed.setColor( dmx );
          getRegister(REGI_RGBLEVELS)->getData();
          break;
        }
#else
      rgbLed.setColor( dmx );
      getRegister(REGI_RGBLEVELS)->getData();
#endif
    }
  }
  if( millis() > 1000*3 ) startup = false;
#endif

  static unsigned long last_tx_time = millis();
  unsigned int interval = panstamp.txInterval[0] << 8 | panstamp.txInterval[1];
  //unsigned int interval = panstamp.txInterval;
  if( isTime(last_tx_time, 1000UL * interval) )
    {
      getRegister(REGI_RGBLEVELS)->getData();
      getRegister(REGI_INTERNALTEMP)->getData();
#ifdef ENABLE_BRIGHTNESS
      getRegister(REGI_BRIGHTNESS)->getData();
#endif
    }

  static unsigned long last_blink_time;
  if( blink
      && isTime(last_blink_time, blink) )
    digitalWrite(LED_PIN, !digitalRead(LED_PIN));   // flash led
}
