#include "JeeLink.h"

JeeLink::JeeLink(bool enableLED) {
  m_ledEnabled = enableLED;
}

void JeeLink::SwitchLed(boolean on) {
	byte LED_PIN = 9;
	pinMode(LED_PIN, OUTPUT);
	digitalWrite(LED_PIN, !on);
}

void JeeLink::Blink(byte ct) {
  if (!m_ledEnabled)
	  return;

    for (int i = 0; i < (ct > 5 ? 5 : ct); i++) {
      SwitchLed(true);
      delay(2);
      SwitchLed(false);
    }
}

void JeeLink::EnableLED(bool enabled) {
  m_ledEnabled = enabled;

  if (!m_ledEnabled)
    SwitchLed(false);
}

bool JeeLink::isLEDEnabled() {
	return m_ledEnabled;
}
