;;; collatz problem

#|
Usage 
(load "./example/collatz.lsp")
> (collatz 87391)
87391->262174->131087->393262->196631->589894->294947->884842->442421->1327264->663632->
331816->165908->82954->41477->124432->62216->31108->15554->7777->23332->11666->5833->
17500->8750->4375->13126->6563->19690->9845->29536->14768->7384->3692->1846->923->2770->
1385->4156->2078->1039->3118->1559->4678->2339->7018->3509->10528->5264->2632->1316->
658->329->988->494->247->742->371->1114->557->1672->836->418->209->628->
314->157->472->236->118->59->178->89->268->134->67->202->101->304->152->
76->38->19->58->29->88->44->22->11->34->17->52->26->
13->40->20->10->5->16->8->4->2->1->T
> 

|#

(defun collatz (n)
    (format (standard-output) "~D->" n)
    (cond ((= n 1) t)
          ((= (mod n 2) 0) (collatz (div n 2)))
          (t (collatz (+ (* 3 n) 1)))))