/*
 * exec: A plugin for the Video Disk Recorder
 * Copyright (C) 2007  Winfried Koehler
 * Licence GPL
 *
 * See the README file for copyright information and how to reach the author.
 *
 *
 * SUPPORT FOR OLD VDR VERSIONS < 1.5.7
 *
 * $Id$
 */

#include <vdr/plugin.h>
#include "compat.h"
#if VDRVERSNUM > 10500
#include <vdr/shutdown.h>
#endif
#include <linux/unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <ctype.h>
#include "menu.h"

//***************** systemexec *************************************
int systemexec(const char *Command, bool Detached) {
  // systemexec is the function "SystemExec" from vdr >= 1.5.1, thread.c
  // copyright see VDR's Copyright (kls and others).
  //
  pid_t pid;

  if ((pid = fork()) < 0) { // fork failed
     LOG_ERROR;
     return -1;
     }
  if (pid > 0) { // parent process
     int status = 0;
     if (waitpid(pid, &status, 0) < 0) {
        LOG_ERROR;
        return -1;
        }
     return status;
     }
  else { // child process
     if (Detached) {
        if (fork() > 0)
           exit(0);
        pid_t sid = setsid();
        if (sid < 0)
           LOG_ERROR;
        int devnull = open("/dev/null", O_RDONLY);
        if (devnull < 0 || dup2(devnull, 0) < 0)
           LOG_ERROR;
        }
     int MaxPossibleFileDescriptors = getdtablesize();
     for (int i = STDERR_FILENO + 1; i < MaxPossibleFileDescriptors; i++)
         close(i); //close all dup'ed filedescriptors
     if (execl("/bin/sh", "sh", "-c", Command, NULL) == -1) {
        LOG_ERROR_STR(Command);
        _exit(-1);
        }
     _exit(0);
     }
}

//***************** systemexec *************************************


//***************** SystemExec *************************************

int SysExec(const char *Command, bool Detached) {

cPipe pipe;
char * buf;
char res[1024]; /* have to fix this later! Risk */

  memset(res,0,sizeof(res));
  asprintf(&buf, "%s; echo $?", Command);
  if(pipe.Open(buf,"r")) {  
    while (fscanf (pipe,"%s",res) != EOF) {
      /* searching for last arg only. */
      }
    }
  pipe.Close();
  free(buf);

  if (strlen(res) > 0 && strlen(res) < 4 && isdigit(res[0]))
    return atoi(res);
  else
    return -1; /* couldnt find result, should not happen. */
};

//***************** SystemExec *************************************


//***************** DoShutdown *************************************
bool DoShutdown(bool force) {
  if (systemexec("svdrpsend.pl hitk power", true) < 0) return false;
  return true;
};
//***************** DoShutdown *************************************

//***************** ProgramWakeup **********************************
#if VDRVERSNUM < 10501 //1.5.1 introduced cPlugin::WakeupTime
void WarnNoWakeup(void) {
  cExecTimer *et = ExecTimers.GetNextWakeupTimer();
  if (et)
    log(0, "exec Plugin: this vdr version doesnt support wakeup by plugins.\n"
           "Please upgrade to vdr-1.5.7 or higher.");
}
#endif
//***************** ProgramWakeup **********************************
