This textX example is based on the example from the [Martin
Fowler's](http://www.martinfowler.com/aboutMe.html) [book on
DSLs](http://www.martinfowler.com/books/dsl.html).

File `state_machine.tx` is the grammar of the language. State machine instances
are given in files `miss_grant_controller.sm` and  `gate.sm`.

`miss_grant_controller.sm` is the original example from Fowler's book.

`gate.sm` is a simple state machine model of a gate that unlocks by inserting
a coin and locks again when someone pass trough the gate.

Script `smdot.py` is an example of source code generator. Given a State Machine
model it will produce dot file which can be viewed by any dot viewer or
converted to some image format by `dot` tool.

For example:

    $ python smdot.py miss_grant_controller.sm
    $ dot -Tpng -O miss_grant_controller.sm.dot

Will create this diagram:

![Miss Grant'c Controller state diagram](https://raw.githubusercontent.com/textX/textX/master/examples/StateMachine/miss_grant_controller.sm.dot.png)

Script `state_machine.py` is model interpreter. You can run models by 
following commands:

    $ python state_machine.py miss_grant_controller.sm
    $ python state_machine.py gate.sm

Image for the meta-model is generated by the textx command and dot tool.

    $ textx generate state_machine.tx --target dot
    $ dot -Tpng -O state_machine.dot

![State Machine meta-model diagram](https://raw.githubusercontent.com/textX/textX/master/examples/StateMachine/state_machine.tx.dot.png)
