/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"key\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"matched\0"
	"materialized\0"
	"maxvalue\0"
	"merge\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parameter\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"pgpool\0"
	"placing\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	15,
	22,
	29,
	33,
	39,
	45,
	55,
	59,
	64,
	70,
	77,
	85,
	93,
	97,
	101,
	107,
	110,
	114,
	125,
	135,
	146,
	157,
	160,
	167,
	174,
	184,
	198,
	207,
	214,
	220,
	228,
	235,
	242,
	246,
	254,
	259,
	267,
	270,
	276,
	281,
	288,
	296,
	305,
	310,
	315,
	323,
	329,
	334,
	344,
	360,
	366,
	377,
	383,
	389,
	397,
	406,
	414,
	424,
	431,
	439,
	447,
	456,
	463,
	473,
	485,
	498,
	512,
	521,
	532,
	543,
	555,
	563,
	572,
	583,
	588,
	593,
	600,
	606,
	610,
	615,
	623,
	639,
	652,
	665,
	680,
	693,
	711,
	724,
	731,
	737,
	742,
	751,
	755,
	766,
	770,
	778,
	786,
	794,
	803,
	814,
	823,
	831,
	838,
	848,
	859,
	867,
	873,
	878,
	885,
	896,
	904,
	912,
	921,
	924,
	933,
	940,
	947,
	952,
	957,
	962,
	969,
	978,
	988,
	992,
	997,
	1004,
	1010,
	1017,
	1025,
	1035,
	1045,
	1053,
	1060,
	1068,
	1079,
	1089,
	1098,
	1106,
	1112,
	1119,
	1125,
	1132,
	1141,
	1147,
	1153,
	1163,
	1167,
	1173,
	1181,
	1189,
	1196,
	1201,
	1206,
	1215,
	1225,
	1235,
	1242,
	1248,
	1256,
	1265,
	1271,
	1280,
	1287,
	1295,
	1302,
	1309,
	1314,
	1319,
	1328,
	1331,
	1337,
	1347,
	1357,
	1366,
	1373,
	1376,
	1384,
	1394,
	1404,
	1410,
	1418,
	1426,
	1435,
	1445,
	1452,
	1458,
	1464,
	1470,
	1482,
	1489,
	1497,
	1501,
	1509,
	1519,
	1528,
	1533,
	1541,
	1544,
	1551,
	1561,
	1566,
	1570,
	1576,
	1585,
	1591,
	1596,
	1604,
	1612,
	1622,
	1628,
	1633,
	1639,
	1644,
	1650,
	1657,
	1662,
	1668,
	1678,
	1693,
	1702,
	1707,
	1714,
	1721,
	1729,
	1735,
	1743,
	1756,
	1765,
	1771,
	1778,
	1785,
	1794,
	1799,
	1805,
	1810,
	1815,
	1821,
	1830,
	1838,
	1844,
	1848,
	1853,
	1857,
	1861,
	1866,
	1871,
	1874,
	1879,
	1889,
	1900,
	1904,
	1912,
	1919,
	1927,
	1934,
	1939,
	1946,
	1952,
	1960,
	1967,
	1970,
	1974,
	1981,
	1986,
	1990,
	1993,
	1998,
	2007,
	2014,
	2022,
	2025,
	2031,
	2042,
	2049,
	2053,
	2059,
	2064,
	2073,
	2081,
	2092,
	2098,
	2104,
	2113,
	2123,
	2130,
	2138,
	2148,
	2156,
	2165,
	2172,
	2180,
	2186,
	2193,
	2202,
	2212,
	2222,
	2230,
	2239,
	2248,
	2256,
	2262,
	2273,
	2284,
	2294,
	2305,
	2313,
	2325,
	2331,
	2337,
	2342,
	2347,
	2356,
	2364,
	2374,
	2378,
	2389,
	2401,
	2409,
	2417,
	2426,
	2434,
	2441,
	2452,
	2460,
	2468,
	2474,
	2482,
	2491,
	2498,
	2508,
	2516,
	2523,
	2529,
	2534,
	2543,
	2550,
	2558,
	2567,
	2571,
	2576,
	2581,
	2591,
	2598,
	2606,
	2613,
	2620,
	2627,
	2636,
	2643,
	2652,
	2662,
	2675,
	2682,
	2690,
	2703,
	2707,
	2713,
	2718,
	2724,
	2729,
	2737,
	2744,
	2749,
	2758,
	2767,
	2772,
	2776,
	2783,
	2794,
	2800,
	2810,
	2821,
	2827,
	2834,
	2842,
	2849,
	2856,
	2862,
	2875,
	2885,
	2893,
	2903,
	2909,
	2916,
	2922,
	2929,
	2941,
	2952,
	2957,
	2966,
	2976,
	2981,
	2986,
	2991,
	2996,
	3006,
	3009,
	3018,
	3030,
	3040,
	3046,
	3054,
	3059,
	3064,
	3073,
	3081,
	3086,
	3092,
	3100,
	3110,
	3122,
	3134,
	3140,
	3147,
	3155,
	3164,
	3173,
	3179,
	3186,
	3191,
	3197,
	3204,
	3210,
	3219,
	3229,
	3235,
	3242,
	3250,
	3259,
	3267,
	3275,
	3283,
	3288,
	3294,
	3303,
	3308,
	3314,
	3325,
	3332,
	3337,
	3344,
	3352,
	3357,
	3365,
	3371,
	3375,
	3389,
	3399,
	3410,
	3420,
	3430,
	3444,
	3453,
	3459,
	3467,
	3480,
	3489,
	3494,
	3498,
};

#define SCANKEYWORDS_NUM_KEYWORDS 461

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[923] = {
		157,   32767, 32767, 243,   48,    32767, 496,   32767,
		22,    53,    -1048, -73,   -275,  0,     32767, 107,
		261,   145,   1287,  32767, 210,   65,    32767, 32767,
		266,   181,   -30,   280,   149,   32767, 382,   0,
		0,     32767, 0,     167,   11,    -89,   1417,  32767,
		141,   311,   22,    63,    0,     0,     296,   -153,
		0,     300,   15,    32767, 0,     32767, 32767, -788,
		164,   0,     196,   347,   32767, 0,     32767, -378,
		310,   32767, -314,  77,    32767, 32767, 359,   32767,
		129,   55,    98,    32767, 32767, 32767, 304,   32767,
		388,   149,   133,   -24,   32767, 32767, -48,   0,
		48,    -191,  73,    92,    156,   0,     32767, 32767,
		317,   403,   753,   103,   179,   19,    56,    0,
		69,    103,   32767, 32767, 32767, 190,   32767, 26,
		-235,  32767, -172,  58,    0,     -17,   32767, 1131,
		365,   32767, 425,   -1211, 304,   366,   207,   32767,
		405,   32767, 178,   32767, 0,     130,   0,     32767,
		-206,  196,   448,   32767, 0,     32767, 479,   32767,
		316,   32767, -75,   0,     32767, 252,   32767, 32767,
		0,     32767, 32767, 32767, -115,  394,   246,   -198,
		32767, 32767, 32767, 32767, 455,   88,    44,    223,
		165,   32767, 32767, 495,   194,   26,    -218,  0,
		1057,  137,   -220,  89,    32767, -432,  32767, 32767,
		32767, 124,   308,   451,   32767, 351,   214,   -62,
		0,     546,   362,   32767, 46,    -2,    32767, 32767,
		99,    221,   32767, 0,     85,    32767, 208,   429,
		-2,    432,   43,    21,    32767, 32767, 389,   315,
		444,   32767, 407,   266,   -93,   177,   76,    405,
		100,   -46,   322,   39,    321,   0,     -194,  -50,
		10,    -112,  -131,  228,   0,     -276,  32767, 184,
		146,   94,    91,    0,     233,   336,   32767, 458,
		32767, 32767, 206,   381,   0,     123,   41,    -633,
		-163,  32767, -63,   32767, 112,   32767, -216,  101,
		32767, 32767, 32767, 266,   -149,  0,     32767, 77,
		254,   32767, 32767, 234,   243,   110,   289,   68,
		32767, 0,     -179,  410,   -131,  -152,  1177,  32767,
		22,    75,    32767, 290,   0,     159,   32767, 32767,
		32767, -273,  177,   32767, 0,     402,   338,   384,
		32767, -75,   32767, 477,   32767, -10,   32767, 32767,
		32767, 32767, -318,  32767, 32767, 32767, 32767, 32767,
		170,   32767, -327,  32767, 32767, 310,   32767, 111,
		18,    32767, 338,   0,     -30,   368,   149,   76,
		32767, 0,     263,   32767, 32767, 133,   411,   32767,
		32767, 32767, 32767, -280,  -135,  32767, 32767, -12,
		32767, 1228,  -281,  185,   -825,  -423,  387,   32767,
		32767, -1,    0,     427,   27,    0,     220,   32767,
		-230,  32767, 81,    32767, 32767, -439,  32767, 32767,
		32767, 32767, -118,  32767, 32767, 32767, 32767, -766,
		-211,  32767, 411,   290,   32767, 32767, -373,  32767,
		32767, 132,   32767, 32767, 445,   32767, 0,     32767,
		440,   32767, 439,   10,    0,     33,    156,   -253,
		-40,   785,   153,   32767, 239,   32767, 89,    194,
		32767, 0,     -108,  192,   139,   217,   230,   60,
		32767, -40,   32767, 0,     41,    119,   32767, 32767,
		140,   0,     32767, 32767, 157,   32767, 32767, -192,
		32767, 32767, -633,  49,    164,   32767, 0,     0,
		32767, 535,   -163,  32767, 151,   134,   32767, 32767,
		79,    74,    364,   321,   0,     0,     0,     32767,
		349,   0,     -54,   -218,  -25,   420,   358,   32767,
		318,   149,   -310,  563,   32767, 375,   -59,   32767,
		32767, 32767, 32767, 32767, 0,     32767, 399,   -977,
		32767, 32767, -35,   32767, 446,   742,   32767, 341,
		32767, 468,   -73,   0,     -266,  123,   32767, 0,
		32767, -229,  0,     262,   -976,  348,   90,    -210,
		32767, 32767, 32767, 32767, 0,     0,     283,   0,
		299,   32767, -491,  0,     32767, -243,  0,     32767,
		445,   392,   0,     32767, 0,     0,     32767, 233,
		32767, 385,   32767, 32767, 32767, 32767, 32767, -575,
		-298,  107,   287,   83,    32767, 426,   32767, -47,
		280,   284,   -254,  32767, 21,    46,    32767, 95,
		32767, -2,    564,   32767, 573,   32767, 0,     0,
		102,   -209,  32767, -811,  267,   182,   -1040, 32767,
		0,     -970,  220,   323,   32767, 32767, 53,    -524,
		251,   302,   32767, 43,    0,     962,   32767, 121,
		1258,  -247,  322,   32767, 158,   0,     32767, 32767,
		221,   -170,  32767, 36,    -110,  32767, 374,   32767,
		32767, 0,     32767, 421,   1165,  188,   317,   488,
		32767, 32767, 0,     0,     32,    0,     408,   32767,
		32767, 0,     0,     393,   32767, 32767, 32767, 0,
		32767, 32767, -162,  32767, 32767, -433,  32767, 9,
		32767, -65,   32767, 32767, 32767, 257,   0,     26,
		32767, 53,    436,   32767, 32767, 32767, 0,     -307,
		32767, 417,   32767, 32767, 139,   32767, 222,   356,
		106,   -41,   0,     357,   297,   32767, 32767, 0,
		234,   32767, 0,     115,   0,     32767, -12,   32767,
		0,     219,   -189,  32767, 0,     32767, 32767, 51,
		32767, -55,   32767, 247,   452,   32767, 32767, 32767,
		-867,  -25,   -52,   1245,  32767, 0,     32767, 263,
		234,   237,   0,     104,   1315,  0,     99,    0,
		32767, 32767, 594,   32767, 1024,  -893,  32767, 32767,
		265,   32767, 0,     0,     0,     32767, 406,   32767,
		414,   32767, 0,     0,     32767, 32767, 32767, -733,
		363,   360,   32767, 32767, 169,   32767, 0,     0,
		32767, 32767, 440,   215,   32767, -118,  32767, 295,
		0,     32767, 184,   32767, 0,     0,     0,     32767,
		32767, 0,     32767, 0,     32767, 32767, 331,   32767,
		32767, 205,   32767, 0,     7,     32767, 0,     32767,
		0,     32767, 32767, 642,   32767, -187,  0,     -30,
		0,     32767, 122,   84,    32767, -103,  32767, 692,
		32767, 32767, 32767, 0,     32767, 213,   32767, 32767,
		361,   140,   162,   98,    367,   32767, 336,   32767,
		32767, 0,     285,   406,   32767, 56,    0,     32767,
		161,   32767, 32767, 440,   -984,  289,   0,     459,
		95,    237,   398,   32767, 32767, -2,    32767, 0,
		231,   32767, 32767, 32767, 379,   32767, 0,     11,
		0,     32767, 32767, 282,   286,   68,    32767, 70,
		32767, 32767, 32767, 166,   32767, -83,   32767, 32767,
		32767, 516,   32767, 335,   32767, 32767, -243,  -132,
		380,   258,   -735,  0,     32767, 169,   0,     32767,
		32767, 0,     32767, 272,   32767, 0,     -386,  150,
		0,     296,   32767, 201,   32767, 146,   359,   0,
		32767, 0,     747,   32767, 0,     32767, 0,     0,
		0,     32767, 32767, 203,   32767, 0,     337,   32767,
		0,     32767, -13,   316,   32767, 32767, 12,    15,
		0,     32767, -34,   32767, 0,     0,     0,     348,
		0,     32767, 78
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 31 + c;
	}
	return h[a % 923] + h[b % 923];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
