/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.commons.text.TextRandomProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomStringGeneratorTest {
    private static final CharacterPredicate A_FILTER = codePoint -> codePoint == 97;
    private static final CharacterPredicate B_FILTER = codePoint -> codePoint == 98;

    private static int codePointLength(String s) {
        return s.codePointCount(0, s.length());
    }

    @Test
    public void testBadMaximumCodePoint() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> RandomStringGenerator.builder().withinRange(0, 0x110000));
    }

    @Test
    public void testBadMinAndMax() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> RandomStringGenerator.builder().withinRange(2, 1));
    }

    @Test
    public void testBadMinimumCodePoint() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> RandomStringGenerator.builder().withinRange(-1, 1));
    }

    @Test
    public void testChangeOfFilter() {
        RandomStringGenerator.Builder builder = RandomStringGenerator.builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{A_FILTER});
        String str = builder.filteredBy(new CharacterPredicate[]{B_FILTER}).build().generate(100);
        for (char c : str.toCharArray()) {
            Assertions.assertEquals((char)'b', (char)c);
        }
    }

    @Test
    public void testGenerateMinMaxLength() {
        boolean minLength = false;
        int maxLength = 3;
        RandomStringGenerator generator = RandomStringGenerator.builder().build();
        String str = generator.generate(0, 3);
        int codePointLength = RandomStringGeneratorTest.codePointLength(str);
        Assertions.assertTrue((codePointLength >= 0 && codePointLength <= 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGenerateMinMaxLengthInvalidLength() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> {
            RandomStringGenerator generator = RandomStringGenerator.builder().build();
            generator.generate(-1, 0);
        });
    }

    @Test
    public void testGenerateMinMaxLengthMinGreaterThanMax() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> {
            RandomStringGenerator generator = RandomStringGenerator.builder().build();
            generator.generate(1, 0);
        });
    }

    @Test
    public void testGenerateTakingIntThrowsNullPointerException() {
        Assertions.assertThrowsExactly(NullPointerException.class, () -> {
            RandomStringGenerator.Builder randomStringGeneratorBuilder = RandomStringGenerator.builder();
            CharacterPredicate[] characterPredicateArray = new CharacterPredicate[2];
            randomStringGeneratorBuilder.filteredBy(characterPredicateArray);
            RandomStringGenerator randomStringGenerator = randomStringGeneratorBuilder.build();
            randomStringGenerator.generate(18);
        });
    }

    @Test
    public void testInvalidLength() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> RandomStringGenerator.builder().build().generate(-1));
    }

    @Test
    public void testMultipleFilters() {
        String str = RandomStringGenerator.builder().withinRange(97, 100).filteredBy(new CharacterPredicate[]{A_FILTER, B_FILTER}).build().generate(5000);
        boolean aFound = false;
        boolean bFound = false;
        for (char c : str.toCharArray()) {
            if (c == 'a') {
                aFound = true;
                continue;
            }
            if (c == 'b') {
                bFound = true;
                continue;
            }
            Assertions.fail((String)"Invalid character");
        }
        Assertions.assertTrue((aFound && bFound ? 1 : 0) != 0);
    }

    @Test
    public void testNoLoneSurrogates() {
        int length = 5000;
        String str = RandomStringGenerator.builder().build().generate(5000);
        char lastChar = str.charAt(0);
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLowSurrogate(c)) {
                Assertions.assertTrue((boolean)Character.isHighSurrogate(lastChar));
            }
            if (Character.isHighSurrogate(lastChar)) {
                Assertions.assertTrue((boolean)Character.isLowSurrogate(c));
            }
            if (Character.isHighSurrogate(c)) {
                Assertions.assertTrue((i + 1 < str.length() ? 1 : 0) != 0);
            }
            lastChar = c;
        }
    }

    @Test
    public void testNoPrivateCharacters() {
        int codePoint;
        int startOfPrivateBMPChars = 57344;
        String str = RandomStringGenerator.builder().withinRange(57344, 65535).build().generate(5000);
        int i = 0;
        do {
            Assertions.assertFalse((Character.getType(codePoint = str.codePointAt(i)) == 18 ? 1 : 0) != 0);
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test
    public void testRemoveFilters() {
        RandomStringGenerator.Builder builder = RandomStringGenerator.builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{A_FILTER});
        builder.filteredBy(new CharacterPredicate[0]);
        String str = builder.build().generate(100);
        for (char c : str.toCharArray()) {
            if (c == 'a') continue;
            return;
        }
        Assertions.fail((String)"Filter appears to have remained in place");
    }

    @Test
    public void testSelectFromCharArray() {
        String str = "abc";
        char[] charArray = "abc".toCharArray();
        RandomStringGenerator generator = RandomStringGenerator.builder().selectFrom(charArray).build();
        String randomText = generator.generate(5);
        for (char c : randomText.toCharArray()) {
            Assertions.assertTrue(("abc".indexOf(c) != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectFromCharVarargs() {
        String str = "abc";
        RandomStringGenerator generator = RandomStringGenerator.builder().selectFrom(new char[]{'a', 'b', 'c'}).build();
        String randomText = generator.generate(5);
        for (char c : randomText.toCharArray()) {
            Assertions.assertTrue(("abc".indexOf(c) != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectFromCharVarargs2() {
        String str = "abcde";
        RandomStringGenerator generator = RandomStringGenerator.builder().selectFrom(new char[0]).selectFrom(null).selectFrom(new char[]{'a', 'b'}).selectFrom(new char[]{'a', 'b', 'c'}).selectFrom(new char[]{'a', 'b', 'c', 'd'}).selectFrom(new char[]{'a', 'b', 'c', 'd', 'e'}).build();
        String randomText = generator.generate(10);
        for (char c : randomText.toCharArray()) {
            Assertions.assertTrue(("abcde".indexOf(c) != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectFromCharVarargSize1() {
        RandomStringGenerator generator = RandomStringGenerator.builder().selectFrom(new char[]{'a'}).build();
        String randomText = generator.generate(5);
        for (char c : randomText.toCharArray()) {
            Assertions.assertEquals((char)'a', (char)c);
        }
    }

    @Test
    public void testSelectFromEmptyCharVarargs() {
        RandomStringGenerator generator = RandomStringGenerator.builder().selectFrom(new char[0]).build();
        String randomText = generator.generate(5);
        for (char c : randomText.toCharArray()) {
            Assertions.assertTrue((c >= '\u0000' && c <= '\u10ffff' ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectFromNullCharVarargs() {
        int length = 5;
        RandomStringGenerator generator = RandomStringGenerator.builder().selectFrom(null).build();
        String randomText = generator.generate(5);
        Assertions.assertEquals((int)5, (int)RandomStringGeneratorTest.codePointLength(randomText));
        for (char c : randomText.toCharArray()) {
            Assertions.assertTrue((c >= '\u0000' && c <= '\u10ffff' ? 1 : 0) != 0);
        }
        RandomStringGenerator.Builder builder = RandomStringGenerator.builder().selectFrom(new char[]{'a'});
        generator = builder.build();
        randomText = generator.generate(5);
        for (char c : randomText.toCharArray()) {
            Assertions.assertEquals((char)'a', (char)c);
        }
        generator = builder.selectFrom(null).build();
        randomText = generator.generate(5);
        Assertions.assertEquals((int)5, (int)RandomStringGeneratorTest.codePointLength(randomText));
        for (char c : randomText.toCharArray()) {
            Assertions.assertTrue((c >= '\u0000' && c <= '\u10ffff' ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetLength() {
        int length = 99;
        RandomStringGenerator generator = RandomStringGenerator.builder().build();
        String str = generator.generate(99);
        Assertions.assertEquals((int)99, (int)RandomStringGeneratorTest.codePointLength(str));
    }

    @Test
    public void testUsingRandom() {
        int testChar = 97;
        TextRandomProvider testRandom = n -> 97;
        String str = RandomStringGenerator.builder().usingRandom(testRandom).build().generate(10);
        for (char c : str.toCharArray()) {
            Assertions.assertEquals((char)'a', (char)c);
        }
    }

    @Test
    public void testWithinMultipleRanges() {
        int codePoint;
        int length = 5000;
        char[][] pairs = new char[][]{{'a', 'z'}, {'0', '9'}};
        RandomStringGenerator generator = RandomStringGenerator.builder().withinRange((char[][])new char[0][]).withinRange((char[][])null).withinRange((char[][])pairs).build();
        String str = generator.generate(5000);
        int minimumCodePoint = 0;
        int maximumCodePoint = 0;
        for (char[] pair : pairs) {
            minimumCodePoint = Math.min(minimumCodePoint, pair[0]);
            maximumCodePoint = Math.max(maximumCodePoint, pair[1]);
        }
        int i = 0;
        do {
            Assertions.assertTrue(((codePoint = str.codePointAt(i)) >= minimumCodePoint && codePoint <= maximumCodePoint ? 1 : 0) != 0);
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test
    public void testWithinRange() {
        int codePoint;
        int length = 5000;
        int minimumCodePoint = 97;
        int maximumCodePoint = 122;
        RandomStringGenerator generator = RandomStringGenerator.builder().withinRange(97, 122).build();
        String str = generator.generate(5000);
        int i = 0;
        do {
            Assertions.assertTrue(((codePoint = str.codePointAt(i)) >= 97 && codePoint <= 122 ? 1 : 0) != 0);
        } while ((i += Character.charCount(codePoint)) < str.length());
    }

    @Test
    public void testZeroLength() {
        RandomStringGenerator generator = RandomStringGenerator.builder().build();
        Assertions.assertEquals((Object)"", (Object)generator.generate(0));
    }
}

