/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 3}, bv={1, 0, 1}, k=1, xi=2, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\b&\u0018\u00002\u0004\b\u00000\u00012\u000e\b\u0000\u0012\b\u0012\u0006\b\u0000\u0018\u00010\u00030\u0002B%\u0012\b\u0010\u0004\u001a\u0004\b\u00000\u0005\u0012\u0014\u0010\u0006\u001a\u0010\b\u0000\u0012\b\u0012\u0006\b\u0000\u0018\u00010\u0003\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0007J,\u0010\u0012\u001a\f\b\u0000\u0012\u0006\u0012\u0004\b\u00000\u00130\u00022\n\u0010\u0014\u001a\u0006\b\u0000\u0018\u00010\u00032\f\u0010\u0006\u001a\b\b\u0000\u0012\u0002\b\u00030\u0002H\u0016J \u0010\u0012\u001a\f\b\u0000\u0012\u0006\u0012\u0004\b\u00000\u00130\u00022\f\u0010\u0006\u001a\b\b\u0000\u0012\u0002\b\u00030\u0002H\u0016J$\u0010\u0015\u001a\u0006\b\u0000\u0018\u00010\u00032\n\u0010\u0016\u001a\u0006\b\u0000\u0018\u00010\u00032\n\u0010\u0017\u001a\u0006\b\u0000\u0018\u00010\u0018H$J\u0016\u0010\u0019\u001a\u0004\b\u00000\u00132\n\u0010\u0014\u001a\u0006\b\u0000\u0018\u00010\u0003H\u0016J\u0014\u0010\u001a\u001a\u0004\b\u00000\u00132\b\u0010\u0017\u001a\u0004\b\u00000\u0018H\u0016R\u0012\u0010\b\u001a\u0006\b\u0000\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\b\u0000\u0012\b\u0012\u0006\b\u0000\u0018\u00010\u0003\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0010\b\u0000\u0012\b\u0012\u0006\b\u0000\u0018\u00010\u0003\u0018\u00010\u00028\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\b\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\b\u0000\u0012\b\u0012\u0006\b\u0000\u0018\u00010\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u0004\b\u00000\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlin/jvm/internal/CoroutineImpl;", "Lkotlin/jvm/internal/Lambda;", "Lkotlin/coroutines/Continuation;", "", "arity", "", "completion", "(ILkotlin/coroutines/Continuation;)V", "_context", "Lkotlin/coroutines/CoroutineContext;", "_facade", "context", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "facade", "getFacade", "()Lkotlin/coroutines/Continuation;", "label", "create", "", "value", "doResume", "data", "exception", "", "resume", "resumeWithException", "kotlin-builtins"})
public abstract class CoroutineImpl
extends Lambda
implements Continuation<Object> {
    @JvmField
    protected int label;
    private final CoroutineContext _context;
    private Continuation<Object> _facade;
    @JvmField
    @Nullable
    protected Continuation<Object> completion;

    @Override
    @NotNull
    public CoroutineContext getContext() {
        CoroutineContext coroutineContext = this._context;
        if (coroutineContext == null) {
            Intrinsics.throwNpe();
        }
        return coroutineContext;
    }

    @NotNull
    public final Continuation<Object> getFacade() {
        if (this._facade == null) {
            Continuation continuation;
            CoroutineContext coroutineContext = this._context;
            if (coroutineContext == null) {
                Intrinsics.throwNpe();
            }
            if ((continuation = (ContinuationInterceptor)coroutineContext.get(ContinuationInterceptor.Key)) == null || (continuation = continuation.interceptContinuation(this)) == null) {
                continuation = this;
            }
            this._facade = continuation;
        }
        Continuation<Object> continuation = this._facade;
        if (continuation == null) {
            Intrinsics.throwNpe();
        }
        return continuation;
    }

    @Override
    public void resume(@Nullable Object value) {
        try {
            Object result = this.doResume(value, null);
            if (Intrinsics.areEqual(result, IntrinsicsKt.getSUSPENDED_MARKER()) ^ true) {
                Continuation<Object> continuation = this.completion;
                if (continuation == null) {
                    Intrinsics.throwNpe();
                }
                continuation.resume(result);
            }
        }
        catch (Throwable e) {
            Continuation<Object> continuation = this.completion;
            if (continuation == null) {
                Intrinsics.throwNpe();
            }
            continuation.resumeWithException(e);
        }
    }

    @Override
    public void resumeWithException(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        try {
            Object result = this.doResume(null, exception);
            if (Intrinsics.areEqual(result, IntrinsicsKt.getSUSPENDED_MARKER()) ^ true) {
                Continuation<Object> continuation = this.completion;
                if (continuation == null) {
                    Intrinsics.throwNpe();
                }
                continuation.resume(result);
            }
        }
        catch (Throwable e) {
            Continuation<Object> continuation = this.completion;
            if (continuation == null) {
                Intrinsics.throwNpe();
            }
            continuation.resumeWithException(e);
        }
    }

    @Nullable
    protected abstract Object doResume(@Nullable Object var1, @Nullable Throwable var2);

    @NotNull
    public Continuation<Unit> create(@NotNull Continuation<?> completion) {
        Intrinsics.checkParameterIsNotNull(completion, "completion");
        throw (Throwable)new IllegalStateException("create(Continuation) has not been overridden");
    }

    @NotNull
    public Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
        Intrinsics.checkParameterIsNotNull(completion, "completion");
        throw (Throwable)new IllegalStateException("create(Any?;Continuation) has not been overridden");
    }

    public CoroutineImpl(int arity, @Nullable Continuation<Object> completion) {
        super(arity);
        this.completion = completion;
        this.label = this.completion != null ? 0 : -1;
        Continuation<Object> continuation = this.completion;
        this._context = continuation != null ? continuation.getContext() : null;
    }
}

