/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bs_Cyrl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "гуџарати";
        final Object[][] data = new Object[][] {
            { "001", "Свијет" },
            { "002", "Африка" },
            { "003", "Сјеверноамерички континент" },
            { "005", "Јужна Америка" },
            { "009", "Океанија" },
            { "011", "Западна Африка" },
            { "013", "Централна Америка" },
            { "014", "Источна Африка" },
            { "015", "Сјеверна Африка" },
            { "017", "Централна Африка" },
            { "018", "Јужна Африка" },
            { "019", "Сјеверна и Јужна Америка" },
            { "021", "Сјеверна Америка" },
            { "029", "Кариби" },
            { "030", "Источна Азија" },
            { "034", "Јужна Азија" },
            { "035", "Југоисточна Азија" },
            { "039", "Јужна Европа" },
            { "053", "Аустралија и Нови Зеланд" },
            { "054", "Меланезија" },
            { "057", "Микронезијски регион" },
            { "061", "Полинезија" },
            { "142", "Азија" },
            { "143", "Централна Азија" },
            { "145", "Западна Азија" },
            { "150", "Европа" },
            { "151", "Источна Европа" },
            { "154", "Сјеверна Европа" },
            { "155", "Западна Европа" },
            { "202", "Подсахарска Африка" },
            { "419", "Латинска Америка" },
            { "AC", "Острво Асенсион" },
            { "AD", "Андора" },
            { "AE", "Уједињени Арапски Емирати" },
            { "AF", "Афганистан" },
            { "AG", "Антигва и Барбуда" },
            { "AI", "Ангвила" },
            { "AL", "Албанија" },
            { "AM", "Арменија" },
            { "AO", "Ангола" },
            { "AQ", "Антарктик" },
            { "AR", "Аргентина" },
            { "AS", "Америчка Самоа" },
            { "AT", "Аустрија" },
            { "AU", "Аустралија" },
            { "AW", "Аруба" },
            { "AX", "Оландска острва" },
            { "AZ", "Азербејџан" },
            { "BA", "Босна и Херцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Белгија" },
            { "BF", "Буркина Фасо" },
            { "BG", "Бугарска" },
            { "BH", "Бахреин" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Свети Бартоломеј" },
            { "BM", "Бермуди" },
            { "BN", "Брунеј" },
            { "BO", "Боливија" },
            { "BQ", "Карипска Холандија" },
            { "BR", "Бразил" },
            { "BS", "Бахами" },
            { "BT", "Бутан" },
            { "BV", "Острво Буве" },
            { "BW", "Боцвана" },
            { "BY", "Бјелорусија" },
            { "BZ", "Белизе" },
            { "CA", "Канада" },
            { "CC", "Кокос (Келинг) Острва" },
            { "CD", "Демократска Република Конго" },
            { "CF", "Централноафричка Република" },
            { "CG", "Конго" },
            { "CH", "Швицарска" },
            { "CI", "Обала Слоноваче (Кот д’Ивоар)" },
            { "CK", "Кукова Острва" },
            { "CL", "Чиле" },
            { "CM", "Камерун" },
            { "CN", "Кина" },
            { "CO", "Колумбија" },
            { "CP", "Острво Клипертон" },
            { "CR", "Костарика" },
            { "CU", "Куба" },
            { "CV", "Зеленортска Острва" },
            { "CW", "Курасао" },
            { "CX", "Божићно острво" },
            { "CY", "Кипар" },
            { "CZ", "Чешка" },
            { "DE", "Њемачка" },
            { "DG", "Дијего Гарсија" },
            { "DJ", "Џибути" },
            { "DK", "Данска" },
            { "DM", "Доминика" },
            { "DO", "Доминиканска Република" },
            { "DZ", "Алжир" },
            { "EA", "Сеута и Мелиља" },
            { "EC", "Еквадор" },
            { "EE", "Естонија" },
            { "EG", "Египат" },
            { "EH", "Западна Сахара" },
            { "ER", "Еритреја" },
            { "ES", "Шпанија" },
            { "ET", "Етиопија" },
            { "EU", "Европска унија" },
            { "EZ", "Еурозона" },
            { "FI", "Финска" },
            { "FJ", "Фиџи" },
            { "FK", "Фокландска Острва" },
            { "FM", "Микронезија" },
            { "FO", "Фарска острва" },
            { "FR", "Француска" },
            { "GA", "Габон" },
            { "GB", "Уједињено Краљевство" },
            { "GD", "Гренада" },
            { "GE", "Грузија" },
            { "GF", "Француска Гвајана" },
            { "GG", "Гернзи" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренланд" },
            { "GM", "Гамбија" },
            { "GN", "Гвинеја" },
            { "GP", "Гваделупе" },
            { "GQ", "Екваторијална Гвинеја" },
            { "GR", "Грчка" },
            { "GS", "Јужна Џорџија и Јужна Сендвичка Острва" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинеја-Бисау" },
            { "GY", "Гвајана" },
            { "HK", "Хонг Конг С. А. Р." },
            { "HM", "Херд и Мекдоналд Острва" },
            { "HN", "Хондурас" },
            { "HR", "Хрватска" },
            { "HT", "Хаити" },
            { "HU", "Мађарска" },
            { "IC", "Канарска острва" },
            { "ID", "Индонезија" },
            { "IE", "Ирска" },
            { "IL", "Израел" },
            { "IM", "Острво Мен" },
            { "IN", "Индија" },
            { "IO", "Британска територија у Индијском океану" },
            { "IQ", "Ирак" },
            { "IR", "Иран" },
            { "IS", "Исланд" },
            { "IT", "Италија" },
            { "JE", "Џерзи" },
            { "JM", "Јамајка" },
            { "JO", "Јордан" },
            { "JP", "Јапан" },
            { "KE", "Кенија" },
            { "KG", "Киргизстан" },
            { "KH", "Камбоџа" },
            { "KI", "Кирибати" },
            { "KM", "Комори" },
            { "KN", "Свети Китс и Невис" },
            { "KP", "Сјеверна Кореја" },
            { "KR", "Јужна Кореја" },
            { "KW", "Кувајт" },
            { "KY", "Кајманска острва" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Либан" },
            { "LC", "Света Луција" },
            { "LI", "Лихтенштајн" },
            { "LK", "Шри Ланка" },
            { "LR", "Либерија" },
            { "LS", "Лесото" },
            { "LT", "Литванија" },
            { "LU", "Луксембург" },
            { "LV", "Латвија" },
            { "LY", "Либија" },
            { "MA", "Мароко" },
            { "MC", "Монако" },
            { "MD", "Молдавија" },
            { "ME", "Црна Гора" },
            { "MF", "Свети Мартин" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалска Острва" },
            { "MK", "Сјеверна Македонија" },
            { "ML", "Мали" },
            { "MM", "Мјанмар" },
            { "MN", "Монголија" },
            { "MO", "Макао С. А. Р." },
            { "MP", "Сјеверна Маријанска Острва" },
            { "MQ", "Мартиник" },
            { "MR", "Мауританија" },
            { "MS", "Монсерат" },
            { "MT", "Малта" },
            { "MU", "Маурицијус" },
            { "MV", "Малдиви" },
            { "MW", "Малави" },
            { "MX", "Мексико" },
            { "MY", "Малезија" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибија" },
            { "NC", "Нова Каледонија" },
            { "NE", "Нигер" },
            { "NF", "Острво Норфолк" },
            { "NG", "Нигерија" },
            { "NI", "Никарагва" },
            { "NL", "Холандија" },
            { "NO", "Норвешка" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуе" },
            { "NZ", "Нови Зеланд" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Француска Полинезија" },
            { "PG", "Папуа Нова Гвинеја" },
            { "PH", "Филипини" },
            { "PK", "Пакистан" },
            { "PL", "Пољска" },
            { "PM", "Сен Пјер и Микелон" },
            { "PN", "Питкерн" },
            { "PR", "Порторико" },
            { "PS", "Палестинске територије" },
            { "PT", "Португал" },
            { "PW", "Палау" },
            { "PY", "Парагвај" },
            { "QA", "Катар" },
            { "QO", "Остала океанија" },
            { "RE", "Реинион" },
            { "RO", "Румунија" },
            { "RS", "Србија" },
            { "RU", "Русија" },
            { "RW", "Руанда" },
            { "SA", "Саудијска Арабија" },
            { "SB", "Соломонска Острва" },
            { "SC", "Сејшели" },
            { "SD", "Судан" },
            { "SE", "Шведска" },
            { "SG", "Сингапур" },
            { "SH", "Света Хелена" },
            { "SI", "Словенија" },
            { "SJ", "Свалбард и Јан Мајен" },
            { "SK", "Словачка" },
            { "SL", "Сијера Леоне" },
            { "SM", "Сан Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомалија" },
            { "SR", "Суринам" },
            { "SS", "Јужни Судан" },
            { "ST", "Сао Томе и Принципе" },
            { "SV", "Салвадор" },
            { "SX", "Свети Мартин (Холандија)" },
            { "SY", "Сирија" },
            { "SZ", "Есватини" },
            { "TA", "Тристан да Куња" },
            { "TC", "Туркс и Кајкос Острва" },
            { "TD", "Чад" },
            { "TF", "Француске Јужне Територије" },
            { "TG", "Того" },
            { "TH", "Тајланд" },
            { "TJ", "Таџикистан" },
            { "TK", "Токелау" },
            { "TL", "Тимор-Лесте" },
            { "TM", "Туркменистан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Турска" },
            { "TT", "Тринидад и Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тајван" },
            { "TZ", "Танзанија" },
            { "UA", "Украјина" },
            { "UG", "Уганда" },
            { "UM", "Мања удаљена острва САД" },
            { "UN", "Уједињене нације" },
            { "US", "Сједињене Америчке Државе" },
            { "UY", "Уругвај" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан" },
            { "VC", "Свети Винсент и Гренадини" },
            { "VE", "Венецуела" },
            { "VG", "Британска Дјевичанска острва" },
            { "VI", "Америчка Дјевичанска острва" },
            { "VN", "Вијетнам" },
            { "VU", "Вануату" },
            { "WF", "Валис и Футуна" },
            { "WS", "Самоа" },
            { "XA", "псеудо акценти" },
            { "XB", "псеудо двосмјерно" },
            { "XK", "Косово" },
            { "YE", "Јемен" },
            { "YT", "Мајоте" },
            { "ZA", "Јужноафричка Република" },
            { "ZM", "Замбија" },
            { "ZW", "Зимбабве" },
            { "ZZ", "Непозната или неважећа област" },
            { "aa", "афарски" },
            { "ab", "абказијски" },
            { "ae", "авестански" },
            { "af", "африканс" },
            { "ak", "акан" },
            { "am", "амхарски" },
            { "an", "арагонежански" },
            { "ar", "арапски" },
            { "as", "асемијски" },
            { "av", "аварски" },
            { "ay", "ајмара" },
            { "az", "азербејџански" },
            { "ba", "башкир" },
            { "be", "бјелоруски" },
            { "bg", "бугарски" },
            { "bi", "бислама" },
            { "bm", "бамбара" },
            { "bn", "бенгалски" },
            { "bo", "тибетански" },
            { "br", "бретонски" },
            { "bs", "босански" },
            { "ca", "каталонски" },
            { "ce", "чеченски" },
            { "ch", "чаморо" },
            { "co", "корзикански" },
            { "cr", "кри" },
            { "cs", "чешки" },
            { "cu", "старославенски" },
            { "cv", "чувашки" },
            { "cy", "велшки" },
            { "da", "дански" },
            { "de", "њемачки" },
            { "dv", "дивехијски" },
            { "dz", "џонга" },
            { "ee", "еве" },
            { "el", "грчки" },
            { "en", "енглески" },
            { "eo", "есперанто" },
            { "es", "шпански" },
            { "et", "естонски" },
            { "eu", "баскијски" },
            { "fa", "персијски" },
            { "ff", "фулах" },
            { "fi", "фински" },
            { "fj", "фиджијски" },
            { "fo", "фарски" },
            { "fr", "француски" },
            { "fy", "западни фризијски" },
            { "ga", "ирски" },
            { "gd", "шкотски галски" },
            { "gl", "галски" },
            { "gn", "гварани" },
            { "gu", metaValue_gu },
            { "gv", "манкс" },
            { "ha", "хауса" },
            { "he", "хебрејски" },
            { "hi", "хинди" },
            { "ho", "хири моту" },
            { "hr", "хрватски" },
            { "ht", "хаићански креолски" },
            { "hu", "мађарски" },
            { "hy", "јерменски" },
            { "hz", "хереро" },
            { "ia", "интерлингва" },
            { "id", "индонежански" },
            { "ie", "међујезички" },
            { "ig", "игбо" },
            { "ii", "сечуан ји" },
            { "ik", "унупиак" },
            { "io", "идо" },
            { "is", "исландски" },
            { "it", "италијански" },
            { "iu", "инуктитут" },
            { "ja", "јапански" },
            { "jv", "јавански" },
            { "ka", "грузијски" },
            { "kg", "конго" },
            { "ki", "кикују" },
            { "kj", "куањама" },
            { "kk", "казашки" },
            { "kl", "калалисут" },
            { "km", "кмерски" },
            { "kn", "канада" },
            { "ko", "корејски" },
            { "kr", "канури" },
            { "ks", "кашмирски" },
            { "ku", "курдски" },
            { "kv", "коми" },
            { "kw", "корнишки" },
            { "ky", "киргиски" },
            { "la", "латински" },
            { "lb", "луксембуршки" },
            { "lg", "ганда" },
            { "li", "лимбургиш" },
            { "ln", "лингала" },
            { "lo", "лаоски" },
            { "lt", "литвански" },
            { "lu", "луба-катанга" },
            { "lv", "латвијски" },
            { "mg", "малагасијски" },
            { "mh", "маршалски" },
            { "mi", "маорски" },
            { "mk", "македонски" },
            { "ml", "малајалам" },
            { "mn", "монголски" },
            { "mr", "марати" },
            { "ms", "малајски" },
            { "mt", "малтешки" },
            { "my", "бурмански" },
            { "na", "науру" },
            { "nb", "норвешки бокмал" },
            { "nd", "сјеверни ндебеле" },
            { "ne", "непалски" },
            { "ng", "ндонга" },
            { "nl", "холандски" },
            { "nn", "норвешки нинорск" },
            { "no", "норвешки" },
            { "nr", "јужни ндебеле" },
            { "nv", "навахо" },
            { "ny", "њања" },
            { "oc", "провансалски" },
            { "oj", "ојибва" },
            { "om", "оромо" },
            { "or", "одија" },
            { "os", "осетски" },
            { "pa", "пенџапски" },
            { "pi", "пали" },
            { "pl", "пољски" },
            { "ps", "паштунски" },
            { "pt", "португалски" },
            { "qu", "квенча" },
            { "rm", "рето-романски" },
            { "rn", "рунди" },
            { "ro", "румунски" },
            { "ru", "руски" },
            { "rw", "кинјаруанда" },
            { "sa", "санскрит" },
            { "sc", "сардињаски" },
            { "sd", "синди" },
            { "se", "сјеверни сами" },
            { "sg", "санго" },
            { "sh", "српскохрватски" },
            { "si", "синхалски" },
            { "sk", "словачки" },
            { "sl", "словенски" },
            { "sm", "самоански" },
            { "sn", "шона" },
            { "so", "сомалски" },
            { "sq", "албански" },
            { "sr", "српски" },
            { "ss", "свати" },
            { "st", "сесото" },
            { "su", "сундански" },
            { "sv", "шведски" },
            { "sw", "свахили" },
            { "ta", "тамилски" },
            { "te", "телугу" },
            { "tg", "таџички" },
            { "th", "тајландски" },
            { "ti", "тигриња" },
            { "tk", "туркменски" },
            { "tl", "тагалски" },
            { "tn", "тсвана" },
            { "to", "тонга" },
            { "tr", "турски" },
            { "ts", "тсонга" },
            { "tt", "татарски" },
            { "tw", "тви" },
            { "ty", "тахићански" },
            { "ug", "ујгурски" },
            { "uk", "украјински" },
            { "ur", "урду" },
            { "uz", "узбечки" },
            { "ve", "венда" },
            { "vi", "вијетнамски" },
            { "vo", "волапук" },
            { "wa", "валун" },
            { "wo", "волоф" },
            { "xh", "коса" },
            { "yi", "јидиш" },
            { "yo", "јоруба" },
            { "za", "жуанг" },
            { "zh", "кинески" },
            { "zu", "зулу" },
            { "ace", "ачинески" },
            { "ach", "аколи" },
            { "ada", "адангмејски" },
            { "ady", "адигејски" },
            { "afh", "африхили" },
            { "agq", "ахемски" },
            { "ain", "аину" },
            { "akk", "акадијски" },
            { "ale", "аљут" },
            { "alt", "јужни алтаи" },
            { "ang", "староенглески" },
            { "ann", "оболо" },
            { "anp", "ангика" },
            { "arc", "армајски" },
            { "arn", "ароканијски" },
            { "arp", "арапахо" },
            { "ars", "најди арапски" },
            { "arw", "аравак" },
            { "asa", "асу" },
            { "ast", "астуријски" },
            { "atj", "атикамекв" },
            { "awa", "авадхи" },
            { "bal", "балучи" },
            { "ban", "балинезијски" },
            { "bas", "баса" },
            { "bej", "беја" },
            { "bem", "бемба" },
            { "bez", "бена" },
            { "bho", "бојпури" },
            { "bik", "бикол" },
            { "bin", "бини" },
            { "bla", "сисика" },
            { "bra", "брај" },
            { "brx", "бодо" },
            { "bua", "буриат" },
            { "bug", "бугинежански" },
            { "byn", "блин" },
            { "cad", "кадо" },
            { "car", "карипски" },
            { "cay", "Кајуга" },
            { "cch", "атсамски" },
            { "ccp", "чакма" },
            { "ceb", "цебуано" },
            { "cgg", "чига" },
            { "chb", "чибча" },
            { "chg", "чагатаи" },
            { "chk", "чукески" },
            { "chm", "мари" },
            { "chn", "чинукски" },
            { "cho", "чоктавски" },
            { "chp", "чипвијански" },
            { "chr", "чероки" },
            { "chy", "чејенски" },
            { "ckb", "централнокурдски" },
            { "clc", "Чилкотин" },
            { "cop", "коптски" },
            { "crg", "мичиф" },
            { "crh", "кримеански турски" },
            { "crj", "јужноисточни кре" },
            { "crk", "равничарски кре" },
            { "crl", "сјеверно источни кре" },
            { "crm", "мосе кре" },
            { "crr", "алгонкуански за Каролину" },
            { "csb", "кашубијански" },
            { "csw", "свампи кре" },
            { "dak", "дакота" },
            { "dar", "даргва" },
            { "dav", "таита" },
            { "del", "делавер" },
            { "den", "славски" },
            { "dgr", "догриб" },
            { "din", "динка" },
            { "dje", "зарма" },
            { "doi", "догри" },
            { "dsb", "доњолужичкосрпски" },
            { "dua", "дуала" },
            { "dum", "средњи холандски" },
            { "dyo", "јола-фоњи" },
            { "dyu", "ђула" },
            { "dzg", "дазага" },
            { "ebu", "ембу" },
            { "efi", "ефикски" },
            { "egy", "староегипатски" },
            { "eka", "екајук" },
            { "elx", "еламитски" },
            { "enm", "средњи енглески" },
            { "ewo", "евондо" },
            { "fan", "фанг" },
            { "fat", "фанти" },
            { "fil", "филипински" },
            { "fon", "фон" },
            { "frc", "кајунски француски" },
            { "frm", "средњи француски" },
            { "fro", "старофранцуски" },
            { "frr", "северно-фризијски" },
            { "frs", "источни фризијски" },
            { "fur", "фриулијски" },
            { "gaa", "га" },
            { "gay", "гајо" },
            { "gba", "гбаја" },
            { "gez", "џиз" },
            { "gil", "гилбертшки" },
            { "gmh", "средњи високи немачки" },
            { "goh", "старонемачки" },
            { "gon", "гонди" },
            { "gor", "горонтало" },
            { "got", "готски" },
            { "grb", "гребо" },
            { "grc", "старогрчки" },
            { "gsw", "њемачки (Швицарска)" },
            { "guz", "гуси" },
            { "gwi", "гвич’ин" },
            { "hai", "хаида" },
            { "haw", "хавајски" },
            { "hax", "јужни хаида" },
            { "hil", "хилигајнон" },
            { "hit", "хитите" },
            { "hmn", "хмонг" },
            { "hsb", "горњолужичкосрпски" },
            { "hup", "хупа" },
            { "hur", "халкомелем" },
            { "iba", "ибан" },
            { "ibb", "ибибио" },
            { "ikt", "западно канадски инуктитут" },
            { "ilo", "илоко" },
            { "inh", "ингвишки" },
            { "jbo", "лојбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "jpr", "јудео-персијски" },
            { "jrb", "јудео-арапски" },
            { "kaa", "кара-калпашки" },
            { "kab", "кабиле" },
            { "kac", "качин" },
            { "kaj", "ђу" },
            { "kam", "камба" },
            { "kaw", "кави" },
            { "kbd", "кабардијски" },
            { "kcg", "тјап" },
            { "kde", "маконде" },
            { "kea", "кабовердијански креолски" },
            { "kfo", "коро" },
            { "kgp", "каинганг" },
            { "kha", "каси" },
            { "kho", "котанешки" },
            { "khq", "којра чини" },
            { "kkj", "како" },
            { "kln", "калењин" },
            { "kmb", "кимбунду" },
            { "kok", "конкани" },
            { "kos", "косреански" },
            { "kpe", "кпеле" },
            { "krc", "карачај-балкар" },
            { "krl", "карелијски" },
            { "kru", "курукх" },
            { "ksb", "шамбала" },
            { "ksf", "бафија" },
            { "ksh", "келнски" },
            { "kum", "кумик" },
            { "kut", "кутенаи" },
            { "kwk", "кваквала" },
            { "lad", "ладино" },
            { "lag", "ланги" },
            { "lah", "ланда" },
            { "lam", "ламба" },
            { "lez", "лезгиан" },
            { "lij", "линуриан" },
            { "lil", "лилоет" },
            { "lkt", "лакота" },
            { "lol", "монго" },
            { "lou", "луизиански креолски" },
            { "loz", "лози" },
            { "lrc", "сјеверни лури" },
            { "lsm", "самиа" },
            { "lua", "луба-лулуа" },
            { "lui", "луисено" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "лушаи" },
            { "luy", "луја" },
            { "mad", "мадурешки" },
            { "mag", "магахи" },
            { "mai", "маитили" },
            { "mak", "макасар" },
            { "man", "мандинго" },
            { "mas", "масаи" },
            { "mdf", "мокша" },
            { "mdr", "мандар" },
            { "men", "менде" },
            { "mer", "меру" },
            { "mfe", "мауритански" },
            { "mga", "средњи ирски" },
            { "mgh", "макуа-мето" },
            { "mgo", "мета" },
            { "mic", "микмак" },
            { "min", "минангкабау" },
            { "mnc", "манчу" },
            { "mni", "манипури" },
            { "moe", "иму-аимун" },
            { "moh", "махавски" },
            { "mos", "моси" },
            { "mua", "мунданг" },
            { "mul", "више језика" },
            { "mus", "кришки" },
            { "mwl", "мирандешки" },
            { "mwr", "марвари" },
            { "myv", "ерзија" },
            { "mzn", "мазандерани" },
            { "nap", "неаполитански" },
            { "naq", "нама" },
            { "nds", "ниски њемачки" },
            { "new", "невари" },
            { "nia", "ниас" },
            { "niu", "ниуеан" },
            { "nmg", "квасио" },
            { "nnh", "нгиембун" },
            { "nog", "ногаи" },
            { "non", "стари норски" },
            { "nqo", "н’ко" },
            { "nso", "сјеверни сото" },
            { "nus", "нуер" },
            { "nwc", "класични невари" },
            { "nym", "њамвези" },
            { "nyn", "њанколе" },
            { "nyo", "њоро" },
            { "nzi", "нзима" },
            { "ojb", "сјеверозападни ојибва" },
            { "ojc", "Централни обијва" },
            { "ojs", "оји-кре" },
            { "ojw", "западни ојибва" },
            { "oka", "оканаган" },
            { "osa", "осаге" },
            { "ota", "отомански турски" },
            { "pag", "пангасински" },
            { "pal", "пахлави" },
            { "pam", "пампанга" },
            { "pap", "папиаменто" },
            { "pau", "палауански" },
            { "pcm", "нигеријски пидгин" },
            { "peo", "староперсијски" },
            { "phn", "феничански" },
            { "pis", "пијин" },
            { "pon", "понпејски" },
            { "pqm", "малисет-шасамкуоди" },
            { "prg", "пруски" },
            { "pro", "старопровансалски" },
            { "raj", "рађастани" },
            { "rap", "рапануи" },
            { "rar", "раротонган" },
            { "rhg", "рохимгја" },
            { "rof", "ромбо" },
            { "rom", "романи" },
            { "rup", "ароманијски" },
            { "rwk", "рва" },
            { "sad", "сандаве" },
            { "sah", "јакутски" },
            { "sam", "самаритански арамејски" },
            { "saq", "самбуру" },
            { "sas", "сасак" },
            { "sat", "сантали" },
            { "sba", "нгамбеј" },
            { "sbp", "сангу" },
            { "scn", "сицилијански" },
            { "sco", "шкотски" },
            { "seh", "сена" },
            { "sel", "селкап" },
            { "ses", "којраборо сени" },
            { "sga", "староирски" },
            { "shi", "ташелхит" },
            { "shn", "шан" },
            { "sid", "сидамо" },
            { "slh", "јужни лушотсед" },
            { "sma", "јужни сами" },
            { "smj", "луле сами" },
            { "smn", "инари сами" },
            { "sms", "сколтски језик" },
            { "snk", "сонинке" },
            { "sog", "соџијенски" },
            { "srn", "сранански тонго" },
            { "srr", "серер" },
            { "str", "страитс салиш" },
            { "suk", "сукума" },
            { "sus", "сусу" },
            { "sux", "сумерски" },
            { "swb", "коморски" },
            { "syc", "класични сиријски" },
            { "syr", "сиријски" },
            { "tce", "јужни тутчоне" },
            { "tem", "тимне" },
            { "teo", "тесо" },
            { "ter", "терено" },
            { "tet", "тетум" },
            { "tgx", "тагиш" },
            { "tht", "талтан" },
            { "tig", "тигре" },
            { "tiv", "тив" },
            { "tkl", "токелау" },
            { "tlh", "клингонски" },
            { "tli", "тлингит" },
            { "tmh", "тамашек" },
            { "tog", "њаса тонга" },
            { "tok", "токи пона" },
            { "tpi", "ток писин" },
            { "trv", "тароко" },
            { "tsi", "тсимшиан" },
            { "ttm", "сјеверни тутчоне" },
            { "tum", "тумбука" },
            { "tvl", "тувалу" },
            { "twq", "тасавак" },
            { "tyv", "тувинијски" },
            { "tzm", "централноатласки тамазихт" },
            { "udm", "удмурт" },
            { "uga", "угаритски" },
            { "umb", "умбунду" },
            { "und", "непознати језик" },
            { "vai", "ваи" },
            { "vec", "венецијански" },
            { "vot", "вотски" },
            { "vun", "вунјо" },
            { "wae", "валсерски" },
            { "wal", "валамо" },
            { "war", "варај" },
            { "was", "вашо" },
            { "wuu", "ву кинески" },
            { "xal", "калмик" },
            { "xog", "сога" },
            { "yao", "јао" },
            { "yap", "јапешки" },
            { "yav", "јангбен" },
            { "ybb", "јемба" },
            { "yrl", "ненгату" },
            { "yue", "кантонски" },
            { "zap", "запотечки" },
            { "zbl", "блисимболи" },
            { "zen", "зенага" },
            { "zgh", "стандардни марокански тамазихт" },
            { "zun", "зуни" },
            { "zxx", "без лингвистичког садржаја" },
            { "zza", "заза" },
            { "Adlm", "адламанско писмо" },
            { "Aghb", "бијело албанско писмо" },
            { "Ahom", "ахом писмо" },
            { "Arab", "арапско писмо" },
            { "Aran", "насталик писмо" },
            { "Armi", "империјско арамејско писмо" },
            { "Armn", "јерменско писмо" },
            { "Avst", "авестанско писмо" },
            { "Bali", "балијско писмо" },
            { "Bamu", "бамум писмо" },
            { "Bass", "баса вах писмо" },
            { "Batk", "батак писмо" },
            { "Beng", "бенгалско писмо" },
            { "Bhks", "баиксуки писмо" },
            { "Blis", "блисимболично писмо" },
            { "Bopo", "бопомофо писмо" },
            { "Brah", "браманско писмо" },
            { "Brai", "брајево писмо" },
            { "Bugi", "бугинско писмо" },
            { "Buhd", "бухидско писмо" },
            { "Cakm", "чакманско писмо" },
            { "Cans", "уједињени канадски абориџински силабици" },
            { "Cari", "каријско писмо" },
            { "Cham", "чамско писмо" },
            { "Cher", "Чероки" },
            { "Chrs", "чорамсианско писмо" },
            { "Cirt", "цирт писмо" },
            { "Copt", "коптичко писмо" },
            { "Cpmn", "кипро-миноанско писмо" },
            { "Cprt", "кипарско писмо" },
            { "Cyrl", "ћирилица" },
            { "Cyrs", "старословенска црквена ћирилица" },
            { "Deva", "деванагари" },
            { "Diak", "дивес акуру писмо" },
            { "Dogr", "догра писмо" },
            { "Dsrt", "Дезерет" },
            { "Dupl", "дуплојанska stenografija" },
            { "Egyd", "египатско народно писмо" },
            { "Egyh", "египатско хијератско писмо" },
            { "Egyp", "египатски хијероглифи" },
            { "Elba", "елбасан писмо" },
            { "Elym", "елимаик писмо" },
            { "Ethi", "етиопско писмо" },
            { "Geok", "грузијско кхутсури писмо" },
            { "Geor", "грузијско писмо" },
            { "Glag", "глагољица" },
            { "Gong", "гуњала гонди писмо" },
            { "Gonm", "масарам гонди писмо" },
            { "Goth", "готика" },
            { "Gran", "гранта писмо" },
            { "Grek", "грчко писмо" },
            { "Gujr", metaValue_gu },
            { "Guru", "гурмуки писмо" },
            { "Hanb", "хан с бопомофо писмом" },
            { "Hang", "хангул" },
            { "Hani", "хан" },
            { "Hano", "хануно" },
            { "Hans", "поједностављени" },
            { "Hant", "традиционални" },
            { "Hatr", "хатран писмо" },
            { "Hebr", "хебрејско писмо" },
            { "Hira", "хирагана" },
            { "Hluw", "анатолијски хијероглифи" },
            { "Hmng", "пахав хмонг писмо" },
            { "Hmnp", "нјакенг пауче хмонг писмо" },
            { "Hrkt", "јапанско слоговно писмо" },
            { "Hung", "старомађарско писмо" },
            { "Inds", "индушко писмо" },
            { "Ital", "стари италик" },
            { "Jamo", "џамо" },
            { "Java", "јаванско писмо" },
            { "Jpan", "јапанско писмо" },
            { "Kali", "кајах-ли писмо" },
            { "Kana", "катакана" },
            { "Kawi", "кави писмо" },
            { "Khar", "карошти писмо" },
            { "Khmr", "кмерско писмо" },
            { "Khoj", "којки писмо" },
            { "Kits", "китан мала слова" },
            { "Knda", "канада писмо" },
            { "Kore", "корејско писмо" },
            { "Kthi", "каити" },
            { "Lana", "ланна писмо" },
            { "Laoo", "лаоско писмо" },
            { "Latf", "латиница (фрактур варијанта)" },
            { "Latg", "галска латиница" },
            { "Latn", "латиница" },
            { "Lepc", "лепча писмо" },
            { "Limb", "лимбу писмо" },
            { "Lina", "линеарно А писмо" },
            { "Linb", "линеарно Б писмо" },
            { "Lisu", "фрасер писмо" },
            { "Lyci", "лисијско писмо" },
            { "Lydi", "лидијско писмо" },
            { "Mahj", "махајани писмо" },
            { "Maka", "макасар писмо" },
            { "Mand", "мандеанско писмо" },
            { "Mani", "манихејско писмо" },
            { "Marc", "марчен писмо" },
            { "Maya", "мајански хијероглифи" },
            { "Medf", "медефаидрин писмо" },
            { "Mend", "менде писмо" },
            { "Merc", "меоитиц курзив" },
            { "Mero", "мероитик писмо" },
            { "Mlym", "малајалам писмо" },
            { "Modi", "моди писмо" },
            { "Mong", "монголско писмо" },
            { "Moon", "месечево писмо" },
            { "Mroo", "мро писмо" },
            { "Mtei", "меитеи мајек писмо" },
            { "Mult", "мултани писмо" },
            { "Mymr", "мијанмарско писмо" },
            { "Nagm", "наг мундари писмо" },
            { "Nand", "нандинагари писмо" },
            { "Narb", "старо сјеверно арапско писмо" },
            { "Nbat", "набатаен писмо" },
            { "Newa", "нева писмо" },
            { "Nkoo", "н’ко писмо" },
            { "Nshu", "нушу писмо" },
            { "Ogam", "огамско писмо" },
            { "Olck", "ол чики писмо" },
            { "Orkh", "орконско писмо" },
            { "Orya", "одија писмо" },
            { "Osge", "осаге писмо" },
            { "Osma", "осмањанско писмо" },
            { "Ougr", "старо ујгур писмо" },
            { "Palm", "палмѕрене писмо" },
            { "Pauc", "пау цин хау писмо" },
            { "Perm", "старо пермикско писмо" },
            { "Phag", "пагс-па писмо" },
            { "Phli", "писани пахлави" },
            { "Phlp", "псалтер пахлави" },
            { "Phlv", "пахлави писмо" },
            { "Phnx", "феничанско писмо" },
            { "Plrd", "поралд фонетско писмо" },
            { "Prti", "писани партиан" },
            { "Qaag", "завгји писмо" },
            { "Rjng", "рејанг писмо" },
            { "Rohg", "ханифи писмо" },
            { "Roro", "ронгоронго писмо" },
            { "Runr", "рунско писмо" },
            { "Samr", "самаританско писмо" },
            { "Sara", "сарати писмо" },
            { "Sarb", "старо јужно арапско писмо" },
            { "Saur", "саураштра писмо" },
            { "Sgnw", "знаковно писмо" },
            { "Shaw", "шавијанско писмо" },
            { "Shrd", "шарада писмо" },
            { "Sidd", "сидхам писмо" },
            { "Sind", "кудавади писмо" },
            { "Sinh", "синхалско писмо" },
            { "Sogd", "согдиан писмо" },
            { "Sogo", "старо согдиан писмо" },
            { "Sora", "сора сомпенг писмо" },
            { "Soyo", "сојомбо писмо" },
            { "Sund", "сунданесе писмо" },
            { "Sylo", "силоти нагри писмо" },
            { "Syrc", "сиријско писмо" },
            { "Syre", "сиријско естрангело писмо" },
            { "Syrj", "западносиријско писмо" },
            { "Syrn", "писмо источне Сирије" },
            { "Tagb", "тагбанва писмо" },
            { "Takr", "такри писмо" },
            { "Tale", "таи ле писмо" },
            { "Talu", "нови таи луе" },
            { "Taml", "тамилско писмо" },
            { "Tang", "тангут писмо" },
            { "Tavt", "таи виет писмо" },
            { "Telu", "телугу писмо" },
            { "Teng", "тенгвар писмо" },
            { "Tfng", "тифинаг писмо" },
            { "Tglg", "тагалог" },
            { "Thaa", "тана писмо" },
            { "Thai", "тајландско писмо" },
            { "Tibt", "тибетанско писмо" },
            { "Tirh", "тирхута писмо" },
            { "Tnsa", "тангса писмо" },
            { "Toto", "тото писмо" },
            { "Ugar", "угаритско писмо" },
            { "Vaii", "ваи писмо" },
            { "Visp", "видљиви говор" },
            { "Vith", "виткуки писмо" },
            { "Wara", "варанг кшити писмо" },
            { "Wcho", "ванчо" },
            { "Xpeo", "староперсијско писмо" },
            { "Xsux", "сумерско-акадско кунеиформ писмо" },
            { "Yezi", "језиди писмо" },
            { "Yiii", "ји писмо" },
            { "Zanb", "занабазар клинасто писмо" },
            { "Zinh", "наследно писмо" },
            { "Zmth", "математичка нотација" },
            { "Zsye", "емоџи" },
            { "Zsym", "симболи" },
            { "Zxxx", "неписани језик" },
            { "Zyyy", "заједничко писмо" },
            { "Zzzz", "непознато писмо" },
            { "de_CH", "високи њемачки (Швицарска)" },
            { "nl_BE", "фламански" },
            { "ro_MD", "молдавски" },
            { "%%1901", "Традиционална немачка ортографија" },
            { "%%1994", "Стандарднизована ресијанска ортографија" },
            { "%%1996", "Немачка ортографија из 1996" },
            { "ar_001", "арапски (стандардни)" },
            { "key.ca", "Календар" },
            { "key.cf", "формат валуте" },
            { "key.co", "сортирање" },
            { "key.cu", "валута" },
            { "key.hc", "сат (12-сати / 24-сата)" },
            { "key.lb", "стил завршетка ретка" },
            { "key.ms", "систем мјерења" },
            { "key.nu", "Бројеви" },
            { "%%ALUKU", "Алуку дијалект" },
            { "%%BARLA", "Барлавенто дијалект групе Кабзвердијана" },
            { "%%BISKE", "Сан Ђорђио/Била дијалект" },
            { "%%BOONT", "Бунтлинг" },
            { "%%CORNU", "ЦОРНУ" },
            { "%%LIPAW", "Липовички дијалект ресијански" },
            { "%%NEDIS", "Натисоне дијалект" },
            { "%%NJIVA", "Гњива/Њива дијалкект" },
            { "%%OSOJS", "Осеако/Осојане дијалект" },
            { "%%POSIX", "Компјутер" },
            { "%%ROZAJ", "Ресијан" },
            { "%%SAAHO", "Сахо" },
            { "%%SOLBA", "Столвица/Солбица дијалект" },
            { "zh_Hans", "кинески (поједностављен)" },
            { "%%AO1990", "Споразум о ортографији португалског језика од 1990." },
            { "%%ARANES", "АРАНЕС" },
            { "%%ASANTE", "АСАНТЕ" },
            { "%%AUVERN", "АУВЕРН" },
            { "%%CISAUP", "ЦИСАУП" },
            { "%%CREISS", "КРЕИС" },
            { "%%DAJNKO", "дајнко алфабет" },
            { "%%EKAVSK", "српрски с екавицом" },
            { "%%FONIPA", "ИПА фонетика" },
            { "%%FONUPA", "УПА фонетика" },
            { "%%SCOUSE", "Скауз" },
            { "%%TARASK", "Тараскијевичка ортографија" },
            { "%%ABL1943", "Ортографска формулација 1943" },
            { "%%AKUAPEM", "АКУАПЕМ" },
            { "%%ALALC97", "АЛА-ЛЦ Романизација, издање 1997." },
            { "%%AREVELA", "Источни арменијски" },
            { "%%AREVMDA", "Западно јерменска" },
            { "%%ARKAIKA", "АРКАИКА" },
            { "%%BALANKA", "Баланка дијалект Аниија" },
            { "%%BAUDDHA", "БАУДДХА" },
            { "%%BOHORIC", "Бохорочки алфабет" },
            { "%%EMODENG", "рани модерни енглески" },
            { "%%FONNAPA", "ФОНАПА" },
            { "%%MONOTON", "Монотоник" },
            { "%%POLYTON", "Политоник" },
            { "%%REVISED", "Ревидирана ортографија" },
            { "%%1606NICT", "Француски из касног средњег века до 1606." },
            { "%%1694ACAD", "Рани модерни француски" },
            { "%%1959ACAD", "Академски" },
            { "%%BAKU1926", "Уједињен турски латинични алфабет" },
            { "%%BASICENG", "БАСИЦЕНГ" },
            { "%%BISCAYAN", "БИСЦАЈАН" },
            { "%%BORNHOLM", "БОРНХОЛМ" },
            { "%%COLB1945", "Конвенција о португалског ортографији за Бразил од 1945." },
            { "%%FONKIRSH", "ФОНКИРШ" },
            { "%%SCOTLAND", "Шкотски стандардни Енглески" },
            { "%%VALENCIA", "Валенцијска" },
            { "type.ca.roc", "Календар Републике Кине" },
            { "type.hc.h11", "12-сатни систем (0–11)" },
            { "type.hc.h12", "12-сатни систем (1–12)" },
            { "type.hc.h23", "24-сатни систем (0–23)" },
            { "type.hc.h24", "24-сатни систем (1–24)" },
            { "type.m0.bgn", "БГН (BGN)" },
            { "type.nu.arab", "арапско-индијске цифре" },
            { "type.nu.armn", "јерменски бројеви" },
            { "type.nu.beng", "бенгалске цифре" },
            { "type.nu.deva", "девангари цифре" },
            { "type.nu.ethi", "етиопски бројеви" },
            { "type.nu.geor", "грузијски бројеви" },
            { "type.nu.grek", "грчки бројеви" },
            { "type.nu.gujr", "гуџаратске цифре" },
            { "type.nu.guru", "гурмуки цифре" },
            { "type.nu.hans", "поједностављени кинески бројеви" },
            { "type.nu.hant", "традиционални кинески бројеви" },
            { "type.nu.hebr", "хебрејски бројеви" },
            { "type.nu.jpan", "јапански бројеви" },
            { "type.nu.khmr", "кмерске цифре" },
            { "type.nu.knda", "канада цифре" },
            { "type.nu.laoo", "лаоске цифре" },
            { "type.nu.latn", "западне цифре" },
            { "type.nu.mlym", "малајалам цифре" },
            { "type.nu.mong", "монголске цифре" },
            { "type.nu.mymr", "мијанмарске цифре" },
            { "type.nu.orya", "орија цифре" },
            { "type.nu.taml", "тамилски бројеви" },
            { "type.nu.telu", "телугу цифре" },
            { "type.nu.thai", "тајске цифре" },
            { "type.nu.tibt", "тибетанске цифре" },
            { "type.ca.dangi", "данги календар" },
            { "type.co.ducet", "задани Unicode редослијед сортирања" },
            { "type.lb.loose", "слободан стил завршетка ретка" },
            { "type.nu.roman", "римски бројеви" },
            { "type.ca.coptic", "коптски календар" },
            { "type.ca.hebrew", "хебрејски календар" },
            { "type.ca.indian", "Индијски национални календар" },
            { "type.co.pinyin", "Пињин сортирање" },
            { "type.co.search", "претрага опште намене" },
            { "type.co.stroke", "Сортирање по броју црта" },
            { "type.co.unihan", "Редослед сортирања радикалним цртицама" },
            { "type.d0.fwidth", "пуна ширина" },
            { "type.d0.hwidth", "пола ширине" },
            { "type.lb.normal", "нормални стил завршетка ретка" },
            { "type.lb.strict", "строги стил завршетка ретка" },
            { "type.m0.ungegn", "УНГЕГН (BGN)" },
            { "type.ms.metric", "метрички систем" },
            { "type.ca.chinese", "кинески календар" },
            { "type.ca.islamic", "исламски календар" },
            { "type.ca.iso8601", "ISO-8601 календар" },
            { "type.ca.persian", "персијски календар" },
            { "type.cf.account", "рачуноводствени формат валуте" },
            { "type.co.big5han", "Традиционално кинеско сортирање" },
            { "type.d0.npinyin", "Нумеричка" },
            { "type.nu.arabext", "продужене арапско-индијске цифре" },
            { "type.nu.armnlow", "мали јерменски бројеви" },
            { "type.nu.greklow", "мали грчки бројеви" },
            { "type.nu.hanidec", "кинески децимални бројеви" },
            { "type.nu.hansfin", "поједностављени кинески финансијски бројеви" },
            { "type.nu.hantfin", "традиционални кинески финансијски бројеви" },
            { "type.nu.jpanfin", "јапански финансијски бројеви" },
            { "type.nu.tamldec", "тамилске цифре" },
            { "type.ca.buddhist", "будистички календар" },
            { "type.ca.ethiopic", "етиопски календар" },
            { "type.ca.japanese", "јапански календар" },
            { "type.cf.standard", "стандардни формат валуте" },
            { "type.co.reformed", "Реформисани редослед сортирања" },
            { "type.co.standard", "стандардни редослијед сортирања" },
            { "type.ms.uksystem", "империјални систем мјерења" },
            { "type.ms.ussystem", "амерички систем мјерења" },
            { "type.nu.fullwide", "цифре пуне ширине" },
            { "type.nu.romanlow", "мали римски бројеви" },
            { "type.ca.gregorian", "грегоријански календар" },
            { "type.co.gb2312han", "Поједностављено кинеско сортирање" },
            { "type.co.phonebook", "Сортирање као телефонски именик" },
            { "type.co.dictionary", "Редослед сортирања у речнику" },
            { "type.co.traditional", "Традиционално сортирање" },
            { "type.ca.ethiopic-amete-alem", "етиопски амет алем календар" },
        };
        return data;
    }
}
