/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.BasicLock;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class BasicObjectLock
extends VMObject {
    private static Field lockField;
    private static OopField objField;
    private static int size;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("BasicObjectLock");
        lockField = type.getField("_lock");
        objField = type.getOopField("_obj");
        size = (int)type.getSize();
    }

    public BasicObjectLock(Address addr) {
        super(addr);
    }

    public OopHandle obj() {
        return objField.getValue(this.addr);
    }

    public BasicLock lock() {
        return new BasicLock(this.addr.addOffsetTo(lockField.getOffset()));
    }

    public static int size() {
        return size;
    }

    public Address address() {
        return this.addr;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                BasicObjectLock.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

