---
title: "rclone purge"
description: "Remove the path and all of its contents."
# autogenerated - DO NOT EDIT, instead edit the source code in cmd/purge/ and as part of making a release run "make commanddocs"
---
# rclone purge

Remove the path and all of its contents.

## Synopsis

Remove the path and all of its contents.  Note that this does not obey
include/exclude filters - everything will be removed.  Use the
[delete](/commands/rclone_delete/) command if you want to selectively
delete files. To delete empty directories only, use command
[rmdir](/commands/rclone_rmdir/) or [rmdirs](/commands/rclone_rmdirs/).

The concurrency of this operation is controlled by the `--checkers` global flag. However, some backends will
implement this command directly, in which case `--checkers` will be ignored.

**Important**: Since this can cause data loss, test first with the
`--dry-run` or the `--interactive`/`-i` flag.


```
rclone purge remote:path [flags]
```

## Options

```
  -h, --help   help for purge
```

Options shared with other commands are described next.
See the [global flags page](/flags/) for global options not listed here.

### Important Options

Important flags useful for most commands

```
  -n, --dry-run         Do a trial run with no permanent changes
  -i, --interactive     Enable interactive mode
  -v, --verbose count   Print lots more stuff (repeat for more)
```

## See Also

* [rclone](/commands/rclone/)	 - Show help for rclone commands, flags and backends.

