/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dezymer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SequenceTree {
    static final boolean BLOSUM_SPACING = true;
    static final boolean RADIAL_LAYOUT = true;
    static DecimalFormat df = new DecimalFormat("0.0####");
    static final String COLOR_CODES = "ABCDEFGHIJKLM";
    static final String BLOSUM_INDICES = "CSTPAGNDEQHRKMILVFYW";
    static final int[][] BLOSUM_62 = new int[][]{{9}, {-1, 4}, {-1, 1, 5}, {-3, -1, -1, 7}, {0, 1, 0, -1, 4}, {-3, 0, -2, -2, 0, 6}, {-3, 1, 0, -2, -2, 0, 6}, {-3, 0, -1, -1, -2, -1, 1, 6}, {-4, 0, -1, -1, -1, -2, 0, 2, 5}, {-3, 0, -1, -1, -1, -2, 0, 0, 2, 5}, {-3, -1, -2, -2, -2, -2, 1, -1, 0, 0, 8}, {-3, -1, -1, -2, -1, -2, 0, -2, 0, 1, 0, 5}, {-3, 0, -1, -1, -1, -2, 0, -1, 1, 1, -1, 2, 5}, {-1, -1, -1, -2, -1, -3, -2, -3, -2, 0, -2, -1, -1, 5}, {-1, -1, -1, -3, -1, -4, -3, -3, -3, -3, -3, -3, -3, 1, 4}, {-1, -2, -1, -3, -1, -4, -3, -4, -3, -2, -3, -2, -2, 2, 2, 4}, {-1, -2, 0, -2, 0, -3, -3, -3, -2, -2, -3, -3, -2, 1, 3, 1, 4}, {-2, -2, -2, -4, -2, -3, -3, -3, -3, -3, -1, -3, -3, 0, 0, 0, -1, 6}, {-2, -2, -2, -3, -2, -3, -2, -3, -2, -1, 2, -2, -2, -1, -1, -1, -1, 3, 7}, {-2, -3, -2, -4, -3, -2, -4, -4, -3, -2, -2, -3, -3, -1, -3, -2, -3, 1, 2, 11}};
    List inputFiles = new ArrayList();
    int prevX = 0;
    Sequence prevLeaf = null;
    Sequence firstLeaf = null;
    int prevHeight = 1;
    int maxPairwiseBlosum = Integer.MIN_VALUE;

    Sequence[] loadSequences(InputStream[] inputStreamArray) throws IOException {
        HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>();
        for (int i = 0; i < inputStreamArray.length; ++i) {
            String string;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStreamArray[i]));
            while ((string = lineNumberReader.readLine()) != null) {
                if (string.length() <= 0) continue;
                Sequence sequence = (Sequence)hashMap.get(string);
                if (sequence == null) {
                    sequence = new Sequence(string);
                    hashMap.put(string, sequence);
                }
                sequence.flags.set(i);
            }
        }
        Sequence[] sequenceArray = hashMap.values().toArray(new Sequence[hashMap.size()]);
        for (int i = 0; i < sequenceArray.length; ++i) {
            sequenceArray[i].index = i;
        }
        return sequenceArray;
    }

    int blosumScore(Sequence sequence, Sequence sequence2) {
        String string = sequence.toString();
        String string2 = sequence2.toString();
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            try {
                n3 = BLOSUM_INDICES.indexOf(string.charAt(n5));
                n4 = BLOSUM_INDICES.indexOf(string2.charAt(n5));
                if (n3 < 0 || n4 < 0) continue;
                if (n3 < n4) {
                    n += BLOSUM_62[n4][n3];
                    continue;
                }
                n += BLOSUM_62[n3][n4];
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                System.err.println("i = " + n3 + "; j = " + n4 + "; k = " + n5);
                System.err.println("Comparing " + string + " (" + string.length() + ") and " + string2 + " (" + string2.length() + ")");
                System.exit(1);
            }
        }
        return n;
    }

    void renderToKinemage(Sequence sequence, PrintStream printStream) {
        printStream.println("@kinemage");
        printStream.println("@onewidth");
        printStream.println("@flat");
        int n = 0;
        boolean bl = false;
        Iterator iterator = this.inputFiles.iterator();
        while (iterator.hasNext()) {
            printStream.println("@" + ++n + "aspect {" + ((File)iterator.next()).getName() + "}");
        }
        printStream.println("@group {connections}");
        printStream.println("@subgroup {connections} nobutton");
        printStream.println("@vectorlist {links} color= gray");
        this.renderConnections(sequence, printStream);
        printStream.println("@group {sequences}");
        printStream.println("@subgroup {sequences} nobutton");
        printStream.println("@balllist {balls} color= white radius= 0.005");
        this.renderNodeBall(sequence, printStream);
    }

    void renderNodeBall(Sequence sequence, PrintStream printStream) {
        double d = sequence.getX();
        double d2 = sequence.getY();
        printStream.print("{" + sequence + "} (");
        for (int i = 0; i < this.inputFiles.size(); ++i) {
            if (sequence.flags.get(i)) {
                printStream.print(COLOR_CODES.charAt(i % COLOR_CODES.length()));
                continue;
            }
            printStream.print("Z");
        }
        printStream.println(") " + df.format(d) + " " + df.format(d2) + " 0");
        if (sequence.child1 != null) {
            this.renderNodeBall(sequence.child1, printStream);
        }
        if (sequence.child2 != null) {
            this.renderNodeBall(sequence.child2, printStream);
        }
    }

    void renderConnections(Sequence sequence, PrintStream printStream) {
        int n;
        double d;
        double d2;
        double d3 = sequence.getX();
        double d4 = sequence.getY();
        if (sequence.child1 != null) {
            d2 = sequence.child1.getX();
            d = sequence.child1.getY();
            printStream.println("{" + sequence + "}P " + df.format(d3) + " " + df.format(d4) + " 0");
            printStream.print("{" + sequence.child1 + "} (");
            for (n = 0; n < this.inputFiles.size(); ++n) {
                if (sequence.child1.flags.get(n)) {
                    printStream.print(COLOR_CODES.charAt(n % COLOR_CODES.length()));
                    continue;
                }
                printStream.print("X");
            }
            printStream.println(") " + df.format(d2) + " " + df.format(d) + " 0");
        }
        if (sequence.child2 != null) {
            d2 = sequence.child2.getX();
            d = sequence.child2.getY();
            printStream.println("{" + sequence + "}P " + df.format(d3) + " " + df.format(d4) + " 0");
            printStream.print("{" + sequence.child2 + "} (");
            for (n = 0; n < this.inputFiles.size(); ++n) {
                if (sequence.child2.flags.get(n)) {
                    printStream.print(COLOR_CODES.charAt(n % COLOR_CODES.length()));
                    continue;
                }
                printStream.print("X");
            }
            printStream.println(") " + df.format(d2) + " " + df.format(d) + " 0");
        }
        if (sequence.child1 != null) {
            this.renderConnections(sequence.child1, printStream);
        }
        if (sequence.child2 != null) {
            this.renderConnections(sequence.child2, printStream);
        }
    }

    public void Main() throws IOException {
        int n;
        int n2;
        Object object;
        Sequence[] sequenceArray;
        if (this.inputFiles.isEmpty()) {
            sequenceArray = this.loadSequences(new InputStream[]{System.in});
        } else {
            object = new InputStream[this.inputFiles.size()];
            for (n2 = 0; n2 < ((InputStream[])object).length; ++n2) {
                object[n2] = new FileInputStream((File)this.inputFiles.get(n2));
            }
            sequenceArray = this.loadSequences((InputStream[])object);
        }
        object = new double[sequenceArray.length][sequenceArray.length];
        for (n2 = 0; n2 < sequenceArray.length; ++n2) {
            object[n2][n2] = (InputStream)-1.7976931348623157E308;
            for (n = n2 + 1; n < sequenceArray.length; ++n) {
                int n3 = this.blosumScore(sequenceArray[n2], sequenceArray[n]);
                double d = n3;
                object[n][n2] = (InputStream)d;
                object[n2][n] = (InputStream)d;
                this.maxPairwiseBlosum = Math.max(n3, this.maxPairwiseBlosum);
            }
        }
        Sequence sequence = null;
        this.prevHeight = 1;
        block3: while (true) {
            System.err.print(".");
            int n4 = -1;
            int n5 = -1;
            Object object2 = -1.7976931348623157E308;
            for (n2 = 0; n2 < sequenceArray.length; ++n2) {
                for (n = n2 + 1; n < sequenceArray.length; ++n) {
                    if (!(object[n2][n] > object2)) continue;
                    object2 = object[n2][n];
                    n4 = n2;
                    n5 = n;
                }
            }
            if (object2 == -1.7976931348623157E308) break;
            Sequence sequence2 = sequenceArray[n4];
            Sequence sequence3 = sequenceArray[n5];
            sequenceArray[n4] = sequence = new Sequence(sequence2, sequence3);
            sequence.index = n4;
            sequenceArray[n5] = null;
            n2 = 0;
            while (true) {
                if (n2 >= sequenceArray.length) continue block3;
                if (n2 != n4) {
                    double d = ((double)sequence2.weight * object[n2][n4] + (double)sequence3.weight * object[n2][n5]) / (double)(sequence2.weight + sequence3.weight);
                    object[n4][n2] = (InputStream)d;
                    object[n2][n4] = (InputStream)d;
                }
                object[n5][n2] = (InputStream)-1.7976931348623157E308;
                object[n2][n5] = (InputStream)-1.7976931348623157E308;
                ++n2;
            }
            break;
        }
        System.err.println();
        this.prevX = 0;
        sequence.calculatePositions();
        this.prevX += this.blosumScore(this.firstLeaf, this.prevLeaf);
        this.renderToKinemage(sequence, System.out);
    }

    public static void main(String[] stringArray) {
        SequenceTree sequenceTree = new SequenceTree();
        try {
            sequenceTree.parseArguments(stringArray);
            sequenceTree.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            sequenceTree.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println();
            System.err.println("*** I/O error: " + iOException.getMessage());
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SequenceTree.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SequenceTree.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.minimize.SequenceTree");
        System.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        this.inputFiles.add(new File(string));
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    static class SeqTracker {
        Map[] maps;

        public SeqTracker(SeqTracker seqTracker, SeqTracker seqTracker2) {
            this.maps = new Map[seqTracker.length()];
            for (int i = 0; i < this.length(); ++i) {
                this.maps[i] = new HashMap(seqTracker.maps[i]);
                for (Map.Entry entry : seqTracker2.maps[i].entrySet()) {
                    String string = (String)entry.getKey();
                    Integer n = (Integer)entry.getValue();
                    Integer n2 = (Integer)this.maps[i].get(string);
                    if (n2 == null) {
                        n2 = new Integer(0);
                    }
                    this.maps[i].put(string, new Integer(n + n2));
                }
            }
        }

        public SeqTracker(String string) {
            this.maps = new Map[string.length()];
            for (int i = 0; i < this.length(); ++i) {
                this.maps[i] = new HashMap();
                this.maps[i].put(string.substring(i, i + 1), new Integer(1));
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.length(); ++i) {
                Map map = this.maps[i];
                if (map.size() == 1) {
                    stringBuffer.append(map.keySet().iterator().next());
                    continue;
                }
                stringBuffer.append("[");
                boolean bl = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(entry.getKey());
                    stringBuffer.append(entry.getValue());
                }
                stringBuffer.append("]");
            }
            return stringBuffer.toString();
        }

        public int length() {
            return this.maps.length;
        }
    }

    class Sequence {
        Sequence child1 = null;
        Sequence child2 = null;
        String seq = null;
        SeqTracker tracker = null;
        BitSet flags = new BitSet();
        int index = -1;
        int weight = 1;
        int height = 0;
        int depth = 0;
        double minx = 0.0;
        double maxx = 360.0;

        public Sequence(String string) {
            this.seq = string;
            this.tracker = new SeqTracker(this.seq);
        }

        public Sequence(Sequence sequence, Sequence sequence2) {
            this.child1 = sequence;
            this.child2 = sequence2;
            this.weight = this.child1.weight + this.child2.weight;
            this.height = SequenceTree.this.prevHeight++;
            this.flags.clear();
            this.flags.or(this.child1.flags);
            this.flags.or(this.child2.flags);
            this.tracker = new SeqTracker(this.child1.tracker, this.child2.tracker);
        }

        public String toString() {
            return this.tracker.toString();
        }

        public void calculatePositions() {
            if (this.child1 == null || this.child2 == null) {
                this.height = 0;
            } else {
                double d = (this.minx + this.maxx) / 2.0;
                this.child1.minx = this.minx;
                this.child1.maxx = d;
                this.child1.depth = this.depth + 1;
                this.child1.calculatePositions();
                this.child2.minx = d;
                this.child2.maxx = this.maxx;
                this.child2.depth = this.depth + 1;
                this.child2.calculatePositions();
                this.height = Math.max(this.child1.height, this.child2.height) + 1;
            }
            if (SequenceTree.this.firstLeaf == null) {
                SequenceTree.this.prevLeaf = SequenceTree.this.firstLeaf = this;
            }
        }

        private double getRawX() {
            return (this.minx + this.maxx) / 2.0;
        }

        public double getX() {
            double d = (double)this.depth / Math.max((double)(this.depth + this.height), 1.0);
            double d2 = Math.toRadians(this.getRawX());
            return d * Math.cos(d2);
        }

        public double getY() {
            double d = (double)this.depth / Math.max((double)(this.depth + this.height), 1.0);
            double d2 = Math.toRadians(this.getRawX());
            return d * Math.sin(d2);
        }
    }
}

