/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.LogViewer;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.util.SoftLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import king.AxisChooser;
import king.GroupEditor;
import king.HTMLHelp;
import king.KMessage;
import king.KinCanvas;
import king.KinTree;
import king.KinfileIO;
import king.KingMain;
import king.KingPrefs;
import king.ParaParams;
import king.PointFinder;
import king.PrefsEditor;
import king.ToolBox;
import king.UIDisplayMenu;
import king.UIText;
import king.ViewEditor;
import king.core.KView;
import king.core.Kinemage;

public class UIMenus
implements KMessage.Subscriber {
    static final DecimalFormat df = new DecimalFormat("###,###,##0");
    KingMain kMain;
    JMenuBar menubar;
    UIDisplayMenu displayMenu;
    JFileChooser fileChooser = null;
    SuffixFileFilter fileFilter;
    PointFinder finder;
    ViewEditor viewEditor;
    JMenu oldViewMenu = null;
    JMenu fileMenu;
    JMenu toolsMenu;
    static final long REDO_MENUS_P = 28L;
    static final int REDO_MENUS_K = 393216;

    public UIMenus(KingMain kingMain) {
        this.kMain = kingMain;
        try {
            this.fileFilter = new SuffixFileFilter("Kinemage files (*.kin)");
            this.fileFilter.addSuffix(".kin");
            this.fileFilter.addSuffix(".kip");
            this.fileFilter.addSuffix(".kip1");
            this.fileFilter.addSuffix(".kip2");
            this.fileFilter.addSuffix(".kip3");
            this.fileFilter.addSuffix(".kip4");
            this.fileFilter.addSuffix(".kip5");
            this.fileFilter.addSuffix(".kip6");
            this.fileFilter.addSuffix(".kip7");
            this.fileFilter.addSuffix(".kip8");
            this.fileFilter.addSuffix(".kip9");
            this.fileChooser = new JFileChooser();
            String string = System.getProperty("user.dir");
            if (string != null) {
                this.fileChooser.setCurrentDirectory(new File(string));
            }
            this.fileChooser.addChoosableFileFilter(this.fileFilter);
            this.fileChooser.setFileFilter(this.fileFilter);
        }
        catch (SecurityException securityException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            if (!(exceptionInInitializerError.getCause() instanceof AccessControlException)) {
                throw exceptionInInitializerError;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.finder = new PointFinder(this.kMain);
        this.viewEditor = new ViewEditor(this.kMain);
        this.buildMenus();
        this.kMain.subscribe(this);
    }

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    void buildMenus() {
        ToolBox toolBox;
        JMenu jMenu;
        this.menubar = new JMenuBar();
        this.fileMenu = jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.menubar.add(jMenu);
        this.rebuildFileMenu();
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        this.menubar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("Find point...", null, this, "onEditFind"));
        jMenuItem.setMnemonic(70);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Find next", null, this, "onEditFindNext"));
        jMenuItem.setMnemonic(78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(new ReflectiveAction("Kinemage properties...", null, this, "onEditKinProps"));
        jMenuItem.setMnemonic(75);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Edit text...", null, this, "onEditText"));
        jMenuItem.setMnemonic(84);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Edit hierarchy...", null, this, "onEditHierarchy"));
        jMenuItem.setMnemonic(72);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(new ReflectiveAction("Configure KiNG...", null, this, "onEditConfigure"));
        jMenuItem.setMnemonic(67);
        jMenu.add(jMenuItem);
        this.rebuildViewsMenu();
        this.displayMenu = new UIDisplayMenu(this.kMain);
        this.menubar.add(this.displayMenu.getMenu());
        this.toolsMenu = jMenu = new JMenu("Tools");
        jMenu.setMnemonic(84);
        this.menubar.add(jMenu);
        this.rebuildToolsMenu();
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        this.menubar.add(jMenu);
        jMenuItem = new JMenuItem(new ReflectiveAction("User manual...", null, this, "onHelpManual"));
        jMenuItem.setMnemonic(77);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Tools");
        jMenu2.setMnemonic(84);
        jMenu.add(jMenu2);
        KinCanvas kinCanvas = this.kMain.getCanvas();
        if (kinCanvas != null && (toolBox = kinCanvas.getToolBox()) != null) {
            toolBox.addPluginsToHelpMenu(jMenu2);
        }
        jMenuItem = new JMenuItem(new ReflectiveAction("Keyboard shortcuts...", null, this, "onHelpKeyboardShortcuts"));
        jMenuItem.setMnemonic(83);
        jMenu.add(jMenuItem);
        jMenu2 = new JMenu("Built-in kinemages");
        jMenu2.setMnemonic(75);
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem(new ReflectiveAction("Internal palette", null, this, "onHelpKinPalette"));
        jMenuItem.setMnemonic(80);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Color cone", null, this, "onHelpKinCone"));
        jMenuItem.setMnemonic(67);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Falling teddy bear", null, this, "onHelpKinBear"));
        jMenuItem.setMnemonic(66);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Error log...", null, this, "onHelpLog"));
        jMenuItem.setMnemonic(69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("About KiNG...", null, this, "onHelpAbout"));
        jMenuItem.setMnemonic(65);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
    }

    public void rebuildFileMenu() {
        JMenu jMenu;
        ToolBox toolBox;
        KinCanvas kinCanvas;
        JMenuItem jMenuItem;
        JMenu jMenu2 = this.fileMenu;
        jMenu2.removeAll();
        boolean bl = this.kMain.isTrusted();
        if (!this.kMain.isApplet()) {
            jMenuItem = new JMenuItem(new ReflectiveAction("New KiNG window", null, this, "onFileNewKing"));
            jMenuItem.setMnemonic(78);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, KingMain.MENU_ACCEL_MASK));
            jMenu2.add(jMenuItem);
            jMenu2.addSeparator();
        }
        if (bl) {
            jMenuItem = new JMenuItem(new ReflectiveAction("Open file...", null, this, "onFileOpen"));
            jMenuItem.setMnemonic(79);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, KingMain.MENU_ACCEL_MASK));
            jMenu2.add(jMenuItem);
        }
        if (this.kMain.isApplet()) {
            jMenuItem = new JMenuItem(new ReflectiveAction("Open URL...", null, this, "onFileOpenURL"));
            if (!bl) {
                jMenuItem.setMnemonic(79);
            }
            if (!bl) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, KingMain.MENU_ACCEL_MASK));
            }
            jMenu2.add(jMenuItem);
        }
        if (bl) {
            jMenuItem = new JMenuItem(new ReflectiveAction("Append file...", null, this, "onFileMerge"));
            jMenuItem.setMnemonic(65);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, KingMain.MENU_ACCEL_MASK));
            jMenu2.add(jMenuItem);
        }
        if (this.kMain.isApplet()) {
            jMenuItem = new JMenuItem(new ReflectiveAction("Append URL...", null, this, "onFileMergeURL"));
            if (!bl) {
                jMenuItem.setMnemonic(65);
            }
            if (!bl) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, KingMain.MENU_ACCEL_MASK));
            }
            jMenu2.add(jMenuItem);
        }
        if (bl && (kinCanvas = this.kMain.getCanvas()) != null && (toolBox = kinCanvas.getToolBox()) != null) {
            jMenu = new JMenu("Import");
            jMenu.setMnemonic(73);
            toolBox.addPluginsToSpecialMenu("<import>", jMenu);
            if (jMenu.getItemCount() > 0) {
                jMenu2.add(jMenu);
            }
        }
        jMenuItem = new JMenuItem(new ReflectiveAction("Close", null, this, "onFileClose"));
        jMenuItem.setMnemonic(67);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Close all", null, this, "onFileCloseAll"));
        jMenuItem.setMnemonic(76);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, KingMain.MENU_ACCEL_MASK));
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        if (bl) {
            jMenuItem = new JMenuItem(new ReflectiveAction("Save as...", null, this, "onFileSaveAs"));
            jMenuItem.setMnemonic(83);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, KingMain.MENU_ACCEL_MASK));
            jMenu2.add(jMenuItem);
        }
        if (this.kMain.isApplet() && this.kMain.getApplet().getParameter("kinfileSaveHandler") != null) {
            jMenuItem = new JMenuItem(new ReflectiveAction("Network save...", null, this, "onFileSaveAsURL"));
            if (!bl) {
                jMenuItem.setMnemonic(83);
            }
            if (!bl) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, KingMain.MENU_ACCEL_MASK));
            }
            jMenu2.add(jMenuItem);
        }
        if (bl && (kinCanvas = this.kMain.getCanvas()) != null && (toolBox = kinCanvas.getToolBox()) != null) {
            jMenu = new JMenu("Export");
            jMenu.setMnemonic(69);
            toolBox.addPluginsToSpecialMenu("<export>", jMenu);
            if (jMenu.getItemCount() > 0) {
                jMenu2.add(jMenu);
            }
        }
        jMenuItem = new JMenuItem(new ReflectiveAction("Print...", null, this, "onFilePrint"));
        jMenuItem.setMnemonic(80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, KingMain.MENU_ACCEL_MASK));
        jMenu2.add(jMenuItem);
        if (!this.kMain.isApplet()) {
            jMenu2.addSeparator();
            jMenuItem = new JMenuItem(new ReflectiveAction("Exit", null, this, "onFileExit"));
            jMenuItem.setMnemonic(88);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, KingMain.MENU_ACCEL_MASK));
            jMenu2.add(jMenuItem);
        }
    }

    public void rebuildViewsMenu() {
        JMenu jMenu = new JMenu("Views");
        jMenu.setMnemonic(86);
        ButtonGroup buttonGroup = new ButtonGroup();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("Save current view", null, this, "onViewSave"));
            jMenuItem.setMnemonic(83);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, KingMain.MENU_ACCEL_MASK));
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(new ReflectiveAction("Edit saved views...", null, this, "onViewEdit"));
            jMenuItem.setMnemonic(69);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, KingMain.MENU_ACCEL_MASK | 1));
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(new ReflectiveAction("Choose viewing axes...", null, this, "onViewChooseAxes"));
            jMenuItem.setMnemonic(67);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(new ReflectiveAction("Parallel coordinates", null, this, "onViewParallelCoords"));
            jMenuItem.setMnemonic(80);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(47, 0));
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
            Serializable serializable = jMenu;
            Iterator<KView> iterator = kinemage.getViewList().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                Serializable serializable2;
                if (n != 1 && n % 25 == 1) {
                    serializable2 = new JMenu("More views");
                    ((JMenu)serializable).add((JMenuItem)serializable2);
                    serializable = serializable2;
                }
                serializable2 = iterator.next();
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ViewAction(n, (KView)serializable2));
                buttonGroup.add(jRadioButtonMenuItem);
                ((JMenu)serializable).add(jRadioButtonMenuItem);
                ++n;
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem("No views available");
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
        if (this.oldViewMenu != null) {
            int n = this.menubar.getComponentIndex(this.oldViewMenu);
            this.menubar.remove(this.oldViewMenu);
            this.menubar.add((Component)jMenu, n);
        } else {
            this.menubar.add(jMenu);
        }
        this.menubar.revalidate();
        this.oldViewMenu = jMenu;
    }

    public void rebuildToolsMenu() {
        ToolBox toolBox;
        JMenu jMenu = this.toolsMenu;
        jMenu.removeAll();
        JCheckBoxMenuItem jCheckBoxMenuItem = this.kMain.getCanvas().getToolBox().services.doFlatland;
        jCheckBoxMenuItem.setMnemonic(76);
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 0));
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.kMain.getCanvas().getToolBox().services.doXYZ;
        jCheckBoxMenuItem.setMnemonic(88);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.kMain.getCanvas().getToolBox().services.doMeasureAll;
        jCheckBoxMenuItem.setMnemonic(77);
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.kMain.getCanvas().getToolBox().services.doObjectPick;
        jCheckBoxMenuItem.setMnemonic(79);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.kMain.getCanvas().getToolBox().services.doSuperpick;
        jCheckBoxMenuItem.setMnemonic(83);
        jMenu.add(jCheckBoxMenuItem);
        KinCanvas kinCanvas = this.kMain.getCanvas();
        if (kinCanvas != null && (toolBox = kinCanvas.getToolBox()) != null) {
            jMenu.addSeparator();
            toolBox.addPluginsToToolsMenu(jMenu);
        }
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("Customize Tools menu...", null, this, "onEditConfigurePlugins"));
        jMenuItem.setMnemonic(67);
        jMenu.add(jMenuItem);
    }

    public void reporter(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "This feature has not been implemented yet.", "Sorry!", 1);
    }

    public void onFileNewKing(ActionEvent actionEvent) {
        new KingMain(new String[0]).Main();
    }

    public void onFileOpen(ActionEvent actionEvent) {
        KinfileIO kinfileIO = this.kMain.getKinIO();
        kinfileIO.askLoadFile(null);
    }

    public void onFileOpenURL(ActionEvent actionEvent) {
        KinfileIO kinfileIO = this.kMain.getKinIO();
        if (this.kMain.isApplet()) {
            kinfileIO.askLoadURL(null);
        }
    }

    public void onFileMerge(ActionEvent actionEvent) {
        KinfileIO kinfileIO = this.kMain.getKinIO();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            kinemage = new Kinemage("Kinemage #1");
            if (kinfileIO.askLoadFile(kinemage)) {
                this.kMain.getStable().append(Arrays.asList(kinemage));
            }
        } else {
            kinfileIO.askLoadFile(kinemage);
        }
    }

    public void onFileMergeURL(ActionEvent actionEvent) {
        KinfileIO kinfileIO = this.kMain.getKinIO();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            kinemage = new Kinemage("Kinemage #1");
            if (this.kMain.isApplet() && kinfileIO.askLoadURL(kinemage)) {
                this.kMain.getStable().append(Arrays.asList(kinemage));
            }
        } else if (this.kMain.isApplet()) {
            kinfileIO.askLoadURL(kinemage);
        }
    }

    public void onFileClose(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null && kinemage.isModified()) {
            int n = JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This kinemage has been modified.\nDo you want to save it before closing?", "Save before closing?", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.onFileSaveAs(actionEvent);
            }
        }
        this.kMain.getStable().closeCurrent();
    }

    public void onFileCloseAll(ActionEvent actionEvent) {
        boolean bl = false;
        for (Kinemage kinemage : this.kMain.getStable().getKins()) {
            if (!kinemage.isModified()) continue;
            bl = true;
        }
        if (bl) {
            int n = JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "One or more open kinemages have been modified.\nDo you want to save them before closing?", "Save before closing?", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.onFileSaveAs(actionEvent);
            }
        }
        this.kMain.getStable().closeAll();
    }

    public void onFileSaveAs(ActionEvent actionEvent) {
        KinfileIO kinfileIO = this.kMain.getKinIO();
        int n = this.kMain.getStable().getKins().size();
        if (n > 1) {
            JRadioButton jRadioButton = new JRadioButton(n == 2 ? "Save both in one file" : "Save all " + n + " in one file", true);
            JRadioButton jRadioButton2 = new JRadioButton("Save only the currently selected kinemage", false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            int n2 = JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), new Object[]{"There are currently " + n + " open kinemages.", "What do you want to do?", jRadioButton, jRadioButton2}, "Saving multiple kinemages", 2, 3);
            if (n2 != 1 && n2 != 2) {
                if (jRadioButton.isSelected()) {
                    kinfileIO.askSaveFile();
                } else if (jRadioButton2.isSelected()) {
                    kinfileIO.askSaveFile(this.kMain.getKinemage());
                }
            }
        } else {
            kinfileIO.askSaveFile();
        }
    }

    public void onFileSaveAsURL(ActionEvent actionEvent) {
        KinfileIO kinfileIO = this.kMain.getKinIO();
        if (this.kMain.isApplet()) {
            kinfileIO.askSaveURL();
        }
    }

    public void onFilePrint(ActionEvent actionEvent) {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.kMain.getCanvas());
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(SoftLog.err);
        }
    }

    public void onFileExit(ActionEvent actionEvent) {
        this.onFileCloseAll(actionEvent);
        if (this.kMain.getStable().getKins().size() == 0) {
            this.kMain.shutdown();
        }
    }

    public void onEditFind(ActionEvent actionEvent) {
        this.finder.show();
    }

    public void onEditFindNext(ActionEvent actionEvent) {
        if (!this.finder.findNext()) {
            this.onEditFind(actionEvent);
        }
    }

    public void onEditText(ActionEvent actionEvent) {
        UIText uIText = this.kMain.getTextWindow();
        if (uIText != null) {
            uIText.onPopupButton(null);
        }
    }

    public void onEditKinProps(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        GroupEditor groupEditor = new GroupEditor(this.kMain, this.kMain.getTopWindow());
        groupEditor.editKinemage(kinemage);
    }

    public void onEditHierarchy(ActionEvent actionEvent) {
        KinTree kinTree = this.kMain.getKinTree();
        if (kinTree != null) {
            kinTree.show();
        }
    }

    public void onEditConfigure(ActionEvent actionEvent) {
        PrefsEditor prefsEditor = new PrefsEditor(this.kMain);
        prefsEditor.edit();
    }

    public void onEditConfigurePlugins(ActionEvent actionEvent) {
        PrefsEditor prefsEditor = new PrefsEditor(this.kMain);
        prefsEditor.editPlugins();
    }

    public void onViewSave(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog(this.kMain.getTopWindow(), "Name for this view:", "Save view", -1);
        if (string == null) {
            return;
        }
        KView kView = this.kMain.getView();
        if (kView == null) {
            return;
        }
        kView = kView.clone();
        kView.setName(string);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        kinemage.addView(kView);
        kinemage.setModified(true);
        this.rebuildViewsMenu();
    }

    public void onViewEdit(ActionEvent actionEvent) {
        this.viewEditor.editViews();
    }

    public void onViewChooseAxes(ActionEvent actionEvent) {
        new AxisChooser(this.kMain, this.kMain.getKinemage());
    }

    public void onViewParallelCoords(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        String string = ParaParams.class.getName() + ".instance";
        ParaParams paraParams = (ParaParams)kinemage.metadata.get(string);
        if (paraParams == null) {
            paraParams = new ParaParams(this.kMain, kinemage);
            kinemage.metadata.put(string, paraParams);
        }
        paraParams.swap();
    }

    public void onHelpManual(ActionEvent actionEvent) {
        URL uRL = this.getClass().getResource("html/king-manual.html");
        if (uRL != null) {
            new HTMLHelp(this.kMain, uRL).show();
        } else {
            SoftLog.err.println("Couldn't find the specified resource!");
        }
    }

    public void onHelpKeyboardShortcuts(ActionEvent actionEvent) {
        URL uRL = this.getClass().getResource("html/kbd-shortcuts.html");
        if (uRL != null) {
            new HTMLHelp(this.kMain, uRL).show();
        } else {
            SoftLog.err.println("Couldn't find the specified resource!");
        }
    }

    public void onHelpKinPalette(ActionEvent actionEvent) {
        URL uRL = this.getClass().getResource("kins/pal5.kin");
        if (uRL != null) {
            this.kMain.getKinIO().loadURL(uRL, null);
        } else {
            SoftLog.err.println("Couldn't find the specified resource!");
        }
    }

    public void onHelpKinCone(ActionEvent actionEvent) {
        URL uRL = this.getClass().getResource("kins/cone.kin");
        if (uRL != null) {
            this.kMain.getKinIO().loadURL(uRL, null);
        } else {
            SoftLog.err.println("Couldn't find the specified resource!");
        }
    }

    public void onHelpKinBear(ActionEvent actionEvent) {
        URL uRL = this.getClass().getResource("kins/fallingbear.kin");
        if (uRL != null) {
            this.kMain.getKinIO().loadURL(uRL, null);
        } else {
            SoftLog.err.println("Couldn't find the specified resource!");
        }
    }

    public void onHelpLog(ActionEvent actionEvent) {
        new LogViewer(this.kMain.getTopWindow(), "KiNG error log", SoftLog.err);
    }

    public void onHelpAbout(ActionEvent actionEvent) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        KingPrefs kingPrefs = this.kMain.getPrefs();
        Runtime runtime = Runtime.getRuntime();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        arrayList.add(new JLabel("KiNG (Kinetic Image, Next Generation)"));
        arrayList.add(new JLabel("Version " + this.kMain.getPrefs().getString("version")));
        arrayList.add(new JLabel("Build " + this.kMain.getPrefs().getString("buildnum")));
        try {
            if (kingPrefs.jarFileDirectory != null) {
                arrayList.add(new JLabel("Installed in " + kingPrefs.jarFileDirectory.getCanonicalPath()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        arrayList.add(new JLabel(" "));
        arrayList.add(new JLabel("Installed Plugins:"));
        Enumeration<?> enumeration = kingPrefs.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).matches(".* version")) continue;
            String string = ((String)object).substring(0, ((String)object).lastIndexOf(" "));
            String string2 = kingPrefs.getProperty(string + " buildnum");
            arrayList.add(new JLabel((String)object + ": " + kingPrefs.getProperty((String)object) + "." + string2));
        }
        arrayList.add(new JLabel(" "));
        arrayList.add(new JLabel("Created in the Richardson lab at Duke University"));
        arrayList.add(new JLabel("http://kinemage.biochem.duke.edu"));
        arrayList.add(new JLabel(" "));
        arrayList.add(new JLabel("Copyright (C) 2002-2009 Ian W. Davis and Vincent B. Chen"));
        arrayList.add(new JLabel("All rights reserved."));
        arrayList.add(new JLabel(" "));
        arrayList.add(new JLabel("Using Java " + System.getProperty("java.version", "(unknown version)")));
        try {
            arrayList.add(new JLabel(System.getProperty("java.home", "(path not found)")));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            n3 = (int)(runtime.totalMemory() >> 10);
            n4 = (int)(runtime.freeMemory() >> 10);
            if (n3 == n && n4 == n2) break;
            System.gc();
            n = n3;
            n2 = n4;
        }
        int n5 = n3 - n4;
        arrayList.add(new JLabel(" "));
        object = new JProgressBar(0, n3);
        ((JProgressBar)object).setStringPainted(true);
        ((JProgressBar)object).setString(df.format(n5) + "kb / " + df.format(n3) + "kb");
        ((JProgressBar)object).setValue(n5);
        arrayList.add(object);
        JOptionPane.showMessageDialog(this.kMain.getTopWindow(), arrayList.toArray(), "About KiNG", 1);
    }

    public static String showMem() {
        Runtime runtime = Runtime.getRuntime();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 10; ++i) {
            n3 = (int)(runtime.totalMemory() >> 10);
            n4 = (int)(runtime.freeMemory() >> 10);
            if (n3 == n && n4 == n2) break;
            System.gc();
            n = n3;
            n2 = n4;
        }
        int n5 = n3 - n4;
        return df.format(n5) + "kb / " + df.format(n3) + "kb";
    }

    public void deliverMessage(KMessage kMessage) {
        if (kMessage.testProg(28L) || kMessage.testKin(393216)) {
            this.rebuildViewsMenu();
            this.displayMenu.rebuildAspectsMenu();
            this.finder.clearSearch();
        }
        if (kMessage.testProg(64L)) {
            this.rebuildFileMenu();
            this.rebuildToolsMenu();
        }
    }

    class ViewAction
    extends AbstractAction {
        KView view;

        public ViewAction(int n, KView kView) {
            super(n + " " + kView.getName());
            this.view = kView;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UIMenus.this.kMain.setView(this.view);
        }
    }
}

