/*
 * Decompiled with CFR 0.152.
 */
package king.points;

import driftwood.r3.Transform;
import java.awt.Color;
import king.core.Engine;
import king.core.Engine2D;
import king.core.KPaint;
import king.core.KPoint;
import king.points.AbstractPoint;

public class RingPoint
extends AbstractPoint {
    public float r0 = 0.0f;
    public float r = 0.0f;

    public RingPoint(String string) {
        super(string);
    }

    public void setRadius(float f) {
        if (f >= 0.0f) {
            this.r0 = f;
        }
        this.fireKinChanged(512);
    }

    public float getRadius() {
        return this.r0;
    }

    public float getDrawRadius() {
        return this.r;
    }

    public void doTransform(Engine engine, Transform transform) {
        throw new UnsupportedOperationException(this.getClass() + ".doTransform() requires a zoom factor");
    }

    public void doTransform(Engine engine, Transform transform, double d) {
        if (this.parent.getScreen()) {
            double d2 = engine.pickingRect.getWidth();
            double d3 = engine.pickingRect.getHeight();
            this.r = this.r0 <= 0.0f && this.parent != null ? this.parent.getRadius() * (float)(Math.min(d2, d3) / 400.0) : this.r0 * (float)(Math.min(d2, d3) / 400.0);
            super.doTransform(engine, transform, d);
        } else {
            this.r = this.r0 <= 0.0f && this.parent != null ? (float)((double)this.parent.getRadius() * d) : (float)((double)this.r0 * d);
            transform.transform(this, engine.work1);
            this.setDrawXYZ(engine.work1);
            if (engine.usePerspective) {
                this.r = (float)((double)this.r * (engine.perspDist / (engine.perspDist - (double)this.z)));
            }
            engine.addPaintable(this, this.z);
        }
    }

    public KPoint isPickedBy(float f, float f2, float f3, boolean bl) {
        float f4 = this.x - f;
        float f5 = this.y - f2;
        float f6 = f4 * f4 + f5 * f5;
        float f7 = this.r - f3;
        if (f7 > 0.0f) {
            f7 *= f7;
        }
        float f8 = this.r + f3;
        f8 *= f8;
        if (f7 <= f6 && f6 <= f8) {
            return this;
        }
        return null;
    }

    public void paint2D(Engine2D engine2D) {
        KPaint kPaint = this.getDrawingColor(engine2D);
        if (kPaint.isInvisible()) {
            return;
        }
        int n = this.parent == null ? 255 : this.parent.getAlpha();
        Color color = kPaint.getPaint(engine2D.backgroundMode, 1.0, engine2D.colorCue, n);
        double d = 2.0f * this.r;
        engine2D.painter.drawOval(color, this.calcLineWidth(engine2D), engine2D.widthCue, this.x, this.y, this.z, d, d);
    }

    protected int calcLineWidth(Engine engine) {
        if (engine.thinLines) {
            return 1;
        }
        if (this.parent != null) {
            return this.parent.getWidth();
        }
        return 2;
    }
}

