/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.CifReader;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import molikin.gui.MainGuiPane;
import molikin.logic.BallAndStickLogic;
import molikin.logic.Logic;
import molikin.logic.RibbonLogic;

public class Quickin {
    public static BallAndStickLogic getLotsLogic() {
        return Quickin.getLotsLogic(false);
    }

    public static BallAndStickLogic getLotsLogic(boolean bl) {
        BallAndStickLogic ballAndStickLogic = new BallAndStickLogic();
        ballAndStickLogic.doProtein = true;
        ballAndStickLogic.doNucleic = true;
        ballAndStickLogic.doHets = true;
        ballAndStickLogic.doIons = true;
        ballAndStickLogic.doWater = false;
        ballAndStickLogic.doPseudoBB = bl;
        ballAndStickLogic.doBackbone = true;
        ballAndStickLogic.doSidechains = true;
        ballAndStickLogic.doHydrogens = true;
        ballAndStickLogic.doDisulfides = true;
        ballAndStickLogic.doBallsOnCarbon = false;
        ballAndStickLogic.doBallsOnAtoms = false;
        ballAndStickLogic.colorBy = BallAndStickLogic.COLOR_BY_MC_SC;
        return ballAndStickLogic;
    }

    public static RibbonLogic getRibbonLogic() {
        RibbonLogic ribbonLogic = new RibbonLogic();
        ribbonLogic.doProtein = true;
        ribbonLogic.doNucleic = true;
        ribbonLogic.doUntwistRibbons = true;
        ribbonLogic.doDnaStyle = false;
        ribbonLogic.colorBy = RibbonLogic.COLOR_BY_RAINBOW;
        return ribbonLogic;
    }

    public static CoordinateFile readPDB(File file) throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(file);
        return coordinateFile;
    }

    public static CoordinateFile readCIF(File file) throws IOException {
        CifReader cifReader = new CifReader();
        CoordinateFile coordinateFile = cifReader.read(file);
        return coordinateFile;
    }

    public static void printKinemage(PrintWriter printWriter, CoordinateFile coordinateFile, Logic[] logicArray) {
        Quickin.printKinemage(printWriter, coordinateFile, logicArray, coordinateFile.getModels().size());
    }

    public static void printKinemage(PrintWriter printWriter, CoordinateFile coordinateFile, Logic[] logicArray, int n) {
        String string = "macromol";
        if (coordinateFile.getIdCode() != null) {
            string = coordinateFile.getIdCode();
        } else if (coordinateFile.getFile() != null) {
            string = coordinateFile.getFile().getName();
        }
        Collection collection = coordinateFile.getModels();
        boolean bl = collection.size() > 1 && n > 1;
        Iterator iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < n; ++i) {
            Model model = (Model)iterator.next();
            if (bl) {
                printWriter.println("@group {" + string + " " + model + "} dominant animate master= {all models}");
            }
            Set set = model.getChainIDs();
            int n2 = 0;
            for (String string2 : set) {
                if (model.getChain(string2) != null) {
                    if (bl) {
                        printWriter.println("@subgroup {chain" + string2 + "} dominant master= {chain" + string2 + "}");
                    } else {
                        printWriter.println("@group {" + string + " " + string2 + "} dominant");
                    }
                    String string3 = MainGuiPane.BACKBONE_COLORS[(bl ? i : n2) % MainGuiPane.BACKBONE_COLORS.length];
                    for (Logic logic : logicArray) {
                        logic.printKinemage(printWriter, model, model.getChain(string2), string, string3);
                    }
                }
                ++n2;
            }
        }
        printWriter.flush();
    }
}

