/*
 * Decompiled with CFR 0.152.
 */
package molikin.kingplugin;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.moldb2.CifReader;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.PdbReader;
import driftwood.util.SoftLog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import king.FileDropHandler;
import king.KingMain;
import king.Plugin;
import king.ToolBox;
import molikin.kingplugin.MolikinWindow;

public class MolikinPlugin
extends Plugin {
    SuffixFileFilter pdbFilter;
    SuffixFileFilter cifFilter;
    SuffixFileFilter allFilter;
    JFileChooser openChooser;
    JFrame frame;

    public MolikinPlugin(ToolBox toolBox) {
        super(toolBox);
        this.buildFilter();
        if (this.kMain.getApplet() == null) {
            this.buildFileChooser();
        }
        this.kMain.getFileDropHandler().addFileDropListener(new CoordFileOpen());
    }

    public void buildFilter() {
        this.allFilter = new SuffixFileFilter("PDB and mmCIF files");
        this.allFilter.addSuffix(".pdb");
        this.allFilter.addSuffix(".xyz");
        this.allFilter.addSuffix(".ent");
        this.allFilter.addSuffix(".cif");
        this.allFilter.addSuffix(".mmcif");
        this.allFilter.addSuffix(".pdb.gz");
        this.allFilter.addSuffix(".xyz.gz");
        this.allFilter.addSuffix(".ent.gz");
        this.allFilter.addSuffix(".cif.gz");
        this.allFilter.addSuffix(".mmcif.gz");
        this.pdbFilter = new SuffixFileFilter("Protein Data Bank (PDB) files");
        this.pdbFilter.addSuffix(".pdb");
        this.pdbFilter.addSuffix(".xyz");
        this.pdbFilter.addSuffix(".ent");
        this.pdbFilter.addSuffix(".pdb.gz");
        this.pdbFilter.addSuffix(".xyz.gz");
        this.pdbFilter.addSuffix(".ent.gz");
        this.cifFilter = new SuffixFileFilter("mmCIF files");
        this.cifFilter.addSuffix(".cif");
        this.cifFilter.addSuffix(".mmcif");
        this.cifFilter.addSuffix(".cif.gz");
        this.cifFilter.addSuffix(".mmcif.gz");
    }

    private void buildFileChooser() {
        String string = System.getProperty("user.dir");
        this.openChooser = new JFileChooser();
        this.openChooser.addChoosableFileFilter(this.allFilter);
        this.openChooser.addChoosableFileFilter(this.pdbFilter);
        this.openChooser.addChoosableFileFilter(this.cifFilter);
        this.openChooser.setFileFilter(this.allFilter);
        if (string != null) {
            this.openChooser.setCurrentDirectory(new File(string));
        }
    }

    public void onOpenFile(ActionEvent actionEvent) {
        String string = System.getProperty("user.dir");
        if (string != null) {
            this.openChooser.setCurrentDirectory(new File(string));
        }
        if (0 == this.openChooser.showOpenDialog(this.kMain.getTopWindow())) {
            try {
                File file = this.openChooser.getSelectedFile();
                if (file != null && file.exists()) {
                    if (this.cifFilter.accept(file)) {
                        this.doCIF(file);
                    } else {
                        this.doPDB(file);
                    }
                    System.setProperty("user.dir", file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An I/O error occurred while loading the file:\n" + iOException.getMessage(), "Sorry!", 0);
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    void doPDB(File file) throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(file);
        new MolikinWindow(this.parent, coordinateFile);
    }

    void doCIF(File file) throws IOException {
        CifReader cifReader = new CifReader();
        CoordinateFile coordinateFile = cifReader.read(file);
        new MolikinWindow(this.parent, coordinateFile);
    }

    public String toString() {
        return "Molecules (PDB, mmCIF)";
    }

    public JMenuItem getToolsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction(this.toString(), null, this, "onOpenFile"));
        jMenuItem.setMnemonic(73);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, KingMain.MENU_ACCEL_MASK));
        return jMenuItem;
    }

    public URL getHelpURL() {
        return null;
    }

    public String getHelpAnchor() {
        return null;
    }

    private class CoordFileOpen
    implements FileDropHandler.Listener {
        private CoordFileOpen() {
        }

        public String toString() {
            return "Open the file in Molikin";
        }

        public boolean canHandleDroppedFile(File file) {
            return MolikinPlugin.this.pdbFilter.accept(file) || MolikinPlugin.this.cifFilter.accept(file);
        }

        public void handleDroppedFile(File file) {
            try {
                if (MolikinPlugin.this.pdbFilter.accept(file)) {
                    MolikinPlugin.this.doPDB(file);
                } else if (MolikinPlugin.this.cifFilter.accept(file)) {
                    MolikinPlugin.this.doCIF(file);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }
}

