/*
 * Decompiled with CFR 0.152.
 */
package hless;

import hless.Str;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CBScatter {
    LineNumberReader in = null;
    PrintWriter out = null;

    List readCBDev(BufferedReader bufferedReader) {
        ArrayList<CBDatum> arrayList = new ArrayList<CBDatum>();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = Str.explode(string, ':');
                if (stringArray.length < 7) continue;
                try {
                    double d = Double.parseDouble(stringArray[5]);
                    double d2 = Math.toRadians(Double.parseDouble(stringArray[6]));
                    String string2 = stringArray[1];
                    String string3 = stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3] + " " + stringArray[4] + "; dev=" + stringArray[5];
                    arrayList.add(new CBDatum(string3, d, d2, string2));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    void doCBetaPlot(List list, PrintWriter printWriter) {
        Object object;
        try {
            String string;
            object = new LineNumberReader(new InputStreamReader(this.getClass().getResourceAsStream("/rc/cbeta/template.kin")));
            while ((string = ((LineNumberReader)object).readLine()) != null) {
                printWriter.println(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Possible error in copying template.");
        }
        catch (IOException iOException) {
            System.err.println("Possible error in copying template.");
        }
        printWriter.println("@subgroup {bullseye}");
        this.writeBullseyeRing(0.125f, "green", printWriter);
        this.writeBullseyeRing(0.25f, "yellow", printWriter);
        this.writeBullseyeRing(0.375f, "red", printWriter);
        this.writeBullseyeRing(0.5f, "hotpink", printWriter);
        printWriter.println("@subgroup {Cbeta dev}");
        printWriter.println("@dotlist {Cb scatter} color= white");
        object = list.iterator();
        while (object.hasNext()) {
            printWriter.println(object.next().toString());
        }
    }

    void writeBullseyeRing(float f, String string, PrintWriter printWriter) {
        int n = 100;
        double d = Math.PI * 2 / (double)n;
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        printWriter.println("@vectorlist {" + f + "} width= 1 color= " + string);
        printWriter.println("{" + f + "}P " + f + " 0.0 0.0");
        for (int i = 1; i <= n; ++i) {
            float f2 = f * (float)Math.cos((double)i * d);
            float f3 = f * (float)Math.sin((double)i * d);
            printWriter.println("{\"} " + decimalFormat.format(f2) + " " + decimalFormat.format(f3) + " 0.0");
        }
    }

    public static void main(String[] stringArray) {
        CBScatter cBScatter = new CBScatter();
        try {
            cBScatter.parseArguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cBScatter.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        cBScatter.Main();
    }

    public void Main() {
        List list = this.readCBDev(this.in);
        this.doCBetaPlot(list, this.out);
        this.out.close();
    }

    void parseArguments(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--")) {
                bl = false;
                linkedList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("-") && bl) {
                int n = stringArray[i].indexOf(61);
                if (n != -1) {
                    linkedList.add(stringArray[i].substring(0, n));
                    linkedList.add(stringArray[i].substring(n + 1));
                    continue;
                }
                linkedList.add(stringArray[i]);
                continue;
            }
            linkedList.add(stringArray[i]);
        }
        ListIterator listIterator = linkedList.listIterator();
        try {
            this.interpretArguments(listIterator);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("'" + listIterator.previous() + "' expected an argument");
        }
    }

    int getInt(Iterator iterator) {
        String string = iterator.next().toString();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not an integer");
        }
    }

    double getDouble(Iterator iterator) {
        String string = iterator.next().toString();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not a real number");
        }
    }

    LineNumberReader getReader(String string) {
        LineNumberReader lineNumberReader = null;
        if (string.equals("-")) {
            lineNumberReader = new LineNumberReader(new InputStreamReader(System.in));
        } else {
            try {
                lineNumberReader = new LineNumberReader(new FileReader(string));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("'" + string + "' is not a readable file or stream.");
            }
        }
        return lineNumberReader;
    }

    BufferedWriter getWriter(String string) {
        BufferedWriter bufferedWriter = null;
        if (string.equals("-")) {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        } else {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("'" + string + "' is not a writable file or stream.");
            }
        }
        return bufferedWriter;
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("/rc/CBScatter.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in '/rc/CBScatter.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("hless.CBScatter, version 0.47 (build 0_0)");
        System.err.println("Copyright (C) 2002 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArguments(Iterator iterator) {
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!string.startsWith("-") || !bl || string.equals("-")) {
                if (this.in == null) {
                    this.in = this.getReader(string);
                    continue;
                }
                if (this.out != null) continue;
                this.out = new PrintWriter(this.getWriter(string));
                continue;
            }
            if (string.equals("--")) {
                bl = false;
                continue;
            }
            if (string.equals("-help") || string.equals("-h")) {
                this.showHelp(true);
                System.exit(0);
                continue;
            }
            if (string.equals("-dummy_option")) continue;
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid argument.");
        }
        if (this.in == null) {
            this.in = this.getReader("-");
        }
        if (this.out == null) {
            this.out = new PrintWriter(this.getWriter("-"));
        }
    }

    static class CBDatum {
        static DecimalFormat df = new DecimalFormat("0.0##");
        String name;
        double mag;
        double dir;
        String altconf;

        public CBDatum(String string, double d, double d2, String string2) {
            this.name = string;
            this.mag = d;
            this.dir = d2;
            this.altconf = string2;
        }

        public String toString() {
            double d = this.mag * Math.cos(this.dir);
            double d2 = this.mag * Math.sin(this.dir);
            int n = 32;
            if (this.altconf != null && this.altconf.length() >= 1) {
                n = this.altconf.charAt(0);
            }
            String string = "";
            if (n == 98 || n == 66 || n == 50) {
                string = "pink";
            }
            return "{" + this.name + "} " + string + " " + df.format(d) + " " + df.format(d2) + " 0.0";
        }
    }
}

