# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.Directory do
  @moduledoc "A directory."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  @derive Dagger.Sync
  defstruct [:selection, :client]

  (
    @doc "Load the directory as a Dagger module\n\n\n\n## Optional Arguments\n\n* `source_subpath` - An optional subpath of the directory which contains the module's source code.\n\nThis is needed when the module code is in a subdirectory but requires parent directories to be loaded in order to execute. For example, the module source code may need a go.mod, project.toml, package.json, etc. file from a parent directory.\n\nIf not set, the module source code is loaded from the root of the directory."
    @spec as_module(t(), keyword()) :: Dagger.Module.t()
    def as_module(%__MODULE__{} = directory, optional_args \\ []) do
      selection = select(directory.selection, "asModule")

      selection =
        if is_nil(optional_args[:source_subpath]) do
          selection
        else
          arg(selection, "sourceSubpath", optional_args[:source_subpath])
        end

      %Dagger.Module{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Gets the difference between this directory and an another directory.\n\n## Required Arguments\n\n* `other` - Identifier of the directory to compare."
    @spec diff(t(), Dagger.Directory.t()) :: Dagger.Directory.t()
    def diff(%__MODULE__{} = directory, other) do
      selection = select(directory.selection, "diff")

      (
        {:ok, id} = Dagger.Directory.id(other)
        selection = arg(selection, "other", id)
      )

      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Retrieves a directory at the given path.\n\n## Required Arguments\n\n* `path` - Location of the directory to retrieve (e.g., \"/src\")."
    @spec directory(t(), Dagger.String.t()) :: Dagger.Directory.t()
    def directory(%__MODULE__{} = directory, path) do
      selection = select(directory.selection, "directory")
      selection = arg(selection, "path", path)
      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Builds a new Docker container from this directory.\n\n\n\n## Optional Arguments\n\n* `platform` - The platform to build.\n* `dockerfile` - Path to the Dockerfile to use (e.g., \"frontend.Dockerfile\").\n* `target` - Target build stage to build.\n* `build_args` - Build arguments to use in the build.\n* `secrets` - Secrets to pass to the build.\n\nThey will be mounted at /run/secrets/[secret-name]."
    @spec docker_build(t(), keyword()) :: Dagger.Container.t()
    def docker_build(%__MODULE__{} = directory, optional_args \\ []) do
      selection = select(directory.selection, "dockerBuild")

      selection =
        if is_nil(optional_args[:platform]) do
          selection
        else
          arg(selection, "platform", optional_args[:platform])
        end

      selection =
        if is_nil(optional_args[:dockerfile]) do
          selection
        else
          arg(selection, "dockerfile", optional_args[:dockerfile])
        end

      selection =
        if is_nil(optional_args[:target]) do
          selection
        else
          arg(selection, "target", optional_args[:target])
        end

      selection =
        if is_nil(optional_args[:build_args]) do
          selection
        else
          arg(selection, "buildArgs", optional_args[:build_args])
        end

      selection =
        if is_nil(optional_args[:secrets]) do
          selection
        else
          ids =
            optional_args[:secrets]
            |> Enum.map(fn value ->
              {:ok, id} = Dagger.Secret.id(value)
              id
            end)

          arg(selection, "secrets", ids)
        end

      %Dagger.Container{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Returns a list of files and directories at the given path.\n\n\n\n## Optional Arguments\n\n* `path` - Location of the directory to look at (e.g., \"/src\")."
    @spec entries(t(), keyword()) :: {:ok, [Dagger.String.t()]} | {:error, term()}
    def entries(%__MODULE__{} = directory, optional_args \\ []) do
      selection = select(directory.selection, "entries")

      selection =
        if is_nil(optional_args[:path]) do
          selection
        else
          arg(selection, "path", optional_args[:path])
        end

      execute(selection, directory.client)
    end
  )

  (
    @doc "Writes the contents of the directory to a path on the host.\n\n## Required Arguments\n\n* `path` - Location of the copied directory (e.g., \"logs/\")."
    @spec export(t(), Dagger.String.t()) :: {:ok, Dagger.Boolean.t()} | {:error, term()}
    def export(%__MODULE__{} = directory, path) do
      selection = select(directory.selection, "export")
      selection = arg(selection, "path", path)
      execute(selection, directory.client)
    end
  )

  (
    @doc "Retrieves a file at the given path.\n\n## Required Arguments\n\n* `path` - Location of the file to retrieve (e.g., \"README.md\")."
    @spec file(t(), Dagger.String.t()) :: Dagger.File.t()
    def file(%__MODULE__{} = directory, path) do
      selection = select(directory.selection, "file")
      selection = arg(selection, "path", path)
      %Dagger.File{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Returns a list of files and directories that matche the given pattern.\n\n## Required Arguments\n\n* `pattern` - Pattern to match (e.g., \"*.md\")."
    @spec glob(t(), Dagger.String.t()) :: {:ok, [Dagger.String.t()]} | {:error, term()}
    def glob(%__MODULE__{} = directory, pattern) do
      selection = select(directory.selection, "glob")
      selection = arg(selection, "pattern", pattern)
      execute(selection, directory.client)
    end
  )

  (
    @doc "A unique identifier for this Directory."
    @spec id(t()) :: {:ok, Dagger.DirectoryID.t()} | {:error, term()}
    def id(%__MODULE__{} = directory) do
      selection = select(directory.selection, "id")
      execute(selection, directory.client)
    end
  )

  (
    @doc "Creates a named sub-pipeline.\n\n## Required Arguments\n\n* `name` - Name of the sub-pipeline.\n\n## Optional Arguments\n\n* `description` - Description of the sub-pipeline.\n* `labels` - Labels to apply to the sub-pipeline."
    @spec pipeline(t(), Dagger.String.t(), keyword()) :: Dagger.Directory.t()
    def pipeline(%__MODULE__{} = directory, name, optional_args \\ []) do
      selection = select(directory.selection, "pipeline")
      selection = arg(selection, "name", name)

      selection =
        if is_nil(optional_args[:description]) do
          selection
        else
          arg(selection, "description", optional_args[:description])
        end

      selection =
        if is_nil(optional_args[:labels]) do
          selection
        else
          arg(selection, "labels", optional_args[:labels])
        end

      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Force evaluation in the engine."
    @spec sync(t()) :: {:ok, Dagger.DirectoryID.t()} | {:error, term()}
    def sync(%__MODULE__{} = directory) do
      selection = select(directory.selection, "sync")
      execute(selection, directory.client)
    end
  )

  (
    @doc "Retrieves this directory plus a directory written at the given path.\n\n## Required Arguments\n\n* `path` - Location of the written directory (e.g., \"/src/\").\n* `directory` - Identifier of the directory to copy.\n\n## Optional Arguments\n\n* `exclude` - Exclude artifacts that match the given pattern (e.g., [\"node_modules/\", \".git*\"]).\n* `include` - Include only artifacts that match the given pattern (e.g., [\"app/\", \"package.*\"])."
    @spec with_directory(t(), Dagger.String.t(), Dagger.Directory.t(), keyword()) ::
            Dagger.Directory.t()
    def with_directory(%__MODULE__{} = directory, path, directory, optional_args \\ []) do
      selection = select(directory.selection, "withDirectory")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.Directory.id(directory)
        selection = arg(selection, "directory", id)
      )

      selection =
        if is_nil(optional_args[:exclude]) do
          selection
        else
          arg(selection, "exclude", optional_args[:exclude])
        end

      selection =
        if is_nil(optional_args[:include]) do
          selection
        else
          arg(selection, "include", optional_args[:include])
        end

      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Retrieves this directory plus the contents of the given file copied to the given path.\n\n## Required Arguments\n\n* `path` - Location of the copied file (e.g., \"/file.txt\").\n* `source` - Identifier of the file to copy.\n\n## Optional Arguments\n\n* `permissions` - Permission given to the copied file (e.g., 0600)."
    @spec with_file(t(), Dagger.String.t(), Dagger.File.t(), keyword()) :: Dagger.Directory.t()
    def with_file(%__MODULE__{} = directory, path, source, optional_args \\ []) do
      selection = select(directory.selection, "withFile")
      selection = arg(selection, "path", path)

      (
        {:ok, id} = Dagger.File.id(source)
        selection = arg(selection, "source", id)
      )

      selection =
        if is_nil(optional_args[:permissions]) do
          selection
        else
          arg(selection, "permissions", optional_args[:permissions])
        end

      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Retrieves this directory plus a new directory created at the given path.\n\n## Required Arguments\n\n* `path` - Location of the directory created (e.g., \"/logs\").\n\n## Optional Arguments\n\n* `permissions` - Permission granted to the created directory (e.g., 0777)."
    @spec with_new_directory(t(), Dagger.String.t(), keyword()) :: Dagger.Directory.t()
    def with_new_directory(%__MODULE__{} = directory, path, optional_args \\ []) do
      selection = select(directory.selection, "withNewDirectory")
      selection = arg(selection, "path", path)

      selection =
        if is_nil(optional_args[:permissions]) do
          selection
        else
          arg(selection, "permissions", optional_args[:permissions])
        end

      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Retrieves this directory plus a new file written at the given path.\n\n## Required Arguments\n\n* `path` - Location of the written file (e.g., \"/file.txt\").\n* `contents` - Content of the written file (e.g., \"Hello world!\").\n\n## Optional Arguments\n\n* `permissions` - Permission given to the copied file (e.g., 0600)."
    @spec with_new_file(t(), Dagger.String.t(), Dagger.String.t(), keyword()) ::
            Dagger.Directory.t()
    def with_new_file(%__MODULE__{} = directory, path, contents, optional_args \\ []) do
      selection = select(directory.selection, "withNewFile")
      selection = arg(selection, "path", path)
      selection = arg(selection, "contents", contents)

      selection =
        if is_nil(optional_args[:permissions]) do
          selection
        else
          arg(selection, "permissions", optional_args[:permissions])
        end

      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Retrieves this directory with all file/dir timestamps set to the given time.\n\n## Required Arguments\n\n* `timestamp` - Timestamp to set dir/files in.\n\nFormatted in seconds following Unix epoch (e.g., 1672531199)."
    @spec with_timestamps(t(), Dagger.Int.t()) :: Dagger.Directory.t()
    def with_timestamps(%__MODULE__{} = directory, timestamp) do
      selection = select(directory.selection, "withTimestamps")
      selection = arg(selection, "timestamp", timestamp)
      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Retrieves this directory with the directory at the given path removed.\n\n## Required Arguments\n\n* `path` - Location of the directory to remove (e.g., \".github/\")."
    @spec without_directory(t(), Dagger.String.t()) :: Dagger.Directory.t()
    def without_directory(%__MODULE__{} = directory, path) do
      selection = select(directory.selection, "withoutDirectory")
      selection = arg(selection, "path", path)
      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )

  (
    @doc "Retrieves this directory with the file at the given path removed.\n\n## Required Arguments\n\n* `path` - Location of the file to remove (e.g., \"/file.txt\")."
    @spec without_file(t(), Dagger.String.t()) :: Dagger.Directory.t()
    def without_file(%__MODULE__{} = directory, path) do
      selection = select(directory.selection, "withoutFile")
      selection = arg(selection, "path", path)
      %Dagger.Directory{selection: selection, client: directory.client}
    end
  )
end
