# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.GitModuleSource do
  @moduledoc "Module source originating from a git repo."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  defstruct [:selection, :client]

  (
    @doc "The URL from which the source's git repo can be cloned."
    @spec clone_url(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def clone_url(%__MODULE__{} = git_module_source) do
      selection = select(git_module_source.selection, "cloneURL")
      execute(selection, git_module_source.client)
    end
  )

  (
    @doc ""
    @spec commit(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def commit(%__MODULE__{} = git_module_source) do
      selection = select(git_module_source.selection, "commit")
      execute(selection, git_module_source.client)
    end
  )

  (
    @doc "The URL to the source's git repo in a web browser"
    @spec html_url(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def html_url(%__MODULE__{} = git_module_source) do
      selection = select(git_module_source.selection, "htmlURL")
      execute(selection, git_module_source.client)
    end
  )

  (
    @doc "A unique identifier for this GitModuleSource."
    @spec id(t()) :: {:ok, Dagger.GitModuleSourceID.t()} | {:error, term()}
    def id(%__MODULE__{} = git_module_source) do
      selection = select(git_module_source.selection, "id")
      execute(selection, git_module_source.client)
    end
  )

  (
    @doc ""
    @spec source_subpath(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def source_subpath(%__MODULE__{} = git_module_source) do
      selection = select(git_module_source.selection, "sourceSubpath")
      execute(selection, git_module_source.client)
    end
  )

  (
    @doc ""
    @spec version(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def version(%__MODULE__{} = git_module_source) do
      selection = select(git_module_source.selection, "version")
      execute(selection, git_module_source.client)
    end
  )
end
