// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_TRACING_CONNECTION_H

#include "generator/integration_tests/golden/v1/request_id_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class RequestIdServiceTracingConnection
    : public golden_v1::RequestIdServiceConnection {
 public:
  ~RequestIdServiceTracingConnection() override = default;

  explicit RequestIdServiceTracingConnection(
    std::shared_ptr<golden_v1::RequestIdServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::test::requestid::v1::Foo>
  CreateFoo(google::test::requestid::v1::CreateFooRequest const& request) override;

  future<StatusOr<google::test::requestid::v1::Foo>>
  RenameFoo(google::test::requestid::v1::RenameFooRequest const& request) override;

  StatusOr<google::longrunning::Operation>
  RenameFoo(NoAwaitTag,
      google::test::requestid::v1::RenameFooRequest const& request) override;

  future<StatusOr<google::test::requestid::v1::Foo>>
  RenameFoo(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::test::requestid::v1::Foo>
  ListFoos(google::test::requestid::v1::ListFoosRequest request) override;

  future<StatusOr<google::test::requestid::v1::Foo>>
  AsyncCreateFoo(google::test::requestid::v1::CreateFooRequest const& request) override;

 private:
  std::shared_ptr<golden_v1::RequestIdServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<golden_v1::RequestIdServiceConnection>
MakeRequestIdServiceTracingConnection(
    std::shared_ptr<golden_v1::RequestIdServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_TRACING_CONNECTION_H
