// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_APP_HUB_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_APP_HUB_CONNECTION_H

#include "google/cloud/apphub/v1/app_hub_connection_idempotency_policy.h"
#include "google/cloud/apphub/v1/internal/app_hub_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/apphub/v1/apphub_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace apphub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `AppHubConnection`.
class AppHubRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<AppHubRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `AppHubConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AppHubLimitedErrorCountRetryPolicy : public AppHubRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit AppHubLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  AppHubLimitedErrorCountRetryPolicy(
      AppHubLimitedErrorCountRetryPolicy&& rhs) noexcept
      : AppHubLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  AppHubLimitedErrorCountRetryPolicy(
      AppHubLimitedErrorCountRetryPolicy const& rhs) noexcept
      : AppHubLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AppHubRetryPolicy> clone() const override {
    return std::make_unique<AppHubLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AppHubRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      apphub_v1_internal::AppHubRetryTraits>
      impl_;
};

/**
 * A retry policy for `AppHubConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AppHubLimitedTimeRetryPolicy : public AppHubRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit AppHubLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  AppHubLimitedTimeRetryPolicy(AppHubLimitedTimeRetryPolicy&& rhs) noexcept
      : AppHubLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  AppHubLimitedTimeRetryPolicy(AppHubLimitedTimeRetryPolicy const& rhs) noexcept
      : AppHubLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AppHubRetryPolicy> clone() const override {
    return std::make_unique<AppHubLimitedTimeRetryPolicy>(maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AppHubRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      apphub_v1_internal::AppHubRetryTraits>
      impl_;
};

/**
 * The `AppHubConnection` object for `AppHubClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `AppHubClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `AppHubClient`.
 *
 * To create a concrete instance, see `MakeAppHubConnection()`.
 *
 * For mocking, see `apphub_v1_mocks::MockAppHubConnection`.
 */
class AppHubConnection {
 public:
  virtual ~AppHubConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<
      google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
  LookupServiceProjectAttachment(
      google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
          request);

  virtual StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
  ListServiceProjectAttachments(
      google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest request);

  virtual future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
  CreateServiceProjectAttachment(
      google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation>
  CreateServiceProjectAttachment(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
          request);

  virtual future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
  CreateServiceProjectAttachment(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
  GetServiceProjectAttachment(
      google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
          request);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteServiceProjectAttachment(
      google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation>
  DeleteServiceProjectAttachment(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
          request);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteServiceProjectAttachment(
      google::longrunning::Operation const& operation);

  virtual StatusOr<
      google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
  DetachServiceProjectAttachment(
      google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
          request);

  virtual StreamRange<google::cloud::apphub::v1::DiscoveredService>
  ListDiscoveredServices(
      google::cloud::apphub::v1::ListDiscoveredServicesRequest request);

  virtual StatusOr<google::cloud::apphub::v1::DiscoveredService>
  GetDiscoveredService(
      google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request);

  virtual StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
  LookupDiscoveredService(
      google::cloud::apphub::v1::LookupDiscoveredServiceRequest const& request);

  virtual StreamRange<google::cloud::apphub::v1::Service> ListServices(
      google::cloud::apphub::v1::ListServicesRequest request);

  virtual future<StatusOr<google::cloud::apphub::v1::Service>> CreateService(
      google::cloud::apphub::v1::CreateServiceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateServiceRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Service>> CreateService(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::apphub::v1::Service> GetService(
      google::cloud::apphub::v1::GetServiceRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Service>> UpdateService(
      google::cloud::apphub::v1::UpdateServiceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateService(
      NoAwaitTag,
      google::cloud::apphub::v1::UpdateServiceRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Service>> UpdateService(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteService(google::cloud::apphub::v1::DeleteServiceRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteServiceRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteService(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
  ListDiscoveredWorkloads(
      google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest request);

  virtual StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
  GetDiscoveredWorkload(
      google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request);

  virtual StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
  LookupDiscoveredWorkload(
      google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const&
          request);

  virtual StreamRange<google::cloud::apphub::v1::Workload> ListWorkloads(
      google::cloud::apphub::v1::ListWorkloadsRequest request);

  virtual future<StatusOr<google::cloud::apphub::v1::Workload>> CreateWorkload(
      google::cloud::apphub::v1::CreateWorkloadRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateWorkload(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateWorkloadRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Workload>> CreateWorkload(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::apphub::v1::Workload> GetWorkload(
      google::cloud::apphub::v1::GetWorkloadRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Workload>> UpdateWorkload(
      google::cloud::apphub::v1::UpdateWorkloadRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateWorkload(
      NoAwaitTag,
      google::cloud::apphub::v1::UpdateWorkloadRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Workload>> UpdateWorkload(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteWorkload(
      google::cloud::apphub::v1::DeleteWorkloadRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteWorkload(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteWorkloadRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteWorkload(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::apphub::v1::Application> ListApplications(
      google::cloud::apphub::v1::ListApplicationsRequest request);

  virtual future<StatusOr<google::cloud::apphub::v1::Application>>
  CreateApplication(
      google::cloud::apphub::v1::CreateApplicationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateApplication(
      NoAwaitTag,
      google::cloud::apphub::v1::CreateApplicationRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Application>>
  CreateApplication(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::apphub::v1::Application> GetApplication(
      google::cloud::apphub::v1::GetApplicationRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Application>>
  UpdateApplication(
      google::cloud::apphub::v1::UpdateApplicationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateApplication(
      NoAwaitTag,
      google::cloud::apphub::v1::UpdateApplicationRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::Application>>
  UpdateApplication(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteApplication(
      google::cloud::apphub::v1::DeleteApplicationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteApplication(
      NoAwaitTag,
      google::cloud::apphub::v1::DeleteApplicationRequest const& request);

  virtual future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
  DeleteApplication(google::longrunning::Operation const& operation);
};

/**
 * A factory function to construct an object of type `AppHubConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of AppHubClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `AppHubConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::apphub_v1::AppHubPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `AppHubConnection` created by
 * this function.
 */
std::shared_ptr<AppHubConnection> MakeAppHubConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPHUB_V1_APP_HUB_CONNECTION_H
