// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/reservation/v1/reservation.proto

#include "google/cloud/bigquery/reservation/v1/reservation_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_reservation_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ReservationServiceClient::ReservationServiceClient(
    std::shared_ptr<ReservationServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ReservationServiceClient::~ReservationServiceClient() = default;

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::CreateReservation(
    std::string const& parent,
    google::cloud::bigquery::reservation::v1::Reservation const& reservation,
    std::string const& reservation_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::CreateReservationRequest request;
  request.set_parent(parent);
  *request.mutable_reservation() = reservation;
  request.set_reservation_id(reservation_id);
  return connection_->CreateReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::CreateReservation(
    google::cloud::bigquery::reservation::v1::CreateReservationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReservation(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::ListReservations(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::ListReservationsRequest request;
  request.set_parent(parent);
  return connection_->ListReservations(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::ListReservations(
    google::cloud::bigquery::reservation::v1::ListReservationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReservations(std::move(request));
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::GetReservation(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::GetReservationRequest request;
  request.set_name(name);
  return connection_->GetReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::GetReservation(
    google::cloud::bigquery::reservation::v1::GetReservationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReservation(request);
}

Status ReservationServiceClient::DeleteReservation(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::DeleteReservationRequest request;
  request.set_name(name);
  return connection_->DeleteReservation(request);
}

Status ReservationServiceClient::DeleteReservation(
    google::cloud::bigquery::reservation::v1::DeleteReservationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::UpdateReservation(
    google::cloud::bigquery::reservation::v1::Reservation const& reservation,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::UpdateReservationRequest request;
  *request.mutable_reservation() = reservation;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceClient::UpdateReservation(
    google::cloud::bigquery::reservation::v1::UpdateReservationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::CreateCapacityCommitment(
    std::string const& parent,
    google::cloud::bigquery::reservation::v1::CapacityCommitment const&
        capacity_commitment,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest
      request;
  request.set_parent(parent);
  *request.mutable_capacity_commitment() = capacity_commitment;
  return connection_->CreateCapacityCommitment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::CreateCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        CreateCapacityCommitmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCapacityCommitment(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::ListCapacityCommitments(std::string const& parent,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest
      request;
  request.set_parent(parent);
  return connection_->ListCapacityCommitments(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::ListCapacityCommitments(
    google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCapacityCommitments(std::move(request));
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::GetCapacityCommitment(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest
      request;
  request.set_name(name);
  return connection_->GetCapacityCommitment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::GetCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        GetCapacityCommitmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCapacityCommitment(request);
}

Status ReservationServiceClient::DeleteCapacityCommitment(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest
      request;
  request.set_name(name);
  return connection_->DeleteCapacityCommitment(request);
}

Status ReservationServiceClient::DeleteCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        DeleteCapacityCommitmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCapacityCommitment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::UpdateCapacityCommitment(
    google::cloud::bigquery::reservation::v1::CapacityCommitment const&
        capacity_commitment,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest
      request;
  *request.mutable_capacity_commitment() = capacity_commitment;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCapacityCommitment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::UpdateCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        UpdateCapacityCommitmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCapacityCommitment(request);
}

StatusOr<
    google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>
ReservationServiceClient::SplitCapacityCommitment(std::string const& name,
                                                  std::int64_t slot_count,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest
      request;
  request.set_name(name);
  request.set_slot_count(slot_count);
  return connection_->SplitCapacityCommitment(request);
}

StatusOr<
    google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>
ReservationServiceClient::SplitCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        SplitCapacityCommitmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SplitCapacityCommitment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::MergeCapacityCommitments(
    std::string const& parent,
    std::vector<std::string> const& capacity_commitment_ids, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest
      request;
  request.set_parent(parent);
  *request.mutable_capacity_commitment_ids() = {capacity_commitment_ids.begin(),
                                                capacity_commitment_ids.end()};
  return connection_->MergeCapacityCommitments(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceClient::MergeCapacityCommitments(
    google::cloud::bigquery::reservation::v1::
        MergeCapacityCommitmentsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->MergeCapacityCommitments(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::CreateAssignment(
    std::string const& parent,
    google::cloud::bigquery::reservation::v1::Assignment const& assignment,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::CreateAssignmentRequest request;
  request.set_parent(parent);
  *request.mutable_assignment() = assignment;
  return connection_->CreateAssignment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::CreateAssignment(
    google::cloud::bigquery::reservation::v1::CreateAssignmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAssignment(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::ListAssignments(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::ListAssignmentsRequest request;
  request.set_parent(parent);
  return connection_->ListAssignments(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::ListAssignments(
    google::cloud::bigquery::reservation::v1::ListAssignmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAssignments(std::move(request));
}

Status ReservationServiceClient::DeleteAssignment(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest request;
  request.set_name(name);
  return connection_->DeleteAssignment(request);
}

Status ReservationServiceClient::DeleteAssignment(
    google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAssignment(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::SearchAssignments(std::string const& parent,
                                            std::string const& query,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest request;
  request.set_parent(parent);
  request.set_query(query);
  return connection_->SearchAssignments(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::SearchAssignments(
    google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchAssignments(std::move(request));
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::SearchAllAssignments(std::string const& parent,
                                               std::string const& query,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest request;
  request.set_parent(parent);
  request.set_query(query);
  return connection_->SearchAllAssignments(request);
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::SearchAllAssignments(
    google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchAllAssignments(std::move(request));
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::MoveAssignment(std::string const& name,
                                         std::string const& destination_id,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::MoveAssignmentRequest request;
  request.set_name(name);
  request.set_destination_id(destination_id);
  return connection_->MoveAssignment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::MoveAssignment(
    google::cloud::bigquery::reservation::v1::MoveAssignmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->MoveAssignment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::UpdateAssignment(
    google::cloud::bigquery::reservation::v1::Assignment const& assignment,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest request;
  *request.mutable_assignment() = assignment;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAssignment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceClient::UpdateAssignment(
    google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAssignment(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceClient::GetBiReservation(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::GetBiReservationRequest request;
  request.set_name(name);
  return connection_->GetBiReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceClient::GetBiReservation(
    google::cloud::bigquery::reservation::v1::GetBiReservationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBiReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceClient::UpdateBiReservation(
    google::cloud::bigquery::reservation::v1::BiReservation const&
        bi_reservation,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest request;
  *request.mutable_bi_reservation() = bi_reservation;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBiReservation(request);
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceClient::UpdateBiReservation(
    google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBiReservation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_reservation_v1
}  // namespace cloud
}  // namespace google
