// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/public_delegated_prefixes/v1/public_delegated_prefixes.proto

#include "google/cloud/compute/public_delegated_prefixes/v1/internal/public_delegated_prefixes_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_public_delegated_prefixes_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PublicDelegatedPrefixesTracingConnection::
    PublicDelegatedPrefixesTracingConnection(
        std::shared_ptr<compute_public_delegated_prefixes_v1::
                            PublicDelegatedPrefixesConnection>
            child)
    : child_(std::move(child)) {}

StreamRange<std::pair<std::string, google::cloud::cpp::compute::v1::
                                       PublicDelegatedPrefixesScopedList>>
PublicDelegatedPrefixesTracingConnection::AggregatedListPublicDelegatedPrefixes(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        AggregatedListPublicDelegatedPrefixesRequest request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":AggregatedListPublicDelegatedPrefixes");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListPublicDelegatedPrefixes(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string,
      google::cloud::cpp::compute::v1::PublicDelegatedPrefixesScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::Announce(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        AnnounceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":Announce");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Announce(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
PublicDelegatedPrefixesTracingConnection::Announce(
    NoAwaitTag, google::cloud::cpp::compute::public_delegated_prefixes::v1::
                    AnnounceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":Announce");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->Announce(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::Announce(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":Announce");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Announce(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::DeletePublicDelegatedPrefix(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        DeletePublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":DeletePublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeletePublicDelegatedPrefix(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
PublicDelegatedPrefixesTracingConnection::DeletePublicDelegatedPrefix(
    NoAwaitTag, google::cloud::cpp::compute::public_delegated_prefixes::v1::
                    DeletePublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":DeletePublicDelegatedPrefix");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeletePublicDelegatedPrefix(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::DeletePublicDelegatedPrefix(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":DeletePublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeletePublicDelegatedPrefix(operation));
}

StatusOr<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
PublicDelegatedPrefixesTracingConnection::GetPublicDelegatedPrefix(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        GetPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":GetPublicDelegatedPrefix");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPublicDelegatedPrefix(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::InsertPublicDelegatedPrefix(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        InsertPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":InsertPublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertPublicDelegatedPrefix(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
PublicDelegatedPrefixesTracingConnection::InsertPublicDelegatedPrefix(
    NoAwaitTag, google::cloud::cpp::compute::public_delegated_prefixes::v1::
                    InsertPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":InsertPublicDelegatedPrefix");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->InsertPublicDelegatedPrefix(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::InsertPublicDelegatedPrefix(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":InsertPublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertPublicDelegatedPrefix(operation));
}

StreamRange<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
PublicDelegatedPrefixesTracingConnection::ListPublicDelegatedPrefixes(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        ListPublicDelegatedPrefixesRequest request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":ListPublicDelegatedPrefixes");
  internal::OTelScope scope(span);
  auto sr = child_->ListPublicDelegatedPrefixes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::PublicDelegatedPrefix>(std::move(span),
                                                              std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::PatchPublicDelegatedPrefix(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        PatchPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":PatchPublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchPublicDelegatedPrefix(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
PublicDelegatedPrefixesTracingConnection::PatchPublicDelegatedPrefix(
    NoAwaitTag, google::cloud::cpp::compute::public_delegated_prefixes::v1::
                    PatchPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":PatchPublicDelegatedPrefix");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->PatchPublicDelegatedPrefix(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::PatchPublicDelegatedPrefix(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":PatchPublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchPublicDelegatedPrefix(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::Withdraw(
    google::cloud::cpp::compute::public_delegated_prefixes::v1::
        WithdrawRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":Withdraw");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Withdraw(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
PublicDelegatedPrefixesTracingConnection::Withdraw(
    NoAwaitTag, google::cloud::cpp::compute::public_delegated_prefixes::v1::
                    WithdrawRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":Withdraw");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->Withdraw(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
PublicDelegatedPrefixesTracingConnection::Withdraw(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection:"
      ":Withdraw");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Withdraw(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<
    compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection>
MakePublicDelegatedPrefixesTracingConnection(
    std::shared_ptr<
        compute_public_delegated_prefixes_v1::PublicDelegatedPrefixesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<PublicDelegatedPrefixesTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_public_delegated_prefixes_v1_internal
}  // namespace cloud
}  // namespace google
