// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/catalog.proto

#include "google/cloud/dataplex/v1/catalog_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CatalogServiceConnectionIdempotencyPolicy::
    ~CatalogServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<CatalogServiceConnectionIdempotencyPolicy>
CatalogServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CatalogServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::CreateEntryType(
    google::cloud::dataplex::v1::CreateEntryTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::UpdateEntryType(
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::DeleteEntryType(
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::ListEntryTypes(
    google::cloud::dataplex::v1::ListEntryTypesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::GetEntryType(
    google::cloud::dataplex::v1::GetEntryTypeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::CreateAspectType(
    google::cloud::dataplex::v1::CreateAspectTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::UpdateAspectType(
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::DeleteAspectType(
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::ListAspectTypes(
    google::cloud::dataplex::v1::ListAspectTypesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::GetAspectType(
    google::cloud::dataplex::v1::GetAspectTypeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::CreateEntryGroup(
    google::cloud::dataplex::v1::CreateEntryGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::UpdateEntryGroup(
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::DeleteEntryGroup(
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::ListEntryGroups(
    google::cloud::dataplex::v1::ListEntryGroupsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::GetEntryGroup(
    google::cloud::dataplex::v1::GetEntryGroupRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::CreateEntry(
    google::cloud::dataplex::v1::CreateEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::UpdateEntry(
    google::cloud::dataplex::v1::UpdateEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::DeleteEntry(
    google::cloud::dataplex::v1::DeleteEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::ListEntries(
    google::cloud::dataplex::v1::ListEntriesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::GetEntry(
    google::cloud::dataplex::v1::GetEntryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::LookupEntry(
    google::cloud::dataplex::v1::LookupEntryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::SearchEntries(
    google::cloud::dataplex::v1::SearchEntriesRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CatalogServiceConnectionIdempotencyPolicy>
MakeDefaultCatalogServiceConnectionIdempotencyPolicy() {
  return std::make_unique<CatalogServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
