// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#include "google/cloud/managedkafka/v1/internal/managed_kafka_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace managedkafka_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ManagedKafkaTracingConnection::ManagedKafkaTracingConnection(
    std::shared_ptr<managedkafka_v1::ManagedKafkaConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaTracingConnection::ListClusters(
    google::cloud::managedkafka::v1::ListClustersRequest request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::ListClusters");
  internal::OTelScope scope(span);
  auto sr = child_->ListClusters(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::managedkafka::v1::Cluster>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaTracingConnection::GetCluster(
    google::cloud::managedkafka::v1::GetClusterRequest const& request) {
  auto span =
      internal::MakeSpan("managedkafka_v1::ManagedKafkaConnection::GetCluster");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCluster(request));
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaTracingConnection::CreateCluster(
    google::cloud::managedkafka::v1::CreateClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::CreateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCluster(request));
}

StatusOr<google::longrunning::Operation>
ManagedKafkaTracingConnection::CreateCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::CreateClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::CreateCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaTracingConnection::CreateCluster(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::CreateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateCluster(operation));
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaTracingConnection::UpdateCluster(
    google::cloud::managedkafka::v1::UpdateClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::UpdateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCluster(request));
}

StatusOr<google::longrunning::Operation>
ManagedKafkaTracingConnection::UpdateCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::UpdateClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::UpdateCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaTracingConnection::UpdateCluster(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::UpdateCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCluster(operation));
}

future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
ManagedKafkaTracingConnection::DeleteCluster(
    google::cloud::managedkafka::v1::DeleteClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::DeleteCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCluster(request));
}

StatusOr<google::longrunning::Operation>
ManagedKafkaTracingConnection::DeleteCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::DeleteClusterRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::DeleteCluster");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteCluster(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
ManagedKafkaTracingConnection::DeleteCluster(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::DeleteCluster");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteCluster(operation));
}

StreamRange<google::cloud::managedkafka::v1::Topic>
ManagedKafkaTracingConnection::ListTopics(
    google::cloud::managedkafka::v1::ListTopicsRequest request) {
  auto span =
      internal::MakeSpan("managedkafka_v1::ManagedKafkaConnection::ListTopics");
  internal::OTelScope scope(span);
  auto sr = child_->ListTopics(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::managedkafka::v1::Topic>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaTracingConnection::GetTopic(
    google::cloud::managedkafka::v1::GetTopicRequest const& request) {
  auto span =
      internal::MakeSpan("managedkafka_v1::ManagedKafkaConnection::GetTopic");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTopic(request));
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaTracingConnection::CreateTopic(
    google::cloud::managedkafka::v1::CreateTopicRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::CreateTopic");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateTopic(request));
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaTracingConnection::UpdateTopic(
    google::cloud::managedkafka::v1::UpdateTopicRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::UpdateTopic");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateTopic(request));
}

Status ManagedKafkaTracingConnection::DeleteTopic(
    google::cloud::managedkafka::v1::DeleteTopicRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::DeleteTopic");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteTopic(request));
}

StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaTracingConnection::ListConsumerGroups(
    google::cloud::managedkafka::v1::ListConsumerGroupsRequest request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::ListConsumerGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListConsumerGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::managedkafka::v1::ConsumerGroup>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaTracingConnection::GetConsumerGroup(
    google::cloud::managedkafka::v1::GetConsumerGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::GetConsumerGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetConsumerGroup(request));
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaTracingConnection::UpdateConsumerGroup(
    google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::UpdateConsumerGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateConsumerGroup(request));
}

Status ManagedKafkaTracingConnection::DeleteConsumerGroup(
    google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&
        request) {
  auto span = internal::MakeSpan(
      "managedkafka_v1::ManagedKafkaConnection::DeleteConsumerGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteConsumerGroup(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<managedkafka_v1::ManagedKafkaConnection>
MakeManagedKafkaTracingConnection(
    std::shared_ptr<managedkafka_v1::ManagedKafkaConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ManagedKafkaTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1_internal
}  // namespace cloud
}  // namespace google
