// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/metastore/v1/metastore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_METASTORE_V1_DATAPROC_METASTORE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_METASTORE_V1_DATAPROC_METASTORE_CLIENT_H

#include "google/cloud/metastore/v1/dataproc_metastore_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace metastore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Configures and manages metastore services.
/// Metastore services are fully managed, highly available, autoscaled,
/// autohealing, OSS-native deployments of technical metadata management
/// software. Each metastore service exposes a network endpoint through which
/// metadata queries are served. Metadata queries can originate from a variety
/// of sources, including Apache Hive, Apache Presto, and Apache Spark.
///
/// The Dataproc Metastore API defines the following resource model:
///
/// * The service works with a collection of Google Cloud projects, named:
/// `/projects/*`
/// * Each project has a collection of available locations, named:
/// `/locations/*`
///   (a location must refer to a Google Cloud `region`)
/// * Each location has a collection of services, named: `/services/*`
/// * Dataproc Metastore services are resources with names of the form:
///
///   `/projects/{project_number}/locations/{location_id}/services/{service_id}`.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DataprocMetastoreClient {
 public:
  explicit DataprocMetastoreClient(
      std::shared_ptr<DataprocMetastoreConnection> connection,
      Options opts = {});
  ~DataprocMetastoreClient();

  ///@{
  /// @name Copy and move support
  DataprocMetastoreClient(DataprocMetastoreClient const&) = default;
  DataprocMetastoreClient& operator=(DataprocMetastoreClient const&) = default;
  DataprocMetastoreClient(DataprocMetastoreClient&&) = default;
  DataprocMetastoreClient& operator=(DataprocMetastoreClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DataprocMetastoreClient const& a,
                         DataprocMetastoreClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DataprocMetastoreClient const& a,
                         DataprocMetastoreClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists services in a project and location.
  ///
  /// @param parent  Required. The relative resource name of the location of metastore services
  ///  to list, in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.Service], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.ListServicesRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L922}
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::Service> ListServices(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists services in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.ListServicesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.Service], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.ListServicesRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L922}
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::Service> ListServices(
      google::cloud::metastore::v1::ListServicesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a single service.
  ///
  /// @param name  Required. The relative resource name of the metastore service to retrieve,
  ///  in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.GetServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L976}
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::Service> GetService(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a single service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.GetServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.Service])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.GetServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L976}
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::Service> GetService(
      google::cloud::metastore::v1::GetServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a metastore service in a project and location.
  ///
  /// @param parent  Required. The relative resource name of the location in which to create a
  ///  metastore service, in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}`.
  /// @param service  Required. The Metastore service to create. The `name` field is
  ///  ignored. The ID of the created metastore service must be provided in
  ///  the request's `service_id` field.
  /// @param service_id  Required. The ID of the metastore service, which is used as the final
  ///  component of the metastore service's name.
  ///  @n
  ///  This value must be between 2 and 63 characters long inclusive, begin with a
  ///  letter, end with a letter or number, and consist of alpha-numeric
  ///  ASCII characters or hyphens.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.CreateServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L991}
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Service>> CreateService(
      std::string const& parent,
      google::cloud::metastore::v1::Service const& service,
      std::string const& service_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag, std::string const& parent,
      google::cloud::metastore::v1::Service const& service,
      std::string const& service_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a metastore service in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.CreateServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.CreateServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L991}
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Service>> CreateService(
      google::cloud::metastore::v1::CreateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateService(
      NoAwaitTag,
      google::cloud::metastore::v1::CreateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Service>> CreateService(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single service.
  ///
  /// @param service  Required. The metastore service to update. The server only merges fields
  ///  in the service if they are specified in `update_mask`.
  ///  @n
  ///  The metastore service's `name` field is used to identify the metastore
  ///  service to be updated.
  /// @param update_mask  Required. A field mask used to specify the fields to be overwritten in the
  ///  metastore service resource by the update.
  ///  Fields specified in the `update_mask` are relative to the resource (not
  ///  to the full request). A field is overwritten if it is in the mask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  /// [google.cloud.metastore.v1.UpdateServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1033}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Service>> UpdateService(
      google::cloud::metastore::v1::Service const& service,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateService(
      NoAwaitTag, google::cloud::metastore::v1::Service const& service,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.UpdateServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Service] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Service]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L286}
  /// [google.cloud.metastore.v1.UpdateServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1033}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Service>> UpdateService(
      google::cloud::metastore::v1::UpdateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateService(
      NoAwaitTag,
      google::cloud::metastore::v1::UpdateServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Service>> UpdateService(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single service.
  ///
  /// @param name  Required. The relative resource name of the metastore service to delete, in
  ///  the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.DeleteServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1065}
  /// [google.cloud.metastore.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1457}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteService(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.DeleteServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.DeleteServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1065}
  /// [google.cloud.metastore.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1457}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteService(
      google::cloud::metastore::v1::DeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteService(
      NoAwaitTag,
      google::cloud::metastore::v1::DeleteServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteService(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Lists imports in a service.
  ///
  /// @param parent  Required. The relative resource name of the service whose metadata imports
  ///  to list, in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.MetadataImport], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.ListMetadataImportsRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1094}
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::MetadataImport> ListMetadataImports(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists imports in a service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.ListMetadataImportsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.MetadataImport], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.ListMetadataImportsRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1094}
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::MetadataImport> ListMetadataImports(
      google::cloud::metastore::v1::ListMetadataImportsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single import.
  ///
  /// @param name  Required. The relative resource name of the metadata import to retrieve, in
  ///  the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}/metadataImports/{import_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.MetadataImport])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.GetMetadataImportRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1147}
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::MetadataImport> GetMetadataImport(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single import.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.GetMetadataImportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.MetadataImport])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.GetMetadataImportRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1147}
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::MetadataImport> GetMetadataImport(
      google::cloud::metastore::v1::GetMetadataImportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new MetadataImport in a given project and location.
  ///
  /// @param parent  Required. The relative resource name of the service in which to create a
  ///  metastore import, in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}`.
  /// @param metadata_import  Required. The metadata import to create. The `name` field is ignored. The
  ///  ID of the created metadata import must be provided in the request's
  ///  `metadata_import_id` field.
  /// @param metadata_import_id  Required. The ID of the metadata import, which is used as the final
  ///  component of the metadata import's name.
  ///  @n
  ///  This value must be between 1 and 64 characters long, begin with a letter,
  ///  end with a letter or number, and consist of alpha-numeric ASCII characters
  ///  or hyphens.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.MetadataImport] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.CreateMetadataImportRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1162}
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
  CreateMetadataImport(
      std::string const& parent,
      google::cloud::metastore::v1::MetadataImport const& metadata_import,
      std::string const& metadata_import_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMetadataImport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMetadataImport(
      NoAwaitTag, std::string const& parent,
      google::cloud::metastore::v1::MetadataImport const& metadata_import,
      std::string const& metadata_import_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new MetadataImport in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.CreateMetadataImportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.MetadataImport] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.CreateMetadataImportRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1162}
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
  CreateMetadataImport(
      google::cloud::metastore::v1::CreateMetadataImportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMetadataImport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMetadataImport(
      NoAwaitTag,
      google::cloud::metastore::v1::CreateMetadataImportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMetadataImport
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
  CreateMetadataImport(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Updates a single import.
  /// Only the description field of MetadataImport is supported to be updated.
  ///
  /// @param metadata_import  Required. The metadata import to update. The server only merges fields
  ///  in the import if they are specified in `update_mask`.
  ///  @n
  ///  The metadata import's `name` field is used to identify the metastore
  ///  import to be updated.
  /// @param update_mask  Required. A field mask used to specify the fields to be overwritten in the
  ///  metadata import resource by the update.
  ///  Fields specified in the `update_mask` are relative to the resource (not
  ///  to the full request). A field is overwritten if it is in the mask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.MetadataImport] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  /// [google.cloud.metastore.v1.UpdateMetadataImportRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1204}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
  UpdateMetadataImport(
      google::cloud::metastore::v1::MetadataImport const& metadata_import,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMetadataImport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMetadataImport(
      NoAwaitTag,
      google::cloud::metastore::v1::MetadataImport const& metadata_import,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a single import.
  /// Only the description field of MetadataImport is supported to be updated.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.UpdateMetadataImportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.MetadataImport] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.MetadataImport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L641}
  /// [google.cloud.metastore.v1.UpdateMetadataImportRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1204}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
  UpdateMetadataImport(
      google::cloud::metastore::v1::UpdateMetadataImportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMetadataImport
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMetadataImport(
      NoAwaitTag,
      google::cloud::metastore::v1::UpdateMetadataImportRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMetadataImport
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
  UpdateMetadataImport(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Exports metadata from a service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.ExportMetadataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.MetadataExport] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.ExportMetadataRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1374}
  /// [google.cloud.metastore.v1.MetadataExport]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L724}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataExport>> ExportMetadata(
      google::cloud::metastore::v1::ExportMetadataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportMetadata
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ExportMetadata(
      NoAwaitTag,
      google::cloud::metastore::v1::ExportMetadataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ExportMetadata
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MetadataExport>> ExportMetadata(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Restores a service from a backup.
  ///
  /// @param service  Required. The relative resource name of the metastore service to run
  ///  restore, in the following form:
  ///  @n
  ///  `projects/{project_id}/locations/{location_id}/services/{service_id}`.
  /// @param backup  Required. The relative resource name of the metastore service backup to
  ///  restore from, in the following form:
  ///  @n
  ///  `projects/{project_id}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Restore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Restore]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L823}
  /// [google.cloud.metastore.v1.RestoreServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1415}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Restore>> RestoreService(
      std::string const& service, std::string const& backup, Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestoreService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RestoreService(
      NoAwaitTag, std::string const& service, std::string const& backup,
      Options opts = {});

  // clang-format off
  ///
  /// Restores a service from a backup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.RestoreServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Restore] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Restore]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L823}
  /// [google.cloud.metastore.v1.RestoreServiceRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1415}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Restore>> RestoreService(
      google::cloud::metastore::v1::RestoreServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestoreService
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RestoreService(
      NoAwaitTag,
      google::cloud::metastore::v1::RestoreServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestoreService
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Restore>> RestoreService(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists backups in a service.
  ///
  /// @param parent  Required. The relative resource name of the service whose backups to
  ///  list, in the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}/backups`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.Backup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Backup]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L768}
  /// [google.cloud.metastore.v1.ListBackupsRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1236}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::Backup> ListBackups(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists backups in a service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.ListBackupsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.metastore.v1.Backup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Backup]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L768}
  /// [google.cloud.metastore.v1.ListBackupsRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1236}
  ///
  // clang-format on
  StreamRange<google::cloud::metastore::v1::Backup> ListBackups(
      google::cloud::metastore::v1::ListBackupsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single backup.
  ///
  /// @param name  Required. The relative resource name of the backup to retrieve, in the
  ///  following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.Backup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Backup]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L768}
  /// [google.cloud.metastore.v1.GetBackupRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1289}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::Backup> GetBackup(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single backup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.GetBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.metastore.v1.Backup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Backup]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L768}
  /// [google.cloud.metastore.v1.GetBackupRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1289}
  ///
  // clang-format on
  StatusOr<google::cloud::metastore::v1::Backup> GetBackup(
      google::cloud::metastore::v1::GetBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new backup in a given project and location.
  ///
  /// @param parent  Required. The relative resource name of the service in which to create a
  ///  backup of the following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}`.
  /// @param backup  Required. The backup to create. The `name` field is ignored. The ID of the
  ///  created backup must be provided in the request's `backup_id` field.
  /// @param backup_id  Required. The ID of the backup, which is used as the final component of the
  ///  backup's name.
  ///  @n
  ///  This value must be between 1 and 64 characters long, begin with a letter,
  ///  end with a letter or number, and consist of alpha-numeric ASCII characters
  ///  or hyphens.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Backup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Backup]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L768}
  /// [google.cloud.metastore.v1.CreateBackupRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1304}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Backup>> CreateBackup(
      std::string const& parent,
      google::cloud::metastore::v1::Backup const& backup,
      std::string const& backup_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateBackup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateBackup(
      NoAwaitTag, std::string const& parent,
      google::cloud::metastore::v1::Backup const& backup,
      std::string const& backup_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new backup in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.CreateBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.Backup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.Backup]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L768}
  /// [google.cloud.metastore.v1.CreateBackupRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1304}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Backup>> CreateBackup(
      google::cloud::metastore::v1::CreateBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateBackup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateBackup(
      NoAwaitTag,
      google::cloud::metastore::v1::CreateBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateBackup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::Backup>> CreateBackup(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single backup.
  ///
  /// @param name  Required. The relative resource name of the backup to delete, in the
  ///  following form:
  ///  @n
  ///  `projects/{project_number}/locations/{location_id}/services/{service_id}/backups/{backup_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.DeleteBackupRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1345}
  /// [google.cloud.metastore.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1457}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteBackup(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteBackup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteBackup(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a single backup.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.DeleteBackupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.DeleteBackupRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1345}
  /// [google.cloud.metastore.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1457}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteBackup(google::cloud::metastore::v1::DeleteBackupRequest const& request,
               Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteBackup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteBackup(
      NoAwaitTag,
      google::cloud::metastore::v1::DeleteBackupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteBackup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
  DeleteBackup(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Query DPMS metadata.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.QueryMetadataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.QueryMetadataResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.QueryMetadataRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1521}
  /// [google.cloud.metastore.v1.QueryMetadataResponse]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1540}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::QueryMetadataResponse>>
  QueryMetadata(
      google::cloud::metastore::v1::QueryMetadataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief QueryMetadata
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> QueryMetadata(
      NoAwaitTag,
      google::cloud::metastore::v1::QueryMetadataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief QueryMetadata
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::QueryMetadataResponse>>
  QueryMetadata(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Move a table to another database.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.MoveTableToDatabaseRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.MoveTableToDatabaseResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.MoveTableToDatabaseRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1560}
  /// [google.cloud.metastore.v1.MoveTableToDatabaseResponse]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1584}
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MoveTableToDatabaseResponse>>
  MoveTableToDatabase(
      google::cloud::metastore::v1::MoveTableToDatabaseRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveTableToDatabase
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> MoveTableToDatabase(
      NoAwaitTag,
      google::cloud::metastore::v1::MoveTableToDatabaseRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveTableToDatabase
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::metastore::v1::MoveTableToDatabaseResponse>>
  MoveTableToDatabase(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Alter metadata resource location. The metadata resource can be a database,
  /// table, or partition. This functionality only updates the parent directory
  /// for the respective metadata resource and does not transfer any existing
  /// data to the new location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.metastore.v1.AlterMetadataResourceLocationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.metastore.v1.AlterMetadataResourceLocationResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.metastore.v1.AlterMetadataResourceLocationRequest]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1588}
  /// [google.cloud.metastore.v1.AlterMetadataResourceLocationResponse]: @googleapis_reference_link{google/cloud/metastore/v1/metastore.proto#L1615}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::metastore::v1::AlterMetadataResourceLocationResponse>>
  AlterMetadataResourceLocation(
      google::cloud::metastore::v1::AlterMetadataResourceLocationRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief AlterMetadataResourceLocation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> AlterMetadataResourceLocation(
      NoAwaitTag,
      google::cloud::metastore::v1::AlterMetadataResourceLocationRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief AlterMetadataResourceLocation
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::metastore::v1::AlterMetadataResourceLocationResponse>>
  AlterMetadataResourceLocation(google::longrunning::Operation const& operation,
                                Options opts = {});

 private:
  std::shared_ptr<DataprocMetastoreConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace metastore_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_METASTORE_V1_DATAPROC_METASTORE_CLIENT_H
