// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networksecurity/v1/network_security.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_NETWORK_SECURITY_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_NETWORK_SECURITY_CLIENT_H

#include "google/cloud/networksecurity/v1/network_security_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace networksecurity_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Network Security API provides resources to configure authentication and
/// authorization policies. Refer to per API resource documentation for more
/// information.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class NetworkSecurityClient {
 public:
  explicit NetworkSecurityClient(
      std::shared_ptr<NetworkSecurityConnection> connection, Options opts = {});
  ~NetworkSecurityClient();

  ///@{
  /// @name Copy and move support
  NetworkSecurityClient(NetworkSecurityClient const&) = default;
  NetworkSecurityClient& operator=(NetworkSecurityClient const&) = default;
  NetworkSecurityClient(NetworkSecurityClient&&) = default;
  NetworkSecurityClient& operator=(NetworkSecurityClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(NetworkSecurityClient const& a,
                         NetworkSecurityClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(NetworkSecurityClient const& a,
                         NetworkSecurityClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists AuthorizationPolicies in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the AuthorizationPolicies
  ///  should be listed, specified in the format
  ///  `projects/{project}/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networksecurity.v1.AuthorizationPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.ListAuthorizationPoliciesRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L161}
  ///
  // clang-format on
  StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>
  ListAuthorizationPolicies(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists AuthorizationPolicies in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.ListAuthorizationPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networksecurity.v1.AuthorizationPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.ListAuthorizationPoliciesRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L161}
  ///
  // clang-format on
  StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>
  ListAuthorizationPolicies(
      google::cloud::networksecurity::v1::ListAuthorizationPoliciesRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single AuthorizationPolicy.
  ///
  /// @param name  Required. A name of the AuthorizationPolicy to get. Must be in the format
  ///  `projects/{project}/locations/{location}/authorizationPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networksecurity.v1.AuthorizationPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.GetAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L194}
  ///
  // clang-format on
  StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>
  GetAuthorizationPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single AuthorizationPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.GetAuthorizationPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networksecurity.v1.AuthorizationPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.GetAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L194}
  ///
  // clang-format on
  StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>
  GetAuthorizationPolicy(
      google::cloud::networksecurity::v1::GetAuthorizationPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new AuthorizationPolicy in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the AuthorizationPolicy. Must be in the
  ///  format `projects/{project}/locations/{location}`.
  /// @param authorization_policy  Required. AuthorizationPolicy resource to be created.
  /// @param authorization_policy_id  Required. Short name of the AuthorizationPolicy resource to be created.
  ///  This value should be 1-63 characters long, containing only
  ///  letters, numbers, hyphens, and underscores, and should not start
  ///  with a number. E.g. "authz_policy".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.AuthorizationPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.CreateAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L206}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  CreateAuthorizationPolicy(
      std::string const& parent,
      google::cloud::networksecurity::v1::AuthorizationPolicy const&
          authorization_policy,
      std::string const& authorization_policy_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAuthorizationPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAuthorizationPolicy(
      NoAwaitTag, std::string const& parent,
      google::cloud::networksecurity::v1::AuthorizationPolicy const&
          authorization_policy,
      std::string const& authorization_policy_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new AuthorizationPolicy in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.CreateAuthorizationPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.AuthorizationPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.CreateAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L206}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  CreateAuthorizationPolicy(google::cloud::networksecurity::v1::
                                CreateAuthorizationPolicyRequest const& request,
                            Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAuthorizationPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAuthorizationPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::
          CreateAuthorizationPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAuthorizationPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  CreateAuthorizationPolicy(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single AuthorizationPolicy.
  ///
  /// @param authorization_policy  Required. Updated AuthorizationPolicy resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  AuthorizationPolicy resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.AuthorizationPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.UpdateAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L227}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  UpdateAuthorizationPolicy(
      google::cloud::networksecurity::v1::AuthorizationPolicy const&
          authorization_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAuthorizationPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAuthorizationPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::AuthorizationPolicy const&
          authorization_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single AuthorizationPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.UpdateAuthorizationPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.AuthorizationPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.AuthorizationPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.UpdateAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L227}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  UpdateAuthorizationPolicy(google::cloud::networksecurity::v1::
                                UpdateAuthorizationPolicyRequest const& request,
                            Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAuthorizationPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAuthorizationPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::
          UpdateAuthorizationPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAuthorizationPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  UpdateAuthorizationPolicy(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Deletes a single AuthorizationPolicy.
  ///
  /// @param name  Required. A name of the AuthorizationPolicy to delete. Must be in the format
  ///  `projects/{project}/locations/{location}/authorizationPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.DeleteAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L240}
  /// [google.cloud.networksecurity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networksecurity/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteAuthorizationPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAuthorizationPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAuthorizationPolicy(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single AuthorizationPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.DeleteAuthorizationPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.DeleteAuthorizationPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/authorization_policy.proto#L240}
  /// [google.cloud.networksecurity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networksecurity/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteAuthorizationPolicy(google::cloud::networksecurity::v1::
                                DeleteAuthorizationPolicyRequest const& request,
                            Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAuthorizationPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAuthorizationPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::
          DeleteAuthorizationPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAuthorizationPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteAuthorizationPolicy(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Lists ServerTlsPolicies in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the ServerTlsPolicies should
  ///  be listed, specified in the format `projects/*/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networksecurity.v1.ServerTlsPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ListServerTlsPoliciesRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L94}
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>
  ListServerTlsPolicies(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists ServerTlsPolicies in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.ListServerTlsPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networksecurity.v1.ServerTlsPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ListServerTlsPoliciesRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L94}
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  ///
  // clang-format on
  StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>
  ListServerTlsPolicies(
      google::cloud::networksecurity::v1::ListServerTlsPoliciesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ServerTlsPolicy.
  ///
  /// @param name  Required. A name of the ServerTlsPolicy to get. Must be in the format
  ///  `projects/*/locations/{location}/serverTlsPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networksecurity.v1.ServerTlsPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.GetServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L126}
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>
  GetServerTlsPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ServerTlsPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.GetServerTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networksecurity.v1.ServerTlsPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.GetServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L126}
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  ///
  // clang-format on
  StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>
  GetServerTlsPolicy(
      google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new ServerTlsPolicy in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the ServerTlsPolicy. Must be in
  ///  the format `projects/*/locations/{location}`.
  /// @param server_tls_policy  Required. ServerTlsPolicy resource to be created.
  /// @param server_tls_policy_id  Required. Short name of the ServerTlsPolicy resource to be created. This value should
  ///  be 1-63 characters long, containing only letters, numbers, hyphens, and
  ///  underscores, and should not start with a number. E.g. "server_mtls_policy".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ServerTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.CreateServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L138}
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  CreateServerTlsPolicy(
      std::string const& parent,
      google::cloud::networksecurity::v1::ServerTlsPolicy const&
          server_tls_policy,
      std::string const& server_tls_policy_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServerTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServerTlsPolicy(
      NoAwaitTag, std::string const& parent,
      google::cloud::networksecurity::v1::ServerTlsPolicy const&
          server_tls_policy,
      std::string const& server_tls_policy_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new ServerTlsPolicy in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.CreateServerTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ServerTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.CreateServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L138}
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  CreateServerTlsPolicy(
      google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServerTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServerTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServerTlsPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  CreateServerTlsPolicy(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single ServerTlsPolicy.
  ///
  /// @param server_tls_policy  Required. Updated ServerTlsPolicy resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  ServerTlsPolicy resource by the update.  The fields
  ///  specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the
  ///  mask. If the user does not provide a mask then all fields will be
  ///  overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ServerTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.UpdateServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L158}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  UpdateServerTlsPolicy(
      google::cloud::networksecurity::v1::ServerTlsPolicy const&
          server_tls_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateServerTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateServerTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::ServerTlsPolicy const&
          server_tls_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single ServerTlsPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.UpdateServerTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ServerTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ServerTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.UpdateServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L158}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  UpdateServerTlsPolicy(
      google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateServerTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateServerTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateServerTlsPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  UpdateServerTlsPolicy(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a single ServerTlsPolicy.
  ///
  /// @param name  Required. A name of the ServerTlsPolicy to delete. Must be in
  ///  the format `projects/*/locations/{location}/serverTlsPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.DeleteServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L172}
  /// [google.cloud.networksecurity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networksecurity/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteServerTlsPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServerTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServerTlsPolicy(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single ServerTlsPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.DeleteServerTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.DeleteServerTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/server_tls_policy.proto#L172}
  /// [google.cloud.networksecurity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networksecurity/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteServerTlsPolicy(
      google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServerTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServerTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServerTlsPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteServerTlsPolicy(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Lists ClientTlsPolicies in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the ClientTlsPolicies should
  ///  be listed, specified in the format `projects/*/locations/{location}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networksecurity.v1.ClientTlsPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.ListClientTlsPoliciesRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L73}
  ///
  // clang-format on
  StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>
  ListClientTlsPolicies(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists ClientTlsPolicies in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.ListClientTlsPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networksecurity.v1.ClientTlsPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.ListClientTlsPoliciesRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L73}
  ///
  // clang-format on
  StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>
  ListClientTlsPolicies(
      google::cloud::networksecurity::v1::ListClientTlsPoliciesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ClientTlsPolicy.
  ///
  /// @param name  Required. A name of the ClientTlsPolicy to get. Must be in the format
  ///  `projects/*/locations/{location}/clientTlsPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networksecurity.v1.ClientTlsPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.GetClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L105}
  ///
  // clang-format on
  StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>
  GetClientTlsPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ClientTlsPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.GetClientTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networksecurity.v1.ClientTlsPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.GetClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L105}
  ///
  // clang-format on
  StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>
  GetClientTlsPolicy(
      google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new ClientTlsPolicy in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the ClientTlsPolicy. Must be in
  ///  the format `projects/*/locations/{location}`.
  /// @param client_tls_policy  Required. ClientTlsPolicy resource to be created.
  /// @param client_tls_policy_id  Required. Short name of the ClientTlsPolicy resource to be created. This value should
  ///  be 1-63 characters long, containing only letters, numbers, hyphens, and
  ///  underscores, and should not start with a number. E.g. "client_mtls_policy".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ClientTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.CreateClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L117}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  CreateClientTlsPolicy(
      std::string const& parent,
      google::cloud::networksecurity::v1::ClientTlsPolicy const&
          client_tls_policy,
      std::string const& client_tls_policy_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateClientTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateClientTlsPolicy(
      NoAwaitTag, std::string const& parent,
      google::cloud::networksecurity::v1::ClientTlsPolicy const&
          client_tls_policy,
      std::string const& client_tls_policy_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new ClientTlsPolicy in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.CreateClientTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ClientTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.CreateClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L117}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  CreateClientTlsPolicy(
      google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateClientTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateClientTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateClientTlsPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  CreateClientTlsPolicy(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single ClientTlsPolicy.
  ///
  /// @param client_tls_policy  Required. Updated ClientTlsPolicy resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  ClientTlsPolicy resource by the update.  The fields
  ///  specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the
  ///  mask. If the user does not provide a mask then all fields will be
  ///  overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ClientTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.UpdateClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L137}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  UpdateClientTlsPolicy(
      google::cloud::networksecurity::v1::ClientTlsPolicy const&
          client_tls_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateClientTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateClientTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::ClientTlsPolicy const&
          client_tls_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single ClientTlsPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.UpdateClientTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.ClientTlsPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.ClientTlsPolicy]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L36}
  /// [google.cloud.networksecurity.v1.UpdateClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L137}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  UpdateClientTlsPolicy(
      google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateClientTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateClientTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateClientTlsPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  UpdateClientTlsPolicy(google::longrunning::Operation const& operation,
                        Options opts = {});

  // clang-format off
  ///
  /// Deletes a single ClientTlsPolicy.
  ///
  /// @param name  Required. A name of the ClientTlsPolicy to delete. Must be in
  ///  the format `projects/*/locations/{location}/clientTlsPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.DeleteClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L151}
  /// [google.cloud.networksecurity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networksecurity/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteClientTlsPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteClientTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteClientTlsPolicy(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single ClientTlsPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networksecurity.v1.DeleteClientTlsPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networksecurity.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networksecurity.v1.DeleteClientTlsPolicyRequest]: @googleapis_reference_link{google/cloud/networksecurity/v1/client_tls_policy.proto#L151}
  /// [google.cloud.networksecurity.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networksecurity/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteClientTlsPolicy(
      google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteClientTlsPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteClientTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteClientTlsPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteClientTlsPolicy(google::longrunning::Operation const& operation,
                        Options opts = {});

 private:
  std::shared_ptr<NetworkSecurityConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networksecurity_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_NETWORK_SECURITY_CLIENT_H
