// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#include "google/cloud/networkservices/v1/network_services_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

NetworkServicesConnectionIdempotencyPolicy::
    ~NetworkServicesConnectionIdempotencyPolicy() = default;

std::unique_ptr<NetworkServicesConnectionIdempotencyPolicy>
NetworkServicesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<NetworkServicesConnectionIdempotencyPolicy>(*this);
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListEndpointPolicies(
    google::cloud::networkservices::v1::
        ListEndpointPoliciesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetEndpointPolicy(
    google::cloud::networkservices::v1::GetEndpointPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateEndpointPolicy(
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::UpdateEndpointPolicy(
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteEndpointPolicy(
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListGateways(
    google::cloud::networkservices::v1::ListGatewaysRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetGateway(
    google::cloud::networkservices::v1::GetGatewayRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateGateway(
    google::cloud::networkservices::v1::CreateGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::UpdateGateway(
    google::cloud::networkservices::v1::UpdateGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteGateway(
    google::cloud::networkservices::v1::DeleteGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListGrpcRoutes(
    google::cloud::networkservices::v1::ListGrpcRoutesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetGrpcRoute(
    google::cloud::networkservices::v1::GetGrpcRouteRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateGrpcRoute(
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::UpdateGrpcRoute(
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteGrpcRoute(
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListHttpRoutes(
    google::cloud::networkservices::v1::ListHttpRoutesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetHttpRoute(
    google::cloud::networkservices::v1::GetHttpRouteRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateHttpRoute(
    google::cloud::networkservices::v1::CreateHttpRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::UpdateHttpRoute(
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteHttpRoute(
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListTcpRoutes(
    google::cloud::networkservices::v1::ListTcpRoutesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetTcpRoute(
    google::cloud::networkservices::v1::GetTcpRouteRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateTcpRoute(
    google::cloud::networkservices::v1::CreateTcpRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::UpdateTcpRoute(
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteTcpRoute(
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListTlsRoutes(
    google::cloud::networkservices::v1::ListTlsRoutesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetTlsRoute(
    google::cloud::networkservices::v1::GetTlsRouteRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateTlsRoute(
    google::cloud::networkservices::v1::CreateTlsRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::UpdateTlsRoute(
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteTlsRoute(
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListServiceBindings(
    google::cloud::networkservices::v1::ListServiceBindingsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetServiceBinding(
    google::cloud::networkservices::v1::GetServiceBindingRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateServiceBinding(
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteServiceBinding(
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::ListMeshes(
    google::cloud::networkservices::v1::ListMeshesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::GetMesh(
    google::cloud::networkservices::v1::GetMeshRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::CreateMesh(
    google::cloud::networkservices::v1::CreateMeshRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::UpdateMesh(
    google::cloud::networkservices::v1::UpdateMeshRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NetworkServicesConnectionIdempotencyPolicy::DeleteMesh(
    google::cloud::networkservices::v1::DeleteMeshRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<NetworkServicesConnectionIdempotencyPolicy>
MakeDefaultNetworkServicesConnectionIdempotencyPolicy() {
  return std::make_unique<NetworkServicesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google
